<%--
   Name:        em/swb/package.jsp

   Description: This jsp is for the Support workbench package detail page.

   Controller:  oracle.sysman.dbTarget.swb.console.packageDetail.PackagesController

   Notes:

   Events:
       incidentsTab  : switch to incidents tab
       activityLogTab  : switch to activitylog tab
       viewIncidents : view incidents
       closeIncidents : close incidents
       selfServiceTab : switch to self service tab
       oracleSupportTab : switch to oracle support tab
       metalink
       quickPackage

   MODIFIED     (MM/DD/YY)
     balnaff     02/13/07 - 
     hopark      12/20/06 - add readonly mode
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>

<%
String noSelWarning = (String) request.getAttribute("noSelWarning");
%>

<script language="JavaScript">

function checkSelection(tblid, ev)
{
    var proxy = new TableProxy(tblid);
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}
</script>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="packageView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST" destinationBinding="myTarget">
       <uix:formValue name="pageName" value="/swb/pkgIncidents"/>
        <uix:formValue name="event" value="" />
        <uix:formValue name="value" value="" />
         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>
        <uix:pageStatus>
<%-- refresh --%>
             <%@ include file = "/swb/refresh.jspf" %>
<%-- error --%>
        </uix:pageStatus>

            
            <uix:switcher childNameBinding="readOnly@servletRequest">
                <uix:case name="true">
<%-- commands for readonly page --%>
                      <uix:tableLayout width="100%">
                          <uix:rowLayout hAlign="right">
                              <uix:cellFormat>
                                  <uix:button
                                  textBinding="PKG_BTN_CUSTOMIZE@SWBMsgs"
                                  destinationBinding="customizeUrl" />
                                  <uix:spacer width="5"/>
                              </uix:cellFormat>
                          </uix:rowLayout>
                      </uix:tableLayout>
                </uix:case>
                <uix:case name="false">
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="PKG_CUSTOMIZE_INSTRUCTION@SWBMsgs"/>
                </uix:case>
            </uix:switcher>

              <%@ include file="/swb/pkgSummary.jspf" %>

              <uix:rowLayout>
                <uix:spacer height="10"/>
              </uix:rowLayout>

<%-- start Tab section --%>
              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar selectedIndexBinding="selectedTab">
                    <uix:link textBinding="PKG_INCIDENTS@SWBMsgs"
                              destinationBinding="incidentsTab" />
                    <uix:link textBinding="PKG_DUMPSS@SWBMsgs"
                              destinationBinding="dumpsTab" />
                    <uix:link textBinding="PKG_ACTIVITYLOGS@SWBMsgs"
                              destinationBinding="useractLogsTab" />
                  </uix:subTabBar>
                </uix:subTabs>

                <uix:rowLayout>
                  <uix:spacer height="5"/>
                </uix:rowLayout>

                <uix:switcher childNameBinding="selectedTab">
                    <uix:case name="0">
                        <%@ include file="/swb/pkgIncidents.jspf" %>
                    </uix:case>
                    <uix:case name="1">
                        <%@ include file="/swb/pkgDumps.jspf" %>
                    </uix:case>
                    <uix:case name="2">
                        <%@ include file="/swb/pkgActLogs.jspf" %>
                    </uix:case>
                </uix:switcher>

              </uix:subTabLayout>
<%-- end Tab section --%>

<%-- start related links section --%>
                 <%@ include file="/swb/homeRelatedLinks.jspf" %>
<%-- end related links section --%>
            </uix:pageLayout>
          </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

