<%--
   Name:        em/swb/pkgAdditionalDumps.jsp

   Description: This jsp is for the "Additional dumps and testcases " in package detail

   Controller:  oracle.sysman.dbTarget.swb.console.packageDetail.UserActionController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     balnaff     11/29/06 - 
     hopark      10/10/06 - add refresh
     hopark      05/03/06 - Created
  --%>


<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

<uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pkgUserActionView@servletRequest">
    <uix:metaContainer>
         <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
    <uix:body>
         <uix:form name="foo"  method="POST"
             destinationBinding="myTarget">
           <uix:pageLayout titleBinding ="pageTitle">
            <%@ include file="/database/global.jspf" %>
        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>
        <uix:pageStatus>
<%-- refresh --%>
             <%@ include file = "/swb/refresh.jspf" %>
<%-- error --%>
        </uix:pageStatus>
        <uix:styledText styleClass="OraInstructionText" textBinding="PKG_ADDITIONAL_DUMPS_INSTR@SWBMsgs"/>
        <uix:spacer height="10"/>
<%-- start view selection --%>
    <uix:rowLayout>
        <uix:messageChoice id="selectedView" name="selectedView" promptBinding="TITLE_VIEW_CHOICE@SWBMsgs"
                           selectedValueBinding="currentView">
            <uix:contents>
                <uix:option textBinding="PD_ADDITIONAL_DUMPS_VIEW_ALL@SWBMsgs" value="all"/>
                <uix:option textBinding="PKG_ADDITIONAL_DUMPS_VIEW_DUMPS@SWBMsgs" value="dump"/>
                <uix:option textBinding="PKG_ADDITIONAL_DUMPS_VIEW_TESTCASES@SWBMsgs" value="testcase"/>
            </uix:contents>
        </uix:messageChoice>
        <uix:spacer width="10"/>
        <uix:button textBinding="BTN_GO@SWBMsgs"
                    onClick="submitForm('foo', true, {event:'changeView'})" />
    </uix:rowLayout>
<%-- end view selection--%>
        <uix:spacer height="5"/>
<%-- start user action table --%>
    <uix:rowLayout>
        <uix:dataScope currentDataBinding="tableBean">
            <uix:dataScope currentDataBinding="userActionTbl">
                <uix:table  name="userActionTbl"
                            id="userActionTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="PKG_ADDITIONAL_DUMPS_ALTTXT@SWBMsgs"
                            destinationBinding="destination"
                            summaryBinding="PD_ADDITIONAL_DUMPS_SUMMARY@SWBMsgs"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            formSubmitted="true">


                      <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:columnHeader>
                          <uix:styledText textBinding="PD_COL_INCIDENT_ID@SWBMsgs"/>
                        </uix:columnHeader>
                        <uix:link textBinding="IncidentID" destinationBinding="IncidentLink" />
                      </uix:column>

                      <uix:column>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:columnHeader>
                          <uix:styledText textBinding="PKG_INCTBL_COL_TYPE@SWBMsgs"/>
                        </uix:columnHeader>
                        <uix:styledText textBinding="Type" />
                      </uix:column>

                      <uix:column>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:columnHeader>
                          <uix:styledText textBinding="PKG_INCTBL_COL_PID@SWBMsgs"/>
                        </uix:columnHeader>
                        <uix:link textBinding="ProblemId" destinationBinding="ProblemLink" />
                      </uix:column>

                      <uix:column useSeparateRows="true">
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:columnHeader>
                          <uix:styledText textBinding="JOBDETAIL_ACTIONTYPE@SWBMsgs"/>
                        </uix:columnHeader>
                        <uix:contents childDataBinding="ActionName">
                          <uix:styledText textBinding="Action" />
                        </uix:contents>
                      </uix:column>

                      <uix:column useSeparateRows="true">
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:columnHeader>
                          <uix:styledText textBinding="JOBDETAIL_STATUS@SWBMsgs"/>
                        </uix:columnHeader>
                        <uix:contents childDataBinding="ActionStatus">
                          <uix:image sourceBinding="StatusIcon" shortDescBinding="IconDesc"/>
                        </uix:contents>
                      </uix:column>

                      <uix:column useSeparateRows="true">
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:columnHeader>
                          <uix:styledText textBinding="JOBDETAIL_GOTOTASK@SWBMsgs"/>
                        </uix:columnHeader>
                        <uix:contents childDataBinding="ActionTask">
                          <uix:image sourceBinding="GoToTaskIcon" shortDescBinding="JOBDETAIL_GOTOTASK@SWBMsgs" 
                                     destinationBinding="GoToTaskLink" />
                        </uix:contents>
                      </uix:column>
                 </uix:table>
            </uix:dataScope>
        </uix:dataScope>
    </uix:rowLayout>
<%-- end user action section --%>

<%-- start Icon Legend --%>
    <uix:rowLayout>
        <uix:tip>
            <uix:styledText textBinding="LEGEND_TEXT@SDKMsgs"/>
            <uix:link textBinding="ICON_KEY@SDKMsgs" destinationBinding="iconLegendUrl"/>
        </uix:tip>
    </uix:rowLayout>
<%-- end Icon Legend --%>

    <uix:rowLayout>
      <uix:spacer height="20"/>
    </uix:rowLayout>
<%-- start related links section --%>
                    <%@ include file="/swb/homeRelatedLinks.jspf" %>
<%-- end related links section --%>

                    </uix:pageLayout>
                </uix:form>
            </uix:body>
        </uix:dataScope>
    </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

