<%--
   Name:        em/swb/pkgAddIncidents.jsp

   Description: This jsp is for the Support workbench/ Package / Add incidents

   Controller:  oracle.sysman.dbTarget.swb.console.packageDetail.PkgAddIncidentsController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     balnaff     11/29/06 - 
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pkgIncView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">

         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- page actions  --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                    textBinding="CANCEL@SDKMsgs"
                    destinationBinding="returnUrl" />
                <uix:button
                    textBinding="OK@SDKMsgs"
                    onClick="submitForm('foo', true, {event:'ok'})" />
              </uix:pageButtonBar>
            </uix:pageButtons>

              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="PKG_ADD_INCIDENTS_SUBTITLE@SWBMsgs"/>
              <uix:rowLayout>
                  <uix:spacer height="10"/>
              </uix:rowLayout>

<%-- start excluded incidents  table --%>
            <uix:header textBinding="PKG_ADD_INCIDENTS_XHEADER@SWBMsgs" >
              <uix:rowLayout width="100%">
                <uix:dataScope currentDataBinding="tableBean">
                  <uix:dataScope currentDataBinding="xincidentsTbl">
                    <uix:table name="xincidentsTbl"
                            id="xincidentsTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="PKG_ADD_INCIDENTS_XALT_TEXT@SWBMsgs"
                            summaryBinding="PKG_ADD_INCIDENTS_XSUMMARY@SWBMsgs"
                            destinationBinding="destination"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            columnHeaderDataBinding="columnHeaderData"
                            columnFormatsBinding="columnFormatsData"
                            formSubmitted="true"
                            width="100%">
                            <uix:tableSelection>
                              <uix:multipleSelection shortDescBinding="SELECT@SWBMsgs">
                              </uix:multipleSelection>
                            </uix:tableSelection>
                            <uix:columnHeaderStamp>
                               <uix:sortableHeader textBinding="text"
                                                   valueBinding="value"
                                                   sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>
                            <uix:contents>
                              <uix:link textBinding="Id" destinationBinding="IncidentLink" />
                              <uix:styledText textBinding="Type" />
                              <uix:link textBinding="ProblemId" destinationBinding="ProblemLink" />
                              <uix:styledText textBinding="Desc" />
                              <uix:styledText textBinding="Size" />
                              <uix:styledText textBinding="Time" />
                            </uix:contents>
                         </uix:table>
                      </uix:dataScope>
                    </uix:dataScope>
                </uix:rowLayout>
            </uix:header>
<%-- end excluded incidents table section --%>
              <uix:rowLayout>
                  <uix:spacer height="20"/>
              </uix:rowLayout>
<%-- start other incidents  table --%>
            <uix:header textBinding="PKG_ADD_INCIDENTS_OHEADER@SWBMsgs" >
              <uix:rowLayout width="100%">
                <uix:dataScope currentDataBinding="tableBean">
                  <uix:dataScope currentDataBinding="oincidentsTbl">
                    <uix:table name="oincidentsTbl"
                            id="oincidentsTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="PKG_ADD_INCIDENTS_OALT_TEXT@SWBMsgs"
                            summaryBinding="PKG_ADD_INCIDENTS_OSUMMARY@SWBMsgs"
                            destinationBinding="destination"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            columnHeaderDataBinding="columnHeaderData"
                            columnFormatsBinding="columnFormatsData"
                            formSubmitted="true"
                            width="100%">
                            <uix:tableSelection>
                              <uix:multipleSelection shortDescBinding="SELECT@SWBMsgs">
                              </uix:multipleSelection>
                            </uix:tableSelection>
                            <uix:columnHeaderStamp>
                               <uix:sortableHeader textBinding="text"
                                                   valueBinding="value"
                                                   sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>
                            <uix:contents>
                              <uix:link textBinding="Id" destinationBinding="IncidentLink" />
                              <uix:link textBinding="ProblemId" destinationBinding="ProblemLink" />
                              <uix:styledText textBinding="Desc" />
                              <uix:styledText textBinding="Size" />
                              <uix:styledText textBinding="Time" />
                            </uix:contents>
                         </uix:table>
                      </uix:dataScope>
                    </uix:dataScope>
                </uix:rowLayout>
            </uix:header>
<%-- end other incidents table section --%>

            </uix:pageLayout>
         </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

