<%--
   Name:        em/swb/pkgCopyOut.jsp

   Description: This jsp is for the Support workbench/ Package / Copyout files

   Controller:  oracle.sysman.dbTarget.swb.console.packageDetail.PkgCopyOutController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     balnaff     06/20/07 - 
     jro         03/15/07 - oac violation fix
     jro         03/15/07 - fix bug 5926607 oac violations
     balnaff     11/29/06 - 
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%
String noSelWarning = (String) request.getAttribute("noSelWarning");
%>

<script language="JavaScript">

function checkSelection(ev)
{
    var proxy = new TableProxy('filesTbl');
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}

function myCallBack(lovWindow, event)
{
   return true;
}

function launchRfs()
{
   openWindow(top, '../page/rfs/postBackWithEvent$event=handleRfsLaunch', 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
}

</script>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>
  <uix:bundle name="DBMsgs"  class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pkgCOView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">

         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- page actions  --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                    textBinding="CANCEL@SDKMsgs"
                    destinationBinding="returnUrl" />
                <uix:button
                    textBinding="OK@SDKMsgs"
                    destination="javascript:checkSelection('ok')" />
              </uix:pageButtonBar>
            </uix:pageButtons>

              <uix:rowLayout>
                  <uix:spacer height="10"/>
              </uix:rowLayout>

              <uix:styledText styleClass="OraInstructionText" textBinding="PKG_COPYOUT_INSTR@SWBMsgs"/>

<%-- start destination folder --%>
            <uix:header textBinding="PKG_COPYOUT_DEST_HEADER@SWBMsgs" >
              <uix:rowLayout>
                  <uix:spacer height="5"/>
              </uix:rowLayout>
                <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="PKG_COPYOUT_DEST_INST@SWBMsgs" />
                </uix:rowLayout>
              <uix:rowLayout>
                  <uix:spacer height="5"/>
              </uix:rowLayout>
                <uix:rowLayout width="100%">
                      <uix:stackLayout>
                       <uix:labeledFieldLayout labelWidth="0%" fieldWidth="100%">
                        <%-- Host Name --%>
                        <uix:messageTextInput name="host"
                                              promptBinding="HOST@DBMsgs"
                                              textBinding="hostName@rfsBean@servletRequest"
                                              styleClass="OraDataText"
                                              readOnly="true"/>

                        <%-- Launch Remote File Selector Page --%>
                        <uix:messagePrompt styleClass="OraPromptText"
                               labeledNodeId="fileName"
                              promptBinding="PKG_COPYOUT_DEST_HEADER@SWBMsgs" required="yes"/>
                        <uix:messageLovField name="fileName"
                                             textBinding="fileName@rfsBean@servletRequest"
                                             shortDesc="Click on the flashlight icon to browse host filesystem"
                                             searchDescBinding="PKG_COPYOUT_DEST_HEADER@SWBMsgs"
                                             columns="100"
                                             id="fileName"
                                             onClick="launchRfs();"/>
                       </uix:labeledFieldLayout>
                       </uix:stackLayout>
                </uix:rowLayout>
            </uix:header>
<%-- end destination folder --%>
              <uix:rowLayout>
                  <uix:spacer height="10"/>
              </uix:rowLayout>
<%-- start files table --%>
            <uix:header textBinding="PKG_COPYOUT_FILES_HEADER@SWBMsgs" >
              <uix:rowLayout>
                  <uix:spacer height="5"/>
              </uix:rowLayout>
                <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="PKG_COPYOUT_FILES_INST@SWBMsgs" />
                </uix:rowLayout>
              <uix:rowLayout>
                  <uix:spacer height="5"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:dataScope currentDataBinding="tableBean">
                  <uix:dataScope currentDataBinding="filesTbl">
                    <uix:table name="filesTbl"
                            id="filesTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="PKG_COPYOUT_ALT_TEXT@SWBMsgs"
                            summaryBinding="PKG_COPYOUT_SUMMARY@SWBMsgs"
                            destinationBinding="destination"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            columnHeaderDataBinding="columnHeaderData"
                            columnFormatsBinding="columnFormatsData"
                            formSubmitted="true"
                            width="100%">
                            <uix:tableSelection>
                              <uix:multipleSelection shortDescBinding="SELECT@SWBMsgs">
                              </uix:multipleSelection>
                            </uix:tableSelection>
                            <uix:columnHeaderStamp>
                               <uix:sortableHeader textBinding="text"
                                                   valueBinding="value"
                                                   sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>
                            <uix:contents>
                                <uix:styledText textBinding="Source" />
                                <uix:styledText textBinding="Filename" />
                                <uix:styledText textBinding="Size" />
                                <uix:styledText textBinding="HasUserData" />
                                <uix:styledText textBinding="Date" />
                                <uix:styledText textBinding="Path" />
                            </uix:contents>
                         </uix:table>
                      </uix:dataScope>
                    </uix:dataScope>
                </uix:rowLayout>
            </uix:header>
<%-- end excluded incidents table section --%>

            </uix:pageLayout>
         </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

