<%--
   Name:        em/swb/pkgPhysicalFiles.jsp

   Description: This jsp is for the "View/Upload physical files" in Package detail

   Controller:  oracle.sysman.dbTarget.swb.console.packageDetail.PhyFilesController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     jsoule      03/11/07 - add Send Remote Packages link
     balnaff     11/29/06 - 
     hopark      10/18/06 - remove selection header
     hopark      05/03/06 - Created
  --%>


<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%
String noSelWarning = (String) request.getAttribute("noSelWarning");
%>

<script language="JavaScript">

function checkSelection(ev)
{
    var proxy = new TableProxy('phyFilesTbl');
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}
</script>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="phyFilesView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">
            <uix:pageLayout titleBinding ="pageTitle">
             <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- begin page actions  --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                    textBinding="OK@SDKMsgs"
                    destinationBinding="returnUrl" />
              </uix:pageButtonBar>
            </uix:pageButtons>
<%-- end page actions  --%>
              <uix:styledText styleClass="OraInstructionText" textBinding="PKG_PHYFILES_INSTR@SWBMsgs"/>
              <uix:rowLayout>
                  <uix:spacer height="20"/>
              </uix:rowLayout>

<%-- begin Physical files table --%>
              <uix:rowLayout width="100%">
                <uix:dataScope currentDataBinding="tableBean">
                  <uix:dataScope currentDataBinding="phyFilesTbl">
                    <uix:table name="phyFilesTbl"
                            id="phyFilesTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="PKG_PHYFILES_ALTTEXT@SWBMsgs"
                            destinationBinding="destination"
                            summaryBinding="PTBL_SUMMARY@SWBMsgs"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            columnHeaderDataBinding="columnHeaderData"
                            columnFormatsBinding="columnFormatsData"
                            formSubmitted="true"
                            width="100%">
                            <uix:tableSelection>
                                <uix:multipleSelection shortDescBinding="SELECT@SWBMsgs"
                                                    disabledBinding="disabled">
                               <uix:contents>
                                     <uix:button textBinding="PKG_PHYFILES_BTN_UPLOAD@SWBMsgs"
                                        destination="javascript:checkSelection('upload')" />
                              </uix:contents>
                              </uix:multipleSelection>
                            </uix:tableSelection>
                            <uix:columnHeaderStamp>
                               <uix:sortableHeader textBinding="text"
                                                   valueBinding="value"
                                                   sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>

                            <uix:contents>
                               <uix:styledText textBinding="Filename" />
                               <uix:styledText textBinding="Path" />
                               <uix:styledText textBinding="Size" />
                               <uix:styledText textBinding="Mode" />
                               <uix:styledText textBinding="Created" />
                               <uix:styledText textBinding="UploadedTime" />
                            </uix:contents>
                         </uix:table>
                      </uix:dataScope>
                    </uix:dataScope>
                </uix:rowLayout>
                <uix:rowLayout width="100%">
                 <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="PKG_UPLOAD_REMOTE_PACKAGES@SWBMsgs"
                                  styleClass="OraPromptText"
                                  renderedBinding="sendRemotePackagesRendered"
                                  destinationBinding="sendRemotePackagesURL"/>
                 </uix:cellFormat>
                </uix:rowLayout>
<%-- end physical files table section --%>

            </uix:pageLayout>
         </uix:form>

      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

