<%--
   Name:        em/swb/pkgRemotePackages.jsp

   Description: This jsp is for the "Manage Remote Packages" in Package detail

   Controller:  oracle.sysman.dbTarget.swb.console.packageDetail.RemotePkgsController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     fagonzal    04/01/08 - Adding 'has incidents' column
     jsoule      03/05/07 - Created
  --%>


<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%
String noSelWarning = (String) request.getAttribute("noSelWarning");
%>

<script language="JavaScript">

function checkSelection(tblid, ev)
{
    var proxy = new TableProxy(tblid);
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}
</script>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="remotePkgsView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo" method="POST" destinationBinding="myTarget">
         <uix:formValue name="pageName" value="/swb/pkgRemotePackages"/>
         <uix:formValue name="event" value="" />
         <uix:pageLayout titleBinding ="pageTitle">

           <%@ include file="/database/global.jspf" %>

           <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
           </uix:messages>
           <uix:pageStatus>
<%-- refresh --%>
             <%@ include file = "/swb/refresh.jspf" %>
<%-- error --%>
           </uix:pageStatus>

        <uix:styledText textBinding="RPKGS_REMOTE_PACKAGES_INSTR@SWBMsgs"
                        styleClass="OraInstructionText"/>

        <uix:tableLayout cellSpacing="10" width="100%">
          <uix:rowLayout vAlign="top">
           <uix:contents>

<%-- Summary area --%>
            <uix:cellFormat hAlign="left">
              <uix:header textBinding="RPKGS_MAIN_PACKAGE_SUMMARY@SWBMsgs">
                <uix:tableLayout>
                 <uix:contents childDataBinding="mainPackageSummary">
                  <%@ include file="/swb/summaryLayout.jspf" %>
                 </uix:contents>
                </uix:tableLayout>
              </uix:header>
            </uix:cellFormat>

           </uix:contents>
          </uix:rowLayout>
        </uix:tableLayout>

<%-- start Child packages table --%>
        <uix:header textBinding="RPKGTBL_SUMMARY@SWBMsgs">
          <uix:tip renderedBinding="uploadDisabled">
            <uix:styledText textBinding="RPKGS_UPLOAD_TIP@SWBMsgs"/>
          </uix:tip>
        <uix:dataScope currentDataBinding="tableBean">
        <uix:dataScope currentDataBinding="remotePkgsTbl">
        <uix:table name="remotePkgsTbl"
                   id="remotePkgsTbl"
                   showAll="yes"
                   alternateTextBinding="RPKGTBL_ALT_TEXT@SWBMsgs"
                   summaryBinding="RPKGTBL_SUMMARY@SWBMsgs"
                   minValue="1"
                   maxValueBinding="maxValue"
                   blockSizeBinding="blockSize"
                   valueBinding="value"
                   tableDataBinding="tableData"
                   columnHeaderDataBinding="columnHeaderData"
                   columnFormatsBinding="columnFormatsData"
                   formSubmitted="true"
                   width="100%">
           <uix:tableSelection>
             <uix:multipleSelection shortDescBinding="SELECT@SWBMsgs"
                                    disabledBinding="disabled">
              <uix:contents>
               <uix:button textBinding="RPKGS_BTN_CREATE@SWBMsgs"
                           destination="javascript:checkSelection('remotePkgsTbl','createRemotePackages')" />
               <uix:button textBinding="RPKGS_BTN_UPDATE@SWBMsgs"
                           destination="javascript:checkSelection('remotePkgsTbl','updateRemotePackages')" />
               <uix:button textBinding="PKG_FINISH_PREP@SWBMsgs"
                           destination="javascript:checkSelection('remotePkgsTbl','finalizeRemotePackages')" />
               <uix:button textBinding="RPKGS_BTN_UPLOAD@SWBMsgs"
                           destination="javascript:checkSelection('remotePkgsTbl','uploadRemotePackages')"
                           disabledBinding="uploadDisabled@remotePkgsView@servletRequest" />
              </uix:contents>
             </uix:multipleSelection>
           </uix:tableSelection>
           <uix:columnHeaderStamp>
             <uix:sortableHeader textBinding="text"
                                 valueBinding="value"
                                 sortableBinding="sortable"/>
           </uix:columnHeaderStamp>
          <uix:contents>
           <uix:styledText textBinding="InstanceName"/>
           <uix:link textBinding="RemotePkgID" destinationBinding="RemotePkgLink" />
           <uix:styledText textBinding="HasIncidents"/>
           <uix:messageStyledText prompt="" textBinding="Status">
             <uix:end>
              <uix:flowLayout>
               <uix:spacer width="5" height="1"
                           renderedBinding="GenerateLinkRendered"/>
               <uix:button textBinding="PKG_GEN_PHYFILE@SWBMsgs"
                           renderedBinding="GenerateLinkRendered"
                           destinationBinding="GenerateLink"/>
              </uix:flowLayout>
             </uix:end>
           </uix:messageStyledText>
           <uix:styledText textBinding="LastUpdated"/>
           <uix:styledText textBinding="Size"/>
          </uix:contents>
         </uix:table>
         </uix:dataScope>
         </uix:dataScope>
         </uix:header>

<%-- end Child packages table --%>

         </uix:pageLayout>
       </uix:form>
     </uix:body>
     </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
