<%--
   Name:        em/swb/pkgRemoveProblems.jsp

   Description: This jsp is for the "Remove Problems" in Package detail

   Controller:  oracle.sysman.dbTarget.swb.console.packageDetail.RemPrbController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     balnaff     11/29/06 - 
     hopark      05/03/06 - Created
  --%>


<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%
String noSelWarning = (String) request.getAttribute("noSelWarning");
%>

<script language="JavaScript">

function checkSelection(ev)
{
    var proxy = new TableProxy('problemTbl');
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}
</script>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pkgPrbView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">

         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- page actions  --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                    textBinding="CANCEL@SDKMsgs"
                    destinationBinding="returnUrl" />
                <uix:button
                    textBinding="OK@SDKMsgs"
                    destination="javascript:checkSelection('ok')" />
              </uix:pageButtonBar>
            </uix:pageButtons>

<%-- start problem table --%>
              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="header" />
              </uix:rowLayout>
              <uix:rowLayout>
                  <uix:spacer height="10"/>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:dataScope currentDataBinding="tableBean">
                  <uix:dataScope currentDataBinding="problemTbl">
                    <uix:table name="problemTbl"
                            id="problemTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="PTBL_ALT_TEXT@SWBMsgs"
                            destinationBinding="destination"
                            summaryBinding="PTBL_SUMMARY@SWBMsgs"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            columnHeaderDataBinding="columnHeaderData"
                            columnFormatsBinding="columnFormatsData"
                            detailDisclosureBinding="problemTbl_details@servletRequest"
                            allDetailsEnabled="true"
                            formSubmitted="true"
                            width="100%">
                            <uix:tableSelection>
                              <uix:multipleSelection shortDescBinding="SELECT@SWBMsgs">
                              </uix:multipleSelection>
                            </uix:tableSelection>
                            <uix:columnHeaderStamp>
                               <uix:sortableHeader textBinding="text"
                                                   valueBinding="value"
                                                   sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>

                            <uix:detail>
                                <uix:flowLayout>
                                  <uix:header textBinding="IncHeader">
                                  <uix:contents childDataBinding="detail">
                                    <uix:tableLayout width = "100%">
                                        <uix:rowLayout>
                                            <uix:cellFormat hAlign="center" width="10%">
                                                <uix:link textBinding="ID"
                                                          longDescBinding="IDLinkDesc"
                                                          destinationBinding="IDLinkUrl" />
                                            </uix:cellFormat>
                                            <uix:cellFormat hAlign="left" width="60%" wrappingDisabled="true" >
                                                <uix:styledText styleClass="OraInstructionText" textBinding="Desc" />
                                            </uix:cellFormat>
                                            <uix:cellFormat hAlign="right" width="30%">
                                                <uix:styledText styleClass="OraInstructionText" textBinding="Created" />
                                            </uix:cellFormat>
                                        </uix:rowLayout>
                                    </uix:tableLayout>
                                  </uix:contents>
                                  </uix:header>
                                </uix:flowLayout>
                            </uix:detail>

                            <uix:contents>
                               <uix:link textBinding="ID" destinationBinding="ProblemLink" />
                               <uix:styledText textBinding="Desc" />
                               <uix:styledText textBinding="IncidentCount" />
                               <uix:styledText textBinding="Time" />
                               <uix:styledText textBinding="LastComment" />
                               <uix:link textBinding="Pkgs" destinationBinding="PkgLink" />
                               <uix:styledText textBinding="SR" />
                            </uix:contents>
                         </uix:table>
                      </uix:dataScope>
                    </uix:dataScope>
                </uix:rowLayout>
<%-- end problem table section --%>
              <uix:rowLayout>
                  <uix:spacer height="20"/>
              </uix:rowLayout>

            </uix:pageLayout>
         </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

