<%--
   Name:        em/swb/pkgPhysicalFiles.jsp

   Description: This jsp is for the "View/Upload physical files" in Package detail

   Controller:  oracle.sysman.dbTarget.swb.console.packageDetail.PhyFilesController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     balnaff     12/13/07 - Backport balnaff_bug-6634265_main from main
     balnaff     11/29/06 - 
     hopark      05/03/06 - Created
  --%>


<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="uploadPkgView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">
            <uix:pageLayout titleBinding ="pageTitle">
             <%@ include file="/database/global.jspf" %>
        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- begin page actions  --%>
                <uix:pageButtons>
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@SDKMsgs"
                      shortDescBinding="CANCEL@SDKMsgs"
                    destinationBinding="returnUrl" />
                    <uix:submitButton
                      textBinding="SUBMIT@SWBMsgs"
                      shortDescBinding="SUBMIT@SWBMsgs"
                      formName="foo"
                      name="event"
                      value="ok"/>
                  </uix:pageButtonBar>
                </uix:pageButtons>
<%-- end page actions  --%>
              <uix:rowLayout>
                  <uix:spacer height="20"/>
              </uix:rowLayout>
           <uix:labeledFieldLayout columns="2" labelWidth="200" width="50%">
            <uix:contents>
              <uix:messageTextInput name="username"
                  textBinding="MLUsername"
                  promptBinding="METALINK_USERNAME@SWBMsgs"
                  columns="20"/>

              <uix:messageTextInput name="password"
                    promptBinding="METALINK_PASSWORD@SWBMsgs"
                    noAutoComplete="true"
                    secret="true"
                    columns="20"/>
              <uix:messageTextInput name="csi"
                    textBinding="MLCSI"
                    promptBinding="METALINK_CSI@SWBMsgs"
                    columns="20"/>
              <uix:messagePrompt
                    promptBinding="METALINK_COUNTRY@SWBMsgs"/>
              <uix:choice name="countrycode" 
                          selectedValueBinding="MLCC"
                          id="countrycode">
                <uix:contents childDataBinding="countryOptions">
                  <uix:option textBinding="textKey"
                              valueBinding="valueKey"/>
                </uix:contents>
              </uix:choice>
              <uix:messagePrompt
                  promptBinding="CREATE_SR@SWBMsgs"/>
              <uix:flowLayout>
               <oem:radioButton
                  name="create"
                  value="create"
                  selectedValueBinding="SRModeSelected"
                  textBinding="YES@SWBMsgs"
                  shortDescBinding="YES@SWBMsg"
                  onClick="submitForm('foo', true, {event:'createSR'})"
                  styleClass="OraInstructionText"/>
               <oem:radioButton
                  name="enter"
                  value="enter"
                  selectedValueBinding="SRModeSelected"
                  textBinding="NO@SWBMsgs"
                  shortDescBinding="NO@SWBMsg"
                  onClick="submitForm('foo', true, {event:'enterSR'})"
                  styleClass="OraInstructionText"/>
              </uix:flowLayout>
              <uix:spacer height="10"/>
              <uix:spacer height="10"/>
              </uix:contents>
              <uix:switcher childNameBinding="SRModeSelected">
              <uix:case name="enter">
                <uix:switcher childNameBinding="SingleProblem@servletRequest">
                    <uix:case name="true">
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                        <uix:messageTextInput name="sr"
                            promptBinding="PD_QPACKAGE_SR@SWBMsgs"
                            textBinding="SR"
                            columns="10"/>
                    </uix:stackLayout>
                  </uix:case>
                  <uix:case name="false">
                        <uix:messageChoice name="srsel"
                                    id="srsel"
                                    required="yes"
                                    shortDescBinding="UPLOAD_SELECT_SR@SWBMsgs"
                                    promptBinding="PD_QPACKAGE_SR@SWBMsgs"
                                    selectedValueBinding="SRSel">
                          <uix:contents childDataBinding="SROptions">
                            <uix:option textBinding="sr"
                                        valueBinding="sr"/>
                          </uix:contents>
                          <uix:end>
                            <uix:flowLayout>
                            <uix:contents>
                              <uix:textInput name="sr"
                                textBinding="SR"
                                columns="10" />
                            </uix:contents>
                            </uix:flowLayout>
                          </uix:end>
                        </uix:messageChoice>
                  </uix:case>
              </uix:switcher>
              </uix:case>
            </uix:switcher>
            </uix:labeledFieldLayout>
             <uix:spacer height="20"/>
<%-- start Physical files table --%>
             <uix:header textBinding="PKG_UPLOADPHYFILES_TITLE@SWBMsgs">
              <uix:rowLayout width="100%">
                <uix:dataScope currentDataBinding="tableBean">
                  <uix:dataScope currentDataBinding="phyFilesTbl">
                    <uix:table name="phyFilesTbl"
                            id="phyFilesTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="PKG_PHYFILES_ALTTEXT@SWBMsgs"
                            summaryBinding="PKG_PHYFILES_SUMMARY@SWBMsgs"
                            destinationBinding="destination"
                            summary="PTBL_SUMMARY@SWBMsgs"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            columnHeaderDataBinding="columnHeaderData"
                            columnFormatsBinding="columnFormatsData"
                            formSubmitted="true"
                            width="100%">
                            <uix:columnHeaderStamp>
                               <uix:sortableHeader textBinding="text"
                                                   valueBinding="value"
                                                   sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>

                            <uix:contents>
                               <uix:styledText textBinding="Filename" />
                               <uix:styledText textBinding="Path" />
                               <uix:styledText textBinding="Size" />
                               <uix:styledText textBinding="Mode" />
                               <uix:styledText textBinding="Created" />
                               <uix:styledText textBinding="UploadedTime" />
                            </uix:contents>
                         </uix:table>
                      </uix:dataScope>
                    </uix:dataScope>
                </uix:rowLayout>
               </uix:header>
<%-- end physical files table section --%>

              <uix:rowLayout>
                  <uix:spacer height="20"/>
              </uix:rowLayout>

<%-- begin schedule --%>
             <uix:header textBinding="UPLOAD_SCHEDULE_TITLE@SWBMsgs">
              <%@ include file="/swb/schedule.jspf" %>
<%-- end schedule --%>
            <uix:switcher childNameBinding="ShowHostCred@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                      <uix:spacer height="10"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                     <uix:header textBinding="HOST_CREDS@SWBMsgs">
                       <%@ include file="/dbhostcreds.jspf" %>
                     </uix:header>
                  </uix:rowLayout>
                 </uix:case>
            </uix:switcher>
              <uix:rowLayout>
                  <uix:spacer height="10"/>
              </uix:rowLayout>
           </uix:header>

<%-- begin size info --%>
            <uix:rowLayout width="100%">
                <uix:dataScope currentDataBinding="sizeInfoBox">
                    <oem:messageBox
                        renderedBinding="rendered"
                        messageTypeBinding="messageType"
                        errorTableBinding="errors"
                        destTableBinding="msgUrls"
                        titleTextKey="titleText"
                        mainTextKey="mainText" />
                </uix:dataScope>
            </uix:rowLayout>
<%-- end size info --%>

            </uix:pageLayout>
         </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

