<%--
   Name:        em/swb/viewRelatedProblems.jsp

   Description: This jsp is for the Support workbench/ Related Problems

   Controller:  oracle.sysman.dbTarget.swb.console.problemDetail.RelatedProblemsController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
                            st_emdbsa_11.1
     fagonzal    01/09/08 - Fixing erroneous detailDisclosureBinding
     jsoule      04/03/07 - match column contents with column headers
     balnaff     11/29/06 - 
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="relatedPrbView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
        <uix:form name="foo"  method="POST" destinationBinding="myTarget">
          <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>
        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- problem tables --%>
            <uix:tableLayout>
               <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraFieldText" textBinding="PD_PROBLEM_KEY@SWBMsgs" />
                </uix:cellFormat>
                <uix:spacer width="20" />
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText" textBinding="problemKey" />
                </uix:cellFormat>
               </uix:rowLayout>
               <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraFieldText" labeledNodeId="incident" textBinding="PD_RELATED_SELINCIDENT@SWBMsgs" />
                </uix:cellFormat>
                <uix:spacer width="20" />
                <uix:cellFormat hAlign="left">
                    <uix:choice name="incident"
                                id="incident"
                                shortDescBinding="PD_RELATED_SELINCIDENT@SWBMsgs"
                                selectedIndexBinding="incidentOptionSel">
                      <uix:contents childDataBinding="incidentOptions">
                        <uix:option textBinding="textKey"
                                    valueBinding="valueKey"/>
                      </uix:contents>
                    </uix:choice>

                </uix:cellFormat>
                <uix:spacer width="10"/>
                <uix:button
                    textBinding="BTN_GO@SWBMsgs"
                    onClick="submitForm('foo', true, {event:'changeIncident'})" />
               </uix:rowLayout>
            </uix:tableLayout>
            <uix:separator/>
            <uix:styledText styleClass="OraInstructionText" textBinding="instr" />
            <uix:header renderedBinding = "hasSameProblemKey"
                        textBinding="PD_RELATED_SAMEPK@SWBMsgs">

            <uix:tableLayout width="100%">
              <uix:contents>
                <uix:rowLayout>
                    <uix:dataScope currentDataBinding="tableBean">
                        <uix:dataScope currentDataBinding="sameKeyTbl">
                            <uix:table name="sameKeyTbl"
                                id="sameKeyTbl"
                                showAll="yes"
                                minValue="1"
                                alternateTextBinding="PTBL_ALT_TEXT@SWBMsgs"
                                destinationBinding="destination"
                                summaryBinding="PTBL_SUMMARY@SWBMsgs"

                                maxValueBinding="maxValue"
                                blockSizeBinding="blockSize"
                                valueBinding="value"

                                tableDataBinding="tableData"
                                columnHeaderDataBinding="columnHeaderData"
                                columnFormatsBinding="columnFormatsData"
                                formSubmitted="true"
                                width="100%">
                                <uix:columnHeaderStamp>
                                   <uix:sortableHeader textBinding="text"
                                                       valueBinding="value"
                                                       sortableBinding="sortable"/>
                                </uix:columnHeaderStamp>

                                <uix:contents>
                                   <uix:link textBinding="ID" destinationBinding="ProblemLink" />
                                   <uix:styledText textBinding="TargetName" />
                                   <uix:styledText textBinding="TargetType" />
                                   <uix:styledText textBinding="Desc" />
                                   <uix:styledText textBinding="Time" />
                                </uix:contents>
                            </uix:table>
                        </uix:dataScope>
                    </uix:dataScope>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
            </uix:header>

            <uix:header textBinding="timeProximityTitle">
                <uix:rowLayout>
                    <uix:styledText styleClass="OraFieldText" labeledNodeId="proximity"
                                    textBinding="PD_RELATED_TIME_PROXIMITY@SWBMsgs" />
                    <uix:spacer width="10"/>
                    <uix:choice name="proximity"
                                id="proximity"
                                shortDescBinding="PD_RELATED_TIME_PROXIMITY@SWBMsgs"
                                selectedIndexBinding="proximityOptionSel">
                      <uix:contents childDataBinding="proximityOptions">
                        <uix:option textBinding="textKey"
                                    valueBinding="valueKey"/>
                      </uix:contents>
                    </uix:choice>

                    <uix:spacer width="10"/>
                    <uix:button
                        textBinding="BTN_GO@SWBMsgs"
                        onClick="submitForm('foo', true, {event:'changeProximity'})" />
                </uix:rowLayout>
                <uix:tableLayout width="100%">
                  <uix:contents>
                    <uix:rowLayout>
                        <uix:dataScope currentDataBinding="tableBean">
                            <uix:dataScope currentDataBinding="timeProximityTbl">
                            <uix:table name="timeProximityTbl"
                                id="timeProximityTbl"
                                showAll="yes"
                                minValue="1"
                                alternateTextBinding="PTBL_ALT_TEXT@SWBMsgs"
                                destinationBinding="destination"
                                summaryBinding="PTBL_SUMMARY@SWBMsgs"

                                maxValueBinding="maxValue"
                                blockSizeBinding="blockSize"
                                valueBinding="value"

                                tableDataBinding="tableData"
                                columnHeaderDataBinding="columnHeaderData"
                                columnFormatsBinding="columnFormatsData"
	                            detailDisclosureBinding="timeProximityTbl_details@servletRequest"
	                            allDetailsEnabled="true"                                
                                formSubmitted="true"
                                width="100%">

	                            <uix:detail>
	                                <uix:flowLayout>
	                                  <uix:header textBinding="IncHeader">
	                                  <uix:contents childDataBinding="detail">
	                                    <uix:tableLayout width = "100%">
	                                        <uix:rowLayout>
	                                            <uix:cellFormat hAlign="center" width="10%">
	                                                <uix:link textBinding="ID"
	                                                          longDescBinding="IDLinkDesc"
	                                                          destinationBinding="IDLinkUrl" />
	                                            </uix:cellFormat>
	                                            <uix:cellFormat hAlign="left" width="60%" wrappingDisabled="true" >
	                                                <uix:styledText styleClass="OraInstructionText" textBinding="Desc" />
	                                            </uix:cellFormat>
	                                            <uix:cellFormat hAlign="right" width="30%">
	                                                <uix:styledText styleClass="OraInstructionText" textBinding="Created" />
	                                            </uix:cellFormat>
	                                        </uix:rowLayout>
	                                    </uix:tableLayout>
	                                  </uix:contents>
	                                  </uix:header>
	                                </uix:flowLayout>
	                            </uix:detail>
	                            
	                            <uix:column renderedBinding="InstanceRendered">
	                             <uix:columnHeader>
	                              <uix:sortableHeader textBinding="text"
	                                                  valueBinding="value"
	                                                  sortableBinding="sortable"/>
	                             </uix:columnHeader>
	                              <uix:styledText textBinding="Instance" />
	                            </uix:column>
	                            <uix:column renderedBinding="IDRendered">
	                             <uix:columnHeader>
	                              <uix:sortableHeader textBinding="text"
	                                                  valueBinding="value"
	                                                  sortableBinding="sortable"/>
	                             </uix:columnHeader>
	                              <uix:link textBinding="ID" destinationBinding="ProblemLink" />
	                            </uix:column>
	                            <uix:column renderedBinding="DescRendered">
	                             <uix:columnHeader>
	                              <uix:sortableHeader textBinding="text"
	                                                  valueBinding="value"
	                                                  sortableBinding="sortable"/>
	                             </uix:columnHeader>
	                             <uix:styledText textBinding="Desc" />
	                            </uix:column>
	                            <uix:column renderedBinding="IncidentCountRendered">
	                             <uix:columnHeader>
	                              <uix:sortableHeader textBinding="text"
	                                                  valueBinding="value"
	                                                  sortableBinding="sortable"/>
	                             </uix:columnHeader>
	                              <uix:styledText textBinding="IncidentCount" />
	                            </uix:column>
	                            <uix:column renderedBinding="TimeRendered">
	                             <uix:columnHeader>
	                              <uix:sortableHeader textBinding="text"
	                                                  valueBinding="value"
	                                                  sortableBinding="sortable"/>
	                             </uix:columnHeader>
	                              <uix:styledText textBinding="Time" />
	                            </uix:column>
	                         </uix:table>
	                        </uix:dataScope>
                    	</uix:dataScope>                        
                    </uix:rowLayout>
                  </uix:contents>
                </uix:tableLayout>
            </uix:header>

            <uix:header textBinding="sameECIDTitle">
                <uix:tableLayout width="100%">
                  <uix:contents>
                    <uix:rowLayout>
                        <uix:dataScope currentDataBinding="tableBean">
                            <uix:dataScope currentDataBinding="sameECIDTbl">
                            <uix:table name="sameECIDTbl"
                                id="sameECIDTbl"
                                showAll="yes"
                                minValue="1"
                                alternateTextBinding="PTBL_ALT_TEXT@SWBMsgs"
                                destinationBinding="destination"
                                summaryBinding="PTBL_SUMMARY@SWBMsgs"

                                maxValueBinding="maxValue"
                                blockSizeBinding="blockSize"
                                valueBinding="value"

                                tableDataBinding="tableData"
                                columnHeaderDataBinding="columnHeaderData"
                                columnFormatsBinding="columnFormatsData"
                                formSubmitted="true"
                                width="100%">
                                <uix:columnHeaderStamp>
                                   <uix:sortableHeader textBinding="text"
                                                       valueBinding="value"
                                                       sortableBinding="sortable"/>
                                </uix:columnHeaderStamp>

                                <uix:contents>
                                   <uix:link textBinding="ID" destinationBinding="ProblemLink" />
                                   <uix:styledText textBinding="TargetName" />
                                   <uix:styledText textBinding="TargetType" />
                                   <uix:styledText textBinding="Desc" />
                                   <uix:styledText textBinding="Time" />
                                </uix:contents>
                            </uix:table>
                            </uix:dataScope>
                        </uix:dataScope>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:tableLayout>
            </uix:header>

<%-- start related links section --%>
                 <%@ include file="/swb/homeRelatedLinks.jspf" %>
<%-- end related links section --%>
          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

