<%--
   Name:        em/swb/problem.jsp

   Description: This jsp is for the Support workbench problem detail page.

   Controller:  oracle.sysman.dbTarget.swb.console.problemDetail.IncidentsController

   Notes:

   Events:
       incidentsTab  : switch to incidents tab
       activityLogTab  : switch to activitylog tab
       viewIncidents : view incidents
       closeIncidents : close incidents
       selfServiceTab : switch to self service tab
       oracleSupportTab : switch to oracle support tab
       metalink
       quickPackage

   MODIFIED     (MM/DD/YY)
     balnaff     02/22/07 - 
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%
String multiSelWarning = (String) request.getAttribute("multiSelWarning");
String noSelWarning = (String) request.getAttribute("noSelWarning");
String editSrPrompt = (String) request.getAttribute("editSRPrompt");
String editBugNoPrompt = (String) request.getAttribute("editBugNoPrompt");
%>

<script language="JavaScript">
function checkMultiSelection(tbl,ev)
{
    var proxy = new TableProxy(tbl);
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    if (rows.length > 1) {
        alert('<%= multiSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}

function checkSelection(tbl,ev)
{
    var proxy = new TableProxy(tbl);
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}

function onEditSr()
{
    var val = prompt('<%= editSrPrompt %>',"");
    if (val != '' && val != null) {
        document.foo.event.value = "setsr";
        document.foo.value.value = val;
        document.foo.submit();
    }
}

function onEditBugNo()
{
    var val = prompt('<%= editBugNoPrompt %>',"");
    if (val != '' && val != null) {
        document.foo.event.value = "setbugno";
        document.foo.value.value = val;
        document.foo.submit();
    }
}

function openMetalink()
{
    window.open('http://metalink.oracle.com', 'Metalink');
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="problemView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST" destinationBinding="myTarget">
       <uix:formValue name="pageName" value="/swb/prbIncidents"/>
        <uix:formValue name="event" value="" />
        <uix:formValue name="value" value="" />

         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>
        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>
        <uix:pageStatus>
<%-- start refresh --%>
             <%@ include file = "/swb/refresh.jspf" %>
<%-- end refresh --%>
        </uix:pageStatus>


<%-- start message section --%>
             <uix:rowLayout width="100%">
                <uix:switcher childNameBinding="hasInformation">
                <uix:case name="true">
                    <uix:messageBox messageBinding="message@information@servletRequest" messageType="information">
                       <uix:stackLayout>
                        <uix:styledText textBinding="line1@information@servletRequest"/>
                        <uix:flowLayout>
                         <uix:styledText textBinding="line2@information@servletRequest"/>
                         <uix:link textBinding="link1@information@servletRequest" destinationBinding="link1url@servletRequest"/>
                         <uix:styledText textBinding="line2_1@information@servletRequest"/>
                        </uix:flowLayout>
                        <uix:flowLayout>
                         <uix:styledText textBinding="line3@information@servletRequest"/>
                         <uix:link textBinding="link2@information@servletRequest" destinationBinding="link2url@servletRequest"/>
                         <uix:styledText textBinding="line3_1@information@servletRequest"/>
                         <uix:link textBinding="link3@information@servletRequest" destinationBinding="link3url@servletRequest"/>
                         <uix:styledText textBinding="line3_2@information@servletRequest"/>
                        </uix:flowLayout>
                       </uix:stackLayout>
                    </uix:messageBox>
                </uix:case>
                </uix:switcher>
            </uix:rowLayout>
<%-- end message  section --%>

<%-- start Summary/Task section --%>
              <%@ include file="/swb/prbSummary.jspf" %>
<%-- end Summary section --%>
              <uix:rowLayout>
                <uix:spacer height="10"/>
              </uix:rowLayout>

<%-- start Tab section --%>
              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar selectedIndexBinding="selectedTab">
                    <uix:link textBinding="PD_INCIDENTS@SWBMsgs"
                              destinationBinding="incidentsTab" />
                    <uix:link textBinding="PD_ACTIVITYLOGS@SWBMsgs"
                              destinationBinding="useractLogsTab" />
                  </uix:subTabBar>
                </uix:subTabs>

                <uix:rowLayout>
                  <uix:spacer height="5"/>
                </uix:rowLayout>

                <uix:switcher childNameBinding="selectedTab">
                    <uix:case name="0">
                        <%@ include file="/swb/prbIncidents.jspf" %>
                    </uix:case>
                    <uix:case name="1">
                        <%@ include file="/swb/prbActLogs.jspf" %>
                    </uix:case>
                </uix:switcher>
              </uix:subTabLayout>
<%-- end Tab section --%>

<%-- start related links section --%>
                 <%@ include file="/swb/homeRelatedLinks.jspf" %>
<%-- end related links section --%>
        </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

