<%--
   Name:        em/swb/quickPackage.jsp

   Description: This jsp is for quick package flow.

   Controller:  oracle.sysman.dbTarget.swb.console.problemDetail.QuickPkgController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     jsoule      02/20/07 - add view manifest
     balnaff     11/29/06 - 
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script language="JavaScript">
function openMetalink()
{
    window.open('http://metalink.oracle.com', 'Metalink');
}
</script>

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pkgView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
        <uix:form name="foo"  method="POST" destinationBinding="myTarget">
            <uix:pageLayout titleBinding ="pageTitle">
                <%@ include file="/database/global.jspf" %>
        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>
<%-- start train  --%>
                <uix:location>
                    <uix:train selectedIndexBinding="trainSelectedIndex">
                        <uix:contents>
                          <uix:link textBinding="PD_QPACKAGE_TRAIN_CREATE@SWBMsgs"/>
                          <uix:link textBinding="PD_QPACKAGE_TRAIN_VIEW@SWBMsgs"/>
                          <uix:link textBinding="PD_QPACKAGE_TRAIN_MANIFEST@SWBMsgs"/>
                          <uix:link textBinding="PD_QPACKAGE_TRAIN_SCHEDULE@SWBMsgs"/>
                        </uix:contents>
                    </uix:train>
                </uix:location>
<%-- end train  --%>

<%-- page actions  --%>
                <uix:pageButtons>
                  <uix:pageButtonBar>
                    <uix:submitButton
                      textBinding="CANCEL@SDKMsgs"
                      shortDescBinding="CANCEL@SDKMsgs"
                      formName="foo"
                      name="event"
                      value="cancel"/>
                    <uix:navigationBar
                      name="trainNav"
                      formSubmitted="true"
                      formName="foo"
                      maxValue="4"
                      minValue="1"
                      valueBinding="navVal"/>
                    <uix:submitButton
                      textBinding="SUBMIT@SWBMsgs"
                      shortDescBinding="SUBMIT@SWBMsgs"
                      renderedBinding="isLastStop"
                      formName="foo"
                      name="event"
                      value="ok"/>
                  </uix:pageButtonBar>
                </uix:pageButtons>
<%-- start context information --%>
               <uix:switcher childNameBinding="hasPackage">
                 <uix:case name="true">
                  <uix:labeledFieldLayout width="100%" columns="2" labelWidth="15%">
                    <uix:messageStyledText promptBinding="PD_QPACKAGE_DATABASE@SWBMsgs"
                          textBinding="target@pkgView@servletRequest"
                          messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                    <uix:messageStyledText promptBinding="PD_QPACKAGE_USER@SWBMsgs"
                          textBinding="userName@pkgView@servletRequest"
                          messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                    <uix:contents childDataBinding="problemKeys">
                        <uix:messageStyledText promptBinding="name"
                            textBinding="val"
                            messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                    </uix:contents>
                      <uix:messageStyledText promptBinding="PD_QPACKAGE_SR@SWBMsgs"
                              textBinding="SR@pkgView@servletRequest"
                              messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                      <uix:messageStyledText promptBinding="PD_PACKAGE_NAME@SWBMsgs"
                            textBinding="pkgName@pkgView@servletRequest"
                            messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                      <uix:messageStyledText promptBinding="PKG_SIZE@SWBMsgs"
                            textBinding="pkgSize@pkgView@servletRequest"
                            messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                  </uix:labeledFieldLayout>
                 </uix:case>
                 <uix:case name="false">
                  <uix:labeledFieldLayout width="100%" columns="2" labelWidth="15%">
                    <uix:messageStyledText promptBinding="PD_QPACKAGE_DATABASE@SWBMsgs"
                          textBinding="target@pkgView@servletRequest"
                          messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                    <uix:messageStyledText promptBinding="PD_QPACKAGE_USER@SWBMsgs"
                          textBinding="userName@pkgView@servletRequest"
                          messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                    <uix:contents childDataBinding="problemKeys">
                        <uix:messageStyledText promptBinding="name"
                            textBinding="val"
                            messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                 </uix:case>
                </uix:switcher>
                <uix:separator/>
<%-- end context information --%>

<%-- start step layout --%>
                <uix:rowLayout width="100%">
                    <uix:tableLayout width="100%">
                        <uix:rowLayout width="100%">
                            <uix:cellFormat width="90%">
                                <uix:switcher childNameBinding="trainSelectedIndex">
                                    <uix:case name="0">
                                        <%@ include file="/swb/quickPkgCreate.jspf" %>
                                    </uix:case>
                                    <uix:case name="1">
                                        <%@ include file="/swb/quickPkgViewContent.jspf" %>
                                    </uix:case>
                                    <uix:case name="2">
                                        <%@ include file="/swb/quickPkgViewManifest.jspf" %>
                                    </uix:case>
                                    <uix:case name="3">
                                        <%@ include file="/swb/quickPkgSchedule.jspf" %>
                                    </uix:case>
                                </uix:switcher>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                </uix:rowLayout>

<%-- end step layout --%>
                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>
            </uix:pageLayout>
        </uix:form>

      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

