<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.data.MessageData" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMMsgID"%>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMUIConstants"%>

<jsp:useBean id="pageView"
             scope="request"
             type="oracle.sysman.dbTarget.swb.console.hm.RunFurtherAssessmentsPageView"/>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="HMMsg"
            class="oracle.sysman.dbTarget.swb.console.hm.HMMsg"/>
 <uix:bundle name="SWBMsgs"
            class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pageView@servletRequest">
      <uix:body>
        <uix:form name="foo"
                  destination='<%= request.getContextPath()+"/console/"+HMUIConstants.RUN_FURTHER_ASSESSMENTS_PAGE %>'>
          <uix:pageLayout titleBinding='<%=HMMsgID.TITLE_RUN_FURTHER_ASSESSMENTS+"@HMMsg"%>'>
            <%@ include file="/database/global.jspf" %>
            <%@ include file = "/swb/refresh.jspf" %>
<uix:messages>
 <uix:dataScope currentDataBinding="results@pageView@servletRequest">
  <uix:switcher childNameBinding="<%= HMUIConstants.KEY_EXISTS %>">
   <uix:case name="<%= Boolean.TRUE.toString() %>">
    <uix:messageBox messageBinding="<%= MessageData.MESSAGE_DATA_MESSAGE %>"
                    messageTypeBinding="<%= MessageData.MESSAGE_DATA_TYPE_SELECT %>">
     <uix:contents childDataBinding="<%= MessageData.MESSAGE_DATA_MESSAGES_SELECT %>">
      <uix:link textBinding="<%= UIConstants.TEXT_ATTR.getAttributeName() %>"
                destinationBinding="<%= UIConstants.LONG_DESC_URL_ATTR.getAttributeName() %>"
                longDescBinding="<%= MessageData.MESSAGE_ATTR.getAttributeName() %>" />
     </uix:contents>
    </uix:messageBox>
   </uix:case>
  </uix:switcher>
 </uix:dataScope>
</uix:messages>

            <uix:tableLayout>
               <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraFieldText" labeledNodeId="incidentId" textBinding="PD_RELATED_SELINCIDENT@SWBMsgs" />
                </uix:cellFormat>
                <uix:spacer width="20" />
                <uix:cellFormat hAlign="left">
                    <uix:choice name="incidentId"
                                id="incidentId"
                                shortDescBinding="PD_RELATED_SELINCIDENT@SWBMsgs"
                                onChange="submitForm('foo', true, {event:'doLoad'})"
                                selectedValueBinding="incOptionSel">
                      <uix:contents childDataBinding="incOptions">
                        <uix:option textBinding="text"
                                    valueBinding="value"/>
                      </uix:contents>
                    </uix:choice>
                   </uix:cellFormat>
               </uix:rowLayout>
            </uix:tableLayout>
            <uix:separator/>
            <uix:header textBinding='<%=HMMsgID.HEADER_RECOMMENDED_ASSESSMENTS+"@HMMsg"%>'>
              <uix:table  width="100%"
                          tableDataBinding="recData"
                          columnHeaderDataBinding="recColHeaderData"
                          columnFormatsBinding="recColFormats"
                          formSubmitted = "true"
                          summaryBinding='<%=HMMsgID.SUMMARY_RECOMMENDED_ASSESSMENTS+"@HMMsg"%>'
                          alternateTextBinding = '<%=HMMsgID.MSG_NO_ITEMS+"@HMMsg"%>'>
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                  <uix:styledText textBinding="text"/>
                </uix:columnHeaderStamp>
                <uix:link textBinding="<%=HMUIConstants.ATTR_CHECKER_NAME%>"
                          destinationBinding="<%=HMUIConstants.ATTR_CHECKER_RUN_URL%>"/>
                <uix:styledText  textBinding="<%=HMUIConstants.ATTR_CHECKER_DESCRIPTION%>" />

              </uix:table>
            </uix:header>

            <uix:header textBinding='<%=HMMsgID.HEADER_AVAILABLE_ASSESSMENTS+"@HMMsg"%>'>
              <uix:table  width="100%"
                          tableDataBinding="availData"
                          columnHeaderDataBinding="availColHeaderData"
                          columnFormatsBinding="availColFormats"
                          formSubmitted = "true"
                          summaryBinding='<%=HMMsgID.SUMMARY_AVAILABLE_ASSESSMENTS+"@HMMsg"%>'
                          alternateTextBinding = '<%=HMMsgID.MSG_NO_ITEMS+"@HMMsg"%>'>
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                  <uix:styledText textBinding="text"/>
                </uix:columnHeaderStamp>
                <uix:link textBinding="<%=HMUIConstants.ATTR_CHECKER_NAME%>"
                          destinationBinding="<%=HMUIConstants.ATTR_CHECKER_RUN_URL%>"/>
                <uix:styledText  textBinding="<%=HMUIConstants.ATTR_CHECKER_DESCRIPTION%>" />

              </uix:table>
            </uix:header>
            <uix:dataScope currentDataBinding="results@pageView@servletRequest">
              <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"/>
              <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"/>
              <uix:formValue name="<%= HMUIConstants.PARAM_PROBLEM_ID %>"
                             valueBinding="<%=HMUIConstants.PARAM_PROBLEM_ID%>"/>
             </uix:dataScope>

          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
