<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.data.MessageData" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMMsgID"%>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMUIConstants"%>

<jsp:useBean id="pageView"
             scope="request"
             type="oracle.sysman.dbTarget.swb.console.hm.RunCheckerPageView"/>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="DBMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
 <uix:bundle name="sdkMessageBundle"
	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
 <uix:bundle name="HMMsg"
            class="oracle.sysman.dbTarget.swb.console.hm.HMMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pageView@servletRequest">
      <uix:body>
        <uix:form name="foo"
                  destination='<%= request.getContextPath()+"/console/"+HMUIConstants.RUN_CHECKER_PAGE %>'>
          <uix:pageLayout titleBinding="title@pageView@servletRequest">
            <%@ include file="/database/global.jspf" %>
<uix:messages>
 <uix:dataScope currentDataBinding="results@pageView@servletRequest">
  <uix:switcher childNameBinding="<%= HMUIConstants.KEY_EXISTS %>">
   <uix:case name="<%= Boolean.TRUE.toString() %>">
    <uix:messageBox messageBinding="<%= MessageData.MESSAGE_DATA_MESSAGE %>"
                    messageTypeBinding="<%= MessageData.MESSAGE_DATA_TYPE_SELECT %>">
     <uix:contents childDataBinding="<%= MessageData.MESSAGE_DATA_MESSAGES_SELECT %>">
      <uix:link textBinding="<%= UIConstants.TEXT_ATTR.getAttributeName() %>"
                destinationBinding="<%= UIConstants.LONG_DESC_URL_ATTR.getAttributeName() %>"
                longDescBinding="<%= MessageData.MESSAGE_ATTR.getAttributeName() %>" />
     </uix:contents>
    </uix:messageBox>
   </uix:case>
  </uix:switcher>
 </uix:dataScope>
</uix:messages>

              <uix:styledText styleClass="OraPromptText" 
                        textBinding="checkerDescription@pageView@servletRequest"/>
              <uix:header textBinding="runCheckerHeader@pageView@servletRequest">
                <uix:stackLayout>
                  <uix:tableLayout>
                    <uix:rowLayout hAlign="left">
                      <uix:styledText styleClass="OraPromptText" 
                                      textBinding='<%=HMMsgID.MSG_RUN_CHECKER+"@HMMsg"%>'/>
                    </uix:rowLayout>
                    <uix:rowLayout hAlign="left">
                      <uix:table  width="100%"
                          summaryBinding='<%=HMMsgID.SUMMARY_CHECKER_PARAMETER+"@HMMsg"%>'
                          tableDataBinding="paramData@pageView@servletRequest"
                          columnHeaderDataBinding="paramColHeaderData@pageView@servletRequest"
                          columnFormatsBinding="paramColFormats@pageView@servletRequest"
                          formSubmitted = "true"
                          alternateText = "NO_ITEM_FOUND@configBundle@servletRequest">
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:styledText textBinding="text"/>
                        </uix:columnHeaderStamp>
                        <uix:styledText  textBinding="<%=HMUIConstants.ATTR_PARAM_NAME%>" />
                        <uix:textInput shortDescBinding='<%=HMMsgID.LABEL_PARAM_VALUE+"@HMMsg"%>'
                            name="<%=HMUIConstants.PARAM_CHECKER_PARAM_VALUE%>"
                            required="<%=HMUIConstants.ATTR_PARAM_MANDATORY%>"
                            textBinding="<%=HMUIConstants.ATTR_PARAM_VALUE%>"/>
                        <uix:styledText  
                            textBinding="<%=HMUIConstants.ATTR_PARAM_DESCRIPTION%>"/>
                      </uix:table>

                     <uix:dataScope currentDataBinding="results@pageView@servletRequest">
                      <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                                     valueBinding="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"/>
                      <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                                     valueBinding="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"/>
                      <uix:formValue name="<%= HMUIConstants.PARAM_ID %>"
                                     valueBinding="<%=HMUIConstants.PARAM_ID%>"/>
                     </uix:dataScope>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:stackLayout> 
              </uix:header> 
              <uix:pageButtons>
                <uix:pageButtonBar>
                 <uix:button 
                     textBinding='<%=HMMsgID.ACTION_CANCEL+"@HMMsg"%>'
                     destinationBinding="cancelURI@pageView@servletRequest"/>
                 <uix:submitButton 
                         textBinding='<%=HMMsgID.ACTION_OK+"@HMMsg"%>'
                         name="event"
                         value="runChecker"/>
                </uix:pageButtonBar>
              </uix:pageButtons>
          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
