<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMMsgID"%>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMUIConstants" %>

<jsp:useBean id="pageView"
             scope="request"
             type="oracle.sysman.dbTarget.swb.console.hm.RunDetailFindingPageView"/>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="DBMsg"
	     class="oracle.sysman.db.rsc.inst.DBMsg"/>
 <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
 <uix:bundle name="HMMsg"
             class="oracle.sysman.dbTarget.swb.console.hm.HMMsg"/>
 <uix:bundle name="SWBMsgs" 
             class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pageView@servletRequest">
      <uix:body>
        <uix:form name="foo"
                  destination='<%= request.getContextPath()+"/console/"+HMUIConstants.RUN_DETAIL_FINDINGS_PAGE %>'>
          <uix:pageLayout titleBinding="title">
            <%@ include file="/database/global.jspf" %>
            <%@ include file = "/swb/refresh.jspf" %>
            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar>
                  <uix:contents>
                    <uix:link
                      textBinding='<%= HMMsgID.TAB_CHECKER_FINDING+"@HMMsg"%>'
                      selected="true"/>
                    <uix:link
                      textBinding='<%=HMMsgID.TAB_CHECKER_RUN+"@HMMsg"%>'
                      destinationBinding = "tabLink"/>
                  </uix:contents>
                </uix:subTabBar>
              </uix:subTabs>
              <jsp:include page="/swb/homeCheckers.jsp"/>
              <uix:ref refID="homeCheckersTabInclude"/>
            </uix:subTabLayout>
            <uix:dataScope currentDataBinding="results@findingDataSource@pageView@servletRequest">
              <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"/>
              <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                              valueBinding="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"/>
              <uix:formValue name="<%= HMUIConstants.PARAM_RUN_ID %>"
                             valueBinding="<%=HMUIConstants.PARAM_RUN_ID%>"/>
              <uix:formValue name="<%= HMUIConstants.PARAM_INCIDENT_ID %>"
                             valueBinding="<%=HMUIConstants.PARAM_INCIDENT_ID%>"/>
              <uix:formValue name="<%= HMUIConstants.PARAM_PROBLEM_ID %>"
                             valueBinding="<%=HMUIConstants.PARAM_PROBLEM_ID%>"/>
            </uix:dataScope>
          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
