<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMMsgID"%>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMUIConstants"%>

<jsp:useBean id="pageView"
             scope="request"
             type="oracle.sysman.dbTarget.swb.console.hm.RunDetailRunPageView"/>

<script language="JavaScript">
function popupReport()
{
    window.open('<%=pageView.getReportLink()%>');
}
</script>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="DBMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
 <uix:bundle name="HMMsg"
            class="oracle.sysman.dbTarget.swb.console.hm.HMMsg"/>
 <uix:bundle name="SWBMsgs" 
             class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pageView@servletRequest">
      <uix:body>
        <uix:form name="foo"
                  destination='<%= request.getContextPath()+"/console/"+HMUIConstants.RUN_DETAIL_RUNS_PAGE %>'>
          <uix:pageLayout titleBinding="title@pageView@servletRequest">
            <%@ include file="/database/global.jspf" %>
            <%@ include file = "/swb/refresh.jspf" %>
              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar>
                    <uix:contents>
                      <uix:link
                        textBinding='<%=HMMsgID.TAB_CHECKER_FINDING+"@HMMsg"%>'
                        destinationBinding = "tabLink@pageView@servletRequest"
                        selected="false"/>
                      <uix:link
                        textBinding='<%=HMMsgID.TAB_CHECKER_RUN+"@HMMsg"%>'
                        selected="true"/>
                    </uix:contents>
                  </uix:subTabBar>
                </uix:subTabs>
                    <uix:header textBinding='<%=HMMsgID.HEADER_CHECKER_RUNS+"@HMMsg"%>' 
                        rendered="<%=pageView.isCheckerTableRendered()%>">
                      <uix:styledText textBinding='<%=HMMsgID.MSG_CHECKER_RUNS+"@HMMsg"%>'
                                      styleClass="OraInstructionText"
                                      rendered="<%=pageView.isCheckerTableRendered()%>"/>

                      <uix:table  width="100%" 
                          name="<%=HMUIConstants.ATTR_CHECKER_RUN_TABLE%>"
                          summaryBinding='<%=HMMsgID.SUMMARY_CHECKER_RUN_TABLE+"@HMMsg"%>'
                          tableDataBinding="runData@pageView@servletRequest"
                          columnHeaderDataBinding="runColHeaderData@pageView@servletRequest"
                          columnFormatsBinding="runColFormats@pageView@servletRequest"
                          formSubmitted = "true"
                          rendered="<%=pageView.isCheckerTableRendered()%>"
                          alternateText ='<%= HMMsgID.MSG_NO_ITEMS+"@HMMsg"%>'>
                        <uix:tableSelection>
                          <uix:singleSelection 
                            shortDesc="SELECT@SWBMsgs"
                            selectedIndexBinding="selectedRun@pageView@servletRequest"
                            onClick="submitForm('foo',1,{'event':'doLoad'});return false">
                          </uix:singleSelection>
                        </uix:tableSelection>
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:styledText textBinding="text"/>
                        </uix:columnHeaderStamp>
                        <uix:styledText  textBinding="<%=HMUIConstants.ATTR_RUN_NAME%>" />
                        <uix:styledText  textBinding="<%=HMUIConstants.ATTR_CHECKER_NAME%>" />
                        <uix:styledText  textBinding="<%=HMUIConstants.ATTR_CHECKER_CLASS%>"/>
                        <uix:styledText  destinationBinding = "<%=HMUIConstants.ATTR_INCIDENT_URL%>"
                                         textBinding="<%=HMUIConstants.ATTR_INCIDENT_ID%>" />
                      </uix:table>
                    </uix:header>
                    <uix:spacer height="5"/>
                    <uix:separator rendered="<%=pageView.isCheckerTableRendered()%>"/>
                    <uix:tableLayout width="100%">
                      <uix:rowLayout hAlign="right">
                        <uix:button textBinding="ACTION_VIEW_REPORT_HTML@HMMsg"
                                    onClick="javascript:popupReport()"/>
                      </uix:rowLayout>
                    </uix:tableLayout>
    
                    <uix:header textBinding="subHeaderName">
                      <uix:labeledFieldLayout columns="2" labelWidth="20%">
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_RUN_NAME+"@HMMsg"%>'/>
                           <uix:styledText styleClass="OraDataText" 
                                textBinding="runName@pageView@servletRequest"/>
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_CHECKER_NAME+"@HMMsg"%>'/>
                           <uix:styledText styleClass="OraDataText" 
                                textBinding="checkerName@pageView@servletRequest"/>
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_CLASS+"@HMMsg"%>'/>
                           <uix:styledText styleClass="OraDataText" 
                                textBinding="className@pageView@servletRequest"/>
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_AVAILABILITY+"@HMMsg"%>'/>
                           <uix:styledText styleClass="OraDataText" 
                                textBinding="availability@pageView@servletRequest"/>
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_RUN_TYPE+"@HMMsg"%>'/>
                           <uix:styledText styleClass="OraDataText" 
                                textBinding="runType@pageView@servletRequest"/>
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_TRIGGERING_INCIDENT+"@HMMsg"%>'/>
                           <uix:styledText
                                destinationBinding="triggeringIncidentURL@pageView@servletRequest"
                                textBinding="triggeringIncident@pageView@servletRequest"/>
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_START_TIME+"@HMMsg"%>'/>
                           <uix:styledText styleClass="OraDataText" 
                                textBinding="startTime@pageView@servletRequest"/>
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_RUNNING_STATUS+"@HMMsg"%>'/>
                           <uix:styledText styleClass="OraDataText" 
                                textBinding="runningStatus@pageView@servletRequest"/>
                           <uix:messagePrompt 
                                promptBinding='<%=HMMsgID.LABEL_END_TIME+"@HMMsg"%>'/>
                           <uix:styledText styleClass="OraDataText" 
                                textBinding="endTime@pageView@servletRequest"/>
                      </uix:labeledFieldLayout>
                <uix:switcher childNameBinding="runParamRendered">
                  <uix:case name="<%= Boolean.TRUE.toString() %>">
                        <uix:header textBinding='<%=HMMsgID.HEADER_PARAMETER+"@HMMsg"%>' renderedBinding="runParamRendered">
                      <uix:table  width="100%"
                          summaryBinding='<%=HMMsgID.SUMMARY_CHECKER_PARAMETER+"@HMMsg"%>'
                          tableDataBinding="runParamData"
                          columnHeaderDataBinding="runParamColHeaderData"
                          columnFormatsBinding="runParamColFormats"
                          formSubmitted = "true"
                          renderedBinding="runParamRendered">
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:styledText textBinding="text"/>
                        </uix:columnHeaderStamp>
                        <uix:styledText  textBinding="<%=HMUIConstants.ATTR_PARAM_NAME%>" />
                        <uix:styledText  textBinding="<%=HMUIConstants.ATTR_PARAM_DESCRIPTION%>"/>
                        <uix:styledText  textBinding="<%=HMUIConstants.ATTR_PARAM_VALUE%>" />
                      </uix:table>
                    </uix:header>
                  </uix:case>
                </uix:switcher>
               </uix:header>
              </uix:subTabLayout>
              <uix:dataScope currentDataBinding="results@pageView@servletRequest">
                <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                               valueBinding="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"/>
                <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                                valueBinding="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"/>
                <uix:formValue name="<%= HMUIConstants.PARAM_RUN_ID %>"
                               valueBinding="<%=HMUIConstants.PARAM_RUN_ID%>"/>
                <uix:formValue name="<%= HMUIConstants.PARAM_INCIDENT_ID %>"
                               valueBinding="<%=HMUIConstants.PARAM_INCIDENT_ID%>"/>
                <uix:formValue name="<%= HMUIConstants.PARAM_PROBLEM_ID %>"
                               valueBinding="<%=HMUIConstants.PARAM_PROBLEM_ID%>"/>
              </uix:dataScope>

          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
