<%--
   Name:        em/swb/runUserAction.jsp

   Description: This jsp is for the "Run User Action"

   Controller:  oracle.sysman.dbTarget.swb.console.common.RunUAController

   Notes:
    input
        id       : action name
        incident : incident id
        invocation : invocation id
        returnurl

   Events:

   MODIFIED     (MM/DD/YY)
     jro         04/17/07 - fix for bug 5940869
     balnaff     11/29/06 - 
     hopark      05/03/06 - Created
  --%>


<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="runUAView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">
         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>
        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- page actions  --%>
                <uix:pageButtons>
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@SDKMsgs"
                      shortDescBinding="CANCEL@SDKMsgs"
                      destinationBinding="returnUrl" />
                    <uix:submitButton
                      textBinding="SUBMIT@SWBMsgs"
                      shortDescBinding="SUBMIT@SWBMsgs"
                      formName="foo"
                      name="event"
                      value="ok"/>
                  </uix:pageButtonBar>
                </uix:pageButtons>

<%-- start summary selection --%>
              <uix:rowLayout>
                  <uix:tableLayout>
                    <uix:contents childDataBinding="actionInfo">
                          <%@ include file="/swb/summaryLayout.jspf" %>
                    </uix:contents>
                  </uix:tableLayout>
              </uix:rowLayout>
<%-- end summaryselection--%>

<%-- start sql text section --%>
              <uix:rowLayout>
                <uix:header textBinding="RUNUA_SQLTEXT@SWBMsgs" renderedBinding="showSql">
                <uix:stackLayout>
                  <uix:contents>
                <uix:styledText styleClass="OraInstructionText" textBinding = "RUNUA_SQLTEXT_PROMPT@SWBMsgs" />
                <uix:textInput shortDescBinding="RUNUA_SQLTEXT@SWBMsgs" name="SQLTextInTextBox" textBinding="SQLTextInTextBox" 
                    columns="80" rows="5" readOnlyBinding="sqlReadonly" id="SQLTextInTextBox" required="yes"/>
                  </uix:contents>
                </uix:stackLayout>
                </uix:header>
              </uix:rowLayout>
<%-- end sql text section --%>

<%-- start parameter table --%>
              <uix:rowLayout>
                <uix:header textBinding="RUNUA_PARAMETERS_HEADER@SWBMsgs">
                    <uix:styledText styleClass="OraInstructionText" textBinding = "RUNUA_PARAMETERS_PROMPT@SWBMsgs" />
                <uix:dataScope currentDataBinding="tableBean">
                  <uix:dataScope currentDataBinding="parameterTbl">
                    <uix:table name="parameterTbl"
                            id="parameterTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="RUNUA_PARAMETERS_ALTTEXT@SWBMsgs"
                            destinationBinding="destination"
                            summaryBinding="RUNUA_PARAMETERS_SUMMARY@SWBMsgs"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            columnHeaderDataBinding="columnHeaderData"
                            columnFormatsBinding="columnFormatsData"
                            formSubmitted="true">
                            <uix:columnHeaderStamp>
                               <uix:sortableHeader textBinding="text"
                                                   valueBinding="value"
                                                   sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>

                            <uix:contents>
                               <uix:styledText textBinding="Name" />
                               <uix:textInput name="value" shortDescBinding="RUNUA_PARAMETERS_VAL@SWBMsgs" 
                                              textBinding="Value" readOnlyBinding="Readonly"/>
                               <uix:styledText textBinding="Desc" />
                            </uix:contents>
                         </uix:table>
                      </uix:dataScope>
                    </uix:dataScope>
                 </uix:header>
                </uix:rowLayout>
<%-- end parameters section --%>


              <uix:rowLayout>
                <uix:header textBinding="RUNUA_SCHEDULE_TITLE@SWBMsgs">
              <%@ include file="/swb/schedule.jspf" %>

                <uix:switcher childNameBinding="ShowHostCred@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                          <uix:spacer height="10"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                         <uix:header textBinding="HOST_CREDS@SWBMsgs">
                           <%@ include file="/dbhostcreds.jspf" %>
                         </uix:header>
                      </uix:rowLayout>
                     </uix:case>
                </uix:switcher>
                </uix:header>
              </uix:rowLayout>

        </uix:pageLayout>
       </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

