<%--
   Name:        em/swb/runUserAction.jsp

   Description: This jsp is for the "Run User Action"

   Controller:  oracle.sysman.dbTarget.swb.console.common.RunUAController

   Notes:
    input
        id       : action name
        incident : incident id
        invocation : invocation id
        returnurl

   Events:

   MODIFIED     (MM/DD/YY)
     jro         02/26/07 - fix for bug 5878636
     jro         02/19/07 - edit user action table
     hopark      05/03/06 - Created
  --%>


<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="runUAView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">
         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>
        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- page actions  --%>
                <uix:pageButtons>
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@SDKMsgs"
                      shortDescBinding="CANCEL@SDKMsgs"
                    destinationBinding="returnUrl" />
                    <uix:button textBinding="BACK@SDKMsgs"
                      shortDescBinding="BACK@SDKMsgs"
                      onClick="submitForm('foo', true, {event:'back'})" />
                    <uix:submitButton
                      textBinding="SUBMIT@SWBMsgs"
                      shortDescBinding="SUBMIT@SWBMsgs"
                      formName="foo"
                      name="event"
                      value="ok"/>
                  </uix:pageButtonBar>
                </uix:pageButtons>

              <uix:rowLayout>
                  <uix:spacer height="20"/>
              </uix:rowLayout>

              <%@ include file="/swb/schedule.jspf" %>
    
                <uix:switcher childNameBinding="ShowHostCred@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                          <uix:spacer height="10"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                         <uix:header textBinding="HOST_CREDS@SWBMsgs">
                           <%@ include file="/dbhostcreds.jspf" %>
                         </uix:header>
                      </uix:rowLayout>
                     </uix:case>
                </uix:switcher>

              <uix:rowLayout>
                  <uix:spacer height="20"/>
              </uix:rowLayout>

        </uix:pageLayout>
       </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

