<%--
   Name:        em/swb/trace.jsp

   Description: This jsp is for the Support workbench/ incident detail/ trace viewer

   Controller:  oracle.sysman.dbTarget.swb.console.incidentDetail.TraceViewerController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     jro         05/11/07 - fix for bug 5979273
     balnaff     02/17/07 - 
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="TraceView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST" destinationBinding="myTarget">
         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>
        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- page actions  --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                    textBinding="OK@SDKMsgs"
                    destinationBinding="traceReturnUrl" />
              </uix:pageButtonBar>
            </uix:pageButtons>

            <uix:rowLayout>
                  <uix:spacer height="10"/>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:tableLayout>
                    <uix:rowLayout>
                        <uix:cellFormat>
                            <uix:spacer width="20" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                            <uix:styledText styleClass="OraFieldText" textBinding="TRACE_FILENAME@SWBMsgs" />
                        </uix:cellFormat>
                        <uix:cellFormat>
                            <uix:spacer width="20" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                             <uix:styledText styleClass="OraDataText" textBinding="traceFileName" />
                        </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                        <uix:spacer height="3"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                        <uix:cellFormat>
                            <uix:spacer width="20" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                            <uix:styledText styleClass="OraFieldText" textBinding="TRACE_MODIFED@SWBMsgs" />
                        </uix:cellFormat>
                        <uix:cellFormat>
                            <uix:spacer width="20" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                         <uix:styledText styleClass="OraDataText" textBinding="traceModified" />
                        </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                        <uix:spacer height="3"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                        <uix:cellFormat>
                            <uix:spacer width="20" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                            <uix:styledText styleClass="OraFieldText" textBinding="TRACE_SIZE@SWBMsgs" />
                        </uix:cellFormat>
                        <uix:cellFormat>
                            <uix:spacer width="20" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                             <uix:styledText styleClass="OraDataText" textBinding="traceSize" />
                        </uix:cellFormat>
                    </uix:rowLayout>
                </uix:tableLayout>
            </uix:rowLayout>
            <uix:rowLayout>
                <uix:spacer height="3"/>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:image source="/em/images/infoicon_active.gif" shortDescBinding="TRACE_WARNING@SWBMsgs"/>
                <uix:styledText styleClass="OraInstructionText" textBinding="TRACE_WARNING@SWBMsgs"/>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:spacer height="3"/>
            </uix:rowLayout>

            <uix:header textBinding="TRACE_VIEWER_HEADER@SWBMsgs">
               <uix:styledText styleClass="OraInstructionText"
                               textBinding="TRACE_INSTR@SWBMsgs"/>
               <uix:tip>
                  <uix:contents>
                    <uix:styledText textBinding="TRACE_TIP_TEXT@SWBMsgs" />
                  </uix:contents>
               </uix:tip>
               <uix:header textBinding="TRACE_DETAILS@SWBMsgs">
                <uix:dataScope currentDataBinding="tableBean">
                   <uix:dataScope currentDataBinding="TraceMapTbl">
                        <uix:hGrid id="TraceMapTbl"
                           width="100%"
                           formSubmitted="true"
                           alternateTextBinding="TRACE_ALT_TEXT@SWBMsgs"
                           destinationBinding="destination"
                           columnFormatsBinding="columnFormatsData"
                           columnHeaderDataBinding="columnHeaderData"
                           treeDataBinding="treeNodes@servletRequest"
                           proxyBinding="TraceMapProxy@servletRequest">
                             <uix:nodeStamp>
                                 <uix:styledText textBinding="text"
                                                destinationBinding="detailUrl" />
                            </uix:nodeStamp>
                         </uix:hGrid>

                    </uix:dataScope>
                 </uix:dataScope>
                <uix:textInput textBinding="traceDetail"
                                shortDescBinding="TRACE_DETAILS@SWBMsgs"
                               readOnly="true"
                               name="trDetail"
                               rows="30" columns="150" />
              </uix:header>
             </uix:header>

        </uix:pageLayout>
       </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

