<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        Metrics.jsp 
 *
 *       
 * MODIFIED
 *    gapadman   06/17/08 - changing yaxis scale
 *    gapadman   06/11/08 - change scale for resource usage and wait
 *    gapadman   04/11/08 - implement manual refresh
 *    gapadman   02/12/08 - add label for charts
 *    gapadman   10/01/07 - fix for refresh issue
 *    gapadman   06/26/07 - 

 *    GAPADMAN    06/25/07 - WLM Metrics
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<%     
    response.setHeader("Pragma", "No-cache");
    response.setHeader("Cache-Control", "no-cache");
%>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 
  
  
       <uix:switcher childNameBinding="selRefChoice@wlmmetricbean@servletRequest">
        <uix:case name="RT_15">
        <uix:rawText>
         <meta http-equiv="Refresh" 
                content="60" >
         <%--
               content='60;URL=<%=request.getAttribute("refreshDest") %>' >
        --%>
        </uix:rawText>
      </uix:case>
    </uix:switcher>  

  <uix:document> 
  
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>  
    <%@ include file="/oemGlobal.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>

    <uix:body>
    
 

             <db:form name="metricForm" method="post" destination="/console/wlm/wlmMetrics"
               copyParams="target,type,pageId">
               
               
          <uix:pageLayout >
       
       <%@ include file="/oemGlobal.jspf" %>
       
        <uix:messages>
          <uix:switcher childNameBinding="showWarning@servletRequest">
            <uix:case name="true">
            
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              destTableBinding="msgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                                      
            </uix:case>
          </uix:switcher>    
        </uix:messages>          

               
          <uix:stackLayout>
          
          
          
              <uix:tableLayout width="100%" >
                <uix:rowLayout >
                  
                  <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:styledText styleClass="OraFieldText" 
                                      textBinding="PSM_PC_NAME@resourcesBundle@servletRequest"
                                      labeledNodeId="pcName"/>                  
                    <uix:choice name="pcName" id = "pcName"
                            onChange="submitForm('metricForm', true, {'event':'updatePCName'})"
                            selectedValueBinding="selPCName@wlmmetricbean@servletRequest">
            
                            <uix:contents childDataBinding="perfClsNames@wlmmetricbean@servletRequest">
                                <uix:option textBinding="text" valueBinding="val" />
                            </uix:contents>
                    </uix:choice>   
                </uix:flowLayout>                    
                  </uix:cellFormat>
                  
                  <uix:cellFormat hAlign="right">
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraFieldText" 
                                      textBinding="VIEW_DATA@resourcesBundle@servletRequest"
                                      labeledNodeId="refreshChoice"/>
                      <uix:choice name="refreshChoice" id="refreshChoice"
                                  shortDescBinding="VIEW_DATA@resourcesBundle@servletRequest"
                                  onChange="submitForm('metricForm', true, {'event':'updateRefreshChoice'})"
                                  selectedValueBinding="selRefChoice@wlmmetricbean@servletRequest"> 
                                  
                        <uix:option textBinding="REAL_TIME_AUTO_60_SEC@resourcesBundle@servletRequest"
                                    value="RT_15"/>

                        <uix:option textBinding="REAL_TIME_MANUAL@resourcesBundle@servletRequest"
                                    value="RT_MAN"/>
                      </uix:choice>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                
                <uix:rowLayout >
                  <uix:cellFormat hAlign="left">
                        <uix:flowLayout>
                              <uix:styledText  styleClass="OraInstructionText"
                                         textBinding="PCMETRICS_HDR_DESC@resourcesBundle@servletRequest" /> 	
                                <uix:image source="/em/images/infoicon_active.gif"
                                hAlign="center"
                               destination="javascript:(new Function('a', 'b', 'c', 'd', 'openWindow(a, b, c, d)'))(top, '/em/console/help/?locale=en_US&amp;topic=rac_cs_policy_set_appqos_perf_metrics_page','helpWindow', {width:650, height:450, menubar:0, location:0, status:0, directories:0});"
                               shortDescBinding="MORE_INFO@resourcesBundle@servletRequest"
                              />
                        </uix:flowLayout> 
                  </uix:cellFormat>
                </uix:rowLayout >
                
              </uix:tableLayout>
        
       <uix:rawText>
          <a name="METRICS_PC_PERF_HDR" />
       </uix:rawText>     
              
<uix:header textBinding="METRICS_PC_PERF_HDR@resourcesBundle@servletRequest">          
            <uix:stackLayout>
      
          <oem:chart
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="825"
                  height="250"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="none"
                  yAxisLabelBinding="METRICS_PC_PERF_YAXIS@resourcesBundle@servletRequest"
                  xAxisLabelBinding="METRICS_XAXIS@resourcesBundle@servletRequest"
                  legendPosition="east"
                  legendVisible="external"
                  seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="refChoiceSVG@wlmmetricbean@servletRequest"
		  xAxisMin="0" xAxisMax="" yAxisWidth="65"  axisMin="-100"  axisMax="100" svgHighlightLegend="true" 
                  >
                <oem:boundChartDataSource dataClass="oracle.sysman.wlm.metrics.MetricsController" dataMethod="updatePSMChart"/>
                
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>

              </oem:chart>
                </uix:stackLayout>
              
         </uix:header>              
         
         
        <uix:rawText>
          <a name="DEM" />
       </uix:rawText>         
         
         <uix:header textBinding="METRICS_DEMAND_HDR@resourcesBundle@servletRequest">          
         <uix:stackLayout>
            <oem:chart
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="825"
                  height="250"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="none"
                  yAxisLabelBinding="METRICS_DEMAND_YAXIS@resourcesBundle@servletRequest"
                  xAxisLabelBinding="METRICS_XAXIS@resourcesBundle@servletRequest"
                  legendPosition="east"
                  legendVisible="external"
                  seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="refChoiceSVG@wlmmetricbean@servletRequest"
		  xAxisMin="0" xAxisMax="" yAxisWidth="65" axisMin="0"   svgHighlightLegend="true" 
                  >
                <oem:boundChartDataSource dataClass="oracle.sysman.wlm.metrics.MetricsController" dataMethod="updateDemPCChart"/>
                
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </oem:chart>
         </uix:stackLayout>
         </uix:header>
         
        <uix:rawText>
          <a name="ACT_VAL" />
       </uix:rawText>       
          
<uix:header textBinding="METRICS_RES_TIME@resourcesBundle@servletRequest">          
         <uix:stackLayout>
            <oem:chart
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="825"
                  height="250"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="none"
                  yAxisLabelBinding="METRICS_RES_YAXIS@resourcesBundle@servletRequest"
                  xAxisLabelBinding="METRICS_XAXIS@resourcesBundle@servletRequest"
                  legendPosition="east"
                  legendVisible="external"
                  seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="refChoiceSVG@wlmmetricbean@servletRequest"
		  xAxisMin="0" xAxisMax="" yAxisWidth="65" axisMin="0"  svgHighlightLegend="true" 
                  >
                <oem:boundChartDataSource dataClass="oracle.sysman.wlm.metrics.MetricsController" dataMethod="updateResTimePCChart"/>
                
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </oem:chart>
         </uix:stackLayout>
         </uix:header>            
      
       
       <uix:rawText>
          <a name="METRICS_RES_WAIT" />
       </uix:rawText>
         
<uix:header textBinding="METRICS_RES_WAIT@resourcesBundle@servletRequest">          
            <uix:stackLayout>
      
          <oem:chart
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="825"
                  height="250"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="none"
                  yAxisLabelBinding="METRICS_RES_YAXIS@resourcesBundle@servletRequest"
                  xAxisLabelBinding="METRICS_XAXIS@resourcesBundle@servletRequest"
                  legendPosition="east"
                  legendVisible="external"
                  seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="refChoiceSVG@wlmmetricbean@servletRequest"
		  xAxisMin="0" xAxisMax="" yAxisWidth="65"  axisMin="0"  svgHighlightLegend="true"
		 
		                   >
                <oem:boundChartDataSource dataClass="oracle.sysman.wlm.metrics.MetricsController" dataMethod="updateWaitResPCChart"/>
                
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
                
              </oem:chart>
                </uix:stackLayout>
              
         </uix:header>  
         

        <uix:rawText>
          <a name="MET_VAL" />
       </uix:rawText>         
         
        <uix:header textBinding="METRICS_RES_USAGE@resourcesBundle@servletRequest">          
         <uix:stackLayout>
            <oem:chart
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="825"
                  height="250"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="none"
                  yAxisLabelBinding="METRICS_RES_YAXIS@resourcesBundle@servletRequest"
                  xAxisLabelBinding="METRICS_XAXIS@resourcesBundle@servletRequest"
                  legendPosition="east"
                  legendVisible="external"
                  seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="refChoiceSVG@wlmmetricbean@servletRequest"
		  xAxisMin="0" xAxisMax="" yAxisWidth="65" axisMin="0"  svgHighlightLegend="true" 
		   >
                <oem:boundChartDataSource dataClass="oracle.sysman.wlm.metrics.MetricsController" dataMethod="updateWaitUsagePCChart"/>
                
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </oem:chart>
         </uix:stackLayout>
         </uix:header>                   
         
          </uix:stackLayout>

        </uix:pageLayout>
               </db:form>
 
    </uix:body>
  </uix:document>
</uix:renderingContext>
