<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
 <html>
 <head>
 <title> HM Run Report </title>
  <style type="text/css">
    body, table, input, select, textarea
    {font:normal normal 8pt Verdana,Arial;text-decoration:none;color:#000000;}
    .s8 {font-size:8pt;color:#006699}
    .s9 {font-size:10pt;color:#006699}
    .s10 {font-size:14pt;color:#006699;}
    .s16 {border-width : 1px; border-color : #CCCC99;
            border-style: solid;color:#006699;font-size:8pt;}
    .s17 {border-width : 1px; border-color : #CCCC99;
           border-style: solid;font-size:8pt;}
  </style>
 </head>
 <body>
  <xsl:apply-templates select="HM-REPORT/RUN_INFO"/>
  <xsl:apply-templates select="HM-REPORT/RUN_PARAMETERS"/>
  <font class="s10"><br/><u>Run Findings And Recommendations</u> </font>
  <xsl:apply-templates select="HM-REPORT/RUN-FINDINGS/FINDING"/>
 </body>
 </html>
</xsl:template>

<!-- run info  -->
<xsl:template match="HM-REPORT/RUN_INFO">
  <font class="s10"><u>Basic Run Information</u> </font>
  <table class="ex" cellspacing="0" border="0">
    <tr><th align="left">Run Name</th>
           <td>: <xsl:value-of select="RUN_NAME"/></td></tr>
    <tr><th align="left">Run Id</th>
           <td>: <xsl:value-of select="RUN_ID"/></td></tr>
    <tr><th align="left">Check Name</th>
           <td>: <xsl:value-of select="CHECK_NAME"/></td></tr>
    <tr><th align="left">Mode</th>
           <td>: <xsl:value-of select="RUN_MODE"/></td></tr>
    <tr><th align="left">Status</th>
           <td>: <xsl:value-of select="RUN_STATUS"/></td></tr>
    <tr><th align="left">Start Time</th>
           <td>: <xsl:value-of select="RUN_START_TIME"/></td></tr>
    <tr><th align="left">End Time</th>
           <td>: <xsl:value-of select="RUN_END_TIME"/></td></tr>
    <tr><th align="left">Error Encountered</th>
           <td>: <xsl:value-of select="RUN_ERROR_NUM"/></td></tr>
    <tr><th align="left">Source Incident Id</th>
           <td>: <xsl:value-of select="SOURCE_INCIDENT_ID"/></td></tr>
    <tr><th align="left">Number of Incidents Created </th>
           <td>: <xsl:value-of select="NUM_INCIDENTS_CREATED"/></td></tr>
   </table>
</xsl:template>

<!-- run parameters  -->
<xsl:template match="HM-REPORT/RUN_PARAMETERS">
  <font class="s10"><u><br/>Input Paramters for the Run</u> </font>
  <table border="0">
     <xsl:for-each select="RUN_PARAMETER">
     <tr>
       <td> <xsl:value-of select="."/></td>
     </tr>
     </xsl:for-each>
  </table>
</xsl:template>

<!-- run findings  -->
<xsl:template match="HM-REPORT/RUN-FINDINGS">
  <font class="s10"><u>Run Findings</u> <br/><br/></font>
     <xsl:for-each select="FINDING">
     <table class="ex" cellspacing="0" border="0">
     <tr>
       <th align="left">Finding Name</th>
       <td> : <xsl:value-of select="FINDING_NAME"/></td>
     </tr>
     <tr>
       <th align="left">Finding ID</th>
       <td> : <xsl:value-of select="FINDING_ID"/></td>
     </tr>
     <tr>
       <th align="left">Type</th>
       <td> : <xsl:value-of select="FINDING_TYPE"/></td>
     </tr>
     <tr>
       <th align="left">Status</th>
       <td> : <xsl:value-of select="FINDING_STATUS"/></td>
     </tr>
     <tr>
       <th align="left">Priority</th>
       <td> : <xsl:value-of select="FINDING_PRIORITY"/></td>
     </tr>
     <xsl:for-each select="FINDING_MESSAGE">
     <tr>
       <th align="left">Message</th>
       <td> : <xsl:value-of select="."/></td>
     </tr>
     </xsl:for-each>
     </table>
     <font class="s5"><u> </u> <br/><br/></font>
     </xsl:for-each>
</xsl:template>

<!-- run recommendation  -->
<xsl:template match="HM-REPORT/RUN-FINDINGS/FINDING">
     <table class="ex" cellspacing="0" border="0">
     <tr> <br/> </tr>
     <tr><td><font class="s9"><u>Finding</u> </font> </td></tr>
     <tr>
       <th align="left">Finding Name</th>
       <td> : <xsl:value-of select="FINDING_NAME"/></td>
     </tr>
     <tr>
       <th align="left">Finding ID</th>
       <td> : <xsl:value-of select="FINDING_ID"/></td>
     </tr>
     <tr>
       <th align="left">Type</th>
       <td> : <xsl:value-of select="FINDING_TYPE"/></td>
     </tr>
     <tr>
       <th align="left">Status</th>
       <td> : <xsl:value-of select="FINDING_STATUS"/></td>
     </tr>
     <tr>
       <th align="left">Priority</th>
       <td> : <xsl:value-of select="FINDING_PRIORITY"/></td>
     </tr>
     <xsl:for-each select="FINDING_MESSAGE">
     <tr>
       <th align="left">Message</th>
       <td> : <xsl:value-of select="."/></td>
     </tr>
     </xsl:for-each>
     </table>
     <xsl:for-each select="RECOMMENDATION">
     <table class="ex" cellspacing="0" border="0">
     <tr><td/> <td><font class="s8"><u>Recommendation</u> </font> </td></tr>
     <tr>
       <td/>
       <th align="left">Recommendation Name</th>
       <td> : <xsl:value-of select="RECOMMENDATION_NAME"/></td>
     </tr>
     <tr>
       <td/>
       <th align="left">Recommendation ID</th>
       <td> : <xsl:value-of select="RECOMMENDATION_ID"/></td>
     </tr>
     <tr>
       <td/>
       <th align="left">Type</th>
       <td> : <xsl:value-of select="RECOMMENDATION_TYPE"/></td>
     </tr>
     <tr>
       <td width="80" />
       <th align="left">Message</th>
       <td> : <xsl:value-of select="RECOMMENDATION_MSG"/></td>
     </tr>
     </table>
     </xsl:for-each> 
</xsl:template>

</xsl:stylesheet>
