#!/usr/local/bin/perl
# 
# $Header: cacheRepository.pl 31-aug-2007.00:07:32 chirgupt Exp $
#
# cacheRepository.pl
# 
# Copyright (c) 2007, Oracle. All rights reserved.  
#
#    NAME
#      cacheRepository.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    chirgupt    08/31/07 - 
#    rattipal    08/08/07 - 
#    rshetty     07/30/07 - Makes a mirror of the rpm repository and copies
#                           boot files to boot directory
#    rshetty     07/30/07 - Creation
#

#This script has to passed the following parameters
#rpmUrl - The rpm repository url
#stageDir -  The directory path where the mirror has to be created.

use strict;

my $rpmUrl = shift;
my $stageDir = shift;


print " Printing parameters\n";
print "rpmUrl = $rpmUrl\n";
print "stageDir= $stageDir\n";

my $rpmMirrorTopDir = "RPM-RepositoryMirror";

my $rpmMirrorDir = $rpmUrl;
$rpmMirrorDir =~ s/(ftp|http|https)\:\/\///g;

my $rpmMirrorTopDirPath = $stageDir."/".$rpmMirrorTopDir;
my $rpmMirrorDirPath = $stageDir."/".$rpmMirrorTopDir."/".$rpmMirrorDir;


#Find the repository type
#First check in RedHat directory if not found check in Enterprise
my $osType = "RedHat";
my $headerFilePath = $rpmUrl."/$osType/RPMS/headers/header.info";
my $headerFileName = "header.info";

my $status = syscmd ("wget $headerFilePath -O $headerFileName","Not a $osType repository","false");
if ($status != 0) {
	$osType = "Enterprise";
	$headerFilePath = $rpmUrl."/$osType/RPMS/headers";
	$status = syscmd ("wget $headerFilePath -O $headerFileName","Not a $osType repository","true");
}

#Find is the repository already exists and compare the header file if it exists
#If header file is not same download the rpm repository


if (!(-d $rpmMirrorDirPath) || ((-d $rpmMirrorDirPath) && 
	(syscmd("diff $headerFileName $rpmMirrorDirPath/$osType/RPMS/headers/header.info","","false")))) {

	#Create the top dir if not there
	if (!(-d $rpmMirrorTopDirPath))
	{
		syscmd("mkdir -m 755 $rpmMirrorTopDirPath","Failed to create $rpmMirrorTopDirPath","true");
	}


	print ("Beginning  to sync repository mirror \n");
	syscmd ("cd $rpmMirrorTopDirPath; wget $rpmUrl/$osType/RPMS -r -np -l 1 -N -nv", "Failed to download RPMS dir","true");
	syscmd ("cd $rpmMirrorTopDirPath; wget $rpmUrl/$osType/base -r -np -l 1 -N -nv" ,"Failed to download base dir","true");
	syscmd ("cd $rpmMirrorTopDirPath; wget $rpmUrl/$osType/RPMS/headers -r -np -l 1 -N -nv", "Failed to download headers Dir","true");
	syscmd ("chmod -R 755 $rpmMirrorTopDirPath","Could not change permissions of $rpmMirrorDirPath","true");

}
else
{
	print ("Repository already mirrored\n");
}



=head
syntax execute ($command,$errorMessage,$isexit)

This functions executes the system command $command and print $errorMessage on failure and exits if $isExit is true
=cut
sub syscmd ()
{
	 my $command = shift;
	 my $errorMessage = shift;
  	 my $isExit = shift;  # by deafult is true

     print ("Executing command: $command\n");
	 system($command);
	 my $exitStatus = $? >> 8;
	 if ($exitStatus != 0)
	 {
		  print ("Status: Failed\n");
		  print ("Error Status: $exitStatus\n");
		  if ($errorMessage) {print ("Error Message: $errorMessage\n");}

		  if ($isExit ne "false") {
    		  exit ($exitStatus);
		  }	
	 }
	 else {
		print ("Status:Succeded\n");
	 }
	 return ($exitStatus);
}
