# 
# $Header: createInstallInfo.pl 07-mar-2006.21:32:18 rattipal Exp $
#
# createInstallInfo.pl
# 
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      createInstallInfo.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    03/07/06 - single oms.properties file 
#    prayarot    10/06/05 - prayarot_prov_security
#    pshroff     10/01/05 - Creation
# 

use strict;
use LWP::Simple;

my $RPMREP_URL = "REPOSITORY_URL=";
my $EMDWALLETERSRCURL = "emdWalletSrcUrl=";

my $imageType = $ARGV[0];
#my $installUser = $ARGV[0];
my $propFile = $ARGV[1];
my $agentFile = $ARGV[2];
my $emd_prop_filepath = $ARGV[3];

if ($imageType =~ /^CustomImage/) 
{
    my $installUser = $ARGV[5];
    my $passwordFile = $ARGV[4];
    my $installPassword=<STDIN>;
    
my $cryptPassword = crypt($installPassword, "Xa");
    
    open PASSFILE, ">>$passwordFile" or die "Can't open $passwordFile $!";	# Open for appending
    
    my $installUserInfo="INSTALL_USER=$installUser\n";
    my $installPasswordInfo="INSTALL_PASSWORD=$cryptPassword\n";
    
    print PASSFILE $installUserInfo;
    print PASSFILE $installPasswordInfo;
    close PASSFILE;
}

open AGENTFILE, ">$agentFile" or die "Can't open $agentFile $!";
print AGENTFILE "agentUserName=oraem\nagentUserGroup=dba\nBASEDIR=\"/usr/lib/oracle\"";
close AGENTFILE;


open PROPFILE, ">>$propFile" or die "Can't open $propFile $!";
open EMD_PROPERTY_FILEHANDLE, "$emd_prop_filepath" or die "Can't open EMD Property File $!";

my $entry;

while ($entry = <EMD_PROPERTY_FILEHANDLE> )
{
    chomp $entry;
    
    if ($entry =~ $RPMREP_URL)
    {
        print "rep-url is $entry\n";
#        print PROPFILE "$entry\n";
    }
    
    if ($entry =~ $EMDWALLETERSRCURL)
    {
	print "wallet-url is $entry\n";
#         print PROPFILE "$entry\n";
	
        if ($entry =~ m,^emdWalletSrcUrl=http://([^/:]+)(?::(\d+))?(/\S*)?$,) 
        { 
            my $host = $1;
            my $port = $2 || 80;
            
            print PROPFILE "s_OMSHost=\"$host\"\n";
            print PROPFILE "s_OMSPort=\"$port\"\n";
        }
    }
}

close PROPFILE; 
close EMD_PROPERTY_FILEHANDLE;

