#!/usr/local/bin/perl
# 
# $Header: createOMSConfigFile.pl 03-sep-2005.02:09:35 pshroff Exp $
#
# createOMSConfigFile.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      createOMSConfigFile.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pshroff     09/03/05 - getting oms hostname/port from walleturl 
#    pshroff     08/08/05 - removing OMS_REG hardcoded pwd 
#    pshroff     07/28/05 - removing append for oms-prop-file-bug#4520449 
#    pshroff     06/30/05 - pshroff_map_shiphome
#    pshroff     06/29/05 - Creation
# 

use strict;
use LWP::Simple;

my $RPMREP_URL = "REPOSITORY_URL=";
my $EMDWALLETERSRCURL = "emdWalletSrcUrl=";

my $emd_prop_filepath = $ARGV[0];
my $oms_property_filename = $ARGV[1];


print "to create oms property file $emd_prop_filepath\n";

open EMD_PROPERTY_FILEHANDLE, "$emd_prop_filepath" or die "Can't open EMD Property File $!";

my $entry;
  
open OUT, ">$oms_property_filename" or die "Can create  OMS Property File" ;
    

while ($entry = <EMD_PROPERTY_FILEHANDLE> )
{
    chomp $entry;

    if ($entry =~ $RPMREP_URL) 
    {
        print "rep-url is $entry\n";
        print OUT "$entry\n";
    }
 
     if ($entry =~ $EMDWALLETERSRCURL) 
    {
         print "wallet-url is $entry\n";
         print OUT "$entry\n";
    
        if ($entry =~ m,^emdWalletSrcUrl=http://([^/:]+)(?::(\d+))?(/\S*)?$,) 
        { 
            my $host = $1;
            my $port = $2 || 80;
            
            print OUT "s_OMSHost=\"$host\"\n";
            print OUT "s_OMSPort=\"$port\"\n";
        }
    }
}

close OUT; 
close EMD_PROPERTY_FILEHANDLE;
