#!/usr/local/bin/perl
# 
# $Header: createRepositoryMirror.pl 17-jun-2007.23:58:04 rshetty Exp $
#
# createRepositoryMirror.pl
# 
# Copyright (c) 2007, Oracle. All rights reserved.  
#
#    NAME
#      createRepositoryMirror.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rshetty     06/17/07 - changing permissions of repository dir to 777
#    gaurgupt    02/14/07 - 
#    spudukol    02/01/07 - Creating a mirror repository on the Stage Server
#    spudukol    02/01/07 - Creation
#
use LWP::Simple;
use strict;

my $repositoryMirrorTopDir = "RPM-RepositoryMirror";


#print "Enter repository URL:";
#my $rpm_repository_name = <STDIN>;

#print "Enter location of staging directory:";
#my $stagetopdir = <STDIN>;

#chomp($rpm_repository_name);
#chomp($stagetopdir);

my $rpm_repository_name = shift;
my $stagetopdir = shift;

if (($rpm_repository_name eq "")||($stagetopdir eq ""))
{
  print "Usage: createRepositoryMirror.pl <RPM Repository URL> <Path of Stage Directory>\n";
  exit 1;
}



my $rpm_repository_dir = $rpm_repository_name;
$rpm_repository_dir =~ s/(ftp|http|https)\:\/\///g;

my $repositoryMirrorTopDirPath = $stagetopdir."/".$repositoryMirrorTopDir;
my $rpm_repository_dir_path = $stagetopdir."/".$repositoryMirrorTopDir."/".$rpm_repository_dir;
my $repositoryMirrorTopDirPath = $stagetopdir."/".$repositoryMirrorTopDir;

#check if repository is correct
#system("wget $rpm_repository_name/RedHat/RPMS/headers/header.info");

my $repository_type = "RedHat";
my $header_dir_source = $rpm_repository_name."/$repository_type/RPMS/headers";
my $header_dir_target = `pwd`;

chomp($header_dir_target);

system("rm -f header.info");
copyFileFromRepository($header_dir_source, $header_dir_target, "header.info");

#first check in RedHat directory if not found check in Enterprise
if (! -e "header.info")
{
  $repository_type = "Enterprise";
  $header_dir_source = $rpm_repository_name."/$repository_type/RPMS/headers";

  system("rm -f header.info");
  copyFileFromRepository($header_dir_source, $header_dir_target, "header.info");
  if (! -e "header.info")
  {
    print "Repository does not exist or is not in proper format\n";
    system("rm -f header.info");
    exit 1;
  }
}

if (!(-d $rpm_repository_dir_path))
{
     system("mkdir -p $rpm_repository_dir_path");
     if ($? != 0)
     {
	exit 1;
     }	
     system("cd $rpm_repository_dir_path; mkdir -p $repository_type/RPMS/headers; mkdir -p $repository_type/base");
}


#copy RPMS

open (HEADER,"header.info");
my @header_entrys = <HEADER>;
close (HEADER);

system("cp header.info  $rpm_repository_dir_path/$repository_type/RPMS/headers");
system ("rm -f header.info");

my  $rpm_repository_url = $rpm_repository_name."/$repository_type/RPMS";
my $rpm_target_loc = $rpm_repository_dir_path."/$repository_type/RPMS";
foreach my $header_entry(@header_entrys)
{
	chomp($header_entry);
	copyRPMFromRepository($header_entry, $rpm_repository_url, $rpm_target_loc);
}


#copy base folder
my $base_repository_url = $rpm_repository_name."/$repository_type/base";
my $base_target_location = $rpm_repository_dir_path."/$repository_type/base";

copyBaseImageFiles($base_repository_url, $base_target_location);

system ("chmod 777 $repositoryMirrorTopDirPath");
if ($? != 0)
{
   print "Could not execute - chmod  777 $repositoryMirrorTopDirPath\n";
   exit 1;
}

system ("chmod -R 777 $rpm_repository_dir_path");
if ($? != 0)
{
   print "Could not execute - chmod -R 777 $rpm_repository_dir_path\n";
   exit 1;
}


sub copyBaseImageFiles()
{
    my ($base_repository_url, $base_target_location)=@_;

    copyFileFromRepository($base_repository_url, $base_target_location, "hdlist");
    copyFileFromRepository($base_repository_url, $base_target_location, "hdlist2");
    copyFileFromRepository($base_repository_url, $base_target_location, "hdstg2.img");
    copyFileFromRepository($base_repository_url, $base_target_location, "netstg2.img");
    copyFileFromRepository($base_repository_url, $base_target_location, "product.img");
    copyFileFromRepository($base_repository_url, $base_target_location, "stage2.img");
    copyFileFromRepository($base_repository_url, $base_target_location, "comps.xml");
    copyFileFromRepository($base_repository_url, $base_target_location, "comps.rpm");
}


sub copyFileFromRepository()
{
    my ($source, $target, $filename)=@_;
    my $pathSeperator="/";
    my $FILENOTFOUND = 404;

    $source=$source.$pathSeperator.$filename;
    $target=$target.$pathSeperator.$filename;

    print "Copying base file $source from RPM repository to $target\n";

    my $copy_status = getstore($source,$target);

    if($copy_status == $FILENOTFOUND)
    {
    print "Failed copying $source from RPM repository location :$target\n";
    }
}

#Copy RPMs from RPM repository
sub copyRPMFromRepository()
{
    my ($rpm_name_entry, $rpm_repository_url, $rpm_target_loc)=@_;
    my $pathSeperator="/";
    my $FILENOTFOUND = 404;

    #$rpm_name_entry = @rpm_name_entrys[0];
    my @rpm_filename_list = split (/\=/,$rpm_name_entry);
    my $rpm_filename=@rpm_filename_list[1];

    my $rpm_src=$rpm_repository_url.$pathSeperator.$rpm_filename;
    my $rpm_target=$rpm_target_loc.$pathSeperator.$rpm_filename;

    my $copy_status = getstore($rpm_src,$rpm_target);

    if($copy_status == $FILENOTFOUND)
    {
        print "Failed copying $rpm_filename from RPM repository\n";
    }
    else
    {
        print "Copied $rpm_filename from RPM repository\n";
    }
}


 
