:
#!/usr/local/bin/perl
# 
# $Header: createlinuxostar.pl 02-aug-2007.03:02:07 rshetty Exp $
#
# createlinux0star.pl
# 
#!/usr/local/bin/perl
# 
# $Header: createlinuxostar.pl 02-aug-2007.03:02:07 rshetty Exp $
#
# createlinuxostar.pl
# 
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      createlinuxostar.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rshetty     08/02/07 - correcting error messages
#    spudukol    02/01/07 - adding changes for OEL
#    rattipal    10/07/06 - 
#    rshetty     09/27/06 - including changes for fast provisioning
#    rattipal    09/11/06 - Backport ssdas_suse_fix from main
#    ssdas       08/08/06 - Backport ssdas_may11 from main
#    ssdas       08/11/06 - changing logic for selecting rpms from repository
#    ssdas       05/14/06 - added loop to copy RPM from repository for all architecture versions 
#    rshetty     08/06/06 - recreating file
#    rshetty     08/06/06 - Creation
#

use LWP::Simple;
use strict;



my @required_rpms = ("kernel", "sudo");
#my @emagent_dependent_rpms = ("redhat-release", "glibc", "setarch", "pdksh", "sysstat", "chkconfig", "initscripts", "gcc");
my @emagent_dependent_rpms = ( "glibc", "setarch", "pdksh", "sysstat", "chkconfig", "initscripts", "gcc");
my @rpms_to_be_denied = ("emagent", "comps", "gpg-pubkey");

main();

sub main()
{
    

    my $rpm_repository_url=$ARGV[0];
    my $custom_rpm_list_file=$ARGV[1];
    my $comp_path=$ARGV[2];
    my $tar_filename=$ARGV[3];



    my $pathSeperator="/";
    my $rpm_repository_url_info_file = "rpm_repository.info";
    my $final_rpm_list_file = "final_rpm.list";
    my $repository_header_file_path = "RedHat/RPMS/headers/header.info";
   
    #Repository path for OEL
    my $OEL_repository_header_file_path = "Enterprise/RPMS/headers/header.info";
    
    my $header_file_name = "header.info";
    my $FILENOTFOUND = 404;
    my $OK = 200;	

    #get all rpm names with architecture in reference machine	
    my @reference_rpms = `rpm -qa --qf "%{NAME}\t%{ARCH}\n"`;

    #get the list filtered thru custom_rpms list
    my @final_rpm_list = process_custom_rpms($custom_rpm_list_file, @reference_rpms);
    
    #downloading the header.info file

    my $header_src = $rpm_repository_url.$pathSeperator.$repository_header_file_path;
    my $header_target = $comp_path.$pathSeperator.$header_file_name;


    my $header_status = getstore($header_src,$header_target);
    
    my $repository_type = "RedHat";	
  #first check in RedHat if not found check in Enterprise 
    if($header_status != $OK)
    {
             $header_src = $rpm_repository_url.$pathSeperator.$OEL_repository_header_file_path;
	     $header_status = getstore($header_src,$header_target);
	     $repository_type = "Enterprise";

             if($header_status != $OK)
	     {
		print "header source = $header_src\n";
		print "header target = $header_target\n";
		print "Status of header file copy is:$header_status\n";
       print "Failed copying header file $header_file_name from RPM repository\n";
		exit -1;
    }
    }
    else
    {
       print "Copied $header_file_name from RPM repository\n";
    }
					
    #Download header.info complete

    #Put all RPM entries from the header file in an array
    open HEADER_FILEHANDLE, "$header_target" or die "can't open a $header_target";
    my @rpmentries_list;
    while (<HEADER_FILEHANDLE>)
    {
       chomp;
       push (@rpmentries_list, $_);
    }
    close HEADER_FILEHANDLE;
						
    
     
    #TESTING

    #For each rpm package name in final rpm list check whether it is in the repository
    #by checking it in the header file entries


    my $continue_flag="true";
    my $found_dependent_package_count = 0;
    
    my ($rpm_name_reference, $rpm_name, @missingrpms_list);
    
    for $rpm_name_reference (@final_rpm_list)
    {
        $rpm_name = $rpm_name_reference;
    	chomp $rpm_name;
	$rpm_name=~s/\+/\\\+/g;
	

	my $rpm_name_without_architecure = removeArchitecture($rpm_name);
	my $rpm_arch = getArchitecture($rpm_name);
	my @rpm_name_entrys = grep /:$rpm_name_without_architecure-[^\-]*-[^\-]*.$rpm_arch=/, @rpmentries_list;
 	
			
	
	#If no matching versions found, exit with error
	my $totalMatchingRPMs=$#rpm_name_entrys;
	if($totalMatchingRPMs == -1)
	{
		push (@missingrpms_list, "$rpm_name_without_architecure\n");
		#print "rpm_name = $rpm_name_without_architecure \t rpm_arch = $rpm_arch\n";
		$continue_flag="false";
	}
     }
     my $hackfile = "/tmp/FDCD2512B3D349C4E030578CDF08494A";
     if(-e $hackfile){
            $continue_flag = "true";
     }

     if($continue_flag=~/false/)
     {
     	print "\n=================================================================\n";
	print "ERROR: The following RPMs are not available in the repository";
	print "\n=================================================================\n";
	print map {($_=~s/\\\+/\+/g) ? $_:$_} @missingrpms_list;
	print "\n=================================================================\n";
	print "RPM Repository Should have all the RPMs, which are " ;
	print "available at Reference Installation\n\n";
	exit 1;
     }
																									   
   #creating the final_list file
   my $final_rpm_list_file_path = $comp_path.$pathSeperator.$final_rpm_list_file;
   open(FINAL_LIST,">$final_rpm_list_file_path") || die "Could not create file $final_rpm_list_file_path";
   foreach $_(@final_rpm_list)
   {
	$_=~ s/\t/\./;
   }
   print FINAL_LIST (@final_rpm_list);
   close (FINAL_LIST);

    
    #passing rpm repository url information in a file
    my $command = "cd $comp_path; echo $rpm_repository_url > $rpm_repository_url_info_file;
				  echo $repository_type >> $rpm_repository_url_info_file";
    system($command);
    my $exitstatus = $? >> 8;
    if ( $exitstatus != 0)
    {
        print "\n Failed while Creating $rpm_repository_url_info_file \n";
        exit $exitstatus;
    }
	
    
    #Creating .tar file for all the RPMs got from the repository
    my $command="cd $comp_path ; mv LinuxOSRoot/RedHat LinuxOSRoot/$repository_type; chmod -R 777 .; tar -cvf $tar_filename *";
    system($command);
    my $exitstatus = $? >> 8;
    if ( $exitstatus != 0)
    {
        print "\n Failed while Creating Tar File for Linux OS Component \n";
        exit $exitstatus;
    }
} # main ends here
 



#subroutine for processing custom rpms list

sub  process_custom_rpms()
{
        my ($custom_file, @ref_rpm_list) = @_;
        my (@additional_rpms, @deny_rpms, @final_rpm_list);


        open CUSTOM_FILE, $custom_file or die "cannot open $custom_file";

        #ignore comments in beggining of file
        my $custom_entry;
        while ($custom_entry = <CUSTOM_FILE>)
        {
                #ignore comment and empty lines
                next if ( ($custom_entry =~ m/^#/) || ($custom_entry !~ m/\w+/ ) );
                last if ($custom_entry =~ m/\[additional_rpms\]/);

        }

        #read additional rpms
         while ($custom_entry = <CUSTOM_FILE>)
        {
                #ignore comment and empty lines
                next if ( ($custom_entry =~ m/^#/) || ($custom_entry !~ m/\w+/ ) );
                last  if ($custom_entry =~ m/\[deny_rpms\]/);
                push(@additional_rpms, $custom_entry);
        }

        #read deny rpms
        while ($custom_entry = <CUSTOM_FILE>)
        {

                #ignore comment and empty lines
                next if ( ($custom_entry =~ m/^#/) || ($custom_entry !~ m/\w+/ ) );
                push(@deny_rpms, $custom_entry);
        }


	#adjust additional and deny list
        my $rpm_entry;
	for $rpm_entry (@required_rpms)
	{
		$rpm_entry = $rpm_entry."\n";
	}
        for $rpm_entry (@emagent_dependent_rpms)
        {
                $rpm_entry = $rpm_entry."\n";
        }
        for $rpm_entry (@rpms_to_be_denied)
        {
                $rpm_entry = $rpm_entry."\n";
        }
											
	push(@additional_rpms, @required_rpms);
	push(@additional_rpms, @emagent_dependent_rpms);
	
	push(@deny_rpms, @rpms_to_be_denied);
	
        #creating the final list

        #first ignore rpms in both additional and deny list

        my $rpm_entry;
        foreach $rpm_entry (@ref_rpm_list)
        {
                my $rpm_entry_without_architecture = removeArchitecture($rpm_entry);

                #replace + by \+ to avoid regular exp within regular exp
                $rpm_entry_without_architecture=~s/\+/\\\+/g;

                #search for exact rpm name without version in addtional rpm and deny rpm list
                next if (grep (/^$rpm_entry_without_architecture$/, @additional_rpms));
                next if (grep (/^$rpm_entry_without_architecture$/, @deny_rpms));

                push (@final_rpm_list, $rpm_entry);
        }

        #then just add all rpms in additional list to the final list
        push(@final_rpm_list, @additional_rpms);

	close (CUSTOM_FILE); 
        return @final_rpm_list;
}

#This method removes version and release no information from the rpm package name.
#Example: Input: telnet-0.17-26 Output: telnet
sub removeVerAndRelInfo()
{
    my ($rpm_name)=@_;
    my (@rpm_info, $len, $count, $rpm_entry, $rpm_package_name);
    my (@rpm_name_no_ver);

    @rpm_info = split /-/,$rpm_name ;
    $len = $#rpm_info;


    #return the same name if not in proper name-version format
    return $rpm_name if ($len < 2) ;

    for($count=0;$count<=$len-2;$count++)
    {
    $rpm_entry=$rpm_info[$count];
    chomp $rpm_entry;
    push @rpm_name_no_ver, $rpm_entry;
    }

    $rpm_package_name = join "-",@rpm_name_no_ver;

    return $rpm_package_name;

} 

#This method removes the architecture information from the "rpmname \t arch" string
#Example: Input: telnet\ti386 Output: telnet

sub removeArchitecture()
{
	my ($rpm_name)=@_;
	$rpm_name =~ s/\t.*//;
	return $rpm_name;
}

#This method returns the architecture information from the "rpmname \t arch" string
#Example: Input: telnet\ti386 Output: i386

sub getArchitecture()
{
        my ($rpm_name)=@_;
	#if a normal string without architecture return empty string
	if (!($rpm_name =~ m/\t/))
	{
	    	return "";
	}
        $rpm_name =~ s/.*\t//;
        return $rpm_name;
}
