#!/usr/lib/perl5/5.8.0
# 
# $Header: createsuseostar.pl 13-sep-2006.22:54:39 gaurgupt Exp $
#
# createsuse0star.pl
# 
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      createsuse0star.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gaurgupt    09/13/06 - removing the copy of rpms
#    gaurgupt    09/04/06 - 
#    ssdas       08/07/06 - adding the command to get the list of rpms
#    ssdas       08/04/06 - passing the rpm_names_without_version parameter
#    ssdas       08/02/06 - creation og tar file for suse
#    gaurgupt    07/10/06 - Creatioin
#   
use LWP::Simple; 
main();

sub main()
{
	$rpm_repository_url=$ARGV[0];
	$custom_rpm_list_file=$ARGV[1];
    	$comp_path=$ARGV[2];
    	$tar_filename=$ARGV[3];

	#createDirectoryStructure($comp_path,$rpm_repository_url);
	$rpm_url_noarch=$rpm_repository_url."/sles10/suse/noarch/";
	$rpm_url_i586=$rpm_repository_url."/sles10/suse/i586/";
	$rpm_url_i686=$rpm_repository_url."/sles10/suse/i686/";	
	
	#get all the rpm names without version in reference machine
	my @reference_rpms_without_version = `rpm -qa --qf "%{NAME}\n"`;
	my @final_rpms_without_version = process_rpms_without_version($custom_rpm_list_file,@reference_rpms_without_version);
	
	my $pathSeperator="/";
        my $comp_temp_loc=$comp_path.$pathSeperator."SuseOSRoot/rpms_list";
        my $repository_url=$comp_path.$pathSeperator."SuseOSRoot/repository_url";
        my $exitstatus;
        open OUTPUTFILE, ">$repository_url" or die "cann't open the repository_url file $!";
        print OUTPUTFILE "$rpm_repository_url";
        close OUTPUTFILE;

        open OUTPUTFILE, ">$comp_temp_loc" or die "cann't open the rpm_list file $!";
        my $rpm_name;
        foreach $rpm_name (@final_rpms_without_version )
        {
                chomp $rpm_name;
                if(index($rpm_name,"emagent") == -1){
                        print OUTPUTFILE "$rpm_name\n";
                }
        }
        close OUTPUTFILE;
        writeSelFile($comp_path.$pathSeperator."SuseOSRoot");

        #Creating .tar file for all the RPMs got from the repository
        $command="cd $comp_path ; chmod -R 777 .; tar -cvf $tar_filename *";
        system($command);
        $exitstatus = $? >> 8;
        if ( $exitstatus != 0)
        {
                print "\n Failed while Creating Tar File for Linux OS Component \n";
                exit $exitstatus;
        }
}

sub writeSelFile(){
        my ($outputfile) = (@_);
        $outputfile = $outputfile."/default.sel";
        open OUTPUTFILE, ">$outputfile" or die "cann't open output file $!";
        print OUTPUTFILE "=Ver: 4\.0\n\n";
        print OUTPUTFILE "=Sel: default 10\.0 65 noarch\n\n";
        print OUTPUTFILE "=Sum: \n\n";
        print OUTPUTFILE "+Req:\n";
        print OUTPUTFILE "-Req:\n\n";
        print OUTPUTFILE "+Rec:\n";
        print OUTPUTFILE "-Rec:\n\n";
        print OUTPUTFILE "+Con:\n";
        print OUTPUTFILE "-Con:\n\n";
        print OUTPUTFILE "=Cat: baseconf\n\n";
        print OUTPUTFILE "=Vis: true\n\n";
        print OUTPUTFILE "=Ord: 04\n\n";
        print OUTPUTFILE "+Ins:\n";
        print OUTPUTFILE "-Ins:\n";
        close OUTPUTFILE;
}

sub createDirectoryStructure(){
        my($comp_path,$rpm_repostiory_url)=(@_[0],@_[1]);
        my $pathSeperator="/";
        my $SuseOSRoot = $comp_path.$pathSeperator."SuseOSRoot";
        #system("rm -rf $SuseOSRoot");
        #mkdir $SuseOSRoot;

        # writing directory yast
	my $temp_file = $SuseOSRoot.$pathSeperator."yast";
        my $tempDir="mkdir -p $temp_file";
        system($tempDir);
        my $YAST_FILE = $SuseOSRoot.$pathSeperator."yast/instorder";
        open INSTORDER, ">$YAST_FILE" or die "cann't open instorder $!";
        print INSTORDER "sles10 sles10";
        close INSTORDER;
        my $YAST_FILE = $SuseOSRoot.$pathSeperator."yast/order";
        open ORDER, ">$YAST_FILE" or die "cann't open order $!";
        print ORDER "sles10 sles10";
        close ORDER;

        # writing sles10 directory
	$temp_file = $SuseOSRoot.$pathSeperator."sles10";
        $tempDir ="mkdir -p $temp_file";
        system($tempDir);
        $rpm_repostiory_url = $rpm_repostiory_url.$pathSeperator."sles10".$pathSeperator;
        my $SLES0_HOME = $SuseOSRoot.$pathSeperator."sles10".$pathSeperator;
        getstore($rpm_repostiory_url."COPYING",$SLES0_HOME."COPYING");
        getstore($rpm_repostiory_url."COPYRIGHT",$SLES0_HOME."COPYRIGHT");
        getstore($rpm_repostiory_url."SuSEgoa\.ico",$SLES0_HOME."SuSEgo\.ico");
        getstore($rpm_repostiory_url."autorun\.inf",$SLES0_HOME."autorun\.inf");
        getstore($rpm_repostiory_url."content",$SLES0_HOME."content");
        getstore($rpm_repostiory_url."control\.xml",$SLES0_HOME."control\.xml");
        getstore($rpm_repostiory_url."gpg-pubkey-0dfb3188-41ed929b\.asc",$SLES0_HOME."gpg-pubkey-0dfb3188-41ed929b\.asc");
        getstore($rpm_repostiory_url."gpg-pubkey-15c17deb-3f9e80c9\.asc",$SLES0_HOME."gpg-pubkey-15c17deb-3f9e80c9\.asc");
        getstore($rpm_repostiory_url."gpg-pubkey-3d25d3d9-36e12d04\.asc",$SLES0_HOME."gpg-pubkey-3d25d3d9-36e12d04\.asc");
        getstore($rpm_repostiory_url."gpg-pubkey-9c800aca-40d8063e\.asc",$SLES0_HOME."gpg-pubkey-9c800aca-40d8063e\.asc");

        my $directory_yast = $SLES0_HOME."directory\.yast";
        open DIRECTORY_YAST, "> $directory_yast" or die "cann't open directory\.yast in sles10 $!";
        print DIRECTORY_YAST "COPYING\n";
        print DIRECTORY_YAST "COPYRIGHT\n";
        print DIRECTORY_YAST "SuSEgo\.ico\n";
	print DIRECTORY_YAST "autorun\.inf\n";
        print DIRECTORY_YAST "content\n";
        print DIRECTORY_YAST "gpg-pubkey-0dfb3188-41ed929b\.asc\n";
        print DIRECTORY_YAST "gpg-pubkey-15c17deb-3f9e80c9\.asc\n";
        print DIRECTORY_YAST "gpg-pubkey-3d25d3d9-36e12d04\.asc\n";
        print DIRECTORY_YAST "gpg-pubkey-9c800aca-40d8063ei\.asc\n";
        print DIRECTORY_YAST "media\.1/\n";
        print DIRECTORY_YAST "suse/\n";
        close DIRECTORY_YAST;

	$temp_file = $SLES0_HOME."media\.1";
        $tempDir = "mkdir -p $temp_file";
        system($tempDir);
        my $media = $SLES0_HOME."media\.1".$pathSeperator;
        getstore($rpm_repostiory_url."media\.1".$pathSeperator."info\.txt",$media."info\.txt");
        getstore($rpm_repostiory_url."media\.1".$pathSeperator."media",$media."media");
        getstore($rpm_repostiory_url."media\.1".$pathSeperator."products",$media."products");
        getstore($rpm_repostiory_url."media\.1".$pathSeperator."directory\.yast",$media."directory\.yast",);

	$temp_file = $SLES0_HOME."media\.2";
        $tempDir = "mkdir -p $temp_file";
        system($tempDir);
        $media = $SLES0_HOME."media\.2".$pathSeperator;
        getstore($rpm_repostiory_url."media\.2".$pathSeperator."media",$media."media");
        getstore($rpm_repostiory_url."media\.2".$pathSeperator."products",$media."products");

	$temp_file = $SLES0_HOME."media\.3";
        $tempDir = "mkdir -p $temp_file";
        #$tempDir = "mkdir $SLES0_HOME.\"media\.3\"";
        system($tempDir);
        $media = $SLES0_HOME."media\.3".$pathSeperator;
        getstore($rpm_repostiory_url."media\.3".$pathSeperator."media",$media."media");
        getstore($rpm_repostiory_url."media\.3".$pathSeperator."products",$media."products");

	$temp_file = $SLES0_HOME."media\.4";
        $tempDir = "mkdir -p $temp_file";
        #$tempDir = "mkdir $SLES0_HOME.\"media\.4\"";
        system($tempDir);
        $media = $SLES0_HOME."media\.4".$pathSeperator;
        getstore($rpm_repostiory_url."media\.4".$pathSeperator."media",$media."media");
        getstore($rpm_repostiory_url."media\.4".$pathSeperator."products",$media."products");

	$temp_file = $SLES0_HOME."media\.5";
        $tempDir = "mkdir -p $temp_file";
#        $tempDir = "mkdir $SLES0_HOME.\"media\.5\"";
        system($tempDir);
        $media = $SLES0_HOME."media\.5".$pathSeperator;
        getstore($rpm_repostiory_url."media\.5".$pathSeperator."media",$media."media");
        getstore($rpm_repostiory_url."media\.5".$pathSeperator."products",$media."products");

	$temp_file = $SLES0_HOME."suse";
        $tempDir = "mkdir -p $temp_file";
        #$tempDir="mkdir $SLES0_HOME.\"suse\"";
        system($tempDir);
	$temp_file = $SLES0_HOME."suse/i586";
        $tempDir = "mkdir -p $temp_file";
        system($tempDir);
	$temp_file = $SLES0_HOME."suse/i686";
        $tempDir = "mkdir -p $temp_file";
       # $tempDir="mkdir $SLES0_HOME.\"suse\".$pathSeperator.\"i686\"";
        system($tempDir);
	$temp_file = $SLES0_HOME."suse/noarch";
        $tempDir = "mkdir -p $temp_file";
     #   $tempDir="mkdir $SLES0_HOME.\"suse\".$pathSeperator.\"noarch\"";
        system($tempDir);
	$temp_file = $SLES0_HOME."suse/setup";
        $tempDir = "mkdir -p $temp_file";
        #$tempDir="mkdir $SLES0_HOME.\"suse\".$pathSeperator.\"setup\"";
        system($tempDir);
        getstore($rpm_repostiory_url."suse/noarch/MD5SUMS",$SLES0_HOME."suse/noarch/MD5SUMS");
        getstore($rpm_repostiory_url."suse/i686/MD5SUMS",$SLES0_HOME."suse/i686/MD5SUMS");
        getstore($rpm_repostiory_url."suse/i586/MD5SUMS",$SLES0_HOME."suse/i586/MD5SUMS");

	$temp_file = $SLES0_HOME."suse/setup/descr";
        $tempDir = "mkdir -p $temp_file";
        system($tempDir);
        getstore($rpm_repostiory_url."suse/setup/descr/packages",$SLES0_HOME."suse/setup/descr/packages");
        getstore($rpm_repostiory_url."suse/setup/descr/EXTRA_PROV",$SLES0_HOME."suse/setup/descr/EXTRA_PROV");
        getstore($rpm_repostiory_url."suse/setup/descr/MD5SUMS",$SLES0_HOME."suse/setup/descr/MD5SUMS");

        $directory_yast = $SLES0_HOME."suse/setup/descr/directory\.yast";
        open DIRECTORY_YAST, "> $directory_yast" or die "cann't open directory\.yast in descr $!";
        print DIRECTORY_YAST "default.sel\n";
        print DIRECTORY_YAST "packages\n";
        print DIRECTORY_YAST "selections\n";
        close DIRECTORY_YAST;

        my $selections = $SLES0_HOME."suse/setup/descr/selections";
        open SELECTIONS, "> $selections" or die "cann't open selections in descr $!";
        print SELECTIONS "default.sel";
        close SELECTIONS;

	$temp_file = $SLES0_HOME."boot";
        $tempDir = "mkdir -p $temp_file";
        system($tempDir);
	$temp_file = $SLES0_HOME."boot/loader";
        $tempDir = "mkdir -p $temp_file";
 system($tempDir);

        getstore($rpm_repostiory_url."boot/LIESMICH",$SLES0_HOME."boot/LIESMICH");
        getstore($rpm_repostiory_url."boot/LIESMICH\.DOS",$SLES0_HOME."boot/LIESMICH\.DOS");
        getstore($rpm_repostiory_url."boot/image",$SLES0_HOME."boot/image");
        getstore($rpm_repostiory_url."boot/mkbootdisk",$SLES0_HOME."boot/mkbootdisk");
        getstore($rpm_repostiory_url."boot/rescue",$SLES0_HOME."boot/rescue");
        getstore($rpm_repostiory_url."boot/rescuefloppy",$SLES0_HOME."boot/rescuefloppy");
        getstore($rpm_repostiory_url."boot/root",$SLES0_HOME."boot/root");
        getstore($rpm_repostiory_url."boot/directory\.yast",$SLES0_HOME."boot/directory\.yast");

        getstore($rpm_repostiory_url."boot/loader/08000600\.spl",$SLES0_HOME."boot/loader/08000600\.spl");
        getstore($rpm_repostiory_url."boot/loader/10240768\.spl",$SLES0_HOME."boot/loader/10240768\.spl");
        getstore($rpm_repostiory_url."boot/loader/12801024\.spl",$SLES0_HOME."boot/loader/12801024\.spl");
        getstore($rpm_repostiory_url."boot/loader/14001050\.spl",$SLES0_HOME."boot/loader/14001050\.spl");
        getstore($rpm_repostiory_url."boot/loader/16001200\.spl",$SLES0_HOME."boot/loader/16001200\.spl");
        getstore($rpm_repostiory_url."boot/loader/16x16\.fnt",$SLES0_HOME."boot/loader/16x16\.fnt");
        getstore($rpm_repostiory_url."boot/loader/back\.jpg",$SLES0_HOME."boot/loader/back\.jpg");
        getstore($rpm_repostiory_url."boot/loader/bg\.hlp",$SLES0_HOME."boot/loader/bg\.hlp");
        getstore($rpm_repostiory_url."boot/loader/bg\.tr",$SLES0_HOME."boot/loader/bg\.tr");
        getstore($rpm_repostiory_url."boot/loader/bootlogo",$SLES0_HOME."boot/loader/bootlogo");
        getstore($rpm_repostiory_url."boot/loader/cs\.hlp",$SLES0_HOME."boot/loader/cs\.hlp");
        getstore($rpm_repostiory_url."boot/loader/cs\.tr",$SLES0_HOME."boot/loader/cs\.tr");
        getstore($rpm_repostiory_url."boot/loader/da\.hlp",$SLES0_HOME."boot/loader/da\.hlp");
        getstore($rpm_repostiory_url."boot/loader/da\.tr",$SLES0_HOME."boot/loader/da\.tr");
        getstore($rpm_repostiory_url."boot/loader/de\.hlp",$SLES0_HOME."boot/loader/de\.hlp");
        getstore($rpm_repostiory_url."boot/loader/de\.tr",$SLES0_HOME."boot/loader/de\.tr");
        getstore($rpm_repostiory_url."boot/loader/directory\.yast",$SLES0_HOME."boot/loader/directory\.yast");
        getstore($rpm_repostiory_url."boot/loader/el\.hlp",$SLES0_HOME."boot/loader/el\.hlp");
        getstore($rpm_repostiory_url."boot/loader/el\.tr",$SLES0_HOME."boot/loader/el\.tr");
        getstore($rpm_repostiory_url."boot/loader/en\.hlp",$SLES0_HOME."boot/loader/en\.hlp");
        getstore($rpm_repostiory_url."boot/loader/en\.tr",$SLES0_HOME."boot/loader/en\.tr");
        getstore($rpm_repostiory_url."boot/loader/es\.hlp",$SLES0_HOME."boot/loader/es\.hlp");
        getstore($rpm_repostiory_url."boot/loader/es\.tr",$SLES0_HOME."boot/loader/es\.tr");
        getstore($rpm_repostiory_url."boot/loader/fi\.hlp",$SLES0_HOME."boot/loader/fi\.hlp");
        getstore($rpm_repostiory_url."boot/loader/fi\.tr",$SLES0_HOME."boot/loader/fi\.tr");
        getstore($rpm_repostiory_url."boot/loader/fr\.hlp",$SLES0_HOME."boot/loader/fr\.hlp");
        getstore($rpm_repostiory_url."boot/loader/fr\.tr",$SLES0_HOME."boot/loader/fr\.tr");
        getstore($rpm_repostiory_url."boot/loader/greeting\.jpg",$SLES0_HOME."boot/loader/greeting\.jpg");
        getstore($rpm_repostiory_url."boot/loader/head_a\.jpg",$SLES0_HOME."boot/loader/head_a\.jpg");
        getstore($rpm_repostiory_url."boot/loader/head\.jpg",$SLES0_HOME."boot/loader/head\.jpg");
        getstore($rpm_repostiory_url."boot/loader/hu\.hlp",$SLES0_HOME."boot/loader/hu\.hlp");
        getstore($rpm_repostiory_url."boot/loader/hu\.tr",$SLES0_HOME."boot/loader/hu\.tr");
        getstore($rpm_repostiory_url."boot/loader/initrd",$SLES0_HOME."boot/loader/initrd");
        getstore($rpm_repostiory_url."boot/loader/isolinux\.bin",$SLES0_HOME."boot/loader/isolinux\.bin");
        getstore($rpm_repostiory_url."boot/loader/isolinux\.cfg",$SLES0_HOME."boot/loader/isolinux\.cfg");
        getstore($rpm_repostiory_url."boot/loader/it\.hlp",$SLES0_HOME."boot/loader/it\.hlp");
        getstore($rpm_repostiory_url."boot/loader/it\.tr",$SLES0_HOME."boot/loader/it\.tr");
        getstore($rpm_repostiory_url."boot/loader/ja\.hlp",$SLES0_HOME."boot/loader/ja\.hlp");
        getstore($rpm_repostiory_url."boot/loader/ja\.tr",$SLES0_HOME."boot/loader/ja\.tr");
        getstore($rpm_repostiory_url."boot/loader/kroete\.dat",$SLES0_HOME."boot/loader/kroete\.dat");
        getstore($rpm_repostiory_url."boot/loader/ldots_a\.jpg",$SLES0_HOME."boot/loader/ldots_a\.jpg");
        getstore($rpm_repostiory_url."boot/loader/ldots\.jpg",$SLES0_HOME."boot/loader/ldots\.jpg");
        getstore($rpm_repostiory_url."boot/loader/linux",$SLES0_HOME."boot/loader/linux");
        getstore($rpm_repostiory_url."boot/loader/lt\.tr",$SLES0_HOME."boot/loader/lt\.tr");
        getstore($rpm_repostiory_url."boot/loader/memtest",$SLES0_HOME."boot/loader/memtest");
        getstore($rpm_repostiory_url."boot/loader/message",$SLES0_HOME."boot/loader/message");
        getstore($rpm_repostiory_url."boot/loader/nb\.hlp",$SLES0_HOME."boot/loader/nb\.hlp");
        getstore($rpm_repostiory_url."boot/loader/nb\.tr",$SLES0_HOME."boot/loader/nb\.tr");
        getstore($rpm_repostiory_url."boot/loader/nl\.hlp",$SLES0_HOME."boot/loader/nl\.hlp");
        getstore($rpm_repostiory_url."boot/loader/nl\.tr",$SLES0_HOME."boot/loader/nl\.tr");
        getstore($rpm_repostiory_url."boot/loader/panim_a\.jpg",$SLES0_HOME."boot/loader/panim_a\.jpg");
        getstore($rpm_repostiory_url."boot/loader/panim\.jpg",$SLES0_HOME."boot/loader/panim\.jpg");
        getstore($rpm_repostiory_url."boot/loader/pback\.jpg",$SLES0_HOME."boot/loader/pback\.jpg");
        getstore($rpm_repostiory_url."boot/loader/phead\.jpg",$SLES0_HOME."boot/loader/phead\.jpg");
        getstore($rpm_repostiory_url."boot/loader/pl\.hlp",$SLES0_HOME."boot/loader/pl\.hlp");
        getstore($rpm_repostiory_url."boot/loader/pl\.tr",$SLES0_HOME."boot/loader/pl\.tr");
        getstore($rpm_repostiory_url."boot/loader/pt_BR\.hlp",$SLES0_HOME."boot/loader/pt_BR\.hlp");
        getstore($rpm_repostiory_url."boot/loader/pt_BR\.tr",$SLES0_HOME."boot/loader/pt_BR\.tr");
        getstore($rpm_repostiory_url."boot/loader/pt\.hlp",$SLES0_HOME."boot/loader/pt\.hlp");
        getstore($rpm_repostiory_url."boot/loader/pt\.tr",$SLES0_HOME."boot/loader/pt\.tr");
        getstore($rpm_repostiory_url."boot/loader/rdots_a\.jpg",$SLES0_HOME."boot/loader/rdots_a\.jpg");
        getstore($rpm_repostiory_url."boot/loader/rdots\.jpg",$SLES0_HOME."boot/loader/rdots\.jpg");
        getstore($rpm_repostiory_url."boot/loader/ro\.tr",$SLES0_HOME."boot/loader/ro\.tr");
        getstore($rpm_repostiory_url."boot/loader/ru\.tr",$SLES0_HOME."boot/loader/ru\.tr");
        getstore($rpm_repostiory_url."boot/loader/sk\.tr",$SLES0_HOME."boot/loader/sk\.tr");
        getstore($rpm_repostiory_url."boot/loader/sl\.hlp",$SLES0_HOME."boot/loader/sl\.hlp");
	 getstore($rpm_repostiory_url."boot/loader/sl\.tr",$SLES0_HOME."boot/loader/sl\.tr");
        getstore($rpm_repostiory_url."boot/loader/sr\.tr",$SLES0_HOME."boot/loader/sr\.tr");
        getstore($rpm_repostiory_url."boot/loader/sv\.hlp",$SLES0_HOME."boot/loader/sv\.hlp");
        getstore($rpm_repostiory_url."boot/loader/sv\.tr",$SLES0_HOME."boot/loader/sv\.tr");
        getstore($rpm_repostiory_url."boot/loader/uk\.hlp",$SLES0_HOME."boot/loader/uk\.hlp");
        getstore($rpm_repostiory_url."boot/loader/uk\.tr",$SLES0_HOME."boot/loader/uk\.tr");
        getstore($rpm_repostiory_url."boot/loader/vdots_a\.jpg",$SLES0_HOME."boot/loader/vdots_a\.jpg");
        getstore($rpm_repostiory_url."boot/loader/vdots\.jpg",$SLES0_HOME."boot/loader/vdots\.jpg");
        getstore($rpm_repostiory_url."boot/loader/zh_CN\.hlp",$SLES0_HOME."boot/loader/zh_CN\.hlp");
        getstore($rpm_repostiory_url."boot/loader/zh_CN\.tr",$SLES0_HOME."boot/loader/zh_CN\.tr");
        getstore($rpm_repostiory_url."boot/loader/zh_TW\.hlp",$SLES0_HOME."boot/loader/zh_TW\.hlp");
        getstore($rpm_repostiory_url."boot/loader/zh_TW\.tr",$SLES0_HOME."boot/loader/zh_TW\.tr");


        system("cd $SuseOSRoot; ln -s sles10/boot boot");
        system("cd $SuseOSRoot; ln -s sles10/content content");
        system("cd $SuseOSRoot; ln -s sles10/suse suse");
        system("cd $SuseOSRoot; ln -s sles10/media\.1 media\.1");
        system("cd $SuseOSRoot; ln -s sles10/control\.xml control\.xml");

        $directory_yast = $SuseOSRoot.$pathSeperator."directory\.yast";
        open DIRECTORY_YAST, "> $directory_yast" or die "cann't open directory\.yast in SuseOSRoot $!";
        print DIRECTORY_YAST "boot\n";
        print DIRECTORY_YAST "content\n";
        print DIRECTORY_YAST "control\.xml\n";
        print DIRECTORY_YAST "media\.1\n";
        print DIRECTORY_YAST "sles10\n";
        print DIRECTORY_YAST "suse\n";
        print DIRECTORY_YAST "yast\n";
        close DIRECTORY_YAST;
}

sub process_rpms(){
	my($comp_path,@final_rpms_without_version) = @_;
	my (@final_rpm_list);
	my $packages = $comp_path."/SuseOSRoot/suse/setup/descr/packages";
	open PACKAGES,$packages or die "cannot open $packages $!";
	my @packages_list = <PACKAGES>;
	my $rpm_entry;
	foreach $rpm_entry (@final_rpms_without_version)
	{
		chomp($rpm_entry);
		my $rpm_name = `rpm -qa $rpm_entry`;
		if(length($rpm_name) != 0){
			push(@final_rpm_list,$rpm_name);
		}else{
			my $search = "=Pkg: $rpm_entry";
			my @entry = grep(/^$search/,@packages_list);
			my $length = @entry;
			if($length != 0){
				my $temp_name;
				foreach $temp_name (@entry){
					my @split_array = split(/ /,$temp_name);
					$rpm_name = @split_array[1]+"-"+@split_array[2]+"-"+@split_array[3];
					push(@final_rpm_list,$rpm_name);
				}
			}else{
				print "the following package does not exist in the repository $rpm_entry \n"	;
				exit;
			}
		}
	}
	return @final_rpm_list;	
}

sub process_rpms_without_version(){
	my($custom_rpm_list_file,@reference_rpms_without_version) = @_;
	my (@additional_rpms, @deny_rpms, @final_rpm_list);

	open CUSTOM_FILE, $custom_rpm_list_file or die "cannot open $custom_rpm_list_file";

        #ignore comments in beggining of file
        my $custom_entry;
        while ($custom_entry = <CUSTOM_FILE>)
        {
                #ignore comment and empty lines
                next if ( ($custom_entry =~ m/^#/) || ($custom_entry !~ m/\w+/ ) );
                last if ($custom_entry =~ m/\[additional_rpms\]/);

        }

        #read additional rpms
         while ($custom_entry = <CUSTOM_FILE>)
        {
                #ignore comment and empty lines
                next if ( ($custom_entry =~ m/^#/) || ($custom_entry !~ m/\w+/ ) );
                last  if ($custom_entry =~ m/\[deny_rpms\]/);
                push(@additional_rpms, $custom_entry);
        }

	#read deny rpms
        while ($custom_entry = <CUSTOM_FILE>)
        {

                #ignore comment and empty lines
                next if ( ($custom_entry =~ m/^#/) || ($custom_entry !~ m/\w+/ ) );
                push(@deny_rpms, $custom_entry);
        }


        #creating the final list

        #first ignore rpms in both additional and deny list

        my $rpm_entry;
        foreach $rpm_entry (@reference_rpms_without_version)
        {
		$rpm_entry=~s/\+/\\\+/g;
                #search for exact rpm name without version in addtional rpm and deny rpm list
                next if (grep (/^$rpm_entry$/, @additional_rpms));
                next if (grep (/^$rpm_entry$/, @deny_rpms));

                push (@final_rpm_list, $rpm_entry);
        }

        #then just add all rpms in additional list to the final list
        push(@final_rpm_list, @additional_rpms);

 
        return @final_rpm_list;
}
