#!/bin/sh
#
# $Header: deploymentLibraryExport.sh 30-apr-2007.16:27:02 minfan Exp $
#
# deploymentLibraryExport.sh
#
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      deploymentLibraryExport.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    minfan      04/25/07 - ojdbc14 sunset
#    kashukla    08/15/06 - Backport kashukla_swlib_exp from main
#    kashukla    08/14/06 - adding metadata-only argument
#    kashukla    05/31/06 - Creation

# invoke java on LibraryScripts with args load, 4 args 
# arg 1 -- connect string
# arg 2 -- user
# arg 3 -- passwd
# arg 4 -- dir
# arg 5 -- -metadata/-full
# arg 6 -- -dir/-component (default is -all)

ORAXDK=$ORACLE_HOME/xdk/lib
CLASSPATH=$ORACLE_HOME/emcore/classes/debug:$ORACLE_HOME/emcore/lib/emCORE.jar:$ORACLE_HOME/sysman/jlib/emCORE.jar:$ORACLE_HOME/oc4j/jdbc/lib/ojdbc5dms.jar:$ORACLE_HOME/oc4j/jdbc/lib/ojdbc14dms.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-net-ee.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-utility.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-collation.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-net.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-internal.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-servlet.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-lcsd.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-tools.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-mapping.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n-translation.jar:$ORACLE_HOME/oc4j/jdbc/lib/orai18n.jar:$ORACLE_HOME/oc4j/lib/dms.jar:$ORACLE_HOME/jdbc/lib/ojdbc14.jar:$ORACLE_HOME/sysman/jlib/log4j-core.jar:$ORAXDK/xml.jar:$ORAXDK/xmlmesg.jar:$ORAXDK/xmlparserv2.jar:$ORAXDK/xschema.jar:$ORAXDK/classgen.jar
JAVA_HOME=$ORACLE_HOME/jdk
JAVA_MAIN=oracle.sysman.eml.swlib.LibraryScripts

ERROR_MSG="Correct Usage is: ./deploymentLibraryExport <conn string> <user> <passwd> <dir loc> <-metadata|-full> [-dir|-comp]";

if [ -z $5 ]; then
    echo $ERROR_MSG; 
    exit;
fi;

METADATA=true;
if [ "-full" == $5 ]; then
    METADATA=false;
elif [ "-metadata" != $5 ]; then
    echo $ERROR_MSG;
    exit;
fi;

CRITERIA=$6;
if [ -z $6 ]; then
    CRITERIA=-all;
fi;

${JAVA_HOME}/bin/java -classpath ${CLASSPATH} ${JAVA_MAIN} export $1 $2 $3 $4 $METADATA $CRITERIA
