set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4417 - APEX  - System Messages
--
-- Application Export:
--   Application:     4417
--   Name:            APEX  - System Messages
--   Date and Time:   08:04 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 1
--     Items:               0
--     Computations:        0
--     Validations:         0
--     Processes:           0
--     Regions:             1
--     Buttons:             0
--   Shared Components
--     Breadcrumbs:         0
--        Entries           0
--     Items:               0
--     Computations:        0
--     Processes:           0
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             0
--     Lists:               0
--     Shortcuts:           0
--     Themes:              0
--     Templates:
--        Page:             9
--        List:            14
--        Report:           7
--        Label:            5
--        Region:          21
--     Messages:        3,702
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4417;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4417);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4417);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4417,
  p_display_id=> 4417,
  p_owner => 'APEX_030200',
  p_name  => 'APEX  - System Messages',
  p_alias => 'A198391709635442937',
  p_page_view_logging => 'YES',
  p_default_page_template=> 91626406749381989.4417 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 91626529080381989.4417 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 91632832228382001.4417 + wwv_flow_api.g_id_offset,
  p_error_template    => 91626406749381989.4417 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4411:1:&SESSION.',
  p_flow_language     => 'zh-cn',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => '',
  p_logout_url        => '',
  p_application_tab_set=> 1,
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(91645213681389498 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_rejoin_existing_sessions   => 'N',
  p_theme_id => 1,
  p_default_label_template => 91641225667382016.4417 + wwv_flow_api.g_id_offset,
  p_default_report_template => 91638400927382012.4417 + wwv_flow_api.g_id_offset,
  p_default_list_template => 91636711305382010.4417 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 91641814330382017.4417 + wwv_flow_api.g_id_offset,
  p_default_button_template => 91626823864381990.4417 + wwv_flow_api.g_id_offset,
  p_default_chart_template => 91631622717381999.4417 + wwv_flow_api.g_id_offset,
  p_default_form_template => 91630725782381998.4417 + wwv_flow_api.g_id_offset,
  p_default_wizard_template => 91632204784382001.4417 + wwv_flow_api.g_id_offset,
  p_default_tabform_template => 91632832228382001.4417 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>91632832228382001.4417 + wwv_flow_api.g_id_offset,
  p_default_menur_template => 91633105066382001.4417 + wwv_flow_api.g_id_offset,
  p_default_listr_template => 91627727983381992.4417 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518143731',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
null;
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_1.441
prompt  ...PAGE 1.4417: 消息
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 1.4417,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '消息',
  p_step_title=> '消息',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 91626406749381989.4417+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165206',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<h1>APEX 开发</h1>'||chr(10)||
'<p>'||chr(10)||
'此应用程序用于管理 APEX 系统消息。单击共享组件, 然后单击消息。'||chr(10)||
''||chr(10)||
'</p>';

wwv_flow_api.create_page_plug (
  p_id=> 91624704892377483.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4417,
  p_plug_name=> 'System Messages',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4417
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
prompt  ...page templates for application: 4417
--
--application/shared_components/user_interface/templates/page/login_zh_cn
prompt  ......Page template 91625820476381987.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><br /></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO#</td>'||chr(10)||
'    <td align="right" valign="top"><br /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br /></td>'||chr(10)||
' ';

c3:=c3||'   <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">';

c3:=c3||'#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625820476381987.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Login.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0"',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_template_comment => '18');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_zh_cn
prompt  ......Page template 91625930032381988.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src=';

c3:=c3||'"#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br />#REGION_POSITION_01#</td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadd';

c3:=c3||'ing="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625930032381988.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1Notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_zh_cn
prompt  ......Page template 91626019499381988.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="right" class="t1topbarLeft"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table border="0" cellpadding="0" cellspacing="0" su';

c3:=c3||'mmary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign';

c3:=c3||'="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626019499381988.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_with_side_bar_zh_cn
prompt  ......Page template 91626101050381989.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/';

c3:=c3||'top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td v';

c3:=c3||'align="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1Pag';

c3:=c3||'eBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626101050381989.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs with Side Bar.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_with_side_bar_zh_cn
prompt  ......Page template 91626232237381989.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/t';

c3:=c3||'heme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table';

c3:=c3||'></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="t';

c3:=c3||'op" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626232237381989.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs with Side Bar.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t2notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_with_side_bar_zh_cn
prompt  ......Page template 91626321000381989.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class';

c3:=c3||'="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REG';

c3:=c3||'ION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03';

c3:=c3||'#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626321000381989.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs with Side Bar.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_zh_cn
prompt  ......Page template 91626406749381989.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50';

c3:=c3||'%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><br /></td>'||chr(10)||
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody">';

c3:=c3||'<div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626406749381989.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
''||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comment => '12');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/printer_friendly_zh_cn
prompt  ......Page template 91626529080381989.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top">'||chr(10)||
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>'||chr(10)||
'#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626529080381989.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Printer Friendly.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_template_comment => '3');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/popup_zh_cn
prompt  ......Page template 91626623032381989.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top"><div class="t1messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_01##REGION_POSITION_02##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626623032381989.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Popup.zh-cn',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
--application/shared_components/user_interface/templates/button/button
prompt  ......Button Template 91626823864381990.4417
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>'||chr(10)||
'</tr';

t:=t||'>'||chr(10)||
'</table>';

wwv_flow_api.create_button_templates (
  p_id=>91626823864381990.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button',
  p_translate_this_template => 'N',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_template_comment       => '');
end;
/
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/report_list
prompt  ......region template 91627404948381991.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr>'||chr(10)||
'<td valign="top"><img src="#';

t:=t||'IMAGE_PREFIX#themes/theme_1/report.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627404948381991.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Report List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627404948381991.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_list
prompt  ......region template 91627727983381992.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr><td valign="top"><img src="#I';

t:=t||'MAGE_PREFIX#themes/theme_1/chart.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627727983381992.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627727983381992.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_title
prompt  ......region template 91628005149381992.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1RegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628005149381992.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 11,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628005149381992.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/hide_and_show_region
prompt  ......region template 91628313436381993.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1HideandShowRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#<a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif'',''#IMAG';

t:=t||'E_PREFIX#themes/theme_1/rollup_minus_dgray.gif'');" class="t1HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif" '||chr(10)||
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body"><div class="t1Hide" id="region#REGION_SEQU';

t:=t||'ENCE_ID#">#BODY#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628313436381993.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Hide and Show Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Gray Head, white body');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628313436381993.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_without_title
prompt  ......region template 91628622914381993.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td></tr>'||chr(10)||
'</table>'||chr(10)||
'#BODY#';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628622914381993.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628622914381993.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_buttons_and_titles
prompt  ......region template 91628912641381993.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table summary="" cellpadding="0" cellspacing="0" border="0" class="t1RegionwithoutButtonsandTitles" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
''||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628912641381993.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Buttons and Titles',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628912641381993.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_alternative_1
prompt  ......region template 91629226514381996.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629226514381996.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region, Alternative 1',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 10,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629226514381996.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/borderless_region
prompt  ......region template 91629526498381997.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BorderlessRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629526498381997.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Borderless Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content without a border.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629526498381997.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_with_title
prompt  ......region template 91629802954381997.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1RegionHeader">#TITLE#</td></tr>'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##COPY##EXPAND##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /';

t:=t||'></td></tr>'||chr(10)||
'</table>#BODY#'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629802954381997.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region with Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629802954381997.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region_alternative_1
prompt  ......region template 91630115446381997.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegionAlternative1" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="';

t:=t||'10" height="20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630115446381997.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region, Alternative 1',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630115446381997.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region
prompt  ......region template 91630411450381997.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegion" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="10" height="';

t:=t||'20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630411450381997.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tl_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'          <td bgcolor="#000000" height="1"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tr_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#FF0000" height="16">'||chr(10)||
'            <table border="0" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'              <tr>'||chr(10)||
'                <td align=middle valign="top">'||chr(10)||
'                  <div align="center">'||chr(10)||
'                     <font color="#ffffff" face="Arial, Helvetica, sans-serif" size="1">'||chr(10)||
'                      <b>#TITLE# </b></font></div>'||chr(10)||
'                </td>'||chr(10)||
'              </tr>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'   <tr>'||chr(10)||
'   <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'   <td valign="top" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="146" height="1" border="0" alt="" /><br />'||chr(10)||
'            <table border="0" cellpadding="1" cellspacing="0" width="146" summary="">'||chr(10)||
'              <tr>'||chr(10)||
'                <td colspan="2">'||chr(10)||
'                  <table border="0" cellpadding="2" cellspacing="0" width="124" summary="">'||chr(10)||
'                    <tr>'||chr(10)||
'                      <td>&nbsp;</td>'||chr(10)||
'                      <td valign="top" width="106">'||chr(10)||
'                        <P><FONT face="arial, helvetica" size="1">'||chr(10)||
'                            #BODY#'||chr(10)||
'                           </font>'||chr(10)||
'                        </P>'||chr(10)||
'                      </td>'||chr(10)||
'                    </tr>'||chr(10)||
'                  </table>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'          <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'      </table>'||chr(10)||
'      <table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#bl_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'          <td bgcolor="#ffffff" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#br_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#000000" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630411450381997.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/form_region
prompt  ......region template 91630725782381998.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1FormRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="400" alt="" /><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CH';

t:=t||'ANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630725782381998.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Form Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 8,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630725782381998.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region_alternative_1
prompt  ......region template 91631001900381998.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1NavigationRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631001900381998.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region, Alternative 1',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631001900381998.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region_with_icon
prompt  ......region template 91631304733381999.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table summary="" cellpadding="0" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td valign="top"><img src=';

t:=t||'"#IMAGE_PREFIX#themes/theme_1/wizard_icon.gif" alt=""/></td>'||chr(10)||
'<td width="100%" valign="top">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631304733381999.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region with Icon',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631304733381999.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_region
prompt  ......region template 91631622717381999.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ChartRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td';

t:=t||'>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631622717381999.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 30,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631622717381999.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/bracketed_region
prompt  ......region template 91631925531382001.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BracketedRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td class=';

t:=t||'"t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td rowspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/the';

t:=t||'me_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631925531382001.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Bracketed Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content with a bracket UI.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631925531382001.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region
prompt  ......region template 91632204784382001.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632204784382001.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632204784382001.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_100_width
prompt  ......region template 91632529189382001.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion100Width" width="100%" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632529189382001.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region 100% Width',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632529189382001.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region
prompt  ......region template 91632832228382001.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632832228382001.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632832228382001.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/breadcrumb_region
prompt  ......region template 91633105066382001.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1BreadcrumbRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633105066382001.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Breadcrumb Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633105066382001.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region
prompt  ......region template 91633419116382002.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1NavigationRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633419116382002.4417 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633419116382002.4417 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist
prompt  ......list template 91633715033382002.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# / alt=""></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t6:=t6||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif"  alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91633715033382002.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML List (Image) with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 21,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_menu_with_sublist
prompt  ......list template 91634003460382007.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t6:=t6||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634003460382007.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Menu with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_tree
prompt  ......list template 91634310642382007.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634310642382007.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Tree',
  p_theme_id  => 1,
  p_theme_class_id => 22,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/wizard_progress_list
prompt  ......list template 91634602833382007.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td><div class="t1current">#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t2:=t2||'<tr><td><div>#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634602833382007.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Wizard Progress List',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_list_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" class="t1WizardProgressList">',
  p_list_template_after_rows=>'<tr><td>&DONE.</td></tr>'||chr(10)||
'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_ordered_list
prompt  ......list template 91634920736382008.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634920736382008.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Ordered List',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_list_template_before_rows=>'<ol class="t1VerticalOrderedList">',
  p_list_template_after_rows=>'</ol>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/button_list
prompt  ......list template 91635207728382008.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left_hl.gif" alt="" /></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#" style="color:#FFFFFF;">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right_hl.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2:=t2||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left.gif" alt="" /></td>'||chr(10)||
'<td class="t1NC"><a href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635207728382008.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Button List',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_list_template_before_rows=>'<div class="t1ButtonList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_links_list
prompt  ......list template 91635520047382008.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1current">#TEXT#</a>';

t2:=t2||'<a href="#LINK#">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635520047382008.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Links List',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_list_template_before_rows=>'<div class="t1HorizontalLinksList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_images_list
prompt  ......list template 91635830396382009.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</td></tr>';

t2:=t2||'<tr><td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635830396382009.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Images List',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_list_template_before_rows=>'<table cellpadding="0" cellspacing="0" border="0" summary="0" class="t1VerticalImagesList">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_sidebar_list
prompt  ......list template 91636106164382009.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1navcurrent">#TEXT#</a>';

t2:=t2||'<a href="#LINK#" class="t1nav">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636106164382009.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Sidebar List',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_list_template_before_rows=>'<div class="t1VerticalSidebarList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_without_bullet
prompt  ......list template 91636400543382009.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636400543382009.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List without Bullet',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithoutBullet">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
prompt  ......list template 91636711305382010.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636711305382010.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List with Bullets',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/tabbed_navigation_list
prompt  ......list template 91637003772382010.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a class="t1current" href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637003772382010.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Tabbed Navigation List',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_list_template_before_rows=>'<ul class="t1TabbedNavigationList">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/hierarchical_expanded
prompt  ......list template 91637324450382010.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91637324450382010.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Hierarchical Expanded',
  p_theme_id  => 1,
  p_theme_class_id => 23,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_images_with_label_list
prompt  ......list template 91637614810382010.4417
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ><br />#TEXT#</td>';

t2:=t2||'<td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></a><br /><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637614810382010.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Images with Label List',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="t1HorizontalImageswithLabelList" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/one_column_unordered_list
prompt  ......report template 91637905071382010.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91637905071382010.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'One Column Unordered List',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><ul class="t1OneColumnUnorderedList">',
  p_row_template_after_rows =>'</ul><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'NOT_CONDITIONAL',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'NOT_CONDITIONAL',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91637905071382010.4417 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'OMIT');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard
prompt  ......report template 91638400927382012.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638400927382012.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91638400927382012.4417 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_alternating_row_colors
prompt  ......report template 91638924547382013.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t1data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="t1dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638924547382013.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard, Alternating Row Colors',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table border="0" cellpadding="0" cellspacing="0" summary="" class="t1standardalternatingrowcolors">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_ppr
prompt  ......report template 91639203883382013.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639203883382013.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard (PPR)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>'||chr(10)||
'<script language=JavaScript type=text/javascript>'||chr(10)||
'<!--'||chr(10)||
'init_htmlPPRReport(''#REGION_ID#'');'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'</htmldb:#REGION_ID#>'||chr(10)||
'</div>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639203883382013.4417 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/horizontal_border
prompt  ......report template 91639730548382014.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639730548382014.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Horizontal Border',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" border="0" class="t1HorizontalBorder" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639730548382014.4417 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/value_attribute_pairs
prompt  ......report template 91640211522382014.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<tr><th class="t1header">#COLUMN_HEADER#</th><td class="t1data">#COLUMN_VALUE#</td></tr>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640211522382014.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Value Attribute Pairs',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ValueAttributePairs">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>#PAGINATION#</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640211522382014.4417 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'<tr><td colspan="2" class="t1seperate"><hr /></td></tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/borderless
prompt  ......report template 91640708921382015.4417
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640708921382015.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Borderless',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table class="t1borderless" cellpadding="0" border="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640708921382015.4417 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/optional_with_help
prompt  ......label template 91641225667382016.4417
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641225667382016.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/no_label
prompt  ......label template 91641313897382017.4417
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641313897382017.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'No Label',
  p_template_body1=>'<span class="t1NoLabel">',
  p_template_body2=>'</span>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional
prompt  ......label template 91641421336382017.4417
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641421336382017.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><span class="t1Optional">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required_with_help
prompt  ......label template 91641529261382017.4417
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641529261382017.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><a class="t1RequiredwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required
prompt  ......label template 91641600810382017.4417
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641600810382017.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><span class="t1Required">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
prompt  ......template 91641730492382017.4417
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641730492382017.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Hierarchical Menu',
  p_before_first=>'<ul class="t1HierarchicalMenu">',
  p_current_page_option=>'<li class="t1current">#NAME#</li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'',
  p_after_last=>'</ul>',
  p_max_levels=>11,
  p_start_with_node=>'CHILD_MENU',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
prompt  ......template 91641814330382017.4417
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641814330382017.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Breadcrumb Menu',
  p_before_first=>'<div class="t1BreadcrumbMenu">',
  p_current_page_option=>'<span class="t1current">#NAME#</span>',
  p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>',
  p_menu_link_attributes=>'',
  p_between_levels=>'&nbsp;&gt;&nbsp;',
  p_after_last=>'</div>',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 91642503902382024.4417
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 91642503902382024.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif',
  p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'“搜索”对话框',
  p_page_html_head=>'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">'||chr(10)||
'',
  p_page_body_attr=>'onload="first_field()" style="margin:0;"',
  p_before_field_text=>'<div class="t1PopupHead">',
  p_page_heading_text=>'',
  p_page_footer_text =>'',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'搜索',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'关闭',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'下一步 >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< 上一步',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'450',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">行 #FIRST_ROW# - #LAST_ROW#</div>',
  p_result_rows_per_pg=>500,
  p_before_result_set=>'<div class="t1PopupBody">',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
--application/shared_components/user_interface/templates/calendar/small_calendar
prompt  ......template 91641910982382018.4417
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91641910982382018.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Small Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#DY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallCalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="1" summary="" class="t1SmallCalendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallWeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="1" summary="0" class="t1SmallWeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="1" summary="0" class="t1SmallDayCalendar">',
  p_daily_month_close_format => '</table></td></tr></table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar
prompt  ......template 91642102481382020.4417
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642102481382020.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1WeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="0" summary="0" class="t1DayCalendar">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar_alternative_1
prompt  ......template 91642303533382020.4417
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642303533382020.4417 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar, Alternative 1',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th valign="bottom" class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarAlternative1Holder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top" height="100" height="100">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarAlternative1Holder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1WeekCalendarAlternative1">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="2" summary="0" class="t1DayCalendarAlternative1">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_reference_id=> null);
end;
null;
 
end;
/

prompt  ...application themes
--
prompt  ...build options used by application 4417
--
 
begin
 
null;
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4417
--
prompt  ......Message master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主/从';

wwv_flow_api.create_message (
  p_id=>196900913254154126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑 %0';

wwv_flow_api.create_message (
  p_id=>196901026018154126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 详细资料';

wwv_flow_api.create_message (
  p_id=>196901116434154126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_DETAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_empty_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不能编辑空的 SQL 脚本。';

wwv_flow_api.create_message (
  p_id=>196901227032154127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_EMPTY_SCRIPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_greater_than_30k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不能编辑超过 30,000 字节的脚本。';

wwv_flow_api.create_message (
  p_id=>196901331547154127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_GREATER_THAN_30K',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求使用以下属性创建主控/详细资料页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>196901427145154127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MASTER_DETAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_3_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主控/详细资料页 (三页)';

wwv_flow_api.create_message (
  p_id=>196901528146154127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_2_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主控/详细资料页 (两页)';

wwv_flow_api.create_message (
  p_id=>196901631157154127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主表';

wwv_flow_api.create_message (
  p_id=>196901704988154127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主显示列';

wwv_flow_api.create_message (
  p_id=>196901800811154127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从表';

wwv_flow_api.create_message (
  p_id=>196901920734154128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示详细资料列';

wwv_flow_api.create_message (
  p_id=>196902030549154128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航主记录方式';

wwv_flow_api.create_message (
  p_id=>196902132213154128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_SORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_include_master_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是否包含主报表?';

wwv_flow_api.create_message (
  p_id=>196902217321154128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INCLUDE_MASTER_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_detail_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主从布局';

wwv_flow_api.create_message (
  p_id=>196902323689154128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建主控/详细资料页。%0';

wwv_flow_api.create_message (
  p_id=>196902421022154128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_MASTER_DETAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_sql_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'有效';

wwv_flow_api.create_message (
  p_id=>196902518937154129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_SQL_VALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_code_compiled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已成功编译代码';

wwv_flow_api.create_message (
  p_id=>196902619313154129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_CODE_COMPILED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'静态引用';

wwv_flow_api.create_message (
  p_id=>196902725513154129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'动态引用';

wwv_flow_api.create_message (
  p_id=>196902822636154129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法对 SQL 查询进行语法分析:'||chr(10)||
'<p>%0</p>'||chr(10)||
'<p>%1</p>'||chr(10)||
'某些查询只能在运行应用程序时执行。如果查询的语法正确, 可以不经验证而保存它 (请参阅查询源下面的选项)。';

wwv_flow_api.create_message (
  p_id=>196902918243154129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表查询无效: %0<br><br>'||chr(10)||
'请使用以下语法:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>条形图对应的文本</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>定义条形图大小的数字列</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>196903016676154129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Flash 图表';

wwv_flow_api.create_message (
  p_id=>196903109387154129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.FLASH_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'第 0 页组件由应用程序中的所有页共享。';

wwv_flow_api.create_message (
  p_id=>196903206499154130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ZERO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'构建器';

wwv_flow_api.create_message (
  p_id=>196903331022154130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILDER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主页';

wwv_flow_api.create_message (
  p_id=>196903414279154130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message nav_app_builder_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航到应用程序构建器主页';

wwv_flow_api.create_message (
  p_id=>196903515799154130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAV_APP_BUILDER_HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_nav
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Express 主目录';

wwv_flow_api.create_message (
  p_id=>196903604405154130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_NAV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>196903727410154130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的 Flash 图表页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>196903819630154131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FLASH_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页组';

wwv_flow_api.create_message (
  p_id=>196903918085154131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_GROUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单';

wwv_flow_api.create_message (
  p_id=>196904002993154131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_sga_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'设置新的 SGA 目标时出错。 %0';

wwv_flow_api.create_message (
  p_id=>196904116161154131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_SGA_TARGET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_pga_agg_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'设置新的 PGA 聚集目标时出错。 %0';

wwv_flow_api.create_message (
  p_id=>196904202470154131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_PGA_AGG_TARGET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查看所有页组';

wwv_flow_api.create_message (
  p_id=>196904303102154131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE GROUPS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_types
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查看所有页类型';

wwv_flow_api.create_message (
  p_id=>196904426893154132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE TYPES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_pages_of_this_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查看此类型的页';

wwv_flow_api.create_message (
  p_id=>196904505282154132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_PAGES_OF_THIS_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'第 0 页';

wwv_flow_api.create_message (
  p_id=>196904622370154132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_ZERO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset_4000
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重置';

wwv_flow_api.create_message (
  p_id=>196904710231154132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET_4000',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message blank
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'空白';

wwv_flow_api.create_message (
  p_id=>196904812532154132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BLANK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑页组';

wwv_flow_api.create_message (
  p_id=>196904908556154132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT PAGE GROUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - 布局';

wwv_flow_api.create_message (
  p_id=>196905003112154132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正在处理您的请求, 请稍候';

wwv_flow_api.create_message (
  p_id=>196905129386154133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_pool
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'共享池';

wwv_flow_api.create_message (
  p_id=>196905208147154133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED POOL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buffer_cache
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'缓冲区高速缓存';

wwv_flow_api.create_message (
  p_id=>196905306821154133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUFFER CACHE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'其他';

wwv_flow_api.create_message (
  p_id=>196905425276154133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OTHER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message navigation_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航页';

wwv_flow_api.create_message (
  p_id=>196905502774154133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAVIGATION_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑';

wwv_flow_api.create_message (
  p_id=>196905606753154133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_MENUS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列表';

wwv_flow_api.create_message (
  p_id=>196905718620154133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'管理页组';

wwv_flow_api.create_message (
  p_id=>196905825997154134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE PAGE GROUPS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未使用列表。';

wwv_flow_api.create_message (
  p_id=>196905927673154134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未使用面包屑。';

wwv_flow_api.create_message (
  p_id=>196906013165154134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_MENUS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p374_pos_5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'位置 5';

wwv_flow_api.create_message (
  p_id=>196906125253154134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P374.POS.5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reassign_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重新分配页';

wwv_flow_api.create_message (
  p_id=>196906206686154134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REASSIGN_PAGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'静态 HTML';

wwv_flow_api.create_message (
  p_id=>196906321932154134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_HTML',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_must_be_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此帐户的口令必须更改。';

wwv_flow_api.create_message (
  p_id=>196906412268154135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MUST_BE_CHANGED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'动态表单';

wwv_flow_api.create_message (
  p_id=>196906503156154135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apex_wizard_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航表单';

wwv_flow_api.create_message (
  p_id=>196906630904154135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEX_WIZARD_FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_htmldb_user_guide
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序构建器用户指南';

wwv_flow_api.create_message (
  p_id=>196906730815154135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.HTMLDB_USER_GUIDE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 天开发者速成';

wwv_flow_api.create_message (
  p_id=>196906813634154135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DEV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 天 DBA 速成';

wwv_flow_api.create_message (
  p_id=>196906905245154135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DBA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_referential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'参考资料';

wwv_flow_api.create_message (
  p_id=>196907031822154136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_REFERENTIAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message inactive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不活动';

wwv_flow_api.create_message (
  p_id=>196907110901154136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INACTIVE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1220_script_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 的结果, 运行 %1';

wwv_flow_api.create_message (
  p_id=>196907203537154136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1220_SCRIPT_RESULT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dml_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DML 表单';

wwv_flow_api.create_message (
  p_id=>196907319850154136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DML_FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'“获取下一个或上一个主键值”处理需要此项。';

wwv_flow_api.create_message (
  p_id=>196907422192154136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'“获取下一个或上一个主键值”处理需要此按钮。';

wwv_flow_api.create_message (
  p_id=>196907507521154136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'获取下一个或上一个主键值';

wwv_flow_api.create_message (
  p_id=>196907612224154136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_show_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示/隐藏列';

wwv_flow_api.create_message (
  p_id=>196907707644154137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_SHOW_COLS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_remove_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>196907805364154137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_REMOVE_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join_hint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'单击此处可选择要联接的列';

wwv_flow_api.create_message (
  p_id=>196907920193154137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN_HINT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行“获取下一个或上一个主键值”处理。';

wwv_flow_api.create_message (
  p_id=>196908029197154137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_get_next_or_prev_pk_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法获取下一个或上一个主键值。%0';

wwv_flow_api.create_message (
  p_id=>196908109030154137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.GET_NEXT_OR_PREV_PK_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_check_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'再次检查您的处理定义。%0';

wwv_flow_api.create_message (
  p_id=>196908216418154137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.CHECK_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_stmt_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已处理语句。';

wwv_flow_api.create_message (
  p_id=>196908313787154138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.STMT_PROCESSED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'卸载脚本';

wwv_flow_api.create_message (
  p_id=>196908407126154138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列';

wwv_flow_api.create_message (
  p_id=>196908501480154138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'别名';

wwv_flow_api.create_message (
  p_id=>196908617951154138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_ALIAS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对象';

wwv_flow_api.create_message (
  p_id=>196908725239154138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OBJECT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'条件';

wwv_flow_api.create_message (
  p_id=>196908814819154138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_CONDITION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'排序类型';

wwv_flow_api.create_message (
  p_id=>196908921896154138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'排序顺序';

wwv_flow_api.create_message (
  p_id=>196909014044154139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT_ORDER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_output
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示';

wwv_flow_api.create_message (
  p_id=>196909104348154139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OUTPUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'函数';

wwv_flow_api.create_message (
  p_id=>196909226232154139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_FUNCTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分组方式';

wwv_flow_api.create_message (
  p_id=>196909304119154139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_GROUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message file_too_big
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此文本文件太大, 无法编辑。要更改内容, 必须在您的本地计算机上编辑该文件, 然后重新上载它。';

wwv_flow_api.create_message (
  p_id=>196909408639154139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FILE_TOO_BIG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_total_sessions2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'会话总数: %0';

wwv_flow_api.create_message (
  p_id=>196909526606154139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_TOTAL_SESSIONS2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_prefs_exists_for2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存在 %1 个用户的 %0 个首选项';

wwv_flow_api.create_message (
  p_id=>196909628506154139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_PREFS_EXISTS_FOR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_to_create_tablespace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此时无法创建表空间。请稍后重试。';

wwv_flow_api.create_message (
  p_id=>196909710465154140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_TO_CREATE_TABLESPACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查询无效, 未找到 select 语句';

wwv_flow_api.create_message (
  p_id=>196909808017154140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY_REQUIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'联接';

wwv_flow_api.create_message (
  p_id=>196909925063154140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'至';

wwv_flow_api.create_message (
  p_id=>196910001568154140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_TO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_max_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最多可以选择 60 列。';

wwv_flow_api.create_message (
  p_id=>196910112533154140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_MAX_COLS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message application_x
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序 %0';

wwv_flow_api.create_message (
  p_id=>196910221290154140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APPLICATION_X',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_executing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行';

wwv_flow_api.create_message (
  p_id=>196910306868154141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.EXECUTING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message clear_command
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'清除命令';

wwv_flow_api.create_message (
  p_id=>196910426300154141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CLEAR_COMMAND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message find_tables
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查找表';

wwv_flow_api.create_message (
  p_id=>196910531223154141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FIND_TABLES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是否确实要退出此页而不进行保存?';

wwv_flow_api.create_message (
  p_id=>196910629210154141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_SHORTCUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message download
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下载';

wwv_flow_api.create_message (
  p_id=>196910732562154141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DOWNLOAD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_for_printing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打印视图';

wwv_flow_api.create_message (
  p_id=>196910808265154141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_FOR_PRINTING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_developer_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有开发者权限';

wwv_flow_api.create_message (
  p_id=>196910920579154142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DEVELOPER_PRIV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令有效';

wwv_flow_api.create_message (
  p_id=>196911006297154142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_VALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令失效';

wwv_flow_api.create_message (
  p_id=>196911106249154142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_EXPIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_completed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已完成';

wwv_flow_api.create_message (
  p_id=>196911227671154142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.COMPLETED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_in_progress
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正在进行';

wwv_flow_api.create_message (
  p_id=>196911310500154142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.IN_PROGRESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 行。';

wwv_flow_api.create_message (
  p_id=>196911432113154142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 行。';

wwv_flow_api.create_message (
  p_id=>196911529289154143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROWS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_elapsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 秒';

wwv_flow_api.create_message (
  p_id=>196911616116154143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ELAPSED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'开发者已定义';

wwv_flow_api.create_message (
  p_id=>196911723988154143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SCHEME_DESC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正常, 成功验证';

wwv_flow_api.create_message (
  p_id=>196911819626154143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未知的用户名';

wwv_flow_api.create_message (
  p_id=>196911922147154143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'帐户已锁定';

wwv_flow_api.create_message (
  p_id=>196912000190154143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_LOCKED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'帐户已失效';

wwv_flow_api.create_message (
  p_id=>196912121845154143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_EXPIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_incorrect
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令不正确';

wwv_flow_api.create_message (
  p_id=>196912214006154144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_INCORRECT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_first_use
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'初次使用口令';

wwv_flow_api.create_message (
  p_id=>196912322409154144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_FIRST_USE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_attempts_exceeded
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'超过了最大登录尝试次数';

wwv_flow_api.create_message (
  p_id=>196912405670154144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ATTEMPTS_EXCEEDED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_internal_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未知的内部错误';

wwv_flow_api.create_message (
  p_id=>196912513072154144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_INTERNAL_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'站点管理';

wwv_flow_api.create_message (
  p_id=>196912632734154144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_LOGIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区登录';

wwv_flow_api.create_message (
  p_id=>196912727433154144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE_LOGIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'访问控制管理页';

wwv_flow_api.create_message (
  p_id=>196912810438154145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_confirm_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建表';

wwv_flow_api.create_message (
  p_id=>196912926829154145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CONFIRM_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序管理';

wwv_flow_api.create_message (
  p_id=>196913007148154145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_ADMIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对所有内容具有完全访问权限, 不使用访问控制列表。';

wwv_flow_api.create_message (
  p_id=>196913103207154145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'有限的访问权限。仅允许在访问控制列表中定义的用户。';

wwv_flow_api.create_message (
  p_id=>196913222886154145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'仅限公共读取。通过访问控制列表控制编辑和管理权限。';

wwv_flow_api.create_message (
  p_id=>196913318675154145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'仅限管理访问权限。';

wwv_flow_api.create_message (
  p_id=>196913408730154146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标识将如何控制对此应用程序的访问权限。';

wwv_flow_api.create_message (
  p_id=>196913509242154146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序模式';

wwv_flow_api.create_message (
  p_id=>196913618571154146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_set_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'设置应用程序模式';

wwv_flow_api.create_message (
  p_id=>196913729537154146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_SET_APP_MODE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dbaccount_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库帐户';

wwv_flow_api.create_message (
  p_id=>196913809530154146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DBACCOUNT_AUTH_SCHEME_DESC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'访问控制列表';

wwv_flow_api.create_message (
  p_id=>196913912489154146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ldap_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP';

wwv_flow_api.create_message (
  p_id=>196914008513154146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LDAP_AUTH_SCHEME_DESC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户名';

wwv_flow_api.create_message (
  p_id=>196914114765154147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USERNAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'权限';

wwv_flow_api.create_message (
  p_id=>196914215400154147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_PRIV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'管理员';

wwv_flow_api.create_message (
  p_id=>196914328230154147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_last_changed_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上次更改者';

wwv_flow_api.create_message (
  p_id=>196914404651154147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_find_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'输入不区分大小写的查询标准, 然后按<b>开始</b>按钮。';

wwv_flow_api.create_message (
  p_id=>196914522172154147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_FIND_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_get_app_mode_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法获取应用程序管理模式。';

wwv_flow_api.create_message (
  p_id=>196914618029154147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有执行所尝试操作的权限。';

wwv_flow_api.create_message (
  p_id=>196914729866154148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_NO_PRIV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法处理“设置应用程序模式”请求。';

wwv_flow_api.create_message (
  p_id=>196914824776154148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序模式已设置。';

wwv_flow_api.create_message (
  p_id=>196914905346154148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_util_invalid_proxy_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'由于指定的 URL 不正确或需要指定代理 URL, 无法访问打印引擎。';

wwv_flow_api.create_message (
  p_id=>196915014645154148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PRINT_UTIL.INVALID_PROXY_URL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_object_browser_only_n_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示前 %0 列。';

wwv_flow_api.create_message (
  p_id=>196915103410154148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已请求运行以下脚本。请确认请求。';

wwv_flow_api.create_message (
  p_id=>196915200775154148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RUN_SCRIPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_script_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'脚本名';

wwv_flow_api.create_message (
  p_id=>196915316667154148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_SCRIPT_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_num_stmts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'语句数';

wwv_flow_api.create_message (
  p_id=>196915400115154149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_NUM_STMTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查看详细资料';

wwv_flow_api.create_message (
  p_id=>196915514585154149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_DETAILS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>196915627406154149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEINSTALL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_31_log_count
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'登录访问日志条目';

wwv_flow_api.create_message (
  p_id=>196915700777154149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_31_LOG_COUNT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ob_compile_errors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 个错误。';

wwv_flow_api.create_message (
  p_id=>196915816466154149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OB_COMPILE_ERRORS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'调色板';

wwv_flow_api.create_message (
  p_id=>196915908982154149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_file_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行脚本。%0';

wwv_flow_api.create_message (
  p_id=>196916029000154150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_FILE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'run_statement 中出错。%0';

wwv_flow_api.create_message (
  p_id=>196916131247154150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_STMT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql_arr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'run_sql_arr 中出错。%0';

wwv_flow_api.create_message (
  p_id=>196916200736154150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL_ARR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'成功';

wwv_flow_api.create_message (
  p_id=>196916332376154150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_fail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>196916402221154150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.FAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'全部编辑';

wwv_flow_api.create_message (
  p_id=>196916514575154150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_ALL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_query_limit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SELECT 语句不能大于 32KB。';

wwv_flow_api.create_message (
  p_id=>196916607670154151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.QUERY_LIMIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message administator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区管理员';

wwv_flow_api.create_message (
  p_id=>196916701824154151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADMINISTATOR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message developer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'开发者';

wwv_flow_api.create_message (
  p_id=>196916810582154151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEVELOPER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message end_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最终用户';

wwv_flow_api.create_message (
  p_id=>196916931936154151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'END_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_nosgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安全组 ID 为空。';

wwv_flow_api.create_message (
  p_id=>196917023914154151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NOSGID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_rows_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已选择 %0 行。';

wwv_flow_api.create_message (
  p_id=>196917109567154151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ROWS_SELECTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'欢迎使用';

wwv_flow_api.create_message (
  p_id=>196917207488154151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_existence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存在性检查失败';

wwv_flow_api.create_message (
  p_id=>196917315155154152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.EXISTENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序替换';

wwv_flow_api.create_message (
  p_id=>196917415736154152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'构建选项';

wwv_flow_api.create_message (
  p_id=>196917528208154152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证';

wwv_flow_api.create_message (
  p_id=>196917607008154152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安装确认';

wwv_flow_api.create_message (
  p_id=>196917725607154152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安装成功后';

wwv_flow_api.create_message (
  p_id=>196917816750154152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安装失败后';

wwv_flow_api.create_message (
  p_id=>196917931960154153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_license
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'许可证';

wwv_flow_api.create_message (
  p_id=>196918023784154153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.LICENSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirm_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'卸载确认';

wwv_flow_api.create_message (
  p_id=>196918129129154153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRM_DEINSTALL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'卸载成功';

wwv_flow_api.create_message (
  p_id=>196918212952154153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2613_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令失效';

wwv_flow_api.create_message (
  p_id=>196918325020154153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2613_EXPIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manual
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'手动';

wwv_flow_api.create_message (
  p_id=>196918406361154153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANUAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_flow_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库帐户';

wwv_flow_api.create_message (
  p_id=>196918509681154154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_FLOW.DBACCOUNT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用数据库帐户身份证明。';

wwv_flow_api.create_message (
  p_id=>196918621355154154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DBACCOUNT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用现有表';

wwv_flow_api.create_message (
  p_id=>196918708835154154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建授权方案';

wwv_flow_api.create_message (
  p_id=>196918804553154154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_script_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 未找到脚本。';

wwv_flow_api.create_message (
  p_id=>196918902938154154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.SCRIPT_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_nest_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 脚本最多可以嵌套 %0 层。';

wwv_flow_api.create_message (
  p_id=>196919021237154154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_NEST_LEVEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_cannot_run_cmd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已阻塞 %0 命令。无法从 SQL 工作室运行它。';

wwv_flow_api.create_message (
  p_id=>196919101900154154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CANNOT_RUN_CMD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_dbaccount_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'单击以在验证函数中置入 -DBACCOUNT-'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>196919208694154155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P802.DBACCOUNT_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_dbauth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用数据库帐户用户名和口令进行验证。';

wwv_flow_api.create_message (
  p_id=>196919307841154155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_DBAUTH_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parsing_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'语法分析方案';

wwv_flow_api.create_message (
  p_id=>196919403204154155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARSING_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用现有授权方案';

wwv_flow_api.create_message (
  p_id=>196919512785154155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_rpt_region_header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标识与此应用程序验证方案对应的用户名。';

wwv_flow_api.create_message (
  p_id=>196919629068154155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'针对 Oracle 数据库帐户检查输入登录表单的用户名和口令。当应用程序用户在数据库中有帐户时, 此技术非常方便。';

wwv_flow_api.create_message (
  p_id=>196919712640154155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15A',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'帐户已锁定。';

wwv_flow_api.create_message (
  p_id=>196919824470154156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_LOCKED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unknown_authentication_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'发生了无法识别的验证错误。';

wwv_flow_api.create_message (
  p_id=>196919914493154156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNKNOWN_AUTHENTICATION_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_before_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正文之前';

wwv_flow_api.create_message (
  p_id=>196920017204154156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BEFORE_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_after_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正文之后';

wwv_flow_api.create_message (
  p_id=>196920127916154156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.AFTER_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_script_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 脚本输出达到最大大小限制。请更改脚本以生成较小的输出, 或与管理员联系以增加脚本结果大小的最大值。';

wwv_flow_api.create_message (
  p_id=>196920211265154156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_SCRIPT_OUTPUT_REACHED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_workspace_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 脚本输出达到工作区结果大小的最大限制。请删除现有结果, 或与管理员联系以增加工作区结果大小的最大值。';

wwv_flow_api.create_message (
  p_id=>196920317451154156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_WORKSPACE_OUTPUT_REACHED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hr_account_unlocked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HR 帐户已解除锁定。';

wwv_flow_api.create_message (
  p_id=>196920400733154156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HR_ACCOUNT_UNLOCKED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Express 2 天速成和开发者指南。';

wwv_flow_api.create_message (
  p_id=>196920502669154157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD HTMLDB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day DBA。';

wwv_flow_api.create_message (
  p_id=>196920615971154157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DBA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Developer Guide。';

wwv_flow_api.create_message (
  p_id=>196920727104154157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DEV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus Java Developer Guide。';

wwv_flow_api.create_message (
  p_id=>196920800719154157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD JAVA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus .NET Developer Guide。';

wwv_flow_api.create_message (
  p_id=>196920907484154157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD NET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus PHP Developer。';

wwv_flow_api.create_message (
  p_id=>196921014541154157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD PHP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'讨论常见的日常管理任务。';

wwv_flow_api.create_message (
  p_id=>196921116170154158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DBA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'说明如何利用 Oracle Database Express Edition 开发环境。';

wwv_flow_api.create_message (
  p_id=>196921204845154158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DEV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'提供一系列说明如何构建以数据库为中心的 Web 应用程序的教程。';

wwv_flow_api.create_message (
  p_id=>196921303811154158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG HTMLDB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'本文档提供的教程说明如何下载和安装 Apache 及 Zend Core PHP 驱动程序, 介绍如何使用 PHP 来连接到 Oracle Database XE, 并演示如何使用 PHP 来开发一个可访问和修改数据的简单应用程序。';

wwv_flow_api.create_message (
  p_id=>196921417323154158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG PHP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'本文档提供的教程说明如何使用 Java 和 JDB 来连接到 Oracle Database XE, 并演示如何使用它们来开发一个可访问和修改数据的简单 Java 应用程序。';

wwv_flow_api.create_message (
  p_id=>196921525210154158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG JAVA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'本文档说明 Oracle Data Provider for .NET 和 Oracle Developer Tools for Visual Studio .NET 的主要功能。它将指导您进行安装和配置, 说明如何使用 Oracle Data Provider for .NET 和 Oracle Developer Tools for Visual Studio .NET 构建基本应用程序, 以及如何创建和使用 PL/SQL 及 .NET 存储过程。';

wwv_flow_api.create_message (
  p_id=>196921624138154158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG NET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'帐户已创建。';

wwv_flow_api.create_message (
  p_id=>196921709328154158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_invalid_context
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须从应用程序会话中调用此过程。';

wwv_flow_api.create_message (
  p_id=>196921804854154159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.INVALID_CONTEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_foreign
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'外部';

wwv_flow_api.create_message (
  p_id=>196921930047154159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_FOREIGN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_requires_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此 WSDL 需要验证身份证明。请在下面提供用户名和口令。';

wwv_flow_api.create_message (
  p_id=>196922015087154159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_REQUIRES_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示处理过程中尝试保存处于会话状态的项 %0。项保护级别为 "%1"。 有无传递的校验和均适合保护级别为 "%2" 的项。';

wwv_flow_api.create_message (
  p_id=>196922111226154159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_SHOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项没有保护。';

wwv_flow_api.create_message (
  p_id=>196922202974154159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.UNPROTECTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_public_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可以在项具有 "应用程序级书签" 校验和时设置项。';

wwv_flow_api.create_message (
  p_id=>196922317379154159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PUBLIC_BOOKMARK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_private_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可以在项具有 "用户级书签" 校验和时设置项。';

wwv_flow_api.create_message (
  p_id=>196922422507154160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PRIVATE_BOOKMARK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可以在项具有 "会话" 校验和时设置项。';

wwv_flow_api.create_message (
  p_id=>196922511385154160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SESSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_internal_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法通过将参数传递到应用程序来设置项。';

wwv_flow_api.create_message (
  p_id=>196922605426154160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.INTERNAL_ONLY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页没有保护';

wwv_flow_api.create_message (
  p_id=>196922705419154160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.UNPROTECTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_checksum_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果校验和被传递到显示过程, 则可以用参数请求页。';

wwv_flow_api.create_message (
  p_id=>196922830108154160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.CHECKSUM_REQUIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'只有在没有参数时才能访问页';

wwv_flow_api.create_message (
  p_id=>196922914016154160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.NO_ARGS_ALLOWED ',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_direct_branch_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'只有使用 "分支到页" 类型分支, 才可以从另一页访问页';

wwv_flow_api.create_message (
  p_id=>196923025554154161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.DIRECT_BRANCH_ONLY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未提供用于显示页处理的校验和, 当将一个或多个请求, 清除高速缓存或参数值作为参数传递时, 该页需要校验和。';

wwv_flow_api.create_message (
  p_id=>196923124905154161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISSING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_mismatch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'根据请求, 清除高速缓存, 参数名和参数值计算的校验和 (%0) 与传递到显示过程中的校验和 (%1) 不匹配。';

wwv_flow_api.create_message (
  p_id=>196923205181154161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISMATCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'参数已传递到不接受参数 (请求, 清除高速缓存, 项值) 的页中。';

wwv_flow_api.create_message (
  p_id=>196923312092154161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_ARGS_ALLOWED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_url_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法使用 URL, GET 或 POST 来调用此页以显示过程, 必须使用 "分支到页" 分支类型才能调用它。';

wwv_flow_api.create_message (
  p_id=>196923418007154161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_URL_ALLOWED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'接受处理过程中尝试保存处于会话状态的项 %0, 项具有“仅内部”保护, 或者不是可以投递的表单项。';

wwv_flow_api.create_message (
  p_id=>196923526725154161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_ACCEPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_no_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(未提供校验和)';

wwv_flow_api.create_message (
  p_id=>196923617585154161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.NO_CHECKSUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_invalid_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找到无效的日期值, 请检查日期格式。';

wwv_flow_api.create_message (
  p_id=>196923712498154162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.INVALID_DATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_ui_def_hint_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序构建器使用用户界面默认设置来填充区域和项属性的初始值, 从而保证一个应用程序中多个页的一致性或多个应用程序的一致性。';

wwv_flow_api.create_message (
  p_id=>196923817600154162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_UI_DEF_HINT_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打开';

wwv_flow_api.create_message (
  p_id=>196923926381154162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_OPEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'锁定';

wwv_flow_api.create_message (
  p_id=>196924001935154162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_LOCKED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'失效';

wwv_flow_api.create_message (
  p_id=>196924125141154162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired_and_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'失效并锁定';

wwv_flow_api.create_message (
  p_id=>196924206880154162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED_AND_LOCKED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是否要执行此删除操作?';

wwv_flow_api.create_message (
  p_id=>196924325561154163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE_MSG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'大小';

wwv_flow_api.create_message (
  p_id=>196924426222154163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIZE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message length
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'长度';

wwv_flow_api.create_message (
  p_id=>196924523206154163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LENGTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message lines
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行';

wwv_flow_api.create_message (
  p_id=>196924623366154163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日历';

wwv_flow_api.create_message (
  p_id=>196924721059154163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_easy_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'轻松日历';

wwv_flow_api.create_message (
  p_id=>196924813170154163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_EASY_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请单击链接:'||chr(10)||
''||chr(10)||
'%0 '||chr(10)||
''||chr(10)||
'以完成审批处理并接收您的身份证明。';

wwv_flow_api.create_message (
  p_id=>196924929168154164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.EMAIL_CLICK_ON_LINK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_accepted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DELETE';

wwv_flow_api.create_message (
  p_id=>196925018029154164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.ACCEPTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求使用以下属性在 Web 服务引用页上创建表单。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>196925101733154164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_web_service_ref
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web 服务引用, 操作';

wwv_flow_api.create_message (
  p_id=>196925206935154164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WEB_SERVICE_REF',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单项';

wwv_flow_api.create_message (
  p_id=>196925306051154164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_output_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'输出项';

wwv_flow_api.create_message (
  p_id=>196925408741154164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OUTPUT_ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_no_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未找到与 Microsoft Access 查询对应的 Oracle 视图。Microsoft Access 查询语法已经加载到编辑窗口。修改此语法以创建 Oracle 视图。';

wwv_flow_api.create_message (
  p_id=>196925514388154164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_NO_VIEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_view_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在移植过程中使用的视图状态必须为 VALID。';

wwv_flow_api.create_message (
  p_id=>196925629757154165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_VIEW_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message storage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存储:';

wwv_flow_api.create_message (
  p_id=>196925703472154165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STORAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message memory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内存:';

wwv_flow_api.create_message (
  p_id=>196925807489154165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MEMORY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_page_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户:';

wwv_flow_api.create_message (
  p_id=>196925902652154165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_PAGE_USERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'会话:';

wwv_flow_api.create_message (
  p_id=>196926031349154165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SESSIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message active
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'活动';

wwv_flow_api.create_message (
  p_id=>196926108581154165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACTIVE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p3_find_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'定位 Exporter Tool 生成的文件';

wwv_flow_api.create_message (
  p_id=>196926202946154166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P3_FIND_FILE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>1. 导出 Microsoft Access 元数据。</b><br />'||chr(10)||
'运行 Exporter for Microsoft Access 并从 .mdb 文件中提取元数据。这将创建数据库 (.xml) 和应用程序 (.sql) 输出文件。'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>196926324029154166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>2. 将 Microsoft Access 数据库移植到 Oracle。</b><br />'||chr(10)||
'运行 Oracle Migration Workbench 并加载步骤 1 的数据库元数据。这会将方案和数据移植到 Oracle。'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>196926424203154166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>3. 创建 Oracle Application Express 工作区。</b><br />'||chr(10)||
'运行 Oracle Application Express 并创建工作区。将工作区与步骤 2 新建的方案关联。'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>196926516970154166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>4. 创建移植项目。</b><br />'||chr(10)||
'登录到步骤 3 创建的工作区并运行 Application Migration Workshop。创建移植项目并加载步骤 1 中的应用程序元数据。'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>196926601476154166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>5. 分析 Microsoft Access 应用程序。</b><br />'||chr(10)||
'从 Application Migration Workshop 验证并调整 Access 应用程序元数据。细化移植的范围并修复任何无效对象。'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>196926724902154166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>6. 生成 Oracle Application Express 应用程序。</b><br />'||chr(10)||
'创建基于有效表单和报表的应用程序或基于有效表和视图的维护应用程序。'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>196926822868154166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP6',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>7. 定义 Application Express 应用程序。</b><br />'||chr(10)||
'在应用程序构建器 (Application Express 的一部分) 中打开应用程序并定制移植的应用程序。可以更改应用程序属性或将新页添加到应用程序。';

wwv_flow_api.create_message (
  p_id=>196926903036154167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP7',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message internal_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内部';

wwv_flow_api.create_message (
  p_id=>196927014951154167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERNAL_USERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message database_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库';

wwv_flow_api.create_message (
  p_id=>196927108047154167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DATABASE_USERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_obj_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 已成功创建。';

wwv_flow_api.create_message (
  p_id=>196927211449154167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_OBJ_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p10_queries_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用最左边的列来选择要包括在移植中的查询。'||chr(10)||
'<br><br>'||chr(10)||
'要包括查询, 其状态必须为“有效”。默认情况下, 选定所有状态为“有效”的查询。'||chr(10)||
'<br><br>'||chr(10)||
'如果没有选择要包括的查询, 所有基于该查询的表单或报表均排除在移植之外。'||chr(10)||
'<br><br>'||chr(10)||
'单击<b>尝试编译无效查询</b>链接运行尝试编译所有查询的批处理。'||chr(10)||
'<br><br>'||chr(10)||
'单击<b>应用更改</b>以保存选择或更新。';

wwv_flow_api.create_message (
  p_id=>196927309960154167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P10_QUERIES_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p9_tables_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用最左边的列来选择要包括在移植中的表。'||chr(10)||
'<br><br>'||chr(10)||
'要包括表, 其状态必须为“有效”。默认情况下, 选定所有状态为“有效”的表。'||chr(10)||
'<br><br>'||chr(10)||
'如果没有选择要包括的表, 所有基于此表的表单和报表均排除在移植之外。'||chr(10)||
'<br><br>单击<b>应用更改</b>以保存选择或更新。';

wwv_flow_api.create_message (
  p_id=>196927431232154167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P9_TABLES_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_table_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果表没有主键, 单击<b>创建主键</b>链接进行添加。所有表在移植之前都必须具有主键。';

wwv_flow_api.create_message (
  p_id=>196927501820154168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_TABLE_INFO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p8_forms_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'1. 使用最左边的列选择要包括在移植中的表单。'||chr(10)||
'<br /><br />'||chr(10)||
'要包括表单, 表单源的状态必须为“有效”。默认情况下, 选定所有基于有效源对象的表单。'||chr(10)||
'<br /><br />'||chr(10)||
'2. 单击<b>尝试编译无效 SQL 查询</b>链接运行尝试编译所有无效 SQL 查询的批处理。'||chr(10)||
'<br /><br />'||chr(10)||
'3. 在<b>移植到</b>列中, 选择要将 Microsoft Access 表单移植到的 Oracle Application Express 对象的类型:  '||chr(10)||
'<li>表单 (默认选项)</li>'||chr(10)||
'<li>表格式表单</li>'||chr(10)||
'<li>报表和表单</li>'||chr(10)||
'<br><br>'||chr(10)||
'对于有效的表和查询, 将显示这些选项。'||chr(10)||
'<br><br>'||chr(10)||
'4. 单击<b>应用更改</b>以保存选择或更新。'||chr(10)||
'<p />'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>196927616132154168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P8_FORMS_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p20_reports_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用最左边的列选择要包括在移植中的报表。'||chr(10)||
'<br><br>'||chr(10)||
'要包括报表, 报表源的状态必须为“有效”。默认情况下, 选定所有基于有效源对象的报表。'||chr(10)||
'<br><br>'||chr(10)||
'单击<b>尝试编译无效 SQL 查询</b>链接运行尝试编译所有无效 SQL 查询的批处理。'||chr(10)||
'<br><br>'||chr(10)||
'单击<b>应用更改</b>以保存选择或更新。';

wwv_flow_api.create_message (
  p_id=>196927706027154168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P20_REPORTS_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_defs_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建新的应用程序时, 将使用这些默认值。';

wwv_flow_api.create_message (
  p_id=>196927819521154168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_DEFS_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示处理过程中尝试保存处于会话状态的项 %0, 项具有“仅内部”保护。';

wwv_flow_api.create_message (
  p_id=>196927910191154168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_SHOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_parser_line_exceeds_32k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'脚本行多于 32767 字节';

wwv_flow_api.create_message (
  p_id=>196928015466154168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_PARSER.LINE_EXCEEDS_32K',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv_obj
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案 %0 对表或视图 %1 不具有选择权限。';

wwv_flow_api.create_message (
  p_id=>196928122345154169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV_OBJ',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_approved_account_req_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您的工作区请求已获批准, 身份证明已通过电子邮件发送至 %0。';

wwv_flow_api.create_message (
  p_id=>196928206438154169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.APPROVED_ACCOUNT_REQ_DISPLAY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message archivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日志归档: 打开';

wwv_flow_api.create_message (
  p_id=>196928308174154169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ARCHIVELOG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message noarchivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日志归档: 关闭';

wwv_flow_api.create_message (
  p_id=>196928427354154169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOARCHIVELOG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_search
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'搜索';

wwv_flow_api.create_message (
  p_id=>196928522091154169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SEARCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表显示方式';

wwv_flow_api.create_message (
  p_id=>196928612898154169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_CHART_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_choose_a_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选择列';

wwv_flow_api.create_message (
  p_id=>196928730742154170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHOOSE_A_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analysis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 分析';

wwv_flow_api.create_message (
  p_id=>196928807173154170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYSIS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 图表';

wwv_flow_api.create_message (
  p_id=>196928916349154170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'插入表单';

wwv_flow_api.create_message (
  p_id=>196929018697154170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新建 %0';

wwv_flow_api.create_message (
  p_id=>196929126558154170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新表单';

wwv_flow_api.create_message (
  p_id=>196929227054154170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE_FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新 %0';

wwv_flow_api.create_message (
  p_id=>196929307720154170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 必须有某些值。';

wwv_flow_api.create_message (
  p_id=>196929407038154171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.NOT_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_is_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 必须是数字。';

wwv_flow_api.create_message (
  p_id=>196929516144154171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.IS_NUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'成功页';

wwv_flow_api.create_message (
  p_id=>196929610291154171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已成功插入数据。';

wwv_flow_api.create_message (
  p_id=>196929714636154171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_another
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'插入另一个';

wwv_flow_api.create_message (
  p_id=>196929826528154171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ANOTHER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_view_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查看报告';

wwv_flow_api.create_message (
  p_id=>196929929188154171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.VIEW_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回主页';

wwv_flow_api.create_message (
  p_id=>196930015196154172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'成功';

wwv_flow_api.create_message (
  p_id=>196930119713154172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_help_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此页显示某页的帮助。';

wwv_flow_api.create_message (
  p_id=>196930227952154172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.HELP_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_prev_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回上一页';

wwv_flow_api.create_message (
  p_id=>196930300191154172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_PREV_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 面包屑';

wwv_flow_api.create_message (
  p_id=>196930414692154172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.MENU',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'插入 %0';

wwv_flow_api.create_message (
  p_id=>196930529518154172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法显示报表。';

wwv_flow_api.create_message (
  p_id=>196930603206154173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_csv_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'电子表格';

wwv_flow_api.create_message (
  p_id=>196930714635154173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CSV_LINK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_clear_cache_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法清除高速缓存。';

wwv_flow_api.create_message (
  p_id=>196930802118154173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CLEAR_CACHE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_reset_pagination_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法重置页码。';

wwv_flow_api.create_message (
  p_id=>196930923562154173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RESET_PAGINATION_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法向 %0 插入一行。';

wwv_flow_api.create_message (
  p_id=>196931019829154173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analyze
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分析';

wwv_flow_api.create_message (
  p_id=>196931103543154173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYZE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_and_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报告和编辑';

wwv_flow_api.create_message (
  p_id=>196931224906154173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_AND_EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新建';

wwv_flow_api.create_message (
  p_id=>196931312658154174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_no_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'相关联的 Microsoft Access 表未能成功移植到 Oracle。有关详细信息, 请复查 Oracle Migration Workbench 日志文件。';

wwv_flow_api.create_message (
  p_id=>196931423163154174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_NO_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库用户 %0 已创建, 该用户具有使用数据文件 %2 的默认表空间 %1';

wwv_flow_api.create_message (
  p_id=>196931532273154174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_validate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'要验证 SQL 查询的语法, 请单击<b>验证</b>。显示的语法提取自 Microsoft Access 数据库。'||chr(10)||
'<br><br>'||chr(10)||
'请确保查询使用的 Oracle 语法有效。只有状态为“有效”的 SQL 查询才能包括在移植过程中。';

wwv_flow_api.create_message (
  p_id=>196931626319154174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_VALIDATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_menu_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法显示面包屑。';

wwv_flow_api.create_message (
  p_id=>196931717227154174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_MENU_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_display_region_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法显示页区域。';

wwv_flow_api.create_message (
  p_id=>196931815405154174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DISPLAY_REGION_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_ws_entire_response_doc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'整个响应文档';

wwv_flow_api.create_message (
  p_id=>196931919265154174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_WS_ENTIRE_RESPONSE_DOC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_invalid_wsdl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'提供的 URL 未返回有效的 WSDL 文档。';

wwv_flow_api.create_message (
  p_id=>196932014426154175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.INVALID_WSDL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_min_len_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令必须至少包含 %0 个字符。';

wwv_flow_api.create_message (
  p_id=>196932121850154175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MIN_LEN_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_differs_by_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新口令中必须至少有 %0 个字符与旧口令不同。';

wwv_flow_api.create_message (
  p_id=>196932224802154175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_DIFFERS_BY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_alpha_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令必须至少包含一个字母字符 (%0)。';

wwv_flow_api.create_message (
  p_id=>196932330601154175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_ALPHA_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令必须至少包含一个数字字符 (0123456789)。';

wwv_flow_api.create_message (
  p_id=>196932412511154176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_NUMERIC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_punctuation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令必须至少包含一个标点字符 (%0)。';

wwv_flow_api.create_message (
  p_id=>196932511553154176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_PUNCTUATION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_upper_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令必须至少包含一个大写的字母字符。';

wwv_flow_api.create_message (
  p_id=>196932615519154176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_UPPER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_lower_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令必须至少包含一个小写的字母字符。';

wwv_flow_api.create_message (
  p_id=>196932718842154176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_LOWER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_username_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令不能包含用户名。';

wwv_flow_api.create_message (
  p_id=>196932815184154176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_USERNAME_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_workspace_name_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令不能包含工作区名称。';

wwv_flow_api.create_message (
  p_id=>196932915067154176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORKSPACE_NAME_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_words_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令中包含禁止的简单单词。';

wwv_flow_api.create_message (
  p_id=>196933003395154177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORDS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存在 SQL 查询';

wwv_flow_api.create_message (
  p_id=>196933120954154177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXISTS_SQL_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不存在 SQL 查询';

wwv_flow_api.create_message (
  p_id=>196933226980154177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_EXISTS_SQL_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表达式 1 的项为空值';

wwv_flow_api.create_message (
  p_id=>196933331162154177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表达式 1 中的项非空';

wwv_flow_api.create_message (
  p_id=>196933403827154177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NOT_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message func_ret_boolean
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回布尔值的 PL/SQL 函数';

wwv_flow_api.create_message (
  p_id=>196933511444154177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNC_RET_BOOLEAN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_eq_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表达式中的首选项值';

wwv_flow_api.create_message (
  p_id=>196933614505154177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_EQ_EXP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_ne_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表达式 1 中的首选项值不等于表达式 2';

wwv_flow_api.create_message (
  p_id=>196933725439154178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_NE_EXP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_eq_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表达式 1 中的项值等于表达式 2';

wwv_flow_api.create_message (
  p_id=>196933811464154178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_EQ_EXP2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_ne_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表达式 1 中的项值不等于表达式 2';

wwv_flow_api.create_message (
  p_id=>196933932318154178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_NE_EXP2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_page_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'每次页访问求值';

wwv_flow_api.create_message (
  p_id=>196934012749154178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'每个会话求值一次';

wwv_flow_api.create_message (
  p_id=>196934104763154178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_SESSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_complexity_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令不符合此站点的口令复杂性规则。';

wwv_flow_api.create_message (
  p_id=>196934231160154178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_COMPLEXITY_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_export
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导出';

wwv_flow_api.create_message (
  p_id=>196934325362154179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.EXPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序是从当前工作区中导出的。';

wwv_flow_api.create_message (
  p_id=>196934420009154179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_CURR_WS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_non_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序是从另一个工作区中导出的。';

wwv_flow_api.create_message (
  p_id=>196934529029154179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_NON_CURR_WS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区已存在, 因此未创建。';

wwv_flow_api.create_message (
  p_id=>196934632194154179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_tobe_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将创建工作区。';

wwv_flow_api.create_message (
  p_id=>196934721094154179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_TOBE_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'向后';

wwv_flow_api.create_message (
  p_id=>196934820367154179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BACK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message today
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'今天';

wwv_flow_api.create_message (
  p_id=>196934903611154179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TODAY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message forward
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'向前';

wwv_flow_api.create_message (
  p_id=>196935009054154180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORWARD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用数据库验证 (用户由 DAD 标识)。';

wwv_flow_api.create_message (
  p_id=>196935111630154180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DAD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_internal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在此应用程序中使用内部 %0 帐户身份证明和登录页。';

wwv_flow_api.create_message (
  p_id=>196935230293154180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_INTERNAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序样例';

wwv_flow_api.create_message (
  p_id=>196935329693154180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'突出常用设计概念的样例应用程序。';

wwv_flow_api.create_message (
  p_id=>196935420772154180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP.DESCR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_collect_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'了解购物车概念。';

wwv_flow_api.create_message (
  p_id=>196935530707154180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.COLLECT.DESCR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message bytes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'字节';

wwv_flow_api.create_message (
  p_id=>196935616802154181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BYTES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rows_returned_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回的行';

wwv_flow_api.create_message (
  p_id=>196935708935154181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROWS_RETURNED_IN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message invalid_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对象 %0 无效。';

wwv_flow_api.create_message (
  p_id=>196935831675154181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INVALID_OBJECT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查询构建器';

wwv_flow_api.create_message (
  p_id=>196935930260154181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY BUILDER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有值列表';

wwv_flow_api.create_message (
  p_id=>196936009720154181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无快捷方式';

wwv_flow_api.create_message (
  p_id=>196936100591154181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_SHORTCUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_authorization_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无验证方案';

wwv_flow_api.create_message (
  p_id=>196936215365154182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_AUTHORIZATION_SCHEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_reset_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果您要在未预置任何值的情况下运行应用程序, 则重置会话状态。';

wwv_flow_api.create_message (
  p_id=>196936311261154182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_RESET_SESSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'“取消”按钮显示文本';

wwv_flow_api.create_message (
  p_id=>196936426114154182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'“完成”按钮显示文本';

wwv_flow_api.create_message (
  p_id=>196936527519154182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_previous_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'“上一步”按钮显示文本';

wwv_flow_api.create_message (
  p_id=>196936613704154182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_next_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'“下一步”按钮显示文本';

wwv_flow_api.create_message (
  p_id=>196936730982154182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.NEXT_BUTTON_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'取消按钮分支';

wwv_flow_api.create_message (
  p_id=>196936831136154182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'完成按钮分支';

wwv_flow_api.create_message (
  p_id=>196936910003154183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_BRANCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1 - %0';

wwv_flow_api.create_message (
  p_id=>196937022816154183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM_OF',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 按钮';

wwv_flow_api.create_message (
  p_id=>196937120110154183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message one
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'一';

wwv_flow_api.create_message (
  p_id=>196937212080154183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message my_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'我的页';

wwv_flow_api.create_message (
  p_id=>196937331157154183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MY_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copyright
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'版权所有 (c) %0, 保留所有权利。';

wwv_flow_api.create_message (
  p_id=>196937420451154183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPYRIGHT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域';

wwv_flow_api.create_message (
  p_id=>196937514904154184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'处理';

wwv_flow_api.create_message (
  p_id=>196937629472154184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message computations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'计算';

wwv_flow_api.create_message (
  p_id=>196937707192154184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPUTATIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message validations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证';

wwv_flow_api.create_message (
  p_id=>196937806741154184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALIDATIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message branches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支';

wwv_flow_api.create_message (
  p_id=>196937916934154184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BRANCHES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项';

wwv_flow_api.create_message (
  p_id=>196938027057154184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'按钮';

wwv_flow_api.create_message (
  p_id=>196938114899154184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - %1 / %2';

wwv_flow_api.create_message (
  p_id=>196938212237154185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z_2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'由管理员 %1 预配的工作区 %0。';

wwv_flow_api.create_message (
  p_id=>196938320052154185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unretrievable
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'由于提供的 URL 无效, 环境要求对 HTTP 请求使用有效的代理服务器地址而您没有为此应用程序定义一个地址, 或者必须为此 &PRODUCT_NAME. 实例配置 wallet 以进行 HTTPS 请求, 因此无法检索 WSDL 文档。';

wwv_flow_api.create_message (
  p_id=>196938418189154185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNRETRIEVABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_no_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WSDL 文档不包含 SOAP 绑定, 而它是添加引用所必需的。';

wwv_flow_api.create_message (
  p_id=>196938521952154185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_NO_SOAP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drillup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'汇集';

wwv_flow_api.create_message (
  p_id=>196938610791154186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drilldown
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'细化';

wwv_flow_api.create_message (
  p_id=>196938706966154186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLDOWN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑';

wwv_flow_api.create_message (
  p_id=>196938804492154186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message generated_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此表是使用表向导创建的。';

wwv_flow_api.create_message (
  p_id=>196938910228154186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'GENERATED_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message series
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'系列 %0';

wwv_flow_api.create_message (
  p_id=>196939018860154186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERIES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_fetch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法提取行。';

wwv_flow_api.create_message (
  p_id=>196939129077154187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_FETCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法处理表 %0 的行。';

wwv_flow_api.create_message (
  p_id=>196939214915154187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_action_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'操作已处理。';

wwv_flow_api.create_message (
  p_id=>196939324191154187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.ACTION_PROCESSED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message to_many_columns_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最多可以选择 %0 列。';

wwv_flow_api.create_message (
  p_id=>196939423870154187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TO_MANY_COLUMNS_SELECTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_javascript_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序要求启用 JavaScript。';

wwv_flow_api.create_message (
  p_id=>196939508103154187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_JAVASCRIPT_ENABLED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_cookies_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序要求启用 cookie。';

wwv_flow_api.create_message (
  p_id=>196939614287154187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_COOKIES_ENABLED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_unauthorized
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'访问未获授权。';

wwv_flow_api.create_message (
  p_id=>196939720423154187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.UNAUTHORIZED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_no_datatype
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未指定 %0 的数据类型。';

wwv_flow_api.create_message (
  p_id=>196939823240154188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P602_NO_DATATYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_multiple_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WSDL 文档包含多个 SOAP 绑定。&PRODUCT_NAME. 只支持 WSDL 具有一个 SOAP 绑定。单击“手动创建 Web 服务引用”可继续为此服务创建引用。';

wwv_flow_api.create_message (
  p_id=>196939928525154188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.MULTIPLE_SOAP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_html_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请单击<a href=''%0''>此处</a>以完成审批处理并接收您的身份证明。';

wwv_flow_api.create_message (
  p_id=>196940003936154188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.HTML_EMAIL_CLICK_ON_LINK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p1023_parsing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正在对脚本进行语法分析 - 请稍候。';

wwv_flow_api.create_message (
  p_id=>196940100610154188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P1023_PARSING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_line_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行号';

wwv_flow_api.create_message (
  p_id=>196940213285154189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.LINE_NUMBER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_invalid_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您请求运行的脚本包含未知语句。请删除以下语句。';

wwv_flow_api.create_message (
  p_id=>196940305714154189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.INVALID_STMT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f400_p107_step
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'步骤 %0';

wwv_flow_api.create_message (
  p_id=>196940430728154189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F400_P107_STEP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4719_yn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示“是”/“否”, 返回“Y”和“N”';

wwv_flow_api.create_message (
  p_id=>196940509170154189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4719.YN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'要报告的结果树';

wwv_flow_api.create_message (
  p_id=>196940613007154189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array_parms
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'要报告的结果参数';

wwv_flow_api.create_message (
  p_id=>196940723042154190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY_PARMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_collection
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'临时结果集名';

wwv_flow_api.create_message (
  p_id=>196940801094154190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLLECTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单区域标题';

wwv_flow_api.create_message (
  p_id=>196940919076154190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单区域模板';

wwv_flow_api.create_message (
  p_id=>196941027531154190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表区域标题';

wwv_flow_api.create_message (
  p_id=>196941126248154190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表区域模板';

wwv_flow_api.create_message (
  p_id=>196941232206154190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_insert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法执行插入操作。%0  %1';

wwv_flow_api.create_message (
  p_id=>196941307947154191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_INSERT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认值: 外观 5';

wwv_flow_api.create_message (
  p_id=>196941403410154191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME15',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 无显示 -';

wwv_flow_api.create_message (
  p_id=>196941504523154191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DISPLAY_VALUE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message xml_load_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'XML 加载错误。';

wwv_flow_api.create_message (
  p_id=>196941624475154191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'XML_LOAD_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_component
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'共享组件';

wwv_flow_api.create_message (
  p_id=>196941718584154191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED_COMPONENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>196941808259154191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.DELETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unexpired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未失效的';

wwv_flow_api.create_message (
  p_id=>196941901929154191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNEXPIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 图表';

wwv_flow_api.create_message (
  p_id=>196942006712154192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_slash_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML/文本';

wwv_flow_api.create_message (
  p_id=>196942114526154192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_SLASH_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text_with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 文本 (带有快捷方式)';

wwv_flow_api.create_message (
  p_id=>196942231560154192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT_WITH_SHORTCUTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法将 DDL 保存为脚本文件。%0';

wwv_flow_api.create_message (
  p_id=>196942307285154192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项名';

wwv_flow_api.create_message (
  p_id=>196942403658154192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示类型';

wwv_flow_api.create_message (
  p_id=>196942512901154192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_analyze_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分析 %0';

wwv_flow_api.create_message (
  p_id=>196942632326154193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.ANALYZE_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_view_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查看方式';

wwv_flow_api.create_message (
  p_id=>196942716399154193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.VIEW_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_analyze_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建分析页。%0';

wwv_flow_api.create_message (
  p_id=>196942826978154193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_ANALYZE_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message icon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图标 %0';

wwv_flow_api.create_message (
  p_id=>196942910252154193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ICON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message check
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行选择器';

wwv_flow_api.create_message (
  p_id=>196943023689154193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECK$',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列链接';

wwv_flow_api.create_message (
  p_id=>196943119874154193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINK$',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message derived
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'派生列';

wwv_flow_api.create_message (
  p_id=>196943220738154193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DERIVED$',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关于';

wwv_flow_api.create_message (
  p_id=>196943319779154194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ABOUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支';

wwv_flow_api.create_message (
  p_id=>196943400878154194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.BRANCHING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加行';

wwv_flow_api.create_message (
  p_id=>196943513763154194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.ADD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑';

wwv_flow_api.create_message (
  p_id=>196943602029154194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_numeric
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页必须是数字的。';

wwv_flow_api.create_message (
  p_id=>196943730568154194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_NUMERIC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_positive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页必须为正数。';

wwv_flow_api.create_message (
  p_id=>196943826962154194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_POSITIVE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_whole_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页必须为整数。';

wwv_flow_api.create_message (
  p_id=>196943915655154195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_WHOLE_NUMBER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序集合 %0 不存在';

wwv_flow_api.create_message (
  p_id=>196944031156154195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NOT_EXIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序集合 %1 中不存在成员序列 %0';

wwv_flow_api.create_message (
  p_id=>196944110657154195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_NOT_EXIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'指定的成员属性编号 %0 无效';

wwv_flow_api.create_message (
  p_id=>196944220667154195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_outside_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'指定的成员属性编号 %0 无效。属性编号必须介于 1 和 %1 之间';

wwv_flow_api.create_message (
  p_id=>196944319652154195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_OUTSIDE_RANGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_sequence_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在应用程序集合 "%1" 中不存在成员序列 %0';

wwv_flow_api.create_message (
  p_id=>196944422653154195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_SEQUENCE_NUMBER_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_array_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序集合数组不能为空';

wwv_flow_api.create_message (
  p_id=>196944526650154196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ARRAY_NOT_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'集合名不能为空';

wwv_flow_api.create_message (
  p_id=>196944619398154196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_NOT_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_too_large
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'集合名不能大于 255 个字符';

wwv_flow_api.create_message (
  p_id=>196944703883154196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_TOO_LARGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存在应用程序集合';

wwv_flow_api.create_message (
  p_id=>196944814615154196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'游标尚未打开';

wwv_flow_api.create_message (
  p_id=>196944911904154196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.CURSOR_NOT_OPEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_translation_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到应用程序 %1 的 %0 翻译';

wwv_flow_api.create_message (
  p_id=>196945003025154196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.TRANSLATION_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'种子插入错误: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>196945122309154197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_INSERT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_delete_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'种子删除错误: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>196945222844154197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_DELETE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_translations_seed_update_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'种子更新错误: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>196945309662154197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TRANSLATIONS.SEED_UPDATE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sync_translations_sync_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'同步错误: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>196945418793154197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SYNC_TRANSLATIONS.SYNC_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_sgid_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安全组 ID 20 是为工作区 ''ORACLE'' 保留的';

wwv_flow_api.create_message (
  p_id=>196945502957154197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.SGID_RESERVED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_button_tab_names_not_equal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'按钮不能与现有选项卡同名';

wwv_flow_api.create_message (
  p_id=>196945631781154197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.BUTTON_TAB_NAMES_NOT_EQUAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_writing_to_directory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'写入物理文件目录 "%0" 时出错。(%1: %2)';

wwv_flow_api.create_message (
  p_id=>196945729943154197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_WRITING_TO_DIRECTORY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_no_file_to_write
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有要写入的 ID 为 %0 的文件';

wwv_flow_api.create_message (
  p_id=>196945820597154198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.NO_FILE_TO_WRITE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'服务器在试图删除文件 "%0" 时出错';

wwv_flow_api.create_message (
  p_id=>196945905229154198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除文件 %0';

wwv_flow_api.create_message (
  p_id=>196946002388154198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed_with_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在用户开始更新过程以后, 数据库中数据的当前版本已经更改。当前校验和 = "%0" 应用程序校验和 = "%1"'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>196946118884154198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED_WITH_CHECKSUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在用户开始更新过程以后, 数据库中数据的当前版本已经更改。';

wwv_flow_api.create_message (
  p_id=>196946231908154198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_invalid_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对此对象的 %0 操作无效。 (%1)';

wwv_flow_api.create_message (
  p_id=>196946301372154198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.INVALID_ACTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法找到要复制的模板 (%0)';

wwv_flow_api.create_message (
  p_id=>196946422941154199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在应用程序 "%1" 工作区 "%2" 中找不到要复制的字段模板 (%0)';

wwv_flow_api.create_message (
  p_id=>196946529615154199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'访问未获授权。';

wwv_flow_api.create_message (
  p_id=>196946612821154199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在应用程序 "%1" 的工作区 "%2" 中找不到要复制的面包屑模板 (%0)';

wwv_flow_api.create_message (
  p_id=>196946700279154199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在应用程序 "%1" 工作区 "%2" 中找不到要复制的按钮模板 (%0)';

wwv_flow_api.create_message (
  p_id=>196946824182154199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换 %0 模板。 %1';

wwv_flow_api.create_message (
  p_id=>196946912016154199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_page_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换页模板。 %0';

wwv_flow_api.create_message (
  p_id=>196947007750154200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.PAGE_TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_region_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换区域模板。 %0';

wwv_flow_api.create_message (
  p_id=>196947104703154200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REGION_TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_report_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换报表模板。 %0';

wwv_flow_api.create_message (
  p_id=>196947203969154200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REPORT_TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_list_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换列表模板。 %0';

wwv_flow_api.create_message (
  p_id=>196947331335154200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.LIST_TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换字段模板。 %0';

wwv_flow_api.create_message (
  p_id=>196947419775154200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换面包屑模板。%0';

wwv_flow_api.create_message (
  p_id=>196947530226154200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_popup_lov_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换弹出式值列表模板。%0';

wwv_flow_api.create_message (
  p_id=>196947619031154200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.POPUP_LOV_TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法替换按钮模板。 %0';

wwv_flow_api.create_message (
  p_id=>196947705337154201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_REPLACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p122_cal_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此对象的日历模板';

wwv_flow_api.create_message (
  p_id=>196947824319154201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P122_CAL_TEMPL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除页引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196947904749154201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_PAGE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_region_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除区域引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196948004248154201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REGION_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_list_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除列表引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196948132111154201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LIST_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_report_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除报表引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196948226919154201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REPORT_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_field_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除字段引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196948306209154202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_FIELD_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_security_scheme_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除安全方案引用 ID。%0';

wwv_flow_api.create_message (
  p_id=>196948420528154202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SECURITY_SCHEME_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除快捷方式引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196948504972154202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SHORTCUT_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除导航栏引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196948620709154202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_NAVBAR_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除值列表引用 ID。%0';

wwv_flow_api.create_message (
  p_id=>196948701940154202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LOV_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_popup_lov_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除弹出式值列表模板引用 ID。%0';

wwv_flow_api.create_message (
  p_id=>196948808683154202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_POPUP_LOV_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除面包屑模板引用 ID。%0';

wwv_flow_api.create_message (
  p_id=>196948912590154203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_MENU_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_button_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除按钮模板引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196949010532154203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_BUTTON_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws_rpt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求使用以下属性在 Web 服务引用页上创建表单和报表。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>196949106138154203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_auth_setup_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除验证方案引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196949210812154203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_AUTH_SETUP_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除项帮助引用 ID。 %0';

wwv_flow_api.create_message (
  p_id=>196949324168154203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_ITEM_HELP_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅页模板。 %0';

wwv_flow_api.create_message (
  p_id=>196949424818154203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_PAGE_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅区域模板。 %0';

wwv_flow_api.create_message (
  p_id=>196949515444154203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REGION_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅列表模板。 %0';

wwv_flow_api.create_message (
  p_id=>196949602122154204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LIST_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅报表模板。 %0';

wwv_flow_api.create_message (
  p_id=>196949730110154204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REPORT_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅字段模板。 %0';

wwv_flow_api.create_message (
  p_id=>196949820017154204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_FIELD_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅弹出式值列表模板。%0';

wwv_flow_api.create_message (
  p_id=>196949916520154204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_POPUP_LOV_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅面包屑模板。%0';

wwv_flow_api.create_message (
  p_id=>196950032572154204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_MENU_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅按钮模板。 %0';

wwv_flow_api.create_message (
  p_id=>196950122754154204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_BUTTON_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅安全方案。%0';

wwv_flow_api.create_message (
  p_id=>196950224706154205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SECURITY_SCHEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅快捷方式。 %0';

wwv_flow_api.create_message (
  p_id=>196950315458154205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SHORTCUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅导航栏。 %0';

wwv_flow_api.create_message (
  p_id=>196950417862154205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_NAVBAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅值列表。%0';

wwv_flow_api.create_message (
  p_id=>196950504557154205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅验证方案。 %0';

wwv_flow_api.create_message (
  p_id=>196950602158154205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_AUTH_SETUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅项帮助。 %0';

wwv_flow_api.create_message (
  p_id=>196950722443154205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_ITEM_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布页模板。 %0';

wwv_flow_api.create_message (
  p_id=>196950810228154206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_PAGE_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布区域模板。 %0';

wwv_flow_api.create_message (
  p_id=>196950930912154206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REGION_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布列表模板。 %0';

wwv_flow_api.create_message (
  p_id=>196951007895154206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LIST_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布报表模板。 %0';

wwv_flow_api.create_message (
  p_id=>196951107048154206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REPORT_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布字段模板。 %0';

wwv_flow_api.create_message (
  p_id=>196951226422154206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_FIELD_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布弹出式值列表模板。%0';

wwv_flow_api.create_message (
  p_id=>196951316220154206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_POPUP_LOV_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布按钮模板。 %0';

wwv_flow_api.create_message (
  p_id=>196951422686154207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_BUTTON_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布面包屑模板。%0';

wwv_flow_api.create_message (
  p_id=>196951519733154207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_MENU_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布安全方案。%0';

wwv_flow_api.create_message (
  p_id=>196951601197154207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SECURITY_SCHEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布快捷方式。 %0';

wwv_flow_api.create_message (
  p_id=>196951731296154207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SHORTCUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布导航栏。 %0';

wwv_flow_api.create_message (
  p_id=>196951804758154207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_NAVBAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布值列表。 %0';

wwv_flow_api.create_message (
  p_id=>196951903394154207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布验证方案。 %0';

wwv_flow_api.create_message (
  p_id=>196952025013154207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_AUTH_SETUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布项帮助。 %0';

wwv_flow_api.create_message (
  p_id=>196952101538154208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_ITEM_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_user_no_privileges
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户 %0 没有 %1 方案的权限。';

wwv_flow_api.create_message (
  p_id=>196952200425154208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.USER_NO_PRIVILEGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到工作区 ID 为 %0 的工作区';

wwv_flow_api.create_message (
  p_id=>196952314829154208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_COMPANY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未指定工作区 ID: %0 的方案';

wwv_flow_api.create_message (
  p_id=>196952425267154208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_auto_provision_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在 "MAKE_REQUEST" 阶段自动预配失败';

wwv_flow_api.create_message (
  p_id=>196952525456154208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.AUTO_PROVISION_FAILURE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_user_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将用户添加到工作区 %0 时出错';

wwv_flow_api.create_message (
  p_id=>196952604937154208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_USER_ADD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此请求已经处理或正在处理。 状态必须等于 "%0"';

wwv_flow_api.create_message (
  p_id=>196952719521154209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_PROCESSED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区 %0 是保留名称, 请求被拒绝';

wwv_flow_api.create_message (
  p_id=>196952800032154209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_RESERVED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案名 %0 是保留方案, 不能预配此方案。';

wwv_flow_api.create_message (
  p_id=>196952926376154209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_RESERVED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不能处理请求 %0。  %1';

wwv_flow_api.create_message (
  p_id=>196953002586154209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_PROCESSED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不能处理请求 %0, 因为 %2 表中存在方案 %1。';

wwv_flow_api.create_message (
  p_id=>196953112366154209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未找到请求 %0';

wwv_flow_api.create_message (
  p_id=>196953229142154209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_generate_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rem 无法生成 %0 %1 的 DDL。';

wwv_flow_api.create_message (
  p_id=>196953322453154210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.GENERATE_DDL_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对 DDL 脚本进行语法分析时出错。 %0';

wwv_flow_api.create_message (
  p_id=>196953408925154210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_PARSE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Save_ddl 错误 %0';

wwv_flow_api.create_message (
  p_id=>196953520969154210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法导入数据库对象安装属性 (id="%0")';

wwv_flow_api.create_message (
  p_id=>196953624731154210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_script_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建安装脚本 (id="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196953722732154210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_SCRIPT_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_next_prev_pk_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建“获取下一个或上一个主键值”处理。%0';

wwv_flow_api.create_message (
  p_id=>196953819872154210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.NEXT_PREV_PK_PROCESS_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_table_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建访问控制表。%0';

wwv_flow_api.create_message (
  p_id=>196953923238154210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_page_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建访问控制页。%0';

wwv_flow_api.create_message (
  p_id=>196954018923154211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message out_of_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请求的行集无效, 报表的源数据已修改。';

wwv_flow_api.create_message (
  p_id=>196954115175154211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OUT_OF_RANGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重置页码';

wwv_flow_api.create_message (
  p_id=>196954218212154211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序安装程序将引导您完成创建数据库对象和种子数据的过程。';

wwv_flow_api.create_message (
  p_id=>196954324020154211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可以配置应用程序的以下属性。';

wwv_flow_api.create_message (
  p_id=>196954400522154211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可以选择包括以下构建选项。';

wwv_flow_api.create_message (
  p_id=>196954504673154212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将执行以下验证以确保您的系统与此应用程序兼容。';

wwv_flow_api.create_message (
  p_id=>196954607823154212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请确认您要安装此应用程序的支持对象。';

wwv_flow_api.create_message (
  p_id=>196954727610154212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您的应用程序的支持对象已安装。';

wwv_flow_api.create_message (
  p_id=>196954800074154212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安装数据库对象和种子数据失败。';

wwv_flow_api.create_message (
  p_id=>196954909905154212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'卸载完成。';

wwv_flow_api.create_message (
  p_id=>196955029523154212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方法';

wwv_flow_api.create_message (
  p_id=>196955119791154212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_METHOD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'详细资料';

wwv_flow_api.create_message (
  p_id=>196955224986154213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内置会话管理逻辑, 内置登录页和针对内部 "cookie 用户" 帐户资料档案库的用户验证。';

wwv_flow_api.create_message (
  p_id=>196955309835154213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内置会话管理逻辑。通过 modplsql DAD 配置完成用户验证。';

wwv_flow_api.create_message (
  p_id=>196955430557154213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此方法已被 SCHEME 验证取代。';

wwv_flow_api.create_message (
  p_id=>196955523934154213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此方法已过时。';

wwv_flow_api.create_message (
  p_id=>196955619792154213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_public_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'公共页';

wwv_flow_api.create_message (
  p_id=>196955710836154213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PUBLIC_PAGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'操作';

wwv_flow_api.create_message (
  p_id=>196955800387154214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复查或编辑';

wwv_flow_api.create_message (
  p_id=>196955917115154214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'或编辑';

wwv_flow_api.create_message (
  p_id=>196956010296154214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'会话管理属性';

wwv_flow_api.create_message (
  p_id=>196956128645154214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用应用程序属性页上的这一应用程序, 或使用上述报表来创建和管理那些在更改验证方法为 %0 时要用到的验证方案。';

wwv_flow_api.create_message (
  p_id=>196956215400154214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(无)';

wwv_flow_api.create_message (
  p_id=>196956300160154214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_NONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_manage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用上述报表管理验证方案。';

wwv_flow_api.create_message (
  p_id=>196956416861154214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_MANAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_deactivate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将状态更改为不活动';

wwv_flow_api.create_message (
  p_id=>196956525059154215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DEACTIVATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(当前)';

wwv_flow_api.create_message (
  p_id=>196956615409154215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_CURRENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使此方案成为当前方案';

wwv_flow_api.create_message (
  p_id=>196956707595154215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'设为当前';

wwv_flow_api.create_message (
  p_id=>196956826647154215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_copy_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>196956919548154215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_COPY_FROM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此验证方案的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>196957003117154215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_MASTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此验证方案的方案';

wwv_flow_api.create_message (
  p_id=>196957123708154216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_SUBSCRIBERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_no_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有订阅此验证方案的订户。';

wwv_flow_api.create_message (
  p_id=>196957203285154216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_NO_SUBSCRIBERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_builtin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(内置)';

wwv_flow_api.create_message (
  p_id=>196957322502154216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_BUILTIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>196957430656154216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pg_sentry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页卫士函数';

wwv_flow_api.create_message (
  p_id=>196957516682154216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PG_SENTRY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_sess_verify
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'会话验证函数';

wwv_flow_api.create_message (
  p_id=>196957627180154216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_SESS_VERIFY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_inv_sess_tgt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效会话目标';

wwv_flow_api.create_message (
  p_id=>196957710260154216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_INV_SESS_TGT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证前处理';

wwv_flow_api.create_message (
  p_id=>196957809040154217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PRE_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证函数';

wwv_flow_api.create_message (
  p_id=>196957924262154217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 主机';

wwv_flow_api.create_message (
  p_id=>196958020641154217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_HOST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 端口';

wwv_flow_api.create_message (
  p_id=>196958114649154217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_PORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 搜索基础';

wwv_flow_api.create_message (
  p_id=>196958215348154217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_DN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 用户名编辑';

wwv_flow_api.create_message (
  p_id=>196958311380154218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证后处理';

wwv_flow_api.create_message (
  p_id=>196958402995154218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_POST_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie 名称';

wwv_flow_api.create_message (
  p_id=>196958522880154218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_path
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie 路径';

wwv_flow_api.create_message (
  p_id=>196958619353154218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_PATH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_domain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie 域';

wwv_flow_api.create_message (
  p_id=>196958723014154218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_DOMAIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_logout_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'注销 URL';

wwv_flow_api.create_message (
  p_id=>196958802220154218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LOGOUT_URL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(数据库验证)';

wwv_flow_api.create_message (
  p_id=>196958922667154218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_DBAUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_flow_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序 ID';

wwv_flow_api.create_message (
  p_id=>196959032118154219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_FLOW_ID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证方法';

wwv_flow_api.create_message (
  p_id=>196959125050154219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_AUTH_METHOD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_scheme_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案名';

wwv_flow_api.create_message (
  p_id=>196959211178154219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_SCHEME_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'说明';

wwv_flow_api.create_message (
  p_id=>196959319500154219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_DESCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p822_curr_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前验证方法';

wwv_flow_api.create_message (
  p_id=>196959424243154219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P822_CURR_METHOD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建列表模板。 %0';

wwv_flow_api.create_message (
  p_id=>196959521941154219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建应用程序。%0';

wwv_flow_api.create_message (
  p_id=>196959632488154220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_FLOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建页模板。 %0';

wwv_flow_api.create_message (
  p_id=>196959700482154220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_PAGE_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_label_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建标签模板。 %0';

wwv_flow_api.create_message (
  p_id=>196959826453154220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LABEL_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建报表模板。 %0';

wwv_flow_api.create_message (
  p_id=>196959907777154220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建区域模板。 %0';

wwv_flow_api.create_message (
  p_id=>196960010322154220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REGION_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建面包屑模板。%0';

wwv_flow_api.create_message (
  p_id=>196960132117154220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建按钮模板。 %0';

wwv_flow_api.create_message (
  p_id=>196960222381154221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_BUTTON_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建弹出式值列表模板。';

wwv_flow_api.create_message (
  p_id=>196960311876154221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.POPUP_LOV_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建标准选项卡。 %0';

wwv_flow_api.create_message (
  p_id=>196960420809154221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建导航栏。 %0';

wwv_flow_api.create_message (
  p_id=>196960507700154221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NAVBAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建面包屑。%0';

wwv_flow_api.create_message (
  p_id=>196960613441154221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建报表页。%0';

wwv_flow_api.create_message (
  p_id=>196960724897154221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建插入表单。%0';

wwv_flow_api.create_message (
  p_id=>196960827827154221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_INSERT_FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建更新表单。 %0';

wwv_flow_api.create_message (
  p_id=>196960918125154222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_UPDATE_FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建图表页。';

wwv_flow_api.create_message (
  p_id=>196961029499154222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_CHART_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'设置以编辑 LDAP 用户名时出错。';

wwv_flow_api.create_message (
  p_id=>196961101044154222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行编辑 LDAP 用户功能。';

wwv_flow_api.create_message (
  p_id=>196961201863154222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_FN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SYS.DBMS_LDAP 包不存在或无效。';

wwv_flow_api.create_message (
  p_id=>196961309806154222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_MISSING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_fix
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请要求您的 DBA 运行 $OH/rdbms/admin/catldap.sql。';

wwv_flow_api.create_message (
  p_id=>196961406480154222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_FIX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_ldap_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行 wwv_flow_custom_auth_ldap.authenticate 时出错。';

wwv_flow_api.create_message (
  p_id=>196961517256154223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_LDAP_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行定制的验证前处理。';

wwv_flow_api.create_message (
  p_id=>196961603607154223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_PRE_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_setup_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'设置以运行身份证明检查功能时出错。';

wwv_flow_api.create_message (
  p_id=>196961731195154223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SETUP_CRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行验证身份证明检查功能。';

wwv_flow_api.create_message (
  p_id=>196961825524154223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_CRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行定制的验证后处理。';

wwv_flow_api.create_message (
  p_id=>196961931324154223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_POST_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login 的参数格式不正确 -- p_flow_page:p_session_id:p_entry_point:%0:%1:%2。';

wwv_flow_api.create_message (
  p_id=>196962014175154223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_null_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login 的 p_session_id 参数为空 -- p_flow_page:%0';

wwv_flow_api.create_message (
  p_id=>196962126511154224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NULL_LOGIN_ARG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请与管理员联系。';

wwv_flow_api.create_message (
  p_id=>196962215612154224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_CONTACT_ADMIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login 中的 p_session 非法 -- p_flow_page:%0 p_session_id:%1。';

wwv_flow_api.create_message (
  p_id=>196962307927154224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_ARG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_invalid_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login 中的 p_session 无效 -- p_flow_page:%0 p_session_id:%1。';

wwv_flow_api.create_message (
  p_id=>196962431117154224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_INVALID_LOGIN_ARG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login 的入口点参数非法 -- p_flow_page:p_session_id:p_entry_point:%0:%1:%2。';

wwv_flow_api.create_message (
  p_id=>196962519414154224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_login_null_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'传送到登录过程的用户名为空。';

wwv_flow_api.create_message (
  p_id=>196962604115154224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LOGIN_NULL_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_partner_app_unreg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法在验证方案中找到注册的合作伙伴应用程序名称。';

wwv_flow_api.create_message (
  p_id=>196962718376154225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_PARTNER_APP_UNREG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_partner_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请编辑验证方案并添加应用程序名称。';

wwv_flow_api.create_message (
  p_id=>196962815504154225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_PARTNER_APP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_wwsec_pkg_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WWSEC_SSO_ENABLER_PRIVATE 包不存在或无效。';

wwv_flow_api.create_message (
  p_id=>196962905675154225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_WWSEC_PKG_MISSING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_wwsec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请要求管理员配置 Oracle AS Single Sign-On 的引擎。';

wwv_flow_api.create_message (
  p_id=>196963017185154225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_WWSEC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_sso_redir
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行 wwv_flow_custom_auth_sso.portal_sso_redirect 时出错。';

wwv_flow_api.create_message (
  p_id=>196963101730154225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SSO_REDIR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_pg_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'login_page 过程的 p_flow_page 参数中出错。';

wwv_flow_api.create_message (
  p_id=>196963212645154225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_PG_ARG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_home_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建主页。 %0';

wwv_flow_api.create_message (
  p_id=>196963304367154225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_HOME_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建列表。 %0';

wwv_flow_api.create_message (
  p_id=>196963426296154226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建列表项。 %0';

wwv_flow_api.create_message (
  p_id=>196963505462154226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建成功页。 %0';

wwv_flow_api.create_message (
  p_id=>196963631712154226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_SUCCESS_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_define_default_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请定义用于创建应用程序的默认模板。';

wwv_flow_api.create_message (
  p_id=>196963712618154226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DEFINE_DEFAULT_TEMPLATES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_use_one_level_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'只能构建使用一级选项卡的应用程序。';

wwv_flow_api.create_message (
  p_id=>196963825921154226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.USE_ONE_LEVEL_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_modules
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建模块。 %0';

wwv_flow_api.create_message (
  p_id=>196963903538154226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MODULES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'语法分析错误 2 %0';

wwv_flow_api.create_message (
  p_id=>196964006840154227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'语法分析错误: %0';

wwv_flow_api.create_message (
  p_id=>196964118534154227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建可更新的报表。 %0';

wwv_flow_api.create_message (
  p_id=>196964216038154227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_UPDATEABLE_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建基于 SP 的表单。 %0';

wwv_flow_api.create_message (
  p_id=>196964311769154227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_SP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建基于表的表单。 %0';

wwv_flow_api.create_message (
  p_id=>196964414807154227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建插入表单。%0';

wwv_flow_api.create_message (
  p_id=>196964513929154227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_INSERT_FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_query_and_update_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建查询和更新页。 %0';

wwv_flow_api.create_message (
  p_id=>196964607233154228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_QUERY_AND_UPDATE_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建图表页。 %0';

wwv_flow_api.create_message (
  p_id=>196964724292154228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CHART_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表类型无效。';

wwv_flow_api.create_message (
  p_id=>196964823263154228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.INVALID_REPORT_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建报表页。%0';

wwv_flow_api.create_message (
  p_id=>196964930418154228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_REPORT_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_calendar_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建日历页。 %0';

wwv_flow_api.create_message (
  p_id=>196965018693154228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CALENDAR_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_equijoin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建基于等值联接的表单。 %0';

wwv_flow_api.create_message (
  p_id=>196965132280154228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_EQUIJOIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建“创建向导的向导”。 %0';

wwv_flow_api.create_message (
  p_id=>196965200000154229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_WIZARD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建树。 %0';

wwv_flow_api.create_message (
  p_id=>196965309430154229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_TREE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_excel_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建 Excel 图表。 %0';

wwv_flow_api.create_message (
  p_id=>196965423020154229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_EXCEL_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建概要页。 %0';

wwv_flow_api.create_message (
  p_id=>196965509193154229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SUMMARY_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建 SVG 图表页。 %0';

wwv_flow_api.create_message (
  p_id=>196965617657154229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SVG_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_updateable_query_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可更新的 SQL 查询已存在。每页只能添加一个可更新的 SQL 查询。';

wwv_flow_api.create_message (
  p_id=>196965721211154229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UPDATEABLE_QUERY_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg_handling
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'登录页处理';

wwv_flow_api.create_message (
  p_id=>196965804768154229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG_HANDLING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序 (%0) 将页 %1 作为登录页。';

wwv_flow_api.create_message (
  p_id=>196965925358154230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'每次请求 %0 页时, 不再执行进一步的验证检查而是显示或接受此页。这样可以在执行验证前显示登录页。';

wwv_flow_api.create_message (
  p_id=>196966004717154230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库验证';

wwv_flow_api.create_message (
  p_id=>196966120790154230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序使用 DAD 配置, 以便进行验证。如果 DAD 配置与帐户信息一起存储, 则 APP_USER 变量将设置为与 DAD 相关联的用户。如果 PUBLIC_USER 应用程序属性设置为与在 DAD 中存储的用户名相同的值, 则可以在应用程序条件, 安全方案求值和其他嵌入逻辑中将 APP_USER 变量与 PUBLIC_USER 属性进行有意义的比较。如果 DAD 并未与用户帐户信息一起存储, 则用户必须通过浏览器显示的对话框传递基本验证质询。此次验证之后, 引擎将 APP_USER 设置为由此质询捕获的名称。';

wwv_flow_api.create_message (
  p_id=>196966221101154230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未通过引擎向用户显示登录页。';

wwv_flow_api.create_message (
  p_id=>196966315750154230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_page_sentry_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页卫士函数';

wwv_flow_api.create_message (
  p_id=>196966422376154230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PAGE_SENTRY_FUNCTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_pg_sentry1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用内置逻辑来执行页卫士任务。对于每个页请求, 页卫士函数执行会话验证并计算返回值。';

wwv_flow_api.create_message (
  p_id=>196966516418154231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PG_SENTRY1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'会话验证函数';

wwv_flow_api.create_message (
  p_id=>196966605478154231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY_FUNCTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chk_cookie1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用内置逻辑, 检查名为 [%0] 的 cookie。如果此 cookie 存在并且其解码后的值位于内部会话表的行中, 则认为此会话有效。';

wwv_flow_api.create_message (
  p_id=>196966719114154231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHK_COOKIE1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用用户提供的附加代码来确定会话是否有效。上面的内置会话验证检查返回了“真”结果后, 执行以下代码并记住它的布尔返回值:';

wwv_flow_api.create_message (
  p_id=>196966830002154231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_compute_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'计算返回值';

wwv_flow_api.create_message (
  p_id=>196966902304154231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.COMPUTE_RETURN_VALUE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页卫士函数将内置会话验证检查的布尔值结果返回给引擎。如果结果为“真”, 引擎将继续显示或接受此页。如果结果为“假”, 引擎将重定向至此验证方案中指定的无效会话页或 URL (参见下文)。';

wwv_flow_api.create_message (
  p_id=>196967021975154231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页卫士函数将对内置会话验证检查的布尔值结果与用户提供的会话验证检查结果执行 AND 操作, 然后将结果返回给引擎。如果结果为“真”, 引擎将继续显示或接受此页。如果结果为“假”, 引擎将重定向至此验证方案中指定的无效会话目标 (参见下文)。';

wwv_flow_api.create_message (
  p_id=>196967119091154232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用定制逻辑来执行页卫士任务。对于每个页请求, 引擎将执行以下代码:';

wwv_flow_api.create_message (
  p_id=>196967218771154232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'以上块的布尔值结果将返回引擎。如果结果为“真”, 引擎将继续显示或接受此页。如果结果为“假”, 引擎将重定向至此验证方案中指定的无效会话目标 (参见下文)。';

wwv_flow_api.create_message (
  p_id=>196967306870154232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'会话验证的内置方法适用于使用 API 调用的 %0 开发者:';

wwv_flow_api.create_message (
  p_id=>196967423019154232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此布尔值函数结果可以与在验证方案中指定的用户提供的页卫士函数中的其他检查相结合。如果调用了此 API, 则它检查名为 %0 的 cookie';

wwv_flow_api.create_message (
  p_id=>196967508879154232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION6',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果此 cookie 存在, 并且其解码值位于内部会话表的行中, 则认为此会话有效, 而且将“真”值返回给调用它的页卫士函数。';

wwv_flow_api.create_message (
  p_id=>196967600486154232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION7',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_invalid_sess_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效会话目标';

wwv_flow_api.create_message (
  p_id=>196967701537154232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.INVALID_SESS_TARGET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果页卫士函数返回“真”, 则继续呈现页或处理页。如果结果为“假”, 则引擎将显示页 %0, 由于该页在此验证方案中指定为无效会话页, 因此将其视为此应用程序的登录页。';

wwv_flow_api.create_message (
  p_id=>196967814750154233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION8',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内置登录页';

wwv_flow_api.create_message (
  p_id=>196967932670154233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.BUILTIN_LOGIN_PG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On 服务器';

wwv_flow_api.create_message (
  p_id=>196968010275154233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SSO_SERVER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_the_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>196968121310154233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.THE_URL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页卫士函数将布尔值结果返回到引擎。如果结果为“真”, 则继续呈现页或处理页。如果结果为“假”, 则引擎将重定向到 %0。';

wwv_flow_api.create_message (
  p_id=>196968210470154233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION9',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action10
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果页卫士函数返回“真”, 则继续呈现页或处理页。如果结果为“假”, 引擎必须退出, 因为在验证方案中没有指定无效会话目标。在这种情况下, 假定用户提供的页卫士函数已重定向至 %0 环境以外的登录页, 可能重定向至外部验证 portal。此函数还应设置全局变量 g_unrecoverable_error := true 以指示引擎退出并且不显示错误页。';

wwv_flow_api.create_message (
  p_id=>196968306227154233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION10',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引擎将执行以下代码, 此代码已指定为此验证方案的验证前处理:';

wwv_flow_api.create_message (
  p_id=>196968403368154234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION11',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将作为不返回值的匿名块执行。';

wwv_flow_api.create_message (
  p_id=>196968512761154234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION12',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在此方案中未指定定制的验证前代码。';

wwv_flow_api.create_message (
  p_id=>196968621021154234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION13',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_credentials_verification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'身份证明验证 (验证)';

wwv_flow_api.create_message (
  p_id=>196968720072154234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CREDENTIALS_VERIFICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'任何输入到登录表单中的用户名/口令组合都将视为有效。输入的用户名将作为会话期间的登录用户的名称。此技术对于在建立任何实际用户帐户之前开发您的应用程序非常有用。';

wwv_flow_api.create_message (
  p_id=>196968801288154234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION14',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'针对应用程序构建器 (cookie 用户) 帐户检查输入登录表单的用户名和口令。在工作区中使用相同的帐户登录到 %0。当应用程序的用户是在相同数据库和工作区中拥有 %0 个帐户的开发者时, 此技术非常有用。';

wwv_flow_api.create_message (
  p_id=>196968922835154234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用此验证方案中指定的 LDAP 目录检查输入登录表单的用户名和口令。';

wwv_flow_api.create_message (
  p_id=>196969019634154234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION16',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 参数设置为:';

wwv_flow_api.create_message (
  p_id=>196969110177154235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION17',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 主机:';

wwv_flow_api.create_message (
  p_id=>196969207190154235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_HOST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 端口:';

wwv_flow_api.create_message (
  p_id=>196969314715154235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_PORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 搜索基础:';

wwv_flow_api.create_message (
  p_id=>196969431761154235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_DN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在调用 DBMS_LDAP.SIMPLE_BIND_S 之前使用下面的块来调用函数。在登录表单中捕获的用户名将传送到此函数, 然后使用函数返回的值来替换 LDAP 搜索基础中的 %LDAP_USER% (参见上文)。';

wwv_flow_api.create_message (
  p_id=>196969523909154235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此代码块必须有此签名:';

wwv_flow_api.create_message (
  p_id=>196969612915154235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用此功能可将登录表单中输入的用户名转换为与 LDAP 目录条目匹配的任意格式。';

wwv_flow_api.create_message (
  p_id=>196969722437154236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行以下用于验证身份证明的定制代码:';

wwv_flow_api.create_message (
  p_id=>196969825295154236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION18',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证后处理';

wwv_flow_api.create_message (
  p_id=>196969931641154236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.POST_AUTH_PROC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action19
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'检查内置登录页使用的会话的内置会话表。如果此会话已存在并且不为其他用户所拥有, 请立即将其标记为属于已验证的用户 (使用来自登录表单的用户名)。';

wwv_flow_api.create_message (
  p_id=>196970010709154236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION19',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action20
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将名为 %0 的 cookie 设置为这样的值: 该值用于在内部会话表中定位行。';

wwv_flow_api.create_message (
  p_id=>196970128846154236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION20',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'确定要重定向到下一个 URL 的 URL。如果 "深链接" 由呈现引擎记录在会话状态中, 则将此作为要转到的 URL。否则将转到指定作为应用程序主页链接属性的 URL。';

wwv_flow_api.create_message (
  p_id=>196970213850154237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION22',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_cust_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'定制验证后处理';

wwv_flow_api.create_message (
  p_id=>196970320286154237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CUST_POST_AUTH_PROC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action23
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证了身份证明以后, 引擎将执行以下指定为此验证方案的验证后处理的代码:';

wwv_flow_api.create_message (
  p_id=>196970404507154237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION23',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action24
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将作为不返回值的匿名块执行。';

wwv_flow_api.create_message (
  p_id=>196970516404154237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION24',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action25
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在此方案中尚未指定定制的验证后代码。';

wwv_flow_api.create_message (
  p_id=>196970615713154237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION25',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action26
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重定向至上面确定的 URL。这标志着使用内置登录页以及它所调用的 API 的登录处理的结束。';

wwv_flow_api.create_message (
  p_id=>196970707277154237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION26',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此页的典型方法是包含一个登录表单来捕获用户的身份证明。然后此页的提交后处理将调用验证模块来验证此身份证明。验证完成后, 此页将执行任何会话注册和 cookie 设置任务。最后, 它将重定向至应用程序的起始页。';

wwv_flow_api.create_message (
  p_id=>196970832015154237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 API: 此类提交后处理可以调用 wwv_flow_custom_auth_std 来执行刚才介绍的所有这些步骤。有两个可用的入口点:';

wwv_flow_api.create_message (
  p_id=>196970901424154238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'调用登录过程, 使引擎为您执行所有步骤。引擎将使用内置的会话表并为您执行会话注册和 cookie 设置。在验证方案中提供的所有定制代码都将在验证前, 验证过程中或验证后运行。';

wwv_flow_api.create_message (
  p_id=>196971019007154238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果您正在自己执行验证, 但希望 %0 为您处理所有的验证后事务, 请调用 post_login 过程。使用这两个入口点, 您可以使用任何内置登录处理步骤, 并结合使用自己的登录页以及在该页上运行的任何处理。请记住, 如果使用内置验证后处理, 还可以利用内置页卫士和会话验证处理。';

wwv_flow_api.create_message (
  p_id=>196971123120154238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'外部登录处理';

wwv_flow_api.create_message (
  p_id=>196971228666154238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此验证方案既不指定登录页也不指定用作无效会话目标的 URL。这意味着由页卫士函数处理这种情况。可能重定向到一次登入 portal, 也可能重定向到其他登录服务器。此外, 验证方案中不存在登录处理值。如果这不是您想要的结果, 请编辑此验证方案, 并提供无效会话页或 URL, 然后重新检查此图表视图。';

wwv_flow_api.create_message (
  p_id=>196971309750154238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此验证方案既不指定登录页也不指定用作为无效会话目标的 URL。这意味着由页卫士函数处理这种情况。可能重定向到一次登入 portal, 也可能重定向到其他登录服务器。但是, 验证方案中存在为登录处理设置的值, 如下所示:';

wwv_flow_api.create_message (
  p_id=>196971421678154238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'登录 URL %0 将 %1 应用程序页指定为无效会话目标。但是, 在验证方案中没有登录处理值。此页负责执行以下步骤:';

wwv_flow_api.create_message (
  p_id=>196971528740154239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'要使 %0 引擎能显示或接受应用程序中的登录页, 必须在应用程序构建器的“页属性”页上选择页属性 ''是 - 此页是公共的''。如果您未执行此操作, 则引擎将尝试在显示页之前执行页卫士函数。如果您尚未登录, 则尝试重定向到相同的 URL。这将造成恶性循环。如果您编写自己的页卫士函数代码, 则需要在当前页是此登录页时进行识别, 并以与其他页不同的方式来处理它。最好可以通过页码来标识它。更常用的方法是使用布尔值函数 wwv_flow_custom_auth.current_page_is_public 来识别应用程序中登录页或其他页的这个公共属性。';

wwv_flow_api.create_message (
  p_id=>196971603438154239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN6',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'登录 URL %0 将 %1 应用程序页指定为无效会话目标。此页负责执行以下步骤:';

wwv_flow_api.create_message (
  p_id=>196971701040154239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN7',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证方案中为登录处理设置的值如下所示:';

wwv_flow_api.create_message (
  p_id=>196971801897154239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN8',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在用户验证之后, Oracle Application Server Single Sign-On Server 将重定向回此应用程序。在 %0 方案中, 入口点是 wwv_flow_custom_auth_sso.process_success 过程。%0 注册为 Oracle Application Server Single Sign-On 合作伙伴应用程序, 并且可以管理登录服务器的所有接口。然而, 如果您喜欢在自己的方案中注册自己的应用程序, 也可以这样做。您既可以编写自己的页卫士, 也可以基于 Portal-SSO 方案, 从验证方案库简单创建一个验证方案 (我的应用程序作为合作伙伴应用程序)。所得方案将调用内置 SSO 页卫士 wwv_flow_custom_auth_std.portal_sso_sentry_v1。在向 Oracle Application Server ';

h:=h||'Single Sign-On 注册时, 此函数要求当前的验证方案知道合作伙伴应用程序的名称。“创建验证方案向导”将要求您提供合作伙伴应用程序的名称, 或可以在创建后, 通过编辑方案添加或更改名称。输入的名称必须与注册的名称完全相同 (注意大小写)。您还需要编写自己的 URLC 接收方过程, 并从中调用 wwv_flow_custom_auth_sso.process_success API, 从而在您向 Oracle Application Server Single Sign-On 注册应用程序时传递该应用程序的名称。此操作将在验证之后向 %0 执行会话注册。如果您编写自己的页卫士, 则可以调用 wwv_flow_custom_auth_sso.portal_sso_redirect API, 以便在页卫士确定需要进行验证时, 重定向到登录服务器。您必须将合作伙伴应用程序的注册名称传递到';

h:=h||'此过程。有关详细资料, 请参阅 %0 文档和 %1 文档。';

wwv_flow_api.create_message (
  p_id=>196971912333154239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN9',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'登录 URL %0 未将 %1 应用程序页指定为无效的会话目标。此外, 验证方案中不存在登录处理值。此页负责执行以下步骤:';

wwv_flow_api.create_message (
  p_id=>196972029903154239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN12',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请注意, 除非在此 URL 上调用的服务使用 %0 wwv_custom_auth_std API 来帮助您执行会话注册任务, 否则您的应用程序将无法使用内置页卫士或会话验证处理。您必须按照自己设计的方式来执行此操作。';

wwv_flow_api.create_message (
  p_id=>196972127350154239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN13',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_pre_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证前处理';

wwv_flow_api.create_message (
  p_id=>196972218594154240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_PRE_AUTH_PROC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证后处理';

wwv_flow_api.create_message (
  p_id=>196972302585154240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_POST_AUTH_PROC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'登录 URL %0 未将 %1 应用程序页指定为无效会话目标。此页负责执行以下步骤:';

wwv_flow_api.create_message (
  p_id=>196972431012154240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN14',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证方案中为登录处理设置的值如下所示:';

wwv_flow_api.create_message (
  p_id=>196972510609154240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN15',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此方案中指定的登录页是该应用程序中的页 [%0]。此页负责执行以下步骤:';

wwv_flow_api.create_message (
  p_id=>196972602789154240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN16',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'但是, 在验证方案中没有登录处理值。';

wwv_flow_api.create_message (
  p_id=>196972713592154240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN17',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'由于此页是应用程序的指定登录页, 因此当初次显示此页时不可能对其执行某些操作, 因为尚未进行用户验证。而且, 当某些会话状态和会话标识变量位于在验证后处理的普通页上时, 它们不可用于页计算或处理。由于这些原因, 在验证方案中按页码排列的登录页说明只适用于具有很少功能或没有功能的页 (除登录表单处理外)。如果您希望登录页的状态更加活跃, 请使用“验证方案向导”中的登录 URL 指定或编辑页。只要您记住使用构建器中的页属性表单将公共页属性设置为 ''是 - 此页是公共的'', 则页中的日志就能够使用除作为应用程序中登录页之外的所有 %0 功能。';

wwv_flow_api.create_message (
  p_id=>196972807837154241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN18',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p817_refresh_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'刷新验证方案时出错。';

wwv_flow_api.create_message (
  p_id=>196972914481154241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P817_REFRESH_AUTH_SCHEME_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'一次登入 (仅 Oracle 使用)';

wwv_flow_api.create_message (
  p_id=>196973029260154241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (%0 作为合作伙伴应用程序)';

wwv_flow_api.create_message (
  p_id=>196973118778154241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (我的应用程序作为合作伙伴应用程序)';

wwv_flow_api.create_message (
  p_id=>196973202660154241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内置登录页: 使用 %0 帐户身份证明';

wwv_flow_api.create_message (
  p_id=>196973301996154241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内置登录页: “开门”身份证明';

wwv_flow_api.create_message (
  p_id=>196973406628154242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内置登录页: 使用 LDAP 目录身份验证';

wwv_flow_api.create_message (
  p_id=>196973501931154242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'基于库中的验证方案';

wwv_flow_api.create_message (
  p_id=>196973620648154242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE7',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_obj_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法找到要复制的 %0 (%1)';

wwv_flow_api.create_message (
  p_id=>196973719993154242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.OBJ_NOT_FOUND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_cannot_find_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法确定指定工作区 ID = "%0"'||chr(10)||
'的安全组 ID';

wwv_flow_api.create_message (
  p_id=>196973801376154242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.CANNOT_FIND_SGID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_remove_last_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不能使用此设备删除工作区的最后一个方案';

wwv_flow_api.create_message (
  p_id=>196973918795154242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REMOVE_LAST_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_reserved_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法重设方案 %0 的口令';

wwv_flow_api.create_message (
  p_id=>196974019688154242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_RESERVED_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不允许重置与工作区不关联的方案的口令。%0';

wwv_flow_api.create_message (
  p_id=>196974131116154243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在工作区 %1 中不存在用户名 %0';

wwv_flow_api.create_message (
  p_id=>196974202813154243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_COMPANY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_page_dev_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'开发者没有在此页上创建组件的权限。';

wwv_flow_api.create_message (
  p_id=>196974322450154243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_PAGE_DEV_PRIV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未选择报表布局';

wwv_flow_api.create_message (
  p_id=>196974428797154243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LAYOUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未知的工作区名称';

wwv_flow_api.create_message (
  p_id=>196974506740154243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unhandled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'呈现引擎无法理解 WSDL 文档。单击“手动创建 Web 服务引用”可继续为此服务创建引用。';

wwv_flow_api.create_message (
  p_id=>196974616821154243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNHANDLED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_last_extended
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上次扩展的 API:';

wwv_flow_api.create_message (
  p_id=>196974708483154244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_LAST_EXTENDED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_current_flows_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前版本:';

wwv_flow_api.create_message (
  p_id=>196974813163154244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.CURRENT_FLOWS_VERSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_import_compatible_with_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此导入与以下版本兼容:';

wwv_flow_api.create_message (
  p_id=>196974925842154244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.IMPORT_COMPATIBLE_WITH_VERSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_missing_export_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您的应用程序导入未提供导出版本。';

wwv_flow_api.create_message (
  p_id=>196975016295154244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.MISSING_EXPORT_VERSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_engine_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法建立您的引擎版本。';

wwv_flow_api.create_message (
  p_id=>196975103823154244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_ENGINE_VERSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_api_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法建立您引擎的上一 API 版本。';

wwv_flow_api.create_message (
  p_id=>196975204969154244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_API_VERSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_upgrade_needed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您需要升级以导入此应用程序导出的内容。';

wwv_flow_api.create_message (
  p_id=>196975310172154245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UPGRADE_NEEDED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_invalid_credentials
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的用户名, 口令或工作区组合';

wwv_flow_api.create_message (
  p_id=>196975413510154245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.INVALID_CREDENTIALS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_user_not_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户 %0 需要 ADMIN 权限才能执行此操作。';

wwv_flow_api.create_message (
  p_id=>196975529260154245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.USER_NOT_ADMIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set_import
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须设置包变量 g_security_group_id 以导入应用程序。';

wwv_flow_api.create_message (
  p_id=>196975619758154245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET_IMPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在没有 p_id 值的情况下调用过程 %0 -- 必须提供应用程序 ID。';

wwv_flow_api.create_message (
  p_id=>196975720369154245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_MISSING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_not_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未删除应用程序 %0。将不尝试执行导入。';

wwv_flow_api.create_message (
  p_id=>196975811713154245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_NOT_DELETED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_templ_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建模板 (名称=%0) 时出错';

wwv_flow_api.create_message (
  p_id=>196975918262154246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TEMPL_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建构建选项 (名称=%0) 时出错';

wwv_flow_api.create_message (
  p_id=>196976015358154246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'设置构建选项 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196976122494154246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建导航栏 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196976202867154246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建导航栏项 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196976318725154246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_ITEM_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序处理 ID ="%0" 时出错';

wwv_flow_api.create_message (
  p_id=>196976402933154246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_PROCESS_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_process_sql_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'设置处理 SQL (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196976516849154247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PROCESS_SQL_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序项 ID="%0" 时出错';

wwv_flow_api.create_message (
  p_id=>196976630988154247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_ITEM_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序计算项="%0" 时出错';

wwv_flow_api.create_message (
  p_id=>196976704912154247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_COMPUTATION_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_std_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建标准选项卡 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196976810131154247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_STD_TAB_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_tabset_rename
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将选项卡集 %1 重命名为 %0 时出错';

wwv_flow_api.create_message (
  p_id=>196976928381154247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TABSET_RENAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_parent_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建父选项卡 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196977029247154247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PARENT_TAB_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lov_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建值列表 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196977119426154248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LOV_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建页 (名称="%0" ID="%1") 时出错';

wwv_flow_api.create_message (
  p_id=>196977205897154248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_help_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建页 %0 帮助文本时出错:';

wwv_flow_api.create_message (
  p_id=>196977331343154248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HELP_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_name_upd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新页 (名称="%0" ID="%1") 时出错';

wwv_flow_api.create_message (
  p_id=>196977407342154248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_NAME_UPD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_button_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建按钮 (名称="%0" ID="%1") 时出错';

wwv_flow_api.create_message (
  p_id=>196977505243154248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUTTON_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建分支 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196977611203154248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_args_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建分支参数 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196977728398154248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_ARGS_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误 (页=%0 项="%1" ID="%2")';

wwv_flow_api.create_message (
  p_id=>196977802386154249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ITEM_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建页计算 (页=%0 项="%1" ID="%2") 时出错';

wwv_flow_api.create_message (
  p_id=>196977914889154249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_COMPUTATION_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_validation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建页验证 (页=%0 名称="%1") 时出错';

wwv_flow_api.create_message (
  p_id=>196978013750154249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_VALIDATION_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建页处理 (页=%0 名称="%1") 时出错';

wwv_flow_api.create_message (
  p_id=>196978129177154249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_PROCESS_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lang_map_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序翻译映射时出错';

wwv_flow_api.create_message (
  p_id=>196978209391154249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LANG_MAP_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_on_table_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建关于表 "%0" 的页';

wwv_flow_api.create_message (
  p_id=>196978325702154249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ON_TABLE_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表类型无效';

wwv_flow_api.create_message (
  p_id=>196978409195154250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INVALID_REPORT_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表页 %0 已存在, 报表区域已添加。';

wwv_flow_api.create_message (
  p_id=>196978517372154250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_has_buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 %0 已具有按钮。';

wwv_flow_api.create_message (
  p_id=>196978625463154250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HAS_BUTTONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_form_added_to_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单已添加到现有页 %0。';

wwv_flow_api.create_message (
  p_id=>196978715508154250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FORM_ADDED_TO_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未创建页 %0, 因为它已存在。';

wwv_flow_api.create_message (
  p_id=>196978816333154250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_bug_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建 Bug (id="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196978911859154250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUG_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_shortcut_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建快捷方式 (ID="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196979030589154251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_SHORTCUT_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_auth_scheme_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建验证方案 (名称="%0") 时出错';

wwv_flow_api.create_message (
  p_id=>196979119159154251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_AUTH_SCHEME_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须设置包变量 g_security_group_id。';

wwv_flow_api.create_message (
  p_id=>196979228335154251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序 ID %0 是为 Oracle Corporation 保留的 ';

wwv_flow_api.create_message (
  p_id=>196979316004154251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_RESERVED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_runtime_incompatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'API 操作包含与当前运行时不兼容的调用。';

wwv_flow_api.create_message (
  p_id=>196979406366154251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_RUNTIME_INCOMPATIBLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'兼容 (应该能够顺利地运行此导入。)';

wwv_flow_api.create_message (
  p_id=>196979501075154251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.COMPATIBLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_not_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不兼容 (导出内容可能包含您的 %0 版本不支持的调用。)';

wwv_flow_api.create_message (
  p_id=>196979609633154252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.NOT_COMPATIBLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline_plus_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内嵌+通知';

wwv_flow_api.create_message (
  p_id=>196979726167154252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE_PLUS_NOTIFICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内嵌';

wwv_flow_api.create_message (
  p_id=>196979812138154252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'通知';

wwv_flow_api.create_message (
  p_id=>196979917895154252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_error_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误页';

wwv_flow_api.create_message (
  p_id=>196980031604154252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ERROR_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_location
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'位置';

wwv_flow_api.create_message (
  p_id=>196980124664154252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOCATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_above_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'框以上';

wwv_flow_api.create_message (
  p_id=>196980226712154252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.ABOVE_BOX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_below_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'框以下';

wwv_flow_api.create_message (
  p_id=>196980314857154253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BELOW_BOX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'底部';

wwv_flow_api.create_message (
  p_id=>196980401291154253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BOTTOM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更改模板';

wwv_flow_api.create_message (
  p_id=>196980529871154253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CHANGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关闭模板';

wwv_flow_api.create_message (
  p_id=>196980601067154253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CLOSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制模板';

wwv_flow_api.create_message (
  p_id=>196980724931154253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_COPY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建模板';

wwv_flow_api.create_message (
  p_id=>196980826597154253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除模板';

wwv_flow_api.create_message (
  p_id=>196980930429154254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_DELETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑模板';

wwv_flow_api.create_message (
  p_id=>196981026847154254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'展开模板';

wwv_flow_api.create_message (
  p_id=>196981116012154254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EXPAND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下一个模板';

wwv_flow_api.create_message (
  p_id=>196981220200154254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_NEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上一个模板';

wwv_flow_api.create_message (
  p_id=>196981307323154254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_PREVIOUS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'顶部';

wwv_flow_api.create_message (
  p_id=>196981417497154254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.TOP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支到页接受';

wwv_flow_api.create_message (
  p_id=>196981524138154255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_ACCEPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支到由项标识的页';

wwv_flow_api.create_message (
  p_id=>196981611632154255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_IDENTIFIED_BY_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_url_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支到由项标识的 URL';

wwv_flow_api.create_message (
  p_id=>196981701839154255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_URL_IDENTIFIED_BY_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支到返回页的函数';

wwv_flow_api.create_message (
  p_id=>196981819214154255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支到返回 URL 的函数';

wwv_flow_api.create_message (
  p_id=>196981914632154255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_URL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支到 PL/SQL 过程';

wwv_flow_api.create_message (
  p_id=>196982031896154255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PLSQL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无';

wwv_flow_api.create_message (
  p_id=>196982107215154255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_unconditional
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无条件';

wwv_flow_api.create_message (
  p_id=>196982224306154256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_UNCONDITIONAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_standard_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标准条件';

wwv_flow_api.create_message (
  p_id=>196982310836154256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STANDARD_CONDITION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从不';

wwv_flow_api.create_message (
  p_id=>196982424264154256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NEVER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4656_default_calendar_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认日历模板';

wwv_flow_api.create_message (
  p_id=>196982502426154256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4656.DEFAULT_CALENDAR_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日历';

wwv_flow_api.create_message (
  p_id=>196982610915154256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_no_ddl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到生成 DDL 的 %0。';

wwv_flow_api.create_message (
  p_id=>196982730651154257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.NO_DDL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit_report_err_updating_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新报表列时出错: %0';

wwv_flow_api.create_message (
  p_id=>196982821887154257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_EDIT_REPORT.ERR_UPDATING_COLS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace_colon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未知的工作区名称: %0';

wwv_flow_api.create_message (
  p_id=>196982904212154257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_migrate_svg_to_flash_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将 SVG 图表移植到 Flash 图表时出错。%0';

wwv_flow_api.create_message (
  p_id=>196983031958154257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MIGRATE_SVG_TO_FLASH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_to_flash
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求将 SVG 图表移植到 Flash 图表。请确认您的请求。';

wwv_flow_api.create_message (
  p_id=>196983110087154257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_TO_FLASH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未成功执行语句。 %0'||chr(10)||
'<pre>%1</pre>';

wwv_flow_api.create_message (
  p_id=>196983230050154257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.RUN_STMT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'GET_STMT 错误。 %0';

wwv_flow_api.create_message (
  p_id=>196983329825154258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_STMT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'GET_BLOCK 错误。 %0';

wwv_flow_api.create_message (
  p_id=>196983428674154258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_BLOCK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_file_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法找到文件。 %0';

wwv_flow_api.create_message (
  p_id=>196983507704154258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_FILE_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_date_picker
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日期选取器';

wwv_flow_api.create_message (
  p_id=>196983617542154258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DATE_PICKER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'隐藏';

wwv_flow_api.create_message (
  p_id=>196983710436154258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.HIDDEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_file_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'文件浏览';

wwv_flow_api.create_message (
  p_id=>196983810828154258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.FILE_BROWSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_stop_and_start_html_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'停止和启动表';

wwv_flow_api.create_message (
  p_id=>196983917186154259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.STOP_AND_START_HTML_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_list_manager
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列表管理器';

wwv_flow_api.create_message (
  p_id=>196984012026154259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.LIST_MANAGER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_check_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复选框';

wwv_flow_api.create_message (
  p_id=>196984106425154259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.CHECK_BOX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_display_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'仅显示';

wwv_flow_api.create_message (
  p_id=>196984216819154259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DISPLAY_ONLY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_multiple_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'多选';

wwv_flow_api.create_message (
  p_id=>196984309607154259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.MULTIPLE_SELECT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_popup_list_of_values
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'弹出式值列表';

wwv_flow_api.create_message (
  p_id=>196984415769154259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.POPUP_LIST_OF_VALUES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_radio
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'单选';

wwv_flow_api.create_message (
  p_id=>196984510833154260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.RADIO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选择列表';

wwv_flow_api.create_message (
  p_id=>196984604221154260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SELECT_LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'文本';

wwv_flow_api.create_message (
  p_id=>196984724148154260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text_area
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'文本区域';

wwv_flow_api.create_message (
  p_id=>196984831502154260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT_AREA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_shuttle
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'往返';

wwv_flow_api.create_message (
  p_id=>196984919885154260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SHUTTLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copy_list_entry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制列表条目';

wwv_flow_api.create_message (
  p_id=>196985001505154261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPY_LIST_ENTRY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有 %0 方案的权限。';

wwv_flow_api.create_message (
  p_id=>196985111329154261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_PRIV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_images_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到图像';

wwv_flow_api.create_message (
  p_id=>196985213096154261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_IMAGES_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未授权访问 (未设置安全组包变量)。';

wwv_flow_api.create_message (
  p_id=>196985317309154261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_SGID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_user_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户组已存在, 因此未创建。';

wwv_flow_api.create_message (
  p_id=>196985416118154261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_USER_GROUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区已存在, 因此未创建。';

wwv_flow_api.create_message (
  p_id=>196985501156154261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_COMPANY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'由于以下原因而未创建用户: %0';

wwv_flow_api.create_message (
  p_id=>196985630816154262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_FND_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_user_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户 %0 不存在。';

wwv_flow_api.create_message (
  p_id=>196985727066154262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_USER_EXIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户 %0 未提供电子邮件地址。';

wwv_flow_api.create_message (
  p_id=>196985829660154262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_EMAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_fetch_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法提取 fnd 用户信息。 %0';

wwv_flow_api.create_message (
  p_id=>196985905365154262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.FETCH_FND_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'通知消息校验和格式错误: %0';

wwv_flow_api.create_message (
  p_id=>196986007080154262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'通知消息校验和内容错误: %0: %1';

wwv_flow_api.create_message (
  p_id=>196986112289154262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打印成功消息校验和格式错误: %0';

wwv_flow_api.create_message (
  p_id=>196986201320154263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打印成功消息校验和内容错误: %0 : %1';

wwv_flow_api.create_message (
  p_id=>196986329545154263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已创建 %0 演示应用程序。';

wwv_flow_api.create_message (
  p_id=>196986400630154263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有足够空间, 无法创建此演示。通过转至管理页并单击 "请求更改当前服务" 链接可以请求额外的存储。';

wwv_flow_api.create_message (
  p_id=>196986504434154263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4150_column_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列 %0';

wwv_flow_api.create_message (
  p_id=>196986613717154263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4150_COLUMN_NUMBER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message cached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已高速缓存';

wwv_flow_api.create_message (
  p_id=>196986730280154263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'有效';

wwv_flow_api.create_message (
  p_id=>196986801809154264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'失效';

wwv_flow_api.create_message (
  p_id=>196986911048154264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXPIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'启用';

wwv_flow_api.create_message (
  p_id=>196987023530154264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ENABLED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'突出显示类型';

wwv_flow_api.create_message (
  p_id=>196987129296154264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cell
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'单元';

wwv_flow_api.create_message (
  p_id=>196987220251154264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CELL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_bgcolor
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'背景色';

wwv_flow_api.create_message (
  p_id=>196987320634154265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BGCOLOR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yellow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'黄色';

wwv_flow_api.create_message (
  p_id=>196987406438154265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YELLOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_green
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'绿色';

wwv_flow_api.create_message (
  p_id=>196987523119154265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_GREEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_orange
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'橙色';

wwv_flow_api.create_message (
  p_id=>196987617504154265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ORANGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_text_color
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'文本颜色';

wwv_flow_api.create_message (
  p_id=>196987713459154265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TEXT_COLOR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_when
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'突出显示, 当';

wwv_flow_api.create_message (
  p_id=>196987824307154265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_WHEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类似';

wwv_flow_api.create_message (
  p_id=>196987931292154266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_LIKE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不类似';

wwv_flow_api.create_message (
  p_id=>196988007134154266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_LIKE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'为空值';

wwv_flow_api.create_message (
  p_id=>196988101870154266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不为空值';

wwv_flow_api.create_message (
  p_id=>196988221066154266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NOT_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在';

wwv_flow_api.create_message (
  p_id=>196988319989154266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不在';

wwv_flow_api.create_message (
  p_id=>196988405908154267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_IN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'保存';

wwv_flow_api.create_message (
  p_id=>196988508981154267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_ascending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'升序';

wwv_flow_api.create_message (
  p_id=>196988622114154267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ASCENDING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_descending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'降序';

wwv_flow_api.create_message (
  p_id=>196988711295154267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCENDING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 选择类别 -';

wwv_flow_api.create_message (
  p_id=>196988827535154267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_CATEGORY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>196988909274154267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'序列';

wwv_flow_api.create_message (
  p_id=>196989019423154268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SEQUENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是';

wwv_flow_api.create_message (
  p_id=>196989116666154268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'否';

wwv_flow_api.create_message (
  p_id=>196989231923154268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行';

wwv_flow_api.create_message (
  p_id=>196989302134154268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_blue
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'蓝色';

wwv_flow_api.create_message (
  p_id=>196989420537154268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BLUE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_red
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'红色';

wwv_flow_api.create_message (
  p_id=>196989506564154269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示';

wwv_flow_api.create_message (
  p_id=>196989621447154269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'其他';

wwv_flow_api.create_message (
  p_id=>196989712481154269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_OTHER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'值';

wwv_flow_api.create_message (
  p_id=>196989802410154269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VALUE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列';

wwv_flow_api.create_message (
  p_id=>196989913520154269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'取消';

wwv_flow_api.create_message (
  p_id=>196990000581154269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CANCEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>196990125682154270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 选择列 -';

wwv_flow_api.create_message (
  p_id=>196990218907154270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序安装程序检测到以前安装了此应用程序的支持对象。此向导将引导您完成升级这些支持对象的过程。';

wwv_flow_api.create_message (
  p_id=>196990323558154270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message caching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'高速缓存';

wwv_flow_api.create_message (
  p_id=>196990423136154270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支=';

wwv_flow_api.create_message (
  p_id=>196990511352154270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.BRANCH=',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_menu_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑条目=';

wwv_flow_api.create_message (
  p_id=>196990606289154270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.MENU_OPTION=',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您的应用程序的支持对象已升级。';

wwv_flow_api.create_message (
  p_id=>196990715390154271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_SUCCESS_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'升级此应用程序的支持对象失败。';

wwv_flow_api.create_message (
  p_id=>196990810709154271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_FAILURE_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_confirm_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请确认您要升级此应用程序的支持对象。';

wwv_flow_api.create_message (
  p_id=>196990910456154271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_CONFIRM_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message yes_by_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是, 按用户';

wwv_flow_api.create_message (
  p_id=>196991027027154271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YES_BY_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message set_binds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'测试查询时必须设置所有绑定变量的值。';

wwv_flow_api.create_message (
  p_id=>196991131672154271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SET_BINDS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新建的登录页: 使用 LDAP 目录身份证明';

wwv_flow_api.create_message (
  p_id=>196991225335154271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6A',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'现有登录页: 使用 LDAP 目录身份证明';

wwv_flow_api.create_message (
  p_id=>196991314345154272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6B',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新建的登录页: 使用 %0 帐户身份证明';

wwv_flow_api.create_message (
  p_id=>196991404768154272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4A',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'现有登录页: 使用 %0 帐户身份证明';

wwv_flow_api.create_message (
  p_id=>196991519167154272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4B',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_flash_chart_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Flash 图表错误: %0';

wwv_flow_api.create_message (
  p_id=>196991624565154272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.FLASH_CHART_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message report_queries_valid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查询有效。已对绑定变量进行语法分析。';

wwv_flow_api.create_message (
  p_id=>196991703342154272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REPORT_QUERIES.VALID_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未选择页。';

wwv_flow_api.create_message (
  p_id=>196991818447154272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页';

wwv_flow_api.create_message (
  p_id=>196991910206154273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建';

wwv_flow_api.create_message (
  p_id=>196992011375154273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CREATE_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑';

wwv_flow_api.create_message (
  p_id=>196992104595154273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EDIT_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_copy_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制';

wwv_flow_api.create_message (
  p_id=>196992211782154273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COPY_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_view_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查看';

wwv_flow_api.create_message (
  p_id=>196992321857154273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VIEW_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页未找到。';

wwv_flow_api.create_message (
  p_id=>196992400313154273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>196992512522154274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标题';

wwv_flow_api.create_message (
  p_id=>196992618911154274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'别名';

wwv_flow_api.create_message (
  p_id=>196992715824154274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ALIAS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模板';

wwv_flow_api.create_message (
  p_id=>196992824174154274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_invalid_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的模板';

wwv_flow_api.create_message (
  p_id=>196992924775154274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INVALID_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标准选项卡集';

wwv_flow_api.create_message (
  p_id=>196993024535154274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TABSET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authorization
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'授权';

wwv_flow_api.create_message (
  p_id=>196993116360154275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHORIZATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'构建选项';

wwv_flow_api.create_message (
  p_id=>196993228601154275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BUILD_OPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证';

wwv_flow_api.create_message (
  p_id=>196993304281154275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHENTICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'公共';

wwv_flow_api.create_message (
  p_id=>196993402297154275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_PUBLIC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必需';

wwv_flow_api.create_message (
  p_id=>196993508348154275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_REQUIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域';

wwv_flow_api.create_message (
  p_id=>196993609952154275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display_pt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示点:&nbsp;';

wwv_flow_api.create_message (
  p_id=>196993720298154275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY_PT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有区域。';

wwv_flow_api.create_message (
  p_id=>196993803402154276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'按钮';

wwv_flow_api.create_message (
  p_id=>196993907723154276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项';

wwv_flow_api.create_message (
  p_id=>196994014481154276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'计算';

wwv_flow_api.create_message (
  p_id=>196994118586154276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'第 0 页不支持计算。应由应用程序级计算处理每页上发生的计算。';

wwv_flow_api.create_message (
  p_id=>196994220022154276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'第 0 页不支持处理。应在应用程序级别上执行每页上发生的处理。';

wwv_flow_api.create_message (
  p_id=>196994324706154276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有“加载时”计算。';

wwv_flow_api.create_message (
  p_id=>196994426481154277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_COMPUTATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'处理';

wwv_flow_api.create_message (
  p_id=>196994530680154277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有“加载时”处理。';

wwv_flow_api.create_message (
  p_id=>196994619770154277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_zero_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'第 0 页不支持分支, 计算, 处理或验证。应在应用程序级别上执行每页上发生的计算和处理。';

wwv_flow_api.create_message (
  p_id=>196994717108154277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ZERO_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有“提交时”计算。';

wwv_flow_api.create_message (
  p_id=>196994818787154277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_COMPUTATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证';

wwv_flow_api.create_message (
  p_id=>196994910241154277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有验证。';

wwv_flow_api.create_message (
  p_id=>196995006867154278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有“提交时”处理。';

wwv_flow_api.create_message (
  p_id=>196995112919154278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分支';

wwv_flow_api.create_message (
  p_id=>196995229462154278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCHING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有分支。';

wwv_flow_api.create_message (
  p_id=>196995308157154278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BRANCHING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父选项卡';

wwv_flow_api.create_message (
  p_id=>196995414760154278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PARENT_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有父级选项卡';

wwv_flow_api.create_message (
  p_id=>196995507938154278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PARENT_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标准选项卡';

wwv_flow_api.create_message (
  p_id=>196995613778154278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STD_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡集';

wwv_flow_api.create_message (
  p_id=>196995705431154279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 %0 没有选项卡集。';

wwv_flow_api.create_message (
  p_id=>196995816883154279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航栏';

wwv_flow_api.create_message (
  p_id=>196995914245154279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAV_BAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序 "%0" 没有导航栏。';

wwv_flow_api.create_message (
  p_id=>196996023427154279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_NAV_BAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message region_templates_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无模板';

wwv_flow_api.create_message (
  p_id=>196996117243154279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGION_TEMPLATES_NO_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未选择页。';

wwv_flow_api.create_message (
  p_id=>196996220789154279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无区域';

wwv_flow_api.create_message (
  p_id=>196996329129154280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无计算';

wwv_flow_api.create_message (
  p_id=>196996403334154280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_COMPUTATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无处理';

wwv_flow_api.create_message (
  p_id=>196996516598154280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未验证';

wwv_flow_api.create_message (
  p_id=>196996604634154280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无分支';

wwv_flow_api.create_message (
  p_id=>196996705352154280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_BRANCHING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'警告';

wwv_flow_api.create_message (
  p_id=>196996820147154280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_WARNING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建区域';

wwv_flow_api.create_message (
  p_id=>196996928778154281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建处理';

wwv_flow_api.create_message (
  p_id=>196997026794154281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建计算';

wwv_flow_api.create_message (
  p_id=>196997118350154281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPUTATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建验证';

wwv_flow_api.create_message (
  p_id=>196997216172154281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建分支';

wwv_flow_api.create_message (
  p_id=>196997310575154281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BRANCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建区域';

wwv_flow_api.create_message (
  p_id=>196997403762154281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建计算';

wwv_flow_api.create_message (
  p_id=>196997523121154282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_COMPUTATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建处理';

wwv_flow_api.create_message (
  p_id=>196997601126154282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建验证';

wwv_flow_api.create_message (
  p_id=>196997729361154282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建分支';

wwv_flow_api.create_message (
  p_id=>196997811378154282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BRANCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您的 %0 口令已更改。';

wwv_flow_api.create_message (
  p_id=>196997918990154282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_CHANGED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message email_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未找到电子邮件地址 "%0"。';

wwv_flow_api.create_message (
  p_id=>196998004853154282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EMAIL_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message change_pw_request
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 请求';

wwv_flow_api.create_message (
  p_id=>196998128262154282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHANGE_PW_REQUEST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关闭';

wwv_flow_api.create_message (
  p_id=>196998214728154283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ARROW_DOWN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建按钮';

wwv_flow_api.create_message (
  p_id=>196998315013154283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建项';

wwv_flow_api.create_message (
  p_id=>196998415260154283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域标题';

wwv_flow_api.create_message (
  p_id=>196998520207154283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建按钮';

wwv_flow_api.create_message (
  p_id=>196998612828154283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑按钮';

wwv_flow_api.create_message (
  p_id=>196998724374154283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建项';

wwv_flow_api.create_message (
  p_id=>196998811029154284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑按钮项';

wwv_flow_api.create_message (
  p_id=>196998929875154284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑项';

wwv_flow_api.create_message (
  p_id=>196999027726154284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_on_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区 %0 没有作为方案 %1 进行语法分析的权限。';

wwv_flow_api.create_message (
  p_id=>196999104828154284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ON_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button_w_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不带区域的按钮';

wwv_flow_api.create_message (
  p_id=>196999218461154284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON_W_NO_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有按钮。';

wwv_flow_api.create_message (
  p_id=>196999303703154284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BUTTON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 "%0" 没有项。';

wwv_flow_api.create_message (
  p_id=>196999406620154285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item_exceeds_max
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项计数超过最大值 100。';

wwv_flow_api.create_message (
  p_id=>196999506314154285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM_EXCEEDS_MAX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域标题';

wwv_flow_api.create_message (
  p_id=>196999607107154285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑';

wwv_flow_api.create_message (
  p_id=>196999722817154285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_reset_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令重设通知';

wwv_flow_api.create_message (
  p_id=>196999816920154285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_RESET_NOTIFICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'展开';

wwv_flow_api.create_message (
  p_id=>196999916804154285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EXPAND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_has_been_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已创建您的 %0 帐户。';

wwv_flow_api.create_message (
  p_id=>197000012275154286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_HAS_BEEN_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_login_instructions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可以通过转到以下位置来登录到 %0:';

wwv_flow_api.create_message (
  p_id=>197000123214154286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_LOGIN_INSTRUCTIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建';

wwv_flow_api.create_message (
  p_id=>197000216393154286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新 %0 帐户通知';

wwv_flow_api.create_message (
  p_id=>197000329664154286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_NOTIFICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建';

wwv_flow_api.create_message (
  p_id=>197000404158154286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关闭';

wwv_flow_api.create_message (
  p_id=>197000513424154286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CLOSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域正文';

wwv_flow_api.create_message (
  p_id=>197000604321154287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打开表单';

wwv_flow_api.create_message (
  p_id=>197000720189154287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_OPEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关闭表单';

wwv_flow_api.create_message (
  p_id=>197000822763154287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_CLOSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'帮助';

wwv_flow_api.create_message (
  p_id=>197000926765154287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>197001032415154287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_DELETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制';

wwv_flow_api.create_message (
  p_id=>197001126916154287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COPY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下一页';

wwv_flow_api.create_message (
  p_id=>197001200068154287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上一页';

wwv_flow_api.create_message (
  p_id=>197001311957154288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PREVIOUS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更改';

wwv_flow_api.create_message (
  p_id=>197001429445154288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CHANGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模板';

wwv_flow_api.create_message (
  p_id=>197001525373154288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主题';

wwv_flow_api.create_message (
  p_id=>197001617946154288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEMES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航栏';

wwv_flow_api.create_message (
  p_id=>197001713347154288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NAV_BAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'通知';

wwv_flow_api.create_message (
  p_id=>197001832444154288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NOTIFICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_global_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'全局通知';

wwv_flow_api.create_message (
  p_id=>197001919252154289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_GLOBAL_NOTIFICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_template_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模板正文';

wwv_flow_api.create_message (
  p_id=>197002030106154289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TEMPLATE_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'成功消息';

wwv_flow_api.create_message (
  p_id=>197002125303154289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_SUCCESS_MSG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标题';

wwv_flow_api.create_message (
  p_id=>197002224774154289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正文标题';

wwv_flow_api.create_message (
  p_id=>197002303884154289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BODY_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_position
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置';

wwv_flow_api.create_message (
  p_id=>197002425940154289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_POSITION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡';

wwv_flow_api.create_message (
  p_id=>197002503089154290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_STD_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父选项卡';

wwv_flow_api.create_message (
  p_id=>197002606693154290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PARENT_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_application_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序选项卡';

wwv_flow_api.create_message (
  p_id=>197002730403154290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_APPLICATION_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_company_img
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区图像';

wwv_flow_api.create_message (
  p_id=>197002824969154290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPANY_IMG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是';

wwv_flow_api.create_message (
  p_id=>197002904626154290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_YES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'否';

wwv_flow_api.create_message (
  p_id=>197003022986154290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_header_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页眉模板';

wwv_flow_api.create_message (
  p_id=>197003125479154291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_HEADER_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主体';

wwv_flow_api.create_message (
  p_id=>197003227829154291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_footer_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页脚模板';

wwv_flow_api.create_message (
  p_id=>197003327918154291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FOOTER_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_substitution
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'替换';

wwv_flow_api.create_message (
  p_id=>197003419648154291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUBSTITUTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用的';

wwv_flow_api.create_message (
  p_id=>197003520984154291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REFERENCED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从';

wwv_flow_api.create_message (
  p_id=>197003600605154291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FROM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'说明';

wwv_flow_api.create_message (
  p_id=>197003710101154291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DESCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_onload
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'加载页时';

wwv_flow_api.create_message (
  p_id=>197003807833154292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ONLOAD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页标题';

wwv_flow_api.create_message (
  p_id=>197003922495154292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_head
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页首';

wwv_flow_api.create_message (
  p_id=>197004018459154292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_HEAD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打开 HTML 表单';

wwv_flow_api.create_message (
  p_id=>197004111620154292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_OPEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'通知消息';

wwv_flow_api.create_message (
  p_id=>197004213849154292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION_MSG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'成功消息';

wwv_flow_api.create_message (
  p_id=>197004307150154292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUCCESS_MSG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页正文';

wwv_flow_api.create_message (
  p_id=>197004422759154293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页正文标题';

wwv_flow_api.create_message (
  p_id=>197004502918154293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关闭 HTML 表单';

wwv_flow_api.create_message (
  p_id=>197004631265154293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_CLOSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置 1';

wwv_flow_api.create_message (
  p_id=>197004700665154293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置 2';

wwv_flow_api.create_message (
  p_id=>197004805799154293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置 3';

wwv_flow_api.create_message (
  p_id=>197004930831154293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置 4';

wwv_flow_api.create_message (
  p_id=>197005010975154294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置 5';

wwv_flow_api.create_message (
  p_id=>197005103124154294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置 6';

wwv_flow_api.create_message (
  p_id=>197005211770154294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS6',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置 7';

wwv_flow_api.create_message (
  p_id=>197005318203154294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS7',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域位置 8';

wwv_flow_api.create_message (
  p_id=>197005406964154294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS8',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_detail_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'详细资料视图';

wwv_flow_api.create_message (
  p_id=>197005508270154294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_DETAIL_VIEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'操作';

wwv_flow_api.create_message (
  p_id=>197005614402154295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ACTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'条件';

wwv_flow_api.create_message (
  p_id=>197005706691154295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CONDITION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'exp';

wwv_flow_api.create_message (
  p_id=>197005822118154295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EXP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示';

wwv_flow_api.create_message (
  p_id=>197005916972154295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'按钮';

wwv_flow_api.create_message (
  p_id=>197006010224154295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'转到页';

wwv_flow_api.create_message (
  p_id=>197006130752154295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_redirect_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'转到页';

wwv_flow_api.create_message (
  p_id=>197006232263154295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REDIRECT_TO_PG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_navigate_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航到页';

wwv_flow_api.create_message (
  p_id=>197006327466154296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAVIGATE_TO_PG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message views2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'视图';

wwv_flow_api.create_message (
  p_id=>197006427412154296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEWS2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证';

wwv_flow_api.create_message (
  p_id=>197006506788154296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'处理';

wwv_flow_api.create_message (
  p_id=>197006627685154296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'计算';

wwv_flow_api.create_message (
  p_id=>197006701326154296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'按 %0 统计的图表';

wwv_flow_api.create_message (
  p_id=>197006828708154296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_CHART_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'按 %0';

wwv_flow_api.create_message (
  p_id=>197006905078154297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域';

wwv_flow_api.create_message (
  p_id=>197007026035154297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主题';

wwv_flow_api.create_message (
  p_id=>197007117166154297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序';

wwv_flow_api.create_message (
  p_id=>197007230988154297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_FLOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(已过时)';

wwv_flow_api.create_message (
  p_id=>197007310541154297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_DEPRECATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_convert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 验证是过时的方法。我们建议您在此应用程序中的一个验证方案上单击 "设为当前" 链接 (如上所示), 或创建新的验证方案并将其设为当前的验证方案。INTERNAL-SETUP 验证方案在功能上等同于 %0 方法。';

wwv_flow_api.create_message (
  p_id=>197007426936154297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_CONVERT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑过时的验证属性';

wwv_flow_api.create_message (
  p_id=>197007521189154298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'过时的属性';

wwv_flow_api.create_message (
  p_id=>197007626743154298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'或准备将验证方法更改为 %0 之前将它们保持不变。';

wwv_flow_api.create_message (
  p_id=>197007731472154298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复查或编辑会话管理属性';

wwv_flow_api.create_message (
  p_id=>197007826038154298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用验证方案来控制应用程序的用户验证和会话管理的其他所有方面。';

wwv_flow_api.create_message (
  p_id=>197007909168154298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_DESC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'指定了一个或多个过时的验证属性。';

wwv_flow_api.create_message (
  p_id=>197008030045154298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复查或编辑这些';

wwv_flow_api.create_message (
  p_id=>197008122732154299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW6',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'或将它们移植到验证方案。';

wwv_flow_api.create_message (
  p_id=>197008226077154299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message month
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'月';

wwv_flow_api.create_message (
  p_id=>197008316238154299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'版本';

wwv_flow_api.create_message (
  p_id=>197008428877154299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_VERSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_dbname
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库名';

wwv_flow_api.create_message (
  p_id=>197008523798154299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_DBNAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_linked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已链接';

wwv_flow_api.create_message (
  p_id=>197008631601154299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_LINKED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_as_app_on_exist_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'作为数据库表上的应用程序';

wwv_flow_api.create_message (
  p_id=>197008728152154300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_AS_APP_ON_EXIST_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_show_xml
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示 XML';

wwv_flow_api.create_message (
  p_id=>197008802556154300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.SHOW_XML',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_query_headings
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法确定查询标题:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>197008910915154300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_QUERY_HEADINGS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_pagination
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'确定页码字符串时出错';

wwv_flow_api.create_message (
  p_id=>197009030457154300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_PAGINATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_report_footer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行报表页脚替换时出错';

wwv_flow_api.create_message (
  p_id=>197009109598154300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_REPORT_FOOTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_proc_function_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法处理返回查询的函数体:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>197009215503154300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_PROC_FUNCTION_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_failed_parsing_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法对 SQL 查询进行语法分析:'||chr(10)||
'%0'||chr(10)||
'%1';

wwv_flow_api.create_message (
  p_id=>197009327588154301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FAILED_PARSING_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表错误:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>197009414249154301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.REPORT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_invalid_lov_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'弹出式值列表查询无效, 需要显示值和返回值, 列名不能相同';

wwv_flow_api.create_message (
  p_id=>197009532164154301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INVALID_LOV_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_new_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 新类别 -';

wwv_flow_api.create_message (
  p_id=>197009621797154301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEW_CATEGORY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_no_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(不可编辑)';

wwv_flow_api.create_message (
  p_id=>197009727143154301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_NO_EDIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前';

wwv_flow_api.create_message (
  p_id=>197009808082154301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_CURRENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建 Flash 图表。 %0';

wwv_flow_api.create_message (
  p_id=>197009909403154302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FLASH_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效';

wwv_flow_api.create_message (
  p_id=>197010014377154302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_included
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'包括';

wwv_flow_api.create_message (
  p_id=>197010124330154302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INCLUDED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_databases
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库';

wwv_flow_api.create_message (
  p_id=>197010230728154302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_DATABASES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_lov_no_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 无方案 -';

wwv_flow_api.create_message (
  p_id=>197010304643154302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_LOV_NO_SCHEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message initcap_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'刷新';

wwv_flow_api.create_message (
  p_id=>197010422230154302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INITCAP_REFRESH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message y
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Y';

wwv_flow_api.create_message (
  p_id=>197010522498154303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'Y',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_schema_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序的语法分析方案 "%0" 在数据库中不存在。';

wwv_flow_api.create_message (
  p_id=>197010621076154303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SCHEMA_NOT_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打开:';

wwv_flow_api.create_message (
  p_id=>197010729152154303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.OPEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4790_date_timestamp_note
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(包含日期或时间戳列)';

wwv_flow_api.create_message (
  p_id=>197010832395154303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P4790_DATE_TIMESTAMP_NOTE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_bipub_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打印支持必须为 STANDARD 或 ADVANCED';

wwv_flow_api.create_message (
  p_id=>197010918380154303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_BIPUB_OPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_first_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除预配的第一个方案';

wwv_flow_api.create_message (
  p_id=>197011012443154303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_FIRST_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'端口号无效';

wwv_flow_api.create_message (
  p_id=>197011101403154303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_PORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wallet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wallet 路径格式必须为“file:<filesystempath>”';

wwv_flow_api.create_message (
  p_id=>197011228241154304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WALLET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_parm_notfound
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到实例参数';

wwv_flow_api.create_message (
  p_id=>197011309778154304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PARM_NOTFOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'内置登录页';

wwv_flow_api.create_message (
  p_id=>197011400782154304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_BUILTIN_LOGIN_PG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_page_in_this_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序中的页';

wwv_flow_api.create_message (
  p_id=>197011530235154304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_PAGE_IN_THIS_FLOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>197011624234154304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_URL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On';

wwv_flow_api.create_message (
  p_id=>197011713282154304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_SSO_SERVER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无';

wwv_flow_api.create_message (
  p_id=>197011817748154305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_NONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_auth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用 %0 帐户用户名和口令进行验证。';

wwv_flow_api.create_message (
  p_id=>197011921476154305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_AUTH_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_no_verify_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不验证身份证明';

wwv_flow_api.create_message (
  p_id=>197012026525154305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_NO_VERIFY_CRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用 LDAP 服务器进行验证。';

wwv_flow_api.create_message (
  p_id=>197012117290154305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_LDAP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_custom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用我的定制函数来进行验证。';

wwv_flow_api.create_message (
  p_id=>197012218484154305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_CUSTOM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_scratch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从头开始';

wwv_flow_api.create_message (
  p_id=>197012316016154305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_SCRATCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'作为现有验证方案的副本';

wwv_flow_api.create_message (
  p_id=>197012428927154306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_COPY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_gallery
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'基于库中预配置的方案';

wwv_flow_api.create_message (
  p_id=>197012508567154306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_GALLERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_use_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无验证 (使用 DAD)';

wwv_flow_api.create_message (
  p_id=>197012629575154306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_USE_DAD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_moc_sso
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SSO Cookie (my.oracle.com -- 仅 Oracle 使用)';

wwv_flow_api.create_message (
  p_id=>197012729517154306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MOC_SSO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_account_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示登录页和使用 %0 帐户身份证明';

wwv_flow_api.create_message (
  p_id=>197012806403154306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_ACCOUNT_CRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_builtin_pg_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示内置登录页和使用“开门”身份证明';

wwv_flow_api.create_message (
  p_id=>197012930350154306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_BUILTIN_PG_OPEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示登录页和使用 LDAP 目录身份证明';

wwv_flow_api.create_message (
  p_id=>197013003165154307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_USE_LDAP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_sso_htmldb_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (%0 引擎作为合作伙伴应用程序)';

wwv_flow_api.create_message (
  p_id=>197013115318154307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SSO_HTMLDB_PARTNER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_my_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (我的应用程序作为合作伙伴应用程序)';

wwv_flow_api.create_message (
  p_id=>197013215620154307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MY_PARTNER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新建';

wwv_flow_api.create_message (
  p_id=>197013317035154307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_NEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_printsvr_protocol
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'打印服务器协议必须为 http 或 https';

wwv_flow_api.create_message (
  p_id=>197013419311154307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PRINTSVR_PROTOCOL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案不存在';

wwv_flow_api.create_message (
  p_id=>197013531444154307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案是受限制的';

wwv_flow_api.create_message (
  p_id=>197013604242154307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_RESTRICTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'访问控制 - 管理员';

wwv_flow_api.create_message (
  p_id=>197013718809154308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_edit_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'访问控制 - 编辑';

wwv_flow_api.create_message (
  p_id=>197013820421154308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_EDIT_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_view_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'访问控制 - 查看';

wwv_flow_api.create_message (
  p_id=>197013920855154308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_VIEW_AUTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'INTERNAL 工作区中的帐户只能用于';

wwv_flow_api.create_message (
  p_id=>197014028348154308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 服务管理';

wwv_flow_api.create_message (
  p_id=>197014104210154308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_domain_index_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在所选的 %0 中存在域索引。“生成 DDL”无法生成域索引的 DDL。';

wwv_flow_api.create_message (
  p_id=>197014214760154308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.DOMAIN_INDEX_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_unsupported_data_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不支持的数据类型';

wwv_flow_api.create_message (
  p_id=>197014306736154309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_exclude_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'排除空值';

wwv_flow_api.create_message (
  p_id=>197014420893154309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_EXCLUDE_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示的列';

wwv_flow_api.create_message (
  p_id=>197014517817154309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_all_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'所有列';

wwv_flow_api.create_message (
  p_id=>197014631178154309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ALL_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您不能删除自身。';

wwv_flow_api.create_message (
  p_id=>197014713682154309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_DELETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_remove_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您无法删除自己的管理员权限。';

wwv_flow_api.create_message (
  p_id=>197014807210154309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表类型';

wwv_flow_api.create_message (
  p_id=>197014912117154310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHART_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_hcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'水平柱状图';

wwv_flow_api.create_message (
  p_id=>197015008372154310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HCOLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_vcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'垂直柱状图';

wwv_flow_api.create_message (
  p_id=>197015125034154310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VCOLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'饼图';

wwv_flow_api.create_message (
  p_id=>197015208763154310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PIE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行';

wwv_flow_api.create_message (
  p_id=>197015332463154310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LINE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_3d
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'3D';

wwv_flow_api.create_message (
  p_id=>197015414961154310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_3D',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标签';

wwv_flow_api.create_message (
  p_id=>197015508123154311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LABEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'聚集';

wwv_flow_api.create_message (
  p_id=>197015606871154311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGGREGATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_do_not_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 不聚集 -';

wwv_flow_api.create_message (
  p_id=>197015708622154311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DO_NOT_AGGREGATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日期';

wwv_flow_api.create_message (
  p_id=>197015800633154311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示';

wwv_flow_api.create_message (
  p_id=>197015922781154311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 选择函数 -';

wwv_flow_api.create_message (
  p_id=>197016026820154311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_FUNCTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'公共';

wwv_flow_api.create_message (
  p_id=>197016128434154312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PUBLIC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是否要删除这些报表设置?';

wwv_flow_api.create_message (
  p_id=>197016231712154312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE_CONFIRM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_reset_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将报表还原为默认设置。';

wwv_flow_api.create_message (
  p_id=>197016318871154312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RESET_CONFIRM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_dup_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您不能输入重复的用户名。';

wwv_flow_api.create_message (
  p_id=>197016425935154312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_DUP_USERNAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'输入任何字符串以用作此会话的用户标识符。';

wwv_flow_api.create_message (
  p_id=>197016519407154312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'输入您的 %0 用户名和口令。';

wwv_flow_api.create_message (
  p_id=>197016614783154312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'输入用户名和口令以供 LDAP 主机验证: %0。';

wwv_flow_api.create_message (
  p_id=>197016726331154313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'输入数据库方案用户名和口令。';

wwv_flow_api.create_message (
  p_id=>197016806488154313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_dial_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的图表查询: %0<br /><br /> 请使用以下语法: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>定义仪表盘刻度值的数字列。</td> </tr> <tr> <td>MAX</td> <td>定义最大刻度值的数字列。</td> </tr> <tr> <td>LOW (可选)</td> <td>定义在前的最小刻度值的数字列。</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH (可选)</td>'||chr(10)||
'<td>定义以前最大仪表盘值的数字列。</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197016908683154313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_dup_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误页=%0 项="%1" ID="%2" 与现有应用程序级别的项同名。';

wwv_flow_api.create_message (
  p_id=>197017025571154313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_DUP_PAGE_ITEM_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_between
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'介于';

wwv_flow_api.create_message (
  p_id=>197017115811154313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BETWEEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法对查询进行语法分析, 游标尚未打开或返回 SQL 查询的函数未返回值。';

wwv_flow_api.create_message (
  p_id=>197017204258154313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.CURSOR_NOT_OPEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_query_cannot_be_parsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回 SQL 查询的函数: 无法在构建器内对查询进行语法分析。如果您认为查询的语法正确, 可选中区域源下面的<b>一般列</b>复选框, 以在不进行语法分析的情况下继续执行。<br />'||chr(10)||
'(%0)';

wwv_flow_api.create_message (
  p_id=>197017318266154314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.QUERY_CANNOT_BE_PARSED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查询列 #%0 (%1) 无效, 请使用列别名';

wwv_flow_api.create_message (
  p_id=>197017417333154314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.USE_COLUMN_ALIAS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_html_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查询列 #%0 (%1) 无效, 使用 HTML 的列需要别名';

wwv_flow_api.create_message (
  p_id=>197017502314154314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.HTML_USE_COLUMN_ALIAS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>无法对查询进行语法分析, 请检查查询的语法。(%0)'||chr(10)||
'</p>';

wwv_flow_api.create_message (
  p_id=>197017613145154314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>无法在构建器内对查询进行语法分析。如果您认为查询的语法正确, 可选中区域源下面的 ''''一般列'''' 复选框, 以在不进行语法分析的情况下继续执行。%0</p>';

wwv_flow_api.create_message (
  p_id=>197017712280154314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用';

wwv_flow_api.create_message (
  p_id=>197017825961154314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_APPLY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_restriction
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将根据以下限制移植 SVG 图表:  '||chr(10)||
'<ul>'||chr(10)||
'<li>'||chr(10)||
'只移植在轴格式字符串中定义的数字格式。忽略日期和时间格式。'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'将移植包含以下内容的数字格式元素:'||chr(10)||
'<br />'||chr(10)||
'0,9,D,G,, (逗号),. (句点),$,C,L,FM'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Flash 图表中每个系列的标签派生自每个系列的列别名。'||chr(10)||
'这与 SVG 图表不同, SVG 图表中每个系列的标签派生自系列名称属性。'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Flash 仪表盘图表显示实际值而不是百分比。'||chr(10)||
'</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_message (
  p_id=>197017930380154314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'收盘价:';

wwv_flow_api.create_message (
  p_id=>197018020965154315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.CLOSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_high
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最高价: ';

wwv_flow_api.create_message (
  p_id=>197018101736154315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.HIGH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_low
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最低价:';

wwv_flow_api.create_message (
  p_id=>197018206507154315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.LOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message monthly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'每月';

wwv_flow_api.create_message (
  p_id=>197018323392154315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTHLY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weekly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'每周';

wwv_flow_api.create_message (
  p_id=>197018420206154315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKLY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message daily
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'每天';

wwv_flow_api.create_message (
  p_id=>197018502668154316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAILY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'< 向后';

wwv_flow_api.create_message (
  p_id=>197018625095154316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.PREVIOUS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'向前 >';

wwv_flow_api.create_message (
  p_id=>197018720278154316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.NEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p4111_used_on_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此值列表在页 %0 上使用。是否确定要删除? ';

wwv_flow_api.create_message (
  p_id=>197018805040154316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P4111_USED_ON_PAGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_create_ws_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在安装工作区时遇到另一个 create_company 调用。';

wwv_flow_api.create_message (
  p_id=>197018918660154316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.CREATE_WS_SEC_VIOLATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_to_is_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须提供收件人才能发送邮件。';

wwv_flow_api.create_message (
  p_id=>197019006487154316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.TO_IS_REQUIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message must_be_xsl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请确保报表布局文件的文件类型为 XSL-FO, 使用 ''.xsl'' 作为文件扩展名。';

wwv_flow_api.create_message (
  p_id=>197019128525154316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MUST_BE_XSL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message your_email_iuws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您的电子邮件地址已由某个用户在以下工作区中注册:';

wwv_flow_api.create_message (
  p_id=>197019214976154317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YOUR_EMAIL_IUWS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区主页';

wwv_flow_api.create_message (
  p_id=>197019305771154317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区登录';

wwv_flow_api.create_message (
  p_id=>197019423410154317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_LOGIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'交互报表';

wwv_flow_api.create_message (
  p_id=>197019516791154317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模板';

wwv_flow_api.create_message (
  p_id=>197019607071154317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'值列表';

wwv_flow_api.create_message (
  p_id=>197019723631154318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未使用共享的值列表。';

wwv_flow_api.create_message (
  p_id=>197019800210154318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未使用模板。';

wwv_flow_api.create_message (
  p_id=>197019929680154318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message button_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'按钮数字标识符';

wwv_flow_api.create_message (
  p_id=>197020010303154318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTON_ID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的图表查询: %0<br /><br />'||chr(10)||
'请使用以下语法:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'或为返回多个系列的查询使用以下语法:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE1 [, VALUE2 [, VALUE3...]]'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>沿图表轴显示的文本。</td></tr>'||chr(10)||
'<tr><td>VALUE1, VALUE2, VALUE3...</td><td>定义数据值的数字列。</td></tr>'||chr(10)||
'</table>'||chr(10)||
'注: 列和行图表的系列名称派生自在查询中使用的列别名。';

wwv_flow_api.create_message (
  p_id=>197020106448154318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CHART_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_scatter_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的散点图查询: %0<br /><br />'||chr(10)||
'请使用以下语法:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, X_VALUE, Y_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>在提示中显示的文本。</td></tr>'||chr(10)||
'<tr><td>X_VALUE</td><td>指定 X 坐标值的数字列。</td></tr>'||chr(10)||
'<tr><td>Y_VALUE</td><td>指定 Y 坐标值的数字列。</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197020213574154318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_SCATTER_CHART_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_range_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的范围图表查询: %0<br /><br />'||chr(10)||
'请使用以下语法:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN_VALUE, CLOSE_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>沿图表轴显示的文本。</td></tr>'||chr(10)||
'<tr><td>OPEN_VALUE</td><td>指定范围开始的数字列。</td></tr>'||chr(10)||
'<tr><td>CLOSE_VALUE</td><td>指定范围结束的数字列。</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197020330459154319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_RANGE_CHART_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_candlestick_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的 K 线图查询: %0<br /><br />'||chr(10)||
'请使用以下语法:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN, HIGH, LOW, CLOSE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>沿图表轴显示的文本。</td></tr>'||chr(10)||
'<tr><td>OPEN</td><td>指定 K 线图开始的数字列。</td></tr>'||chr(10)||
'<tr><td>HIGH</td><td>指定 K 线图最大值的数字列。</td></tr>'||chr(10)||
'<tr><td>LOW</td><td>指定 K 线图最小值的数字列。</td></tr>'||chr(10)||
'<tr><td>CLOSE</td><td>指定 K 线图结束的数字列。</td></tr>'||chr(10)||
'<';

h:=h||'/table>';

wwv_flow_api.create_message (
  p_id=>197020416340154319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CANDLESTICK_CHART_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_dial_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的仪表盘图表查询: %0<br /><br />请使用以下语法:'||chr(10)||
'<pre> SELECT VALUE, MAX [, LOW, HIGH] VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>定义仪表盘值的数字列。</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>定义仪表盘最大值的数字列。</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW (可选)</td>'||chr(10)||
'<td>定义仪表盘上显示范围的最小值的数字列。如果定义了此值, 则需要 HIGH 值。</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH (可选)</td>'||chr(10)||
'<td>定义仪表盘上显示范围的最大值的数字列。如果定义了此值, 则需要 LOW 值。</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'此查询应返回一行。';

wwv_flow_api.create_message (
  p_id=>197020513052154319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_DIAL_CHART_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_pie_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的图表查询: %0<br /><br />'||chr(10)||
'请使用以下语法:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>在图例文本, 提示本文和饼图切片标签中显示的文本。</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>定义数据值的数字列。</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197020630106154319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_PIE_CHART_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drag_and_drop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'拖放';

wwv_flow_api.create_message (
  p_id=>197020711358154319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRAG_AND_DROP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_parameter_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'为参数 %0 提供了空值。';

wwv_flow_api.create_message (
  p_id=>197020827549154320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.PARAMETER_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_invalid_mail_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'为参数 p_mail_id 提供的值无效: %0';

wwv_flow_api.create_message (
  p_id=>197020929257154320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.INVALID_MAIL_ID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类别';

wwv_flow_api.create_message (
  p_id=>197021001348154320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CATEGORY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'说明';

wwv_flow_api.create_message (
  p_id=>197021109984154320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在导出文件中的大块内检测到 remove_page 过程的 API 调用。';

wwv_flow_api.create_message (
  p_id=>197021211378154320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.SEC_VIOLATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_fmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'尝试上载到 Forms 移植项目的文件不是有效的 Forms 模块 (_fmb.XML) 文件。只能上载由 Oracle Forms 附带的 Forms2XML 转换工具生成的 Forms 模块 XML 文件。';

wwv_flow_api.create_message (
  p_id=>197021317843154320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_FMB_CONTENT_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_rpt_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'尝试上载到 Forms 移植项目的文件不是有效的报表 (.XML) 文件。只能上载由 Oracle Reports 构建器附带的文件转换实用程序生成的报表 XML 文件。';

wwv_flow_api.create_message (
  p_id=>197021408016154321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_RPT_CONTENT_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL: http(s)://domain/path/doc.(pdf)(html)(等等...)';

wwv_flow_api.create_message (
  p_id=>197021514432154321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'IP 地址';

wwv_flow_api.create_message (
  p_id=>197021618127154321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'电话号码, 美国: %0';

wwv_flow_api.create_message (
  p_id=>197021710327154321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'电话号码, 美国, 可灵活使用: 999.999.9999, (999)-999-9999, 999 999 9999, 等等...';

wwv_flow_api.create_message (
  p_id=>197021830541154321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'邮编: 99999';

wwv_flow_api.create_message (
  p_id=>197021918233154321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ZIP + 4: 99999-9999';

wwv_flow_api.create_message (
  p_id=>197022014625154321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日期: %0';

wwv_flow_api.create_message (
  p_id=>197022118320154322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日期, 可灵活使用: 带有任何分隔符的 %0 ';

wwv_flow_api.create_message (
  p_id=>197022220729154322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL 无效';

wwv_flow_api.create_message (
  p_id=>197022311092154322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'IP 地址无效';

wwv_flow_api.create_message (
  p_id=>197022418513154322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'电话号码格式必须为 %0';

wwv_flow_api.create_message (
  p_id=>197022517393154322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法识别的电话号码格式';

wwv_flow_api.create_message (
  p_id=>197022615466154323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'邮编的格式必须为 %0';

wwv_flow_api.create_message (
  p_id=>197022702733154323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日期的格式必须为 %0';

wwv_flow_api.create_message (
  p_id=>197022820111154323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法识别的日期格式';

wwv_flow_api.create_message (
  p_id=>197022910627154323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_curr_warn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'警告: 您将要删除此应用程序的当前验证方案!';

wwv_flow_api.create_message (
  p_id=>197023017023154323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_CURR_WARN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_func_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行应用程序 %0 中的定制验证函数。';

wwv_flow_api.create_message (
  p_id=>197023129641154323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FUNC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法提取应用程序 %0 中的定制验证函数体。';

wwv_flow_api.create_message (
  p_id=>197023214432154324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FETCH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_scheme_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法提取应用程序 %0 中的 authentication_scheme。';

wwv_flow_api.create_message (
  p_id=>197023331552154324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SCHEME_FETCH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_pg_sentry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行应用程序 %0 中的页卫士。';

wwv_flow_api.create_message (
  p_id=>197023403463154324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_PG_SENTRY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_sess_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行应用程序 %0 的验证方案中的插件会话验证函数。';

wwv_flow_api.create_message (
  p_id=>197023512631154324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SESS_VERIFY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WWSEC_SSO_ENABLER_PRIVATE 包不存在或无效。';

wwv_flow_api.create_message (
  p_id=>197023623530154324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请要求您的 %0 管理员配置 Oracle Application Server Single Sign-On 的引擎。';

wwv_flow_api.create_message (
  p_id=>197023728111154324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行 wwv_flow_custom_auth_sso.portal_sso_redirect 时出错。';

wwv_flow_api.create_message (
  p_id=>197023823087154325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_api_deep_link_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'会话 %0 的 remember_deep_link 中出现意外错误。';

wwv_flow_api.create_message (
  p_id=>197023904870154325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_API.DEEP_LINK_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_dup_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找到 %0 的重复用户名。';

wwv_flow_api.create_message (
  p_id=>197024005759154325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.DUP_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_load_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'加载用户时出错。用户 %0 失败。';

wwv_flow_api.create_message (
  p_id=>197024111650154325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.LOAD_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_mmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'尝试上载到 Forms 移植项目的文件不是有效的表单菜单 (_mmb.XML) 文件。只能上载由 Oracle Forms 附带的 Form2XML 转换工具生成的表单菜单 XML 文件。';

wwv_flow_api.create_message (
  p_id=>197024215537154325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_MMB_CONTENT_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行 %0 - %1 (共 %2 行)';

wwv_flow_api.create_message (
  p_id=>197024310150154326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_found_but_not_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找到请求的最小行数 %0, 但是未显示: %1';

wwv_flow_api.create_message (
  p_id=>197024423657154326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FOUND_BUT_NOT_DISPLAYED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_more_than_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'大于 %2 的行 %0 - %1 ';

wwv_flow_api.create_message (
  p_id=>197024519342154326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_MORE_THAN_Z',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序';

wwv_flow_api.create_message (
  p_id=>197024601595154326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页';

wwv_flow_api.create_message (
  p_id=>197024709346154326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页名';

wwv_flow_api.create_message (
  p_id=>197024809973154326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域标题';

wwv_flow_api.create_message (
  p_id=>197024911913154327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡集';

wwv_flow_api.create_message (
  p_id=>197025022173154327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡标签';

wwv_flow_api.create_message (
  p_id=>197025130204154327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_LABEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表所有者';

wwv_flow_api.create_message (
  p_id=>197025227843154327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_OWNER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表名';

wwv_flow_api.create_message (
  p_id=>197025308745154327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列';

wwv_flow_api.create_message (
  p_id=>197025409783154327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_updateable_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可更新列';

wwv_flow_api.create_message (
  p_id=>197025513674154327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATEABLE_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主键 %0';

wwv_flow_api.create_message (
  p_id=>197025604172154328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页标题';

wwv_flow_api.create_message (
  p_id=>197025725147154328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_tabset_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有为此页选择选项卡集。';

wwv_flow_api.create_message (
  p_id=>197025821538154328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO.TABSET.SELECTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将创建新选项卡集 "%0", 并由此页使用。';

wwv_flow_api.create_message (
  p_id=>197025900049154328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE.NEW.TABSET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_use_existing_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此页将使用现有选项卡集 "%0"。';

wwv_flow_api.create_message (
  p_id=>197026028852154328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.USE.EXISTING.TABSET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabset_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'警告, 选项卡集信息不完整。';

wwv_flow_api.create_message (
  p_id=>197026115586154328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABSET.INCOMPLETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父选项卡集';

wwv_flow_api.create_message (
  p_id=>197026201182154329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父选项卡标签';

wwv_flow_api.create_message (
  p_id=>197026327680154329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_LABEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无模板';

wwv_flow_api.create_message (
  p_id=>197026402258154329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项';

wwv_flow_api.create_message (
  p_id=>197026510258154329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域模板';

wwv_flow_api.create_message (
  p_id=>197026623484154329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'信息模板';

wwv_flow_api.create_message (
  p_id=>197026705391154330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'信息默认文本';

wwv_flow_api.create_message (
  p_id=>197026818558154330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 按钮显示文本';

wwv_flow_api.create_message (
  p_id=>197026926189154330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 按钮分支';

wwv_flow_api.create_message (
  p_id=>197027024652154330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_BRANCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_suggested_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'建议名称';

wwv_flow_api.create_message (
  p_id=>197027132697154330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SUGGESTED_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_actual_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'实际名称';

wwv_flow_api.create_message (
  p_id=>197027205146154331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ACTUAL_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_new_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新建模板';

wwv_flow_api.create_message (
  p_id=>197027305788154331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NEW_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示列';

wwv_flow_api.create_message (
  p_id=>197027404873154331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_process_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'处理选项';

wwv_flow_api.create_message (
  p_id=>197027519926154331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PROCESS_OPTIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'所有者';

wwv_flow_api.create_message (
  p_id=>197027605731154331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OWNER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_stored_procedure_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存储过程名';

wwv_flow_api.create_message (
  p_id=>197027719408154331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STORED_PROCEDURE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 查询';

wwv_flow_api.create_message (
  p_id=>197027801540154332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SQL_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表查询';

wwv_flow_api.create_message (
  p_id=>197027932636154332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表坐标轴';

wwv_flow_api.create_message (
  p_id=>197028020602154332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_AXIS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'比例';

wwv_flow_api.create_message (
  p_id=>197028101786154332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCALE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_number_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数字掩码';

wwv_flow_api.create_message (
  p_id=>197028200078154332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_NUMBER_MASK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表类型';

wwv_flow_api.create_message (
  p_id=>197028315800154332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表标题';

wwv_flow_api.create_message (
  p_id=>197028405165154333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表大小';

wwv_flow_api.create_message (
  p_id=>197028512584154333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SIZE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_vertical_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'垂直条形图';

wwv_flow_api.create_message (
  p_id=>197028631209154333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_VERTICAL_BAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_horizontal_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'水平条形图';

wwv_flow_api.create_message (
  p_id=>197028727240154333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_HORIZONTAL_BAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'饼图';

wwv_flow_api.create_message (
  p_id=>197028821644154333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_PIE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行';

wwv_flow_api.create_message (
  p_id=>197028928771154333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_LINE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scatter
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'散点图';

wwv_flow_api.create_message (
  p_id=>197029031729154334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCATTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_insert_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'插入';

wwv_flow_api.create_message (
  p_id=>197029129020154334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INSERT_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_update_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新';

wwv_flow_api.create_message (
  p_id=>197029230889154334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATE_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_delete_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>197029329670154334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DELETE_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tabular_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的表格式表单页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197029412551154334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TABULAR_FORM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197029505805154334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的向导。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197029607342154335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_WIZARD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的基于表的表单页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197029705024154335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的基于存储过程的表单。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197029812798154335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_SP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的基于 SQL 查询的表单。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197029915964154335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_simple_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的 HTML 条形图页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197030027941154335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SIMPLE_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的 SVG 图表页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197030124300154335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SVG_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的日历页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197030223242154336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_CALENDAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_date_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日期列';

wwv_flow_api.create_message (
  p_id=>197030326927154336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DATE_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_label_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标签列';

wwv_flow_api.create_message (
  p_id=>197030402180154336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.LABEL_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的树页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197030530351154336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TREE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'树名';

wwv_flow_api.create_message (
  p_id=>197030613221154336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'树类型';

wwv_flow_api.create_message (
  p_id=>197030725289154336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_max_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最大级别';

wwv_flow_api.create_message (
  p_id=>197030804856154336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_MAX_LEVEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_start
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'开始树';

wwv_flow_api.create_message (
  p_id=>197030919954154337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_START',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'树查询';

wwv_flow_api.create_message (
  p_id=>197031014979154337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'基于带有弹出式值列表的新项';

wwv_flow_api.create_message (
  p_id=>197031123816154337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'基于 SQL 查询';

wwv_flow_api.create_message (
  p_id=>197031226739154337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_SQL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_static
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'静态值';

wwv_flow_api.create_message (
  p_id=>197031312194154337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_STATIC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的面包屑区域和面包屑选项。请确认选择。';

wwv_flow_api.create_message (
  p_id=>197031406328154338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MENU',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域类型';

wwv_flow_api.create_message (
  p_id=>197031529860154338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_point
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示点';

wwv_flow_api.create_message (
  p_id=>197031606392154338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_POINT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑模板';

wwv_flow_api.create_message (
  p_id=>197031708453154338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'序列';

wwv_flow_api.create_message (
  p_id=>197031804328154338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SEQUENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑链接';

wwv_flow_api.create_message (
  p_id=>197031923301154338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_LINK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑文本';

wwv_flow_api.create_message (
  p_id=>197032006950154339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父面包屑';

wwv_flow_api.create_message (
  p_id=>197032100351154339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_query_and_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的表单页和报表页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197032212591154339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表页';

wwv_flow_api.create_message (
  p_id=>197032308548154339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表页名';

wwv_flow_api.create_message (
  p_id=>197032424836154339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表页选项卡集';

wwv_flow_api.create_message (
  p_id=>197032500005154339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表页选项卡标签';

wwv_flow_api.create_message (
  p_id=>197032605522154340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单页';

wwv_flow_api.create_message (
  p_id=>197032724870154340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单页名';

wwv_flow_api.create_message (
  p_id=>197032815116154340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单页选项卡集';

wwv_flow_api.create_message (
  p_id=>197032917888154340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表单页选项卡标签';

wwv_flow_api.create_message (
  p_id=>197033018086154340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主键列';

wwv_flow_api.create_message (
  p_id=>197033115733154340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表列';

wwv_flow_api.create_message (
  p_id=>197033213690154341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_where_clause
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Where 子句';

wwv_flow_api.create_message (
  p_id=>197033328197154341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WHERE_CLAUSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_drill_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的细化报表页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197033400127154341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DRILL_DOWN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父页';

wwv_flow_api.create_message (
  p_id=>197033531265154341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'详细资料页 %0';

wwv_flow_api.create_message (
  p_id=>197033623510154341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'详细资料选项卡标签 %0';

wwv_flow_api.create_message (
  p_id=>197033710834154341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TAB_LABEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父表名称';

wwv_flow_api.create_message (
  p_id=>197033828123154341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TABLE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从表名 %0';

wwv_flow_api.create_message (
  p_id=>197033909142154342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父显示列';

wwv_flow_api.create_message (
  p_id=>197034003775154342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_DISPLAY_COLS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'详细资料 %0 显示列';

wwv_flow_api.create_message (
  p_id=>197034111628154342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父表排序方式';

wwv_flow_api.create_message (
  p_id=>197034209104154342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_ORDER_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从表 %0 的排序方式';

wwv_flow_api.create_message (
  p_id=>197034301245154342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_ORDER_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_inc_bread_crumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'包括面包屑';

wwv_flow_api.create_message (
  p_id=>197034422522154343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INC_BREAD_CRUMB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_root
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑根';

wwv_flow_api.create_message (
  p_id=>197034514968154343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_ROOT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父面包屑列';

wwv_flow_api.create_message (
  p_id=>197034626675154343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU_COL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从面包屑列';

wwv_flow_api.create_message (
  p_id=>197034725848154343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_MENU_COL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的概要页。按 "添加更多" 按钮可从其他页和/或区域添加附加项。按 "完成" 按钮可创建概要项。';

wwv_flow_api.create_message (
  p_id=>197034826812154343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SUMMARY_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_copy_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求复制具有以下属性的页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197034929240154343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COPY_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的报表页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197035005130154343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_REPORT_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡名';

wwv_flow_api.create_message (
  p_id=>197035119449154344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_easy_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的报表页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197035211829154344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_EASY_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表模板';

wwv_flow_api.create_message (
  p_id=>197035315400154344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sort_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'排序选项';

wwv_flow_api.create_message (
  p_id=>197035405428154344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SORT_OPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认值: HTML (标准)';

wwv_flow_api.create_message (
  p_id=>197035518308154344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认: 垂直报表, 外观 1 (不含空列)';

wwv_flow_api.create_message (
  p_id=>197035610333154344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认: 垂直报表, 外观 1 (包含空列)';

wwv_flow_api.create_message (
  p_id=>197035726296154345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认值: 外观 1';

wwv_flow_api.create_message (
  p_id=>197035825623154345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME11',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认值: 外观 2';

wwv_flow_api.create_message (
  p_id=>197035927973154345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME12',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name21
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导出: CSV';

wwv_flow_api.create_message (
  p_id=>197036028419154345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME21',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导出: XML';

wwv_flow_api.create_message (
  p_id=>197036123243154345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME22',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模板:';

wwv_flow_api.create_message (
  p_id=>197036229706154345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_col_head_sorting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用列标题排序';

wwv_flow_api.create_message (
  p_id=>197036305779154346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COL_HEAD_SORTING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的应用程序。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197036404371154346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_APPLICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>197036532367154346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'别名';

wwv_flow_api.create_message (
  p_id=>197036627716154346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_ALIAS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_default_lang
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认语言';

wwv_flow_api.create_message (
  p_id=>197036704422154346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证';

wwv_flow_api.create_message (
  p_id=>197036814887154346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.AUTHENTICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页';

wwv_flow_api.create_message (
  p_id=>197036908927154347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡';

wwv_flow_api.create_message (
  p_id=>197037013573154347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航栏';

wwv_flow_api.create_message (
  p_id=>197037116853154347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NAV_BAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'UI 主题';

wwv_flow_api.create_message (
  p_id=>197037219025154347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'蓝色和棕褐色';

wwv_flow_api.create_message (
  p_id=>197037306582154347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'红色';

wwv_flow_api.create_message (
  p_id=>197037409475154347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'海军蓝和灰色';

wwv_flow_api.create_message (
  p_id=>197037529364154348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'橄榄色';

wwv_flow_api.create_message (
  p_id=>197037619495154348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'栗色';

wwv_flow_api.create_message (
  p_id=>197037719830154348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME6',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'纯蓝色和棕褐色';

wwv_flow_api.create_message (
  p_id=>197037823319154348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME7',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'蓝色';

wwv_flow_api.create_message (
  p_id=>197037919693154348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME8',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无';

wwv_flow_api.create_message (
  p_id=>197038029968154348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME_NONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_copied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>197038131033154348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.COPIED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此模板的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>197038204136154349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.MASTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此模板的标签模板';

wwv_flow_api.create_message (
  p_id=>197038313821154349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有模板订阅此模板。';

wwv_flow_api.create_message (
  p_id=>197038407119154349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_current_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前验证方法';

wwv_flow_api.create_message (
  p_id=>197038523478154349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CURRENT_AUTH_METHOD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'登录页';

wwv_flow_api.create_message (
  p_id=>197038627992154349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无';

wwv_flow_api.create_message (
  p_id=>197038703825154350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.NONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'登录 URL';

wwv_flow_api.create_message (
  p_id=>197038820813154350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_URL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_custom_auth_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'定制验证函数';

wwv_flow_api.create_message (
  p_id=>197038900375154350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CUSTOM_AUTH_FUNCTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_confirm_migrate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此应用程序的定制验证选项将被移植到验证方案中。';

wwv_flow_api.create_message (
  p_id=>197039012910154350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CONFIRM_MIGRATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_value_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须指定值。';

wwv_flow_api.create_message (
  p_id=>197039104289154350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.VALUE_REQUIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>197039201963154350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PLSQL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_e_val
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项=值';

wwv_flow_api.create_message (
  p_id=>197039300600154350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项不为空';

wwv_flow_api.create_message (
  p_id=>197039414468154351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_req_e_e1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请求=e1';

wwv_flow_api.create_message (
  p_id=>197039516877154351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页在';

wwv_flow_api.create_message (
  p_id=>197039629576154351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_IN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页不在';

wwv_flow_api.create_message (
  p_id=>197039720036154351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存在';

wwv_flow_api.create_message (
  p_id=>197039807410154351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从不';

wwv_flow_api.create_message (
  p_id=>197039916726154351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NEVER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无';

wwv_flow_api.create_message (
  p_id=>197040005007154352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p688_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标识要导出的应用程序组件。这可用于备份, 或将这些组件加载到其他实例。';

wwv_flow_api.create_message (
  p_id=>197040125900154352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P688_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存在';

wwv_flow_api.create_message (
  p_id=>197040208313154352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不存在';

wwv_flow_api.create_message (
  p_id=>197040325183154352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建示例应用程序来演示 Web 服务。';

wwv_flow_api.create_message (
  p_id=>197040402629154352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您将要创建 (重新创建)“商业样式”演示应用程序。';

wwv_flow_api.create_message (
  p_id=>197040505704154352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_worldcup_mania
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您将要创建“世界杯狂热之旅”演示应用程序。';

wwv_flow_api.create_message (
  p_id=>197040601716154353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果存在以下数据库对象则重新创建它们';

wwv_flow_api.create_message (
  p_id=>197040722084154353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_RECREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案';

wwv_flow_api.create_message (
  p_id=>197040813842154353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对象类型';

wwv_flow_api.create_message (
  p_id=>197040908850154353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>197041000444154353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存在';

wwv_flow_api.create_message (
  p_id=>197041124250154353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表';

wwv_flow_api.create_message (
  p_id=>197041213197154354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_application_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序 ID 从 3000 至 8999 为系统保留值。';

wwv_flow_api.create_message (
  p_id=>197041324191154354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APPLICATION_RESERVED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'序列';

wwv_flow_api.create_message (
  p_id=>197041430235154354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SEQUENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'触发器';

wwv_flow_api.create_message (
  p_id=>197041517864154354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TRIGGER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'包';

wwv_flow_api.create_message (
  p_id=>197041613836154354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PACKAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_basic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您将要创建“基本示例演示应用程序”。';

wwv_flow_api.create_message (
  p_id=>197041712032154354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BASIC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您将要创建“收藏品展示”演示应用程序。';

wwv_flow_api.create_message (
  p_id=>197041808947154355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_or_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在方案 %0 中创建或重新创建';

wwv_flow_api.create_message (
  p_id=>197041905861154355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p19_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须至少指定一项才能创建非空验证。';

wwv_flow_api.create_message (
  p_id=>197042025196154355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P19.VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对象名';

wwv_flow_api.create_message (
  p_id=>197042132185154355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_basic_lexer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'BASIC_LEXER';

wwv_flow_api.create_message (
  p_id=>197042231343154355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BASIC_LEXER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_context_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上下文索引';

wwv_flow_api.create_message (
  p_id=>197042321843154355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CONTEXT_INDEX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标题必须包含 <b>&lt;head&gt;</b> 和 <b>&lt;/head&gt;</b> 标记。';

wwv_flow_api.create_message (
  p_id=>197042406173154356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序';

wwv_flow_api.create_message (
  p_id=>197042500129154356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.APPLICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_need_7m
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'“总统就职演说”演示需要大约 7MB 的可用磁盘空间, 并且在您的方案中安装需要两分钟的时间。';

wwv_flow_api.create_message (
  p_id=>197042613931154356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NEED_7M',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>#HEAD#</b>替换字符串必须出现在 <b> &lt;head&gt;</b> 和 <b>&lt;/head&gt;</b> 标记之间。';

wwv_flow_api.create_message (
  p_id=>197042711195154356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_free_space
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您大约有 %0 MB 可用。';

wwv_flow_api.create_message (
  p_id=>197042821618154356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.FREE_SPACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_will_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果不重新创建此演示, 可能会遇到错误。';

wwv_flow_api.create_message (
  p_id=>197042928698154356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WILL_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p818_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须至少选择一个要复制的方案。';

wwv_flow_api.create_message (
  p_id=>197043030047154357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P818.VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_mand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须指定模板名。';

wwv_flow_api.create_message (
  p_id=>197043120745154357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_MAND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>197043207208154357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.COPIED_FROM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'弹出式值列表模板';

wwv_flow_api.create_message (
  p_id=>197043302610154357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此模板的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>197043427537154357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MASTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此模板的弹出式值列表模板';

wwv_flow_api.create_message (
  p_id=>197043507819154357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有模板订阅此模板。';

wwv_flow_api.create_message (
  p_id=>197043605940154358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前应用程序';

wwv_flow_api.create_message (
  p_id=>197043731386154358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_APPLICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'别名';

wwv_flow_api.create_message (
  p_id=>197043829819154358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALIAS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新时间';

wwv_flow_api.create_message (
  p_id=>197043904933154358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_report_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此模板的报表模板';

wwv_flow_api.create_message (
  p_id=>197044019154154358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REPORT_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'所有者';

wwv_flow_api.create_message (
  p_id=>197044101989154358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OWNER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证';

wwv_flow_api.create_message (
  p_id=>197044204218154359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_edit_this_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑此模板';

wwv_flow_api.create_message (
  p_id=>197044316535154359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_EDIT_THIS_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_authentication_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证主页';

wwv_flow_api.create_message (
  p_id=>197044407626154359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_AUTHENTICATION_HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模板';

wwv_flow_api.create_message (
  p_id=>197044507812154359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此模板的面包屑模板';

wwv_flow_api.create_message (
  p_id=>197044606841154359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MENU_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table_summary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'演示应用程序安装状态报表';

wwv_flow_api.create_message (
  p_id=>197044723570154359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE_SUMMARY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_demo_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'演示应用程序';

wwv_flow_api.create_message (
  p_id=>197044804869154360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEMO_APP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_status
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'状态';

wwv_flow_api.create_message (
  p_id=>197044906400154360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.STATUS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'操作';

wwv_flow_api.create_message (
  p_id=>197045017246154360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ACTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'收藏品展示';

wwv_flow_api.create_message (
  p_id=>197045129335154360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_learn_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'了解 %0 购物车概念。';

wwv_flow_api.create_message (
  p_id=>197045226193154360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.LEARN_ABOUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已安装';

wwv_flow_api.create_message (
  p_id=>197045323800154360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALLED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_run
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'运行';

wwv_flow_api.create_message (
  p_id=>197045406643154360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.RUN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_not_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有安装';

wwv_flow_api.create_message (
  p_id=>197045530898154361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NOT_INSTALLED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安装';

wwv_flow_api.create_message (
  p_id=>197045630577154361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页';

wwv_flow_api.create_message (
  p_id=>197045711580154361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标题';

wwv_flow_api.create_message (
  p_id=>197045813334154361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message security
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安全性';

wwv_flow_api.create_message (
  p_id=>197045913365154361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECURITY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message standard_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标准选项卡集';

wwv_flow_api.create_message (
  p_id=>197046012137154361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STANDARD_TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'宠物商店';

wwv_flow_api.create_message (
  p_id=>197046119050154362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PETSTORE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用 %0 构建在线商店的示例。';

wwv_flow_api.create_message (
  p_id=>197046215461154362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install_now
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'立即安装';

wwv_flow_api.create_message (
  p_id=>197046315128154362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL_NOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'商业样式';

wwv_flow_api.create_message (
  p_id=>197046419464154362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BUSINESS_LOOK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'健康报表和页码概念的示例。';

wwv_flow_api.create_message (
  p_id=>197046516105154362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web 服务';

wwv_flow_api.create_message (
  p_id=>197046630116154362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WEB_SERVICES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_webservices
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'了解如何将 web 服务与 %0 一起使用。';

wwv_flow_api.create_message (
  p_id=>197046700913154363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'总统就职演说';

wwv_flow_api.create_message (
  p_id=>197046815798154363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PRESIDENTIAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'了解如何将 Oracle Text 与 %0 一起使用。 ';

wwv_flow_api.create_message (
  p_id=>197046929219154363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_select_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选择要返回到的时间, 然后单击源, 以填充所需的项并关闭此页。';

wwv_flow_api.create_message (
  p_id=>197047032305154363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_SELECT_TIME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_project_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项目跟踪';

wwv_flow_api.create_message (
  p_id=>197047116751154363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PROJECT_TRACKING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_flashback_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 的还原功能使用称为 "闪回查询" 的内置数据库功能, 可用于查询某个时间的数据。';

wwv_flow_api.create_message (
  p_id=>197047200895154363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_FLASHBACK_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_proj_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用 %0 构建的项目状态跟踪应用程序的示例。';

wwv_flow_api.create_message (
  p_id=>197047324327154364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_undo_retention
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'基于数据库参数 "UNDO_RETENTION", 您只能还原在前 %0 小时内所作的更改。';

wwv_flow_api.create_message (
  p_id=>197047424490154364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_UNDO_RETENTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>197047503261154364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.COPIED_FROM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此项帮助的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>197047612640154364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.MASTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此项帮助文本的项';

wwv_flow_api.create_message (
  p_id=>197047702494154364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有项订阅此项帮助文本。';

wwv_flow_api.create_message (
  p_id=>197047814044154364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.NO_SUBSCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_confirm_create_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'确认在应用程序中创建标准选项卡';

wwv_flow_api.create_message (
  p_id=>197047903476154365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_CONFIRM_CREATE_STD_TAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_tabset_info_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'警告, 选项卡集信息不完整。';

wwv_flow_api.create_message (
  p_id=>197048003282154365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_TABSET_INFO_INCOMPLETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>197048104268154365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.COPIED_FROM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_page_will_use_existng_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 %0 将使用现有选项卡集 "%1"。';

wwv_flow_api.create_message (
  p_id=>197048232751154365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_PAGE_WILL_USE_EXISTNG_TABSET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_new_tabset_will_be_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将创建新选项卡集 %0。';

wwv_flow_api.create_message (
  p_id=>197048310559154365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_NEW_TABSET_WILL_BE_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此授权方案的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>197048427541154366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.MASTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此授权方案的授权方案';

wwv_flow_api.create_message (
  p_id=>197048529866154366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有授权方案订阅此授权方案。';

wwv_flow_api.create_message (
  p_id=>197048621200154366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.NO_SUBSCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_not_supplied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须提供口令和确认口令。';

wwv_flow_api.create_message (
  p_id=>197048727798154366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NOT_SUPPLIED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_no_match
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令不匹配, 请重试。';

wwv_flow_api.create_message (
  p_id=>197048816574154366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NO_MATCH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>197048929827154366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.COPIED_FROM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_chg_only_yours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'只能更改您自己的口令。';

wwv_flow_api.create_message (
  p_id=>197049007135154367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_CHG_ONLY_YOURS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此快捷方式的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>197049112180154367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.MASTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'处理更改口令请求时出现意外错误: %0';

wwv_flow_api.create_message (
  p_id=>197049201028154367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此快捷方式的快捷方式';

wwv_flow_api.create_message (
  p_id=>197049306060154367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有快捷方式订阅此快捷方式。';

wwv_flow_api.create_message (
  p_id=>197049407386154367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.NO_SUBSCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 处理 PLSQL 表达式时出错。%0';

wwv_flow_api.create_message (
  p_id=>197049511835154367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_PLSQL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1026 处理 SQL 表达式时出错: %0';

wwv_flow_api.create_message (
  p_id=>197049624391154367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_SQL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡集';

wwv_flow_api.create_message (
  p_id=>197049717480154368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_orcl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle 错误: %0';

wwv_flow_api.create_message (
  p_id=>197049816906154368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_ORCL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡文本';

wwv_flow_api.create_message (
  p_id=>197049904777154368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前页';

wwv_flow_api.create_message (
  p_id=>197050020066154368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>197050131836154368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.COPIED_FROM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此值列表的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>197050206060154368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.MASTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此值列表的值列表';

wwv_flow_api.create_message (
  p_id=>197050311387154369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'订阅此值列表的值列表不存在。';

wwv_flow_api.create_message (
  p_id=>197050407474154369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.NO_SUBSCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父选项卡集';

wwv_flow_api.create_message (
  p_id=>197050507759154369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新建父选项卡集';

wwv_flow_api.create_message (
  p_id=>197050627554154369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET_NEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'父选项卡文本';

wwv_flow_api.create_message (
  p_id=>197050720834154369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选项卡序列';

wwv_flow_api.create_message (
  p_id=>197050828647154369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SEQUENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前映像';

wwv_flow_api.create_message (
  p_id=>197050917574154370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_IMAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_page_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此模板的页模板';

wwv_flow_api.create_message (
  p_id=>197051026459154370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.PAGE_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message non_current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'非当前图像';

wwv_flow_api.create_message (
  p_id=>197051108964154370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NON_CURRENT_IMAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图像属性';

wwv_flow_api.create_message (
  p_id=>197051216778154370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE_ATTRIBUTES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示条件';

wwv_flow_api.create_message (
  p_id=>197051308445154370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message condition_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'条件类型';

wwv_flow_api.create_message (
  p_id=>197051411775154370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITION_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示条件文本';

wwv_flow_api.create_message (
  p_id=>197051513846154371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>197051601231154371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.COPIED_FROM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_table_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表名已存在。';

wwv_flow_api.create_message (
  p_id=>197051728232154371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.TABLE_ALREADY_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'构建选项';

wwv_flow_api.create_message (
  p_id=>197051819167154371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILD_OPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此导航栏的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>197051922199154371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.MASTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列长度不能为零。';

wwv_flow_api.create_message (
  p_id=>197052021277154371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_ZERO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列长度不能为空。';

wwv_flow_api.create_message (
  p_id=>197052122092154371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此导航栏的导航栏';

wwv_flow_api.create_message (
  p_id=>197052231773154372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列名不能超过 30 个字符。';

wwv_flow_api.create_message (
  p_id=>197052326127154372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列名不能为空。';

wwv_flow_api.create_message (
  p_id=>197052421980154372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_NULL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有导航栏订阅此导航栏。';

wwv_flow_api.create_message (
  p_id=>197052526200154372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.NO_SUBSCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_table_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表名不得超过 30 个字符。';

wwv_flow_api.create_message (
  p_id=>197052609624154372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.TABLE_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_not_valid_pk_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> 不是有效的主键名。';

wwv_flow_api.create_message (
  p_id=>197052703368154372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.NOT_VALID_PK_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p173_no_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不存在此项的帮助';

wwv_flow_api.create_message (
  p_id=>197052822014154373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P173_NO_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_name_already_used
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> 已由现有对象使用。';

wwv_flow_api.create_message (
  p_id=>197052928489154373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NAME_ALREADY_USED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_err_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 无法从 "declare function x return varchar2 is begin %0 return null; end; begin wwv_flow_utilities.g_query := x; end;" 确定 LOV。';

wwv_flow_api.create_message (
  p_id=>197053030747154373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ERR_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_not_valid_seq_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> 不是有效的序列名。';

wwv_flow_api.create_message (
  p_id=>197053116652154373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NOT_VALID_SEQ_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加';

wwv_flow_api.create_message (
  p_id=>197053207632154373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ADD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> 不是有效的表名。';

wwv_flow_api.create_message (
  p_id=>197053327837154373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_TABLE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>197053406341154374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.REMOVE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> 不是有效的对象名。';

wwv_flow_api.create_message (
  p_id=>197053521536154374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_OBJECT_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_table_not_found_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在方案 <b>%1</b> 中找不到表 <b>%0</b>。';

wwv_flow_api.create_message (
  p_id=>197053606403154374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.TABLE_NOT_FOUND_IN_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_no_matches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无匹配。';

wwv_flow_api.create_message (
  p_id=>197053720375154374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NO_MATCHES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_prev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上一页';

wwv_flow_api.create_message (
  p_id=>197053821691154374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.PREV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_need_unique_execution_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请输入唯一的执行次序号。';

wwv_flow_api.create_message (
  p_id=>197053904289154374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NEED_UNIQUE_EXECUTION_ORDER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_copied_from_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'复制自应用程序';

wwv_flow_api.create_message (
  p_id=>197054024310154375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_COPIED_FROM_APP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下一页';

wwv_flow_api.create_message (
  p_id=>197054118355154375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_cal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日历';

wwv_flow_api.create_message (
  p_id=>197054211533154375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关闭';

wwv_flow_api.create_message (
  p_id=>197054306429154375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CLOSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_ok
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'确定';

wwv_flow_api.create_message (
  p_id=>197054404934154375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.OK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_search_dialog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'“搜索”对话框';

wwv_flow_api.create_message (
  p_id=>197054526859154375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SEARCH_DIALOG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_find
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查找 %0';

wwv_flow_api.create_message (
  p_id=>197054618151154376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.FIND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_region_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此模板的区域模板';

wwv_flow_api.create_message (
  p_id=>197054702131154376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REGION_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_js_no_support
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不支持 JavaScript';

wwv_flow_api.create_message (
  p_id=>197054818584154376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.JS_NO_SUPPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_master_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'这是此模板的 "主" 副本。';

wwv_flow_api.create_message (
  p_id=>197054918250154376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_MASTER_COPY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列表';

wwv_flow_api.create_message (
  p_id=>197055003065154376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_list_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此模板的列表模板';

wwv_flow_api.create_message (
  p_id=>197055104302154376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.LIST_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_button_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'引用此模板的按钮模板';

wwv_flow_api.create_message (
  p_id=>197055220902154377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_BUTTON_TEMPL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_no_subscirbers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有模板订阅此模板。';

wwv_flow_api.create_message (
  p_id=>197055326255154377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_NO_SUBSCIRBERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_lov2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行值列表查询 "%1" 时出现错误 %0。';

wwv_flow_api.create_message (
  p_id=>197055401832154377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LOV2_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_region_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主题';

wwv_flow_api.create_message (
  p_id=>197055505086154377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REGION_TEMPLATE.THEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_page_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主题';

wwv_flow_api.create_message (
  p_id=>197055611400154377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_PAGE_TEMPLATE.THEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_list_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主题';

wwv_flow_api.create_message (
  p_id=>197055706374154377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LIST_TEMPLATE.THEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_label_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主题';

wwv_flow_api.create_message (
  p_id=>197055818806154378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LABEL_TEMPLATE.THEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_report_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主题';

wwv_flow_api.create_message (
  p_id=>197055928313154378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REPORT_TEMPLATE.THEME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页项';

wwv_flow_api.create_message (
  p_id=>197056029764154378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.PAGE_ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域';

wwv_flow_api.create_message (
  p_id=>197056110466154378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_default_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已作为应用程序默认模板进行引用。';

wwv_flow_api.create_message (
  p_id=>197056225390154378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.DEFAULT_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_printer_friendly_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'作为打印机友好的模板进行引用。';

wwv_flow_api.create_message (
  p_id=>197056330705154378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PRINTER_FRIENDLY_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_error_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已作为错误模板进行引用。';

wwv_flow_api.create_message (
  p_id=>197056401177154379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.ERROR_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已在页中引用';

wwv_flow_api.create_message (
  p_id=>197056527326154379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_not_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未引用此页模板。';

wwv_flow_api.create_message (
  p_id=>197056615701154379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.NOT_REFERENCED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此页模板为';

wwv_flow_api.create_message (
  p_id=>197056727671154379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'树名';

wwv_flow_api.create_message (
  p_id=>197056815369154379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类型';

wwv_flow_api.create_message (
  p_id=>197056904309154379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项';

wwv_flow_api.create_message (
  p_id=>197057024398154380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'树查询';

wwv_flow_api.create_message (
  p_id=>197057116655154380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_show_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示源';

wwv_flow_api.create_message (
  p_id=>197057202085154380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_SHOW_SOURCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_hide_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'隐藏源';

wwv_flow_api.create_message (
  p_id=>197057324415154380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_HIDE_SOURCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>197057427852154380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列表模板';

wwv_flow_api.create_message (
  p_id=>197057508340154380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_seq
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'序列';

wwv_flow_api.create_message (
  p_id=>197057610269154381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_SEQ',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'文本';

wwv_flow_api.create_message (
  p_id=>197057707022154381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'目标';

wwv_flow_api.create_message (
  p_id=>197057826621154381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TARGET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页项';

wwv_flow_api.create_message (
  p_id=>197057900814154381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域';

wwv_flow_api.create_message (
  p_id=>197058020871154381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_set_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'单击可设置区域';

wwv_flow_api.create_message (
  p_id=>197058120776154381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.SET_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_prompt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'提示';

wwv_flow_api.create_message (
  p_id=>197058201012154382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PROMPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_no_item_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未找到任何项';

wwv_flow_api.create_message (
  p_id=>197058310386154382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_apply_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用权限';

wwv_flow_api.create_message (
  p_id=>197058409072154382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_APPLY_PERMISSIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示值';

wwv_flow_api.create_message (
  p_id=>197058519782154382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISPLAY_VALUE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回值';

wwv_flow_api.create_message (
  p_id=>197058604952154382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.RETURN_VALUE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_revoke_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'撤销权限';

wwv_flow_api.create_message (
  p_id=>197058726938154382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_REVOKE_PERMISSIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认值';

wwv_flow_api.create_message (
  p_id=>197058805025154383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DEFAULT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_primary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主排序列';

wwv_flow_api.create_message (
  p_id=>197058926061154383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.PRIMARY_SORT_COL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_noaction_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不需要执行操作';

wwv_flow_api.create_message (
  p_id=>197059024395154383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_NOACTION_REQUIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_secondary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'次级排序列';

wwv_flow_api.create_message (
  p_id=>197059107493154383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SECONDARY_SORT_COL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_select_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选择列';

wwv_flow_api.create_message (
  p_id=>197059216947154383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SELECT_COL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_disable_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'禁用排序列';

wwv_flow_api.create_message (
  p_id=>197059328172154383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISABLE_SORT_COL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_manager_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'警告: 父选项卡目标 "%0" 引用了不存在的页。';

wwv_flow_api.create_message (
  p_id=>197059429341154383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_MANAGER.WARNING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求刷新以下项帮助';

wwv_flow_api.create_message (
  p_id=>197059505265154384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'如果正确, 则单击“全部刷新”。否则, 单击“取消”。';

wwv_flow_api.create_message (
  p_id=>197059624405154384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_confirm_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您将要删除应用程序 %0 中的验证方案。如果此应用程序当前未使用 SCHEME 验证或如果方案不是当前验证方案, 则删除该方案不会对此应用程序的操作造成影响。如果此应用程序使用 SCHEME 验证, 并且该方案是当前验证方案, 则此应用程序将继续使用 SCHEME 验证运行, 但是用默认验证方案运行。此操作将使用带有 "开门" 身份证明验证 (即允许任何人运行此应用程序) 的内置登录页。';

wwv_flow_api.create_message (
  p_id=>197059729143154384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.CONFIRM_DELETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_dup_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列名 <b>%0</b> 已在此表中使用多次。';

wwv_flow_api.create_message (
  p_id=>197059809522154384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.DUP_COL_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_nbr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列 <b>%0</b> 的精度无效 (1 - 38)。<br />';

wwv_flow_api.create_message (
  p_id=>197059923574154384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_NBR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列 <b>%0</b> 的比例无效 (-84 - 127)。<br />';

wwv_flow_api.create_message (
  p_id=>197060003933154384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_SCALE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_char
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列 <b>%0</b> 的精度无效 (%1 - %2)。<br />';

wwv_flow_api.create_message (
  p_id=>197060105122154385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_CHAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列名 <b>%0</b> 无效。<br />';

wwv_flow_api.create_message (
  p_id=>197060229617154385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_COL_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_enter_at_least_one_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须至少输入一列的名称。';

wwv_flow_api.create_message (
  p_id=>197060319590154385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.ENTER_AT_LEAST_ONE_COL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_dup_arg_names
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'参数名 <b>%0</b> 在此函数中已使用多次。<br />';

wwv_flow_api.create_message (
  p_id=>197060430989154385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.DUP_ARG_NAMES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p232_reset_css
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重置 CSS';

wwv_flow_api.create_message (
  p_id=>197060511296154385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P232_RESET_CSS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_native
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'本机文件格式。';

wwv_flow_api.create_message (
  p_id=>197060628527154385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_NATIVE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_text_file_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查看文本形式的文档。';

wwv_flow_api.create_message (
  p_id=>197060707715154386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_TEXT_FILE_FORMAT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_parse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对此脚本进行语法分析。';

wwv_flow_api.create_message (
  p_id=>197060827176154386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_PARSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_show_all_workspaces
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示所有工作区';

wwv_flow_api.create_message (
  p_id=>197060932637154386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_SHOW_ALL_WORKSPACES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列';

wwv_flow_api.create_message (
  p_id=>197061021147154386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_conditions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'条件';

wwv_flow_api.create_message (
  p_id=>197061132224154386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.CONDITIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下箭头';

wwv_flow_api.create_message (
  p_id=>197061215925154386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_DOWN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'右箭头';

wwv_flow_api.create_message (
  p_id=>197061312633154387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_RIGHT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'AND';

wwv_flow_api.create_message (
  p_id=>197061401194154387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.AND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_or
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'OR';

wwv_flow_api.create_message (
  p_id=>197061524507154387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.OR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_preview
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'预览条件';

wwv_flow_api.create_message (
  p_id=>197061629587154387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.PREVIEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求刷新以下验证方案';

wwv_flow_api.create_message (
  p_id=>197061718024154387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.REFRESH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_make_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'单击“设为当前”按钮可使应用程序使用此验证方案。';

wwv_flow_api.create_message (
  p_id=>197061806917154388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.MAKE_CURRENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已经在 SQL 脚本资料档案库中创建了表 %0 的创建表脚本。';

wwv_flow_api.create_message (
  p_id=>197061902650154388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_repository
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'转到脚本资料档案库';

wwv_flow_api.create_message (
  p_id=>197062006846154388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 工作室主页';

wwv_flow_api.create_message (
  p_id=>197062122407154388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'运行脚本';

wwv_flow_api.create_message (
  p_id=>197062208689154388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RUN_SCRIPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回到';

wwv_flow_api.create_message (
  p_id=>197062306117154388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RETURN_TO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;工作室';

wwv_flow_api.create_message (
  p_id=>197062403040154389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主页';

wwv_flow_api.create_message (
  p_id=>197062520415154389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在 "%1" 方案中已创建包 "%0"。';

wwv_flow_api.create_message (
  p_id=>197062614783154389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'浏览包';

wwv_flow_api.create_message (
  p_id=>197062726659154389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BROWSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 工作室主页';

wwv_flow_api.create_message (
  p_id=>197062803739154389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回到';

wwv_flow_api.create_message (
  p_id=>197062920863154389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.RETURN_TO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;工作室';

wwv_flow_api.create_message (
  p_id=>197063021558154389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主页';

wwv_flow_api.create_message (
  p_id=>197063116343154390 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.HOME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回创建表向导';

wwv_flow_api.create_message (
  p_id=>197063224598154390 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BACK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_failed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建表 "%0" 失败。';

wwv_flow_api.create_message (
  p_id=>197063307958154390 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.FAILED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message null_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(空)';

wwv_flow_api.create_message (
  p_id=>197063407742154390 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NULL_IN_PAREN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_instruct_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'第一行包含列名。';

wwv_flow_api.create_message (
  p_id=>197063504445154390 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300_INSTRUCT_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(表)';

wwv_flow_api.create_message (
  p_id=>197063617222154390 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE_IN_PAREN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(视图)';

wwv_flow_api.create_message (
  p_id=>197063708815154391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_IN_PAREN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_applications
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'所有应用程序';

wwv_flow_api.create_message (
  p_id=>197063825038154391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_APPLICATIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message seconds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'秒';

wwv_flow_api.create_message (
  p_id=>197063910881154391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECONDS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分钟';

wwv_flow_api.create_message (
  p_id=>197064001918154391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minutes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分钟';

wwv_flow_api.create_message (
  p_id=>197064128689154391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hour
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'小时';

wwv_flow_api.create_message (
  p_id=>197064227671154391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOUR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'小时';

wwv_flow_api.create_message (
  p_id=>197064317312154392 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOURS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message day
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'天';

wwv_flow_api.create_message (
  p_id=>197064412602154392 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'天';

wwv_flow_api.create_message (
  p_id=>197064524919154392 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAYS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message week
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'周';

wwv_flow_api.create_message (
  p_id=>197064617394154392 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'周';

wwv_flow_api.create_message (
  p_id=>197064711266154392 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message year
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'年';

wwv_flow_api.create_message (
  p_id=>197064812584154392 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YEAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'所有用户';

wwv_flow_api.create_message (
  p_id=>197064908684154393 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_USERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上次';

wwv_flow_api.create_message (
  p_id=>197065015495154393 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'函数';

wwv_flow_api.create_message (
  p_id=>197065103958154393 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'索引';

wwv_flow_api.create_message (
  p_id=>197065221880154393 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INDEX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'包';

wwv_flow_api.create_message (
  p_id=>197065319594154393 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PACKAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'过程';

wwv_flow_api.create_message (
  p_id=>197065412351154394 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCEDURE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'序列';

wwv_flow_api.create_message (
  p_id=>197065504399154394 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SEQUENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message synonym
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'同义词';

wwv_flow_api.create_message (
  p_id=>197065624933154394 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SYNONYM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表';

wwv_flow_api.create_message (
  p_id=>197065729427154394 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'触发器';

wwv_flow_api.create_message (
  p_id=>197065828653154394 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'视图';

wwv_flow_api.create_message (
  p_id=>197065914303154394 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'插入';

wwv_flow_api.create_message (
  p_id=>197066030468154395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSERT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新';

wwv_flow_api.create_message (
  p_id=>197066111567154395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>197066212856154395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_in_data_dict
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不在数据字典中';

wwv_flow_api.create_message (
  p_id=>197066326386154395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_IN_DATA_DICT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新选项卡集';

wwv_flow_api.create_message (
  p_id=>197066416205154395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_TABSET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'非';

wwv_flow_api.create_message (
  p_id=>197066503080154395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑';

wwv_flow_api.create_message (
  p_id=>197066603915154396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MENU',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 查询';

wwv_flow_api.create_message (
  p_id=>197066725037154396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message structured_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'结构化查询';

wwv_flow_api.create_message (
  p_id=>197066831847154396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STRUCTURED_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function_body_returning_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回 SQL 查询的 PL/SQL 函数体';

wwv_flow_api.create_message (
  p_id=>197066902756154396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION_BODY_RETURNING_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 文本';

wwv_flow_api.create_message (
  p_id=>197067021697154396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message plsql_procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>197067104710154396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLSQL_PROCEDURE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message anonymous_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'匿名块';

wwv_flow_api.create_message (
  p_id=>197067229240154396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ANONYMOUS_BLOCK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message help_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'帮助文本';

wwv_flow_api.create_message (
  p_id=>197067323587154397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HELP_TEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message web_service_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web 服务结果';

wwv_flow_api.create_message (
  p_id=>197067415819154397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEB_SERVICE_RESULT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表';

wwv_flow_api.create_message (
  p_id=>197067505030154397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message simple
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'简单';

wwv_flow_api.create_message (
  p_id=>197067620781154397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIMPLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message escape_sc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'转义特殊字符';

wwv_flow_api.create_message (
  p_id=>197067711928154397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ESCAPE_SC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'带有快捷方式';

wwv_flow_api.create_message (
  p_id=>197067823459154397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WITH_SHORTCUTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可更新的报表';

wwv_flow_api.create_message (
  p_id=>197067914110154398 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATEABLE_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>197068003911154398 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'树';

wwv_flow_api.create_message (
  p_id=>197068117355154398 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TREE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列表';

wwv_flow_api.create_message (
  p_id=>197068214902154398 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'所有主题';

wwv_flow_api.create_message (
  p_id=>197068301223154398 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_THEMES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML';

wwv_flow_api.create_message (
  p_id=>197068423399154398 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message driven
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'驱动';

wwv_flow_api.create_message (
  p_id=>197068530542154399 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRIVEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图像';

wwv_flow_api.create_message (
  p_id=>197068603341154399 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无模板';

wwv_flow_api.create_message (
  p_id=>197068728637154399 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无项';

wwv_flow_api.create_message (
  p_id=>197068805850154399 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'弹出式值列表';

wwv_flow_api.create_message (
  p_id=>197068904255154399 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'POPUP_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message schemes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案';

wwv_flow_api.create_message (
  p_id=>197069028797154399 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SCHEMES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'快捷方式';

wwv_flow_api.create_message (
  p_id=>197069115613154400 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHORTCUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_page_as_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用页 %0 作为登录页。';

wwv_flow_api.create_message (
  p_id=>197069200296154400 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_PAGE_AS_LOGIN_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_new_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建新的登录页。';

wwv_flow_api.create_message (
  p_id=>197069331840154400 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_NEW_LOGIN_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_builtin_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'使用内置登录页。';

wwv_flow_api.create_message (
  p_id=>197069402831154400 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_BUILTIN_LOGIN_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区';

wwv_flow_api.create_message (
  p_id=>197069521885154400 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message core
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'核心';

wwv_flow_api.create_message (
  p_id=>197069600537154400 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CORE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_static_files
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'所有静态文件';

wwv_flow_api.create_message (
  p_id=>197069718642154401 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_STATIC_FILES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message associated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关联的';

wwv_flow_api.create_message (
  p_id=>197069806962154401 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ASSOCIATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1816 转换应用程序别名 p_flow_alias_or_id (%0) 时出现意外错误。';

wwv_flow_api.create_message (
  p_id=>197069901036154401 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_not_logged_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未登录。验证所需的 Cookie 缺失或无效。';

wwv_flow_api.create_message (
  p_id=>197070015881154401 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOT_LOGGED_IN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_click_to_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>单击<a href="%0">此处</a>可登录</a>';

wwv_flow_api.create_message (
  p_id=>197070100407154401 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLICK_TO_LOGIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-99900 无法创建唯一的会话 ID: %0';

wwv_flow_api.create_message (
  p_id=>197070215648154401 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_SESSION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_session_info_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1029 无法存储会话信息。会话=%0 项=%1';

wwv_flow_api.create_message (
  p_id=>197070322155154402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SESSION_INFO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_save_routine_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 保存例行程序时出现意外错误。';

wwv_flow_api.create_message (
  p_id=>197070424686154402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SAVE_ROUTINE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_deeplinking_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 make_deeplinking_item 会话=%0 中出现意外错误';

wwv_flow_api.create_message (
  p_id=>197070518088154402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DEEPLINKING_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1002 在应用程序 "%1" 中找不到项 "%0" 的项 ID。';

wwv_flow_api.create_message (
  p_id=>197070629965154402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'意外错误, 在应用程序级别或页级别上找不到项名。';

wwv_flow_api.create_message (
  p_id=>197070708491154402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1902 在 find_item_name 例行程序中项 ID 为空。';

wwv_flow_api.create_message (
  p_id=>197070818599154402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'意外错误';

wwv_flow_api.create_message (
  p_id=>197070914997154403 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNEXPECTED_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1802 找不到项 ID "%0"';

wwv_flow_api.create_message (
  p_id=>197071018839154403 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1082 执行授权方案代码时出错。';

wwv_flow_api.create_message (
  p_id=>197071124263154403 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AUTH_SCHEME_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_access_denied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 安全检查拒绝的访问';

wwv_flow_api.create_message (
  p_id=>197071201287154403 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ACCESS_DENIED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_first_page_data_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已在数据的第一页。';

wwv_flow_api.create_message (
  p_id=>197071309213154403 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIRST_PAGE_DATA_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 创建项 FSP_PROCESS_STATE_%0 时出现意外错误';

wwv_flow_api.create_message (
  p_id=>197071431338154403 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_ITEM_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1003 执行计算查询时出错。';

wwv_flow_api.create_message (
  p_id=>197071527268154404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_QUERY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1030 执行计算表达式时出错。';

wwv_flow_api.create_message (
  p_id=>197071618466154404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_EXP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_function_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 无法计算函数。computation_point=%0 computation_type=%1';

wwv_flow_api.create_message (
  p_id=>197071724141154404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_FUNCTION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_unknown_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 未知的计算类型。';

wwv_flow_api.create_message (
  p_id=>197071807987154404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_UNKNOWN_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_validation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1006 验证例行程序时出错。';

wwv_flow_api.create_message (
  p_id=>197071920135154404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VALIDATION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 无法运行 "返回文本的函数体" 验证。';

wwv_flow_api.create_message (
  p_id=>197072017495154404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_TEXT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_bool_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1021 无法运行 "返回布尔值的函数体" 验证。';

wwv_flow_api.create_message (
  p_id=>197072130141154404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_BOOL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_point_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1007 分支点不能为空: %0';

wwv_flow_api.create_message (
  p_id=>197072215048154405 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_POINT_NULL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1008 执行分支到页 %0 时出错。';

wwv_flow_api.create_message (
  p_id=>197072309398154405 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_PAGE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_accept_recur_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1010 已超过分支到页接受的处理递归限制值。%0';

wwv_flow_api.create_message (
  p_id=>197072406558154405 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ACCEPT_RECUR_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_funct_ret_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 无法处理分支到返回页的函数。';

wwv_flow_api.create_message (
  p_id=>197072502695154405 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_FUNCT_RET_PAGE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_func_returning_url_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 无法处理分支到返回 URL 的函数。';

wwv_flow_api.create_message (
  p_id=>197072603733154405 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_FUNC_RETURNING_URL_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1009 分支处理时出错。';

wwv_flow_api.create_message (
  p_id=>197072717106154406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sql_exp_heading_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1910 对标题文本中的 SQL 表达式求值时出错。';

wwv_flow_api.create_message (
  p_id=>197072816787154406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SQL_EXP_HEADING_TEXT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_eval_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1011 无效的求值类型: %0';

wwv_flow_api.create_message (
  p_id=>197072922378154406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EVAL_TYPE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197073014922154406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_g_flow_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 分配 G_FLOW_ID (%0) 时出现意外错误。';

wwv_flow_api.create_message (
  p_id=>197073112884154406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.G_FLOW_ID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1412 无法解析页别名 (%0)。';

wwv_flow_api.create_message (
  p_id=>197073209667154406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ALIAS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_call_to_show_from_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1430 不支持从页处理调用以显示: G_FLOW_STEP_ID (%0)。';

wwv_flow_api.create_message (
  p_id=>197073330560154406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CALL_TO_SHOW_FROM_PROC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7620 无法确定应用程序 (%0) 的工作区。';

wwv_flow_api.create_message (
  p_id=>197073429635154407 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'p_company 或 wwv_flow_company cookie 应包含应用程序所有者的安全组 ID。';

wwv_flow_api.create_message (
  p_id=>197073511175154407 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_FOOTER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 找不到应用程序。';

wwv_flow_api.create_message (
  p_id=>197073619511154407 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区信息';

wwv_flow_api.create_message (
  p_id=>197073718075154407 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.WORKSPACE_INFO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序=%0  工作区=%1';

wwv_flow_api.create_message (
  p_id=>197073825399154407 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_FOOTER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>197073904966154407 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_justification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'审批理由';

wwv_flow_api.create_message (
  p_id=>197074017983154408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.JUSTIFICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_login_server_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1555 未登录到 Oracle Login Server。未标识公共用户。';

wwv_flow_api.create_message (
  p_id=>197074131430154408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGIN_SERVER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'说明';

wwv_flow_api.create_message (
  p_id=>197074228581154408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DESCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'管理员信息';

wwv_flow_api.create_message (
  p_id=>197074313494154408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ADMIN_INFO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_first_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名';

wwv_flow_api.create_message (
  p_id=>197074419841154408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.FIRST_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_last_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'姓';

wwv_flow_api.create_message (
  p_id=>197074520089154408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.LAST_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'电子邮件';

wwv_flow_api.create_message (
  p_id=>197074601916154409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.EMAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'电话';

wwv_flow_api.create_message (
  p_id=>197074713541154409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.PHONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案信息';

wwv_flow_api.create_message (
  p_id=>197074815169154409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_INFO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重用现有方案';

wwv_flow_api.create_message (
  p_id=>197074923550154409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.REUSE_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是';

wwv_flow_api.create_message (
  p_id=>197075012681154409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.YES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'否';

wwv_flow_api.create_message (
  p_id=>197075131812154409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案名';

wwv_flow_api.create_message (
  p_id=>197075217906154410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1333 无法提取 ASFCOOKIE。';

wwv_flow_api.create_message (
  p_id=>197075300835154410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_db_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库大小';

wwv_flow_api.create_message (
  p_id=>197075429222154410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DB_SIZE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1201 在定制验证时未设置会话 ID。';

wwv_flow_api.create_message (
  p_id=>197075504161154410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页=%0';

wwv_flow_api.create_message (
  p_id=>197075612542154410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_FOOTER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请输入区分大小写的验证代码, 然后单击<b>提交请求</b>。';

wwv_flow_api.create_message (
  p_id=>197075730495154410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ACCEPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unsupp_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1444 不支持的验证方案。';

wwv_flow_api.create_message (
  p_id=>197075820641154411 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNSUPP_AUTH_SCHEME_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求预配新 %0。';

wwv_flow_api.create_message (
  p_id=>197075906857154411 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区信息';

wwv_flow_api.create_message (
  p_id=>197076023251154411 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.WORKSPACE_INFO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'名称';

wwv_flow_api.create_message (
  p_id=>197076119913154411 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'安全组 ID';

wwv_flow_api.create_message (
  p_id=>197076202283154411 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SGID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_system_assigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'系统指定的';

wwv_flow_api.create_message (
  p_id=>197076306877154411 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SYSTEM_ASSIGNED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'说明';

wwv_flow_api.create_message (
  p_id=>197076421806154412 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DESCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_inv_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 未找到应用程序。工作区无效。';

wwv_flow_api.create_message (
  p_id=>197076512438154412 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_INV_COMP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'管理员信息';

wwv_flow_api.create_message (
  p_id=>197076613698154412 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.ADMIN_INFO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_user_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户名';

wwv_flow_api.create_message (
  p_id=>197076731347154412 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.USER_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'电子邮件';

wwv_flow_api.create_message (
  p_id=>197076829612154412 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.EMAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标题';

wwv_flow_api.create_message (
  p_id=>197076901779154412 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序=%0 当前工作区=%1 请求的工作区=%2';

wwv_flow_api.create_message (
  p_id=>197077032160154413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_FOOTER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted_to_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'访问此应用程序将重定向到应用程序开发者, 请稍后重试。';

wwv_flow_api.create_message (
  p_id=>197077101423154413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED_TO_DEV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案信息';

wwv_flow_api.create_message (
  p_id=>197077231886154413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_INFO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对此应用程序的访问受到限制, 请稍后重试。';

wwv_flow_api.create_message (
  p_id=>197077314498154413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重用现有方案';

wwv_flow_api.create_message (
  p_id=>197077405029154413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.REUSE_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1181 无法在显示页时设置 VPD 安全上下文。';

wwv_flow_api.create_message (
  p_id=>197077532418154413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'是';

wwv_flow_api.create_message (
  p_id=>197077626572154414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.YES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1111 asfcookie 不能为空。';

wwv_flow_api.create_message (
  p_id=>197077725401154414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_NULL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'否';

wwv_flow_api.create_message (
  p_id=>197077804034154414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案名';

wwv_flow_api.create_message (
  p_id=>197077919491154414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_create_tblspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将创建表空间';

wwv_flow_api.create_message (
  p_id=>197078022621154414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.CREATE_TBLSPACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1016 找不到应用程序 "%0" 页 "%1" (请求的语言="%2")';

wwv_flow_api.create_message (
  p_id=>197078107896154414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_NOT_FND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_flow_xxx
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'FLOW_XXX';

wwv_flow_api.create_message (
  p_id=>197078229415154414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.FLOW_XXX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请与您的应用程序管理员联系。';

wwv_flow_api.create_message (
  p_id=>197078331596154415 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CONTACT_ADMIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_datafile
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表空间的数据文件';

wwv_flow_api.create_message (
  p_id=>197078415302154415 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DATAFILE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_required_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未启用所需的角色。';

wwv_flow_api.create_message (
  p_id=>197078511818154415 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.REQUIRED_ROLE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_logout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'注销';

wwv_flow_api.create_message (
  p_id=>197078624048154415 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGOUT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1013 用户 %0 没有执行所尝试操作的权限。需要角色 %1, 请与您的应用程序管理员联系。';

wwv_flow_api.create_message (
  p_id=>197078705334154415 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_clear_step_cache_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1018 清除步骤高速缓存时出错。';

wwv_flow_api.create_message (
  p_id=>197078815329154415 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLEAR_STEP_CACHE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_resolve_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1512 无法解析页别名 (%0)。';

wwv_flow_api.create_message (
  p_id=>197078913727154416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_RESOLVE_ALIAS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_on_accept_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7621 无法在接受应用程序时确定应用程序 (%0) 的工作区。';

wwv_flow_api.create_message (
  p_id=>197079018699154416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ON_ACCEPT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_comp_for_flow_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'p_company 或 wwv_flow_company cookie 应包含应用程序所有者的安全组 ID。';

wwv_flow_api.create_message (
  p_id=>197079132024154416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMP_FOR_FLOW_FOOTER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1182 无法在接受页时设置 VPD 安全上下文。';

wwv_flow_api.create_message (
  p_id=>197079228400154416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_insufficent_info_on_req_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-9988 为此请求提供的信息不足: 可能是由于未等待上一页完全加载造成的。请按浏览器的后退和重新加载按钮, 或导航到应用程序主页以继续操作。';

wwv_flow_api.create_message (
  p_id=>197079321991154416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.INSUFFICENT_INFO_ON_REQ_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_request_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序=%0 页=%1 请求=%2';

wwv_flow_api.create_message (
  p_id=>197079418285154416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_REQUEST_FOOTER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_save_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1022 无法保存属性。';

wwv_flow_api.create_message (
  p_id=>197079524541154417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_SAVE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1023 无法执行验证。';

wwv_flow_api.create_message (
  p_id=>197079629154154417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_VALID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_processing_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 无法执行处理。';

wwv_flow_api.create_message (
  p_id=>197079717842154417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_PROCESSING_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_to_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1777: 提供的页 %0 没有要分支到的页。请向您的应用程序管理员报告此错误。';

wwv_flow_api.create_message (
  p_id=>197079809013154417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_TO_BRANCH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_restart_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<a href="f?p=%0">重新启动应用程序</a>';

wwv_flow_api.create_message (
  p_id=>197079924485154417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.RESTART_APP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无可用的页帮助。';

wwv_flow_api.create_message (
  p_id=>197080022756154417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_HELP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1019 计算项默认值时出错: 页=%0 名称=%1。';

wwv_flow_api.create_message (
  p_id=>197080118087154418 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_VAL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_plsql_item_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1020 PLSQL 项处理 (函数) 中出现错误。';

wwv_flow_api.create_message (
  p_id=>197080223968154418 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.PLSQL_ITEM_PROC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1904 无法计算项默认值: 类型 = 函数体 computation_type= %0。';

wwv_flow_api.create_message (
  p_id=>197080301759154418 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_FUNC_BODY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_post_calc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1079“项计算后”计算出错。';

wwv_flow_api.create_message (
  p_id=>197080408747154418 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_POST_CALC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_spell_chk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'拼写检查';

wwv_flow_api.create_message (
  p_id=>197080504515154418 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.SPELL_CHK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 处理 PLSQL 表达式时出错。%0';

wwv_flow_api.create_message (
  p_id=>197080624431154419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序=%0 页=%1 SQLERRM=%2';

wwv_flow_api.create_message (
  p_id=>197080713891154419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_FOOTER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_func_return_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1101 无法处理返回查询的函数体。';

wwv_flow_api.create_message (
  p_id=>197080805889154419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FUNC_RETURN_QUERY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_proc_curr_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1108 无法处理项的当前条件。';

wwv_flow_api.create_message (
  p_id=>197080905683154419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PROC_CURR_COND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unable_set_short_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-2904 无法设置快捷方式值。';

wwv_flow_api.create_message (
  p_id=>197081026005154419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNABLE_SET_SHORT_VAL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_trees_root_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'警告: 找不到树根节点 ID "%0"。';

wwv_flow_api.create_message (
  p_id=>197081103188154419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREES.ROOT_NOT_FND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message v_alias_conversion_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 转换应用程序别名 (%0) 时出现意外错误。';

wwv_flow_api.create_message (
  p_id=>197081218190154419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'V.ALIAS_CONVERSION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序:';

wwv_flow_api.create_message (
  p_id=>197081310580154420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.APPLICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页:';

wwv_flow_api.create_message (
  p_id=>197081430246154420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_plsql_lines_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL %0 %1 包含 %2 行源代码。';

wwv_flow_api.create_message (
  p_id=>197081500727154420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PLSQL_LINES_SOURCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<span class="tiny">未找到页。</font>';

wwv_flow_api.create_message (
  p_id=>197081602537154420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_PAGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 <font size=-2>页</span>';

wwv_flow_api.create_message (
  p_id=>197081732618154420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_det_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 无法从 "declare function x return varchar2 is begin %0  return null; end; begin wwv_flow_utilities.g_query := x; end;" 确定值列表。';

wwv_flow_api.create_message (
  p_id=>197081827004154420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_DET_LOV_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_js_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不支持 JavaScript。';

wwv_flow_api.create_message (
  p_id=>197081915278154421 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.JS_NOT_SUPPORTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列表';

wwv_flow_api.create_message (
  p_id=>197082013023154421 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_unassigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'管理未分配项';

wwv_flow_api.create_message (
  p_id=>197082103454154421 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE_UNASSIGNED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'补充';

wwv_flow_api.create_message (
  p_id=>197082221419154421 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_split_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分离补充';

wwv_flow_api.create_message (
  p_id=>197082315737154421 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_triade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'三分';

wwv_flow_api.create_message (
  p_id=>197082425346154422 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TRIADE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_tetrade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'四分';

wwv_flow_api.create_message (
  p_id=>197082511708154422 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TETRADE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_analogic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模拟';

wwv_flow_api.create_message (
  p_id=>197082623079154422 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_ANALOGIC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_monotone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'单音';

wwv_flow_api.create_message (
  p_id=>197082706030154422 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_MONOTONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary_colors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'补充颜色';

wwv_flow_api.create_message (
  p_id=>197082809590154422 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fetch_value_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'fetch_value 中出现应用程序错误。';

wwv_flow_api.create_message (
  p_id=>197082909004154422 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FETCH_VALUE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_button_temp_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'提取按钮模板 ID=%0 时出错';

wwv_flow_api.create_message (
  p_id=>197083016820154422 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BUTTON_TEMP_FETCH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法跟踪: %0';

wwv_flow_api.create_message (
  p_id=>197083111255154423 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_TRACE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_set_timed_stat_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法设置 timed_statistics: %0';

wwv_flow_api.create_message (
  p_id=>197083216888154423 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_SET_TIMED_STAT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_available
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不可用的应用程序';

wwv_flow_api.create_message (
  p_id=>197083322704154423 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_AVAILABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_stop_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法停止跟踪: %0';

wwv_flow_api.create_message (
  p_id=>197083416527154423 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_STOP_TRACE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_view_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须提供应用程序和页才能查看帮助。';

wwv_flow_api.create_message (
  p_id=>197083506796154423 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VIEW_HELP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_not_disp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误: 由于尚未打开 HTML 表单, 因此不显示项 "%0"。';

wwv_flow_api.create_message (
  p_id=>197083629103154424 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_NOT_DISP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_unable_cast_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法将值 "%0" 转换为日期格式掩码 %1。';

wwv_flow_api.create_message (
  p_id=>197083730527154424 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.UNABLE_CAST_VALUE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑项 %0 - %1, 序列: %2';

wwv_flow_api.create_message (
  p_id=>197083824795154424 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.EDIT ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_reset_pag_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法重置区域页码。';

wwv_flow_api.create_message (
  p_id=>197083902386154424 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RESET_PAG_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_print_shortcut_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法打印快捷方式: %0';

wwv_flow_api.create_message (
  p_id=>197084025143154424 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PRINT_SHORTCUT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_render_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'呈现图表时出错: %0';

wwv_flow_api.create_message (
  p_id=>197084112128154425 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RENDER_CHART_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_debug
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'调试:';

wwv_flow_api.create_message (
  p_id=>197084232590154425 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.DEBUG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_feature_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此版本不支持的功能。';

wwv_flow_api.create_message (
  p_id=>197084317939154425 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FEATURE_NOT_SUPPORTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_request_for_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERROR 4322- 请求帮助所使用的语法不正确。在要求有效页码时请求为空值。';

wwv_flow_api.create_message (
  p_id=>197084413036154425 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.REQUEST_FOR_HELP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_help_request_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误 4323- 请求帮助未提供显示帮助的数字页 ID。';

wwv_flow_api.create_message (
  p_id=>197084520970154425 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.HELP_REQUEST_ERR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_init_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法初始化查询。';

wwv_flow_api.create_message (
  p_id=>197084612828154425 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_INIT_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_company_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区是必需的。';

wwv_flow_api.create_message (
  p_id=>197084732062154426 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.COMPANY_REQUIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_flow_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序是必需的。';

wwv_flow_api.create_message (
  p_id=>197084822644154426 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.FLOW_REQUIRED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的用户名 "%0" 或口令。';

wwv_flow_api.create_message (
  p_id=>197084905114154426 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行';

wwv_flow_api.create_message (
  p_id=>197085009252154426 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_ROWS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'坐标轴';

wwv_flow_api.create_message (
  p_id=>197085100512154426 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AXIS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_average
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'平均值';

wwv_flow_api.create_message (
  p_id=>197085204751154426 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AVERAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_sum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'总和';

wwv_flow_api.create_message (
  p_id=>197085306709154427 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_SUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_maximum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最大值';

wwv_flow_api.create_message (
  p_id=>197085412377154427 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MAXIMUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_minimum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最小值';

wwv_flow_api.create_message (
  p_id=>197085525507154427 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MINIMUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上次';

wwv_flow_api.create_message (
  p_id=>197085624611154427 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_LAST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_first
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'第一个';

wwv_flow_api.create_message (
  p_id=>197085710048154427 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_FIRST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_go
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'开始';

wwv_flow_api.create_message (
  p_id=>197085818803154427 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_GO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_chart_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的图表类型。';

wwv_flow_api.create_message (
  p_id=>197085919496154428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_CHART_TYPE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_sso_redirect_to_login_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正在重定向到用于验证的登录服务器...';

wwv_flow_api.create_message (
  p_id=>197086007554154428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_SSO.REDIRECT_TO_LOGIN_SERVER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_line_too_long
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行 %2 的行长度 %0 超出了最大值 %1';

wwv_flow_api.create_message (
  p_id=>197086102428154428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.LINE_TOO_LONG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选中此页上要包含的区域。如果您未在正确的应用程序上下文中或未拥有适当的权限, 则可能不显示选中的区域。';

wwv_flow_api.create_message (
  p_id=>197086231192154428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未找到此页的可定制区域。';

wwv_flow_api.create_message (
  p_id=>197086325633154428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关闭';

wwv_flow_api.create_message (
  p_id=>197086414591154428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CLOSE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用更改';

wwv_flow_api.create_message (
  p_id=>197086509222154429 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_APPLY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_cust_opt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页定制选项';

wwv_flow_api.create_message (
  p_id=>197086601989154429 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CUST_OPT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认值';

wwv_flow_api.create_message (
  p_id=>197086714289154429 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DEFAULT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_disp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示';

wwv_flow_api.create_message (
  p_id=>197086810674154429 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DISP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'隐藏';

wwv_flow_api.create_message (
  p_id=>197086912015154429 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_HIDDEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_func_body_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'语法分析错误: 函数体不能为空。';

wwv_flow_api.create_message (
  p_id=>197087002497154429 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.FUNC_BODY_NULL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'语法分析错误: %0';

wwv_flow_api.create_message (
  p_id=>197087122918154430 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.PARSE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_administration_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'取消';

wwv_flow_api.create_message (
  p_id=>197087205255154430 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMINISTRATION.DEPRECATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已清除 %0 个会话。';

wwv_flow_api.create_message (
  p_id=>197087302744154430 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_SESSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_dup_sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已清除 %0 个重复的会话。';

wwv_flow_api.create_message (
  p_id=>197087430531154430 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_DUP_SESSIONS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_obsolete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'废弃';

wwv_flow_api.create_message (
  p_id=>197087515669154430 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.OBSOLETE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_plsql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的 PL/SQL 表达式条件: %0';

wwv_flow_api.create_message (
  p_id=>197087619341154430 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_PLSQL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的函数体条件: %0';

wwv_flow_api.create_message (
  p_id=>197087717170154431 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_FUNC_BODY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_sql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的 SQL 表达式条件: %0';

wwv_flow_api.create_message (
  p_id=>197087800418154431 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_SQL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_exists_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存在的条件无效/条件不存在: %0';

wwv_flow_api.create_message (
  p_id=>197087902391154431 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_EXISTS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法生成弹出式值列表, 过滤器为: %0';

wwv_flow_api.create_message (
  p_id=>197088004990154431 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'生成查询 %0 时出错';

wwv_flow_api.create_message (
  p_id=>197088107380154431 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_QUERY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'初始化值列表时出错: %0 ';

wwv_flow_api.create_message (
  p_id=>197088216702154431 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_LOV_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法绑定 "%0"';

wwv_flow_api.create_message (
  p_id=>197088322788154432 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.UNABLE_TO_BIND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_disp_only_list_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误:“仅显示”值列表必须选择两列。';

wwv_flow_api.create_message (
  p_id=>197088423434154432 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.DISP_ONLY_LIST_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_auth_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'弹出式值列表验证失败。';

wwv_flow_api.create_message (
  p_id=>197088519260154432 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_AUTH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_check_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'弹出式值列表校验和验证失败。';

wwv_flow_api.create_message (
  p_id=>197088600749154432 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_CHECK_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法初始化查询。';

wwv_flow_api.create_message (
  p_id=>197088711087154432 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_QUERY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_checkbox_query_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对复选框查询进行求值时出错: %0';

wwv_flow_api.create_message (
  p_id=>197088821352154432 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CHECKBOX_QUERY_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_contains
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'包含';

wwv_flow_api.create_message (
  p_id=>197088910346154433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_CONTAINS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_regexp_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'匹配正则表达式';

wwv_flow_api.create_message (
  p_id=>197089016809154433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_REGEXP_LIKE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bold
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'粗体';

wwv_flow_api.create_message (
  p_id=>197089131713154433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BOLD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_italics
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'斜体';

wwv_flow_api.create_message (
  p_id=>197089202976154433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_ITALICS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_underline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下划线';

wwv_flow_api.create_message (
  p_id=>197089303354154433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_UNDERLINE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_no_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编号列表';

wwv_flow_api.create_message (
  p_id=>197089406263154433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_NO_LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bull_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项目符号列表';

wwv_flow_api.create_message (
  p_id=>197089516601154434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BULL_LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'左对齐';

wwv_flow_api.create_message (
  p_id=>197089603090154434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_LEFT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_cen
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'居中对齐';

wwv_flow_api.create_message (
  p_id=>197089709121154434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_CEN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_rt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'右对齐';

wwv_flow_api.create_message (
  p_id=>197089814490154434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_RT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'向左缩进';

wwv_flow_api.create_message (
  p_id=>197089918915154434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_LEFT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'向右缩进';

wwv_flow_api.create_message (
  p_id=>197090003275154434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_RIGHT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_email_address
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Express 帐户的新电子邮件地址。';

wwv_flow_api.create_message (
  p_id=>197090121035154434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_EMAIL_ADDRESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_worksheet_show_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'呈现报表时出错: %0';

wwv_flow_api.create_message (
  p_id=>197090212281154435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WORKSHEET.SHOW_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用以下过程创建 PL/SQL 包 %0:'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197090315511154435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_CREATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示说明';

wwv_flow_api.create_message (
  p_id=>197090415625154435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_SPEC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'隐藏说明';

wwv_flow_api.create_message (
  p_id=>197090506195154435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_SPEC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'显示正文';

wwv_flow_api.create_message (
  p_id=>197090603022154435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'隐藏正文';

wwv_flow_api.create_message (
  p_id=>197090710772154436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下载说明';

wwv_flow_api.create_message (
  p_id=>197090817548154436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_SPEC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下载正文';

wwv_flow_api.create_message (
  p_id=>197090931555154436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_subprogram
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'子程序';

wwv_flow_api.create_message (
  p_id=>197091009105154436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SUBPROGRAM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'说明';

wwv_flow_api.create_message (
  p_id=>197091131197154436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESCRIPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用于将数据插入 %0, 需要提供主键';

wwv_flow_api.create_message (
  p_id=>197091227423154436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用于更新由主键标识的 %0 中的数据';

wwv_flow_api.create_message (
  p_id=>197091324302154436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用于基于主键删除 %0 中的数据';

wwv_flow_api.create_message (
  p_id=>197091406180154437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC3',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用于基于主键检索 %0 中的数据';

wwv_flow_api.create_message (
  p_id=>197091509715154437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 应用程序 %0 的表 API, 生成时间 %1';

wwv_flow_api.create_message (
  p_id=>197091604711154437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_COMMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_column_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有列信息可用。';

wwv_flow_api.create_message (
  p_id=>197091725611154437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_COLUMN_INFO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url_prohibited
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请求的 URL 已禁止。请与管理员联系。';

wwv_flow_api.create_message (
  p_id=>197091821311154437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL_PROHIBITED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 正文';

wwv_flow_api.create_message (
  p_id=>197091901076154437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_help_invalid_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的项 ID: %0 ';

wwv_flow_api.create_message (
  p_id=>197092028140154438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM_HELP.INVALID_ITEM_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p_valid_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须指定有效的页码, 例如 p?n=1234。';

wwv_flow_api.create_message (
  p_id=>197092111059154438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P.VALID_PAGE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模板名 %0 已存在。请输入新名称。';

wwv_flow_api.create_message (
  p_id=>197092204895154438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_ALREADY_EXISTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求创建具有以下属性的交互报表页。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197092306387154438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message htmlwithshortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'带有快捷方式的 HTML';

wwv_flow_api.create_message (
  p_id=>197092409573154438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTMLWITHSHORTCUTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message print_server_not_configured
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'目前不能使用报表打印, 没有配置打印服务器。';

wwv_flow_api.create_message (
  p_id=>197092505757154439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PRINT SERVER NOT CONFIGURED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列表模板';

wwv_flow_api.create_message (
  p_id=>197092620074154439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST_TEMPLATES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions_list_template_override
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域列表模板覆盖';

wwv_flow_api.create_message (
  p_id=>197092711993154439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS_LIST_TEMPLATE_OVERRIDE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regioin_references
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'区域引用';

wwv_flow_api.create_message (
  p_id=>197092819785154439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIOIN_REFERENCES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_max_row_cnt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'此查询返回的行数超过了 %0, 请过滤数据以确保获得完整结果。';

wwv_flow_api.create_message (
  p_id=>197092926233154439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MAX_ROW_CNT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_doesnot_contain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不包含';

wwv_flow_api.create_message (
  p_id=>197093031846154439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'位于最后';

wwv_flow_api.create_message (
  p_id=>197093112284154440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_IN_LAST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_isnot_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不位于最后';

wwv_flow_api.create_message (
  p_id=>197093224978154440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_mins
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分钟';

wwv_flow_api.create_message (
  p_id=>197093320075154440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MINS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'小时';

wwv_flow_api.create_message (
  p_id=>197093403419154440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_HOURS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'天';

wwv_flow_api.create_message (
  p_id=>197093531805154440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_DAYS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'周';

wwv_flow_api.create_message (
  p_id=>197093611988154440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_WEEKS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_months
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'月';

wwv_flow_api.create_message (
  p_id=>197093723497154440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MONTHS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_years
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'年';

wwv_flow_api.create_message (
  p_id=>197093808006154441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_YEARS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message interactive_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'交互报表';

wwv_flow_api.create_message (
  p_id=>197093914567154441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERACTIVE_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'与';

wwv_flow_api.create_message (
  p_id=>197094021887154441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p33_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'生成维护应用程序';

wwv_flow_api.create_message (
  p_id=>197094119703154441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P33_BREADCRUMB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'生成应用程序';

wwv_flow_api.create_message (
  p_id=>197094215039154441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_BREADCRUMB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加约束条件';

wwv_flow_api.create_message (
  p_id=>197094321893154442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADD_CONSTRAINT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建索引';

wwv_flow_api.create_message (
  p_id=>197094421361154442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_INDEX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_app_defs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序默认值';

wwv_flow_api.create_message (
  p_id=>197094513121154442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_APP_DEFS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p24_save_to_worksheet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'保存到工作表';

wwv_flow_api.create_message (
  p_id=>197094609260154442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P24_SAVE_TO_WORKSHEET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wksp_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区 ID 无效。';

wwv_flow_api.create_message (
  p_id=>197094716900154442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WKSP_ID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_wkspc_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到工作区。';

wwv_flow_api.create_message (
  p_id=>197094816319154442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_WKSPC_NOT_FOUND',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_loading_data
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正在加载数据...';

wwv_flow_api.create_message (
  p_id=>197094931769154443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.LOADING_DATA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_waiting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'正在加载数据。请稍候。';

wwv_flow_api.create_message (
  p_id=>197095003368154443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.WAITING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户 %0 对 %1 方案不具有权限。';

wwv_flow_api.create_message (
  p_id=>197095104618154443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_plan_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已创建计划表, 以便于解释计划语句';

wwv_flow_api.create_message (
  p_id=>197095209413154443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_PLAN_TABLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_error_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在第 %0 行出错: %1';

wwv_flow_api.create_message (
  p_id=>197095315763154443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ERROR_MSG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'数据库中不存在方案 "%0"。请与工作区管理员联系, 以为您设置正确的默认方案。';

wwv_flow_api.create_message (
  p_id=>197095412846154443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_insert_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'将脚本插入文件表时出错。';

wwv_flow_api.create_message (
  p_id=>197095502454154443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.INSERT_SCRIPT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_parse_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对脚本进行语法分析时出错。';

wwv_flow_api.create_message (
  p_id=>197095609324154444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.PARSE_SCRIPT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建脚本文件错误。';

wwv_flow_api.create_message (
  p_id=>197095725118154444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_SCRIPT_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_not_implemented
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'尚未实施。';

wwv_flow_api.create_message (
  p_id=>197095812426154444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NOT_IMPLEMENTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_product_build
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'产品版本:';

wwv_flow_api.create_message (
  p_id=>197095920184154444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.PRODUCT_BUILD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_schema_compatibility
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'方案兼容性:';

wwv_flow_api.create_message (
  p_id=>197096021179154444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.SCHEMA_COMPATIBILITY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_last_ddl_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上一 DDL 的时间:';

wwv_flow_api.create_message (
  p_id=>197096103973154444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LAST_DDL_TIME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_host_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'主机方案:';

wwv_flow_api.create_message (
  p_id=>197096208321154445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.HOST_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_application_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序所有者:';

wwv_flow_api.create_message (
  p_id=>197096315699154445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.APPLICATION_OWNER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区 ID:';

wwv_flow_api.create_message (
  p_id=>197096429345154445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_ID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区名称:';

wwv_flow_api.create_message (
  p_id=>197096525894154445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前用户:';

wwv_flow_api.create_message (
  p_id=>197096616320154445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_language_preference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'语言首选项:';

wwv_flow_api.create_message (
  p_id=>197096705681154446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LANGUAGE_PREFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_time_on_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'当前时间 (在服务器上):';

wwv_flow_api.create_message (
  p_id=>197096800257154446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_TIME_ON_SERVER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_add_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加成员错误。';

wwv_flow_api.create_message (
  p_id=>197096928017154446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ADD_MEMBER_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_update_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新成员错误。';

wwv_flow_api.create_message (
  p_id=>197097014338154446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.UPDATE_MEMBER_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建脚本时出错。';

wwv_flow_api.create_message (
  p_id=>197097102534154446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'portal_sso_redirect 中出现错误: 缺失应用程序注册信息:';

wwv_flow_api.create_message (
  p_id=>197097214847154447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请按照安装指南注册此应用程序。';

wwv_flow_api.create_message (
  p_id=>197097324228154447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_redir_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法将 portal_sso_redirect 过程作为合作伙伴应用程序名称为 %1 的方案 %0 运行。';

wwv_flow_api.create_message (
  p_id=>197097419974154447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.REDIR_ERR1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 过程的非法调用者:';

wwv_flow_api.create_message (
  p_id=>197097522281154447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR1',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message please_contact_administrator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请与管理员联系。';

wwv_flow_api.create_message (
  p_id=>197097601162154447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLEASE_CONTACT_ADMINISTRATOR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'确定 %0 的调用者时出错';

wwv_flow_api.create_message (
  p_id=>197097701733154447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_invalid_app_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'urlc 标记中的应用程序会话无效: %0';

wwv_flow_api.create_message (
  p_id=>197097801200154448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.INVALID_APP_SESSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_generic_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 中出现错误';

wwv_flow_api.create_message (
  p_id=>197097931343154448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_bad_urlc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'由 sso 返回的 %1 标记中的 %0 非法。';

wwv_flow_api.create_message (
  p_id=>197098028714154448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.BAD_URLC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法将 %0 过程作为合作伙伴应用程序名称为 %2 的方案 %1 运行';

wwv_flow_api.create_message (
  p_id=>197098132480154448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PARSE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unknown_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误: 未知的快捷方式类型。';

wwv_flow_api.create_message (
  p_id=>197098200126154448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNKNOWN_TYPE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_add_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加单词';

wwv_flow_api.create_message (
  p_id=>197098311402154448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ADD_WORD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_word_added
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已将 %0 添加到您的字典中。';

wwv_flow_api.create_message (
  p_id=>197098412555154449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.WORD_ADDED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_dup_word_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在字典中已存在 %0。';

wwv_flow_api.create_message (
  p_id=>197098500386154449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.DUP_WORD_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'完成';

wwv_flow_api.create_message (
  p_id=>197098614126154449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_DONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'取消';

wwv_flow_api.create_message (
  p_id=>197098710240154449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_CANCEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_apply_changes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用更改';

wwv_flow_api.create_message (
  p_id=>197098817995154449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_APPLY_CHANGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_add_to_dictionary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加到字典';

wwv_flow_api.create_message (
  p_id=>197098900118154449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_ADD_TO_DICTIONARY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_pick_a_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选取单词 A';

wwv_flow_api.create_message (
  p_id=>197099014254154450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.PICK_A_WORD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_enter_new_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请输入新单词。';

wwv_flow_api.create_message (
  p_id=>197099130095154450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ENTER_NEW_WORD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_tree_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'意外错误 %0';

wwv_flow_api.create_message (
  p_id=>197099213952154450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREE.UNEXPECTED_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_window_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'计算器';

wwv_flow_api.create_message (
  p_id=>197099321950154450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.WINDOW_TITLE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'取消';

wwv_flow_api.create_message (
  p_id=>197099405700154450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.CANCEL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'完成';

wwv_flow_api.create_message (
  p_id=>197099514624154450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.DONE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_flow_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未选择应用程序。';

wwv_flow_api.create_message (
  p_id=>197099603725154451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_FLOW_SELECTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message vertical
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'垂直';

wwv_flow_api.create_message (
  p_id=>197099711221154451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VERTICAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message horizontal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'水平';

wwv_flow_api.create_message (
  p_id=>197099818686154451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HORIZONTAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户名';

wwv_flow_api.create_message (
  p_id=>197099915402154451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_USERNAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_user_api_t_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'电子邮件';

wwv_flow_api.create_message (
  p_id=>197100003751154451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_USER_API.T_EMAIL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_password
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令';

wwv_flow_api.create_message (
  p_id=>197100131012154451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PASSWORD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_privilege
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'权限';

wwv_flow_api.create_message (
  p_id=>197100200092154452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PRIVILEGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已加载 %0 个用户。';

wwv_flow_api.create_message (
  p_id=>197100312618154452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_MESSAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑';

wwv_flow_api.create_message (
  p_id=>197100412707154452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197100510947154452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_max_rows_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败: 要显示的最大行数必须大于零。';

wwv_flow_api.create_message (
  p_id=>197100618492154452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MAX_ROWS_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_invalid_col_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在查询中定义的列数无效, 此区域类型需要 %0 列';

wwv_flow_api.create_message (
  p_id=>197100727936154453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.INVALID_COL_NUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“轴最大值”必须大于“轴最小值”。';

wwv_flow_api.create_message (
  p_id=>197100831362154453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_bar_width_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败: 条宽度必须大于零。';

wwv_flow_api.create_message (
  p_id=>197100923153154453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.BAR_WIDTH_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:轴间隔必须大于零。';

wwv_flow_api.create_message (
  p_id=>197101032007154453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“轴最小值”必须大于或等于零。';

wwv_flow_api.create_message (
  p_id=>197101104205154453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“轴最大值”必须大于零。';

wwv_flow_api.create_message (
  p_id=>197101213375154453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_invalid_no_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无效的查询, 找不到 select 语句';

wwv_flow_api.create_message (
  p_id=>197101311222154453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY.INVALID_NO_SELECT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_gaps_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“条间距” 必须大于或等于零。';

wwv_flow_api.create_message (
  p_id=>197101424858154454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.GAPS_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“Y 轴最大值”必须大于轴最小值。';

wwv_flow_api.create_message (
  p_id=>197101524426154454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败: X 轴间隔必须大于零。';

wwv_flow_api.create_message (
  p_id=>197101604055154454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败: Y 轴间隔必须大于零。';

wwv_flow_api.create_message (
  p_id=>197101711511154454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“X 轴最小值”必须大于或等于零。';

wwv_flow_api.create_message (
  p_id=>197101824183154454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“Y 轴最小值”必须大于或等于零。';

wwv_flow_api.create_message (
  p_id=>197101917003154454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“X 轴最大值”必须大于零。';

wwv_flow_api.create_message (
  p_id=>197102019610154455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证失败:“Y 轴最大值”必须大于零。';

wwv_flow_api.create_message (
  p_id=>197102122010154455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_get_color_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法获取颜色: %0';

wwv_flow_api.create_message (
  p_id=>197102216557154455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_GET_COLOR_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_func_ret_sql_qry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回 SQL 查询的函数: 无法在应用程序构建器内对查询进行语法分析。%0';

wwv_flow_api.create_message (
  p_id=>197102311189154455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FUNC_RET_SQL_QRY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'语法分析错误: %0 ';

wwv_flow_api.create_message (
  p_id=>197102422193154455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.PARSE_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_fetch_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'提取错误: %0';

wwv_flow_api.create_message (
  p_id=>197102501052154455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FETCH_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_calc_graph_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法计算图形占有者位置: %0';

wwv_flow_api.create_message (
  p_id=>197102629445154456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_CALC_GRAPH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_svg_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG 图表错误: %0';

wwv_flow_api.create_message (
  p_id=>197102724220154456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.SVG_CHART_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_more_data_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找到更多数据, 但是显示的值不能超过 30 个。';

wwv_flow_api.create_message (
  p_id=>197102802033154456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MORE_DATA_FND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'顶部';

wwv_flow_api.create_message (
  p_id=>197102903056154456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_TOP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'底部';

wwv_flow_api.create_message (
  p_id=>197103003822154456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_BOTTOM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_up
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'向上';

wwv_flow_api.create_message (
  p_id=>197103121473154457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_UP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'向下';

wwv_flow_api.create_message (
  p_id=>197103230431154457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_DOWN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'移动';

wwv_flow_api.create_message (
  p_id=>197103316090154457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'全部移动';

wwv_flow_api.create_message (
  p_id=>197103418091154457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE_ALL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除';

wwv_flow_api.create_message (
  p_id=>197103514154154457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'全部删除';

wwv_flow_api.create_message (
  p_id=>197103600003154457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE_ALL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重置';

wwv_flow_api.create_message (
  p_id=>197103732716154458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_RESET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_unable_fnd_userid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在 cookie %0 中找不到 USERID';

wwv_flow_api.create_message (
  p_id=>197103830779154458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.UNABLE_FND_USERID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_exception
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'异常错误';

wwv_flow_api.create_message (
  p_id=>197103914979154458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.EXCEPTION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误: %0';

wwv_flow_api.create_message (
  p_id=>197104030066154458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_invalid_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ASFCOOKIE 无效, 请重新登录您的应用程序。';

wwv_flow_api.create_message (
  p_id=>197104117215154458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.INVALID_COOKIE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_creating_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建工作区';

wwv_flow_api.create_message (
  p_id=>197104229833154458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CREATING_WORKSPACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下一页';

wwv_flow_api.create_message (
  p_id=>197104314645154459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下一个集';

wwv_flow_api.create_message (
  p_id=>197104408342154459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上一页';

wwv_flow_api.create_message (
  p_id=>197104505748154459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上一个集';

wwv_flow_api.create_message (
  p_id=>197104618133154459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS_SET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户名或口令无效, 或 cookie 已到期, 请重新登录。';

wwv_flow_api.create_message (
  p_id=>197104727236154459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS_COOKIE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_from_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查询 %1 中的 %0';

wwv_flow_api.create_message (
  p_id=>197104800577154459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FROM_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_in_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查询 %1 中的 %0 ';

wwv_flow_api.create_message (
  p_id=>197104902540154460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.IN_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_fetch_cal_cursor_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从日历游标 %0 提取时出错';

wwv_flow_api.create_message (
  p_id=>197105002146154460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FETCH_CAL_CURSOR_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_no_sgid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未设置安全组 ID (工作区标识)。';

wwv_flow_api.create_message (
  p_id=>197105106926154460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.NO_SGID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行 wwv_flow_copy %0 >> %1 时出错';

wwv_flow_api.create_message (
  p_id=>197105231986154460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.EXECUTION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_button_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行 wwv_flow_copy_button %0 >> %1 时出错';

wwv_flow_api.create_message (
  p_id=>197105306949154460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_BUTTON.EXECUTION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_item_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行 wwv_flow_copy_page_item %0 >> %1 时出错';

wwv_flow_api.create_message (
  p_id=>197105403169154460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE_ITEM.EXECUTION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'值列表 ID "%0" 不是数字。';

wwv_flow_api.create_message (
  p_id=>197105511778154461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NUMERIC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未找到值列表 ID "%0"。';

wwv_flow_api.create_message (
  p_id=>197105621862154461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NOT_FOUND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行 wwv_flow_copy_lov %0 时出错';

wwv_flow_api.create_message (
  p_id=>197105731127154461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.EXECUTION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_unable_to_find_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到要复制的快捷方式 (%0)。';

wwv_flow_api.create_message (
  p_id=>197105828701154461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.UNABLE_TO_FIND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作区 %0 已创建, 并且确认电子邮件已在 %2 发送到 %1。';

wwv_flow_api.create_message (
  p_id=>197105923806154461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message return_to_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回到 %0 登录页';

wwv_flow_api.create_message (
  p_id=>197106013667154461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RETURN_TO_LOGIN_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_disable_work_prov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已临时禁用工作区创建操作。';

wwv_flow_api.create_message (
  p_id=>197106117135154461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.DISABLE.WORK.PROV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加约束条件 %0';

wwv_flow_api.create_message (
  p_id=>197106223401154462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ADD_CONSTRAINT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message created_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建日期';

wwv_flow_api.create_message (
  p_id=>197106330476154462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATED_ON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新时间';

wwv_flow_api.create_message (
  p_id=>197106407360154462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED_ON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行排序';

wwv_flow_api.create_message (
  p_id=>197106504747154462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_ORDER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_as_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在 %0';

wwv_flow_api.create_message (
  p_id=>197106632071154462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AS_OF',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_min_ago
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 分钟之前';

wwv_flow_api.create_message (
  p_id=>197106706175154463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MIN_AGO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_format_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'格式掩码';

wwv_flow_api.create_message (
  p_id=>197106827833154463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FORMAT_MASK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'计算';

wwv_flow_api.create_message (
  p_id=>197106900054154463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPUTATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_choose_download_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选择报表下载格式';

wwv_flow_api.create_message (
  p_id=>197107004314154463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_frm_nav_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法计算表单导航。%0';

wwv_flow_api.create_message (
  p_id=>197107105609154463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_FRM_NAV_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_report_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&lt; 报表视图';

wwv_flow_api.create_message (
  p_id=>197107231089154463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REPORT_VIEW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'第 %0 行, 共 %1 行';

wwv_flow_api.create_message (
  p_id=>197107327173154463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_OF',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 错误。%1';

wwv_flow_api.create_message (
  p_id=>197107430350154464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'验证 %0 错误: %1';

wwv_flow_api.create_message (
  p_id=>197107507679154464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.VERIFY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建页) 时出错: %0 ';

wwv_flow_api.create_message (
  p_id=>197107619912154464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PAGE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_pg_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建页模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197107709778154464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PG_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建字段模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197107811653154464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_FIELD_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_create_rpt_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建报表模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197107916688154465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW.CREATE_RPT_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建区域模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108003424154465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_REGION_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建列表模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108130295154465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_LIST_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建面包屑模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108214661154465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_MENU_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_popup_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建弹出式值列表模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108326658154465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_POPUP_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_standard_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建标准选项卡) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108408426154465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_STANDARD_TABS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_compute_tab_target_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (计算选项卡目标) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108523662154466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COMPUTE_TAB_TARGET_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_parent_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (创建父选项卡) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108616289154466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PARENT_TABS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_page_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制页模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108727950154466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_PAGE_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制字段模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197108806327154466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_FIELD_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_report_templates_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制报表模板) 时出错: %0 ';

wwv_flow_api.create_message (
  p_id=>197108910535154466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REPORT_TEMPLATES_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制区域模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197109027365154466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REGION_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制列表模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197109122398154467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LIST_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制面包屑模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197109229051154467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_MENU_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_button_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制按钮模板) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197109325162154467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_BUTTON_TEMPLATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制导航栏) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197109423621154467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_NAVBAR_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制值列表) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197109529542154467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LOV_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_security_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制安全方案) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197109610083154467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_SECURITY_SCHEME_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_crypt_key_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关键字必须是 8, 16 或 24 字节。';

wwv_flow_api.create_message (
  p_id=>197109723599154468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CRYPT.KEY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_css_api_unable_to_remove_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除 css: %0';

wwv_flow_api.create_message (
  p_id=>197109814984154468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CSS_API.UNABLE_TO_REMOVE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_debugtab_biu_fer_invalid_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日期格式无效。';

wwv_flow_api.create_message (
  p_id=>197109917407154468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DEBUGTAB_BIU_FER.INVALID_DATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法绑定 %0, 请检查项的长度是否超过 30 字节。使用 v() 语法可引用长度超过 30 字节的项。%1';

wwv_flow_api.create_message (
  p_id=>197110017242154468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.UNABLE_TO_BIND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message run_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'仅运行';

wwv_flow_api.create_message (
  p_id=>197110108827154468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RUN_ONLY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wizapi_delete_checked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除选定项';

wwv_flow_api.create_message (
  p_id=>197110210481154468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WIZAPI_DELETE_CHECKED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_olb_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forms 对象库 XML 文件名';

wwv_flow_api.create_message (
  p_id=>197110302570154469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_OLB_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authorization_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制授权方案) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197110420121154469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHORIZATION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authentication_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建应用程序 (复制验证方案) 时出错: %0';

wwv_flow_api.create_message (
  p_id=>197110503100154469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHENTICATION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cannot_determine_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误, 无法确定具有指定安全组 ID 和应用程序别名的应用程序。';

wwv_flow_api.create_message (
  p_id=>197110612910154469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CANNOT_DETERMINE_FLOW_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_convert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序别名 "%0" 无法转换为唯一的应用程序 ID。';

wwv_flow_api.create_message (
  p_id=>197110723555154469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_CONVERT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_exist_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'别名 "%0" 不存在。';

wwv_flow_api.create_message (
  p_id=>197110822637154469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_EXIST_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_home_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法定向到主页。';

wwv_flow_api.create_message (
  p_id=>197110905767154470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_HOME_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_update_sub_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'update_substitution_cache 中出现错误: %0';

wwv_flow_api.create_message (
  p_id=>197111029956154470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UPDATE_SUB_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DML 中出现错误: p_rowid=%0, p_alt_rowid=%1, p_rowid2=%2, p_alt_rowid2=%3。%4';

wwv_flow_api.create_message (
  p_id=>197111102949154470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unable_proc_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法处理 wwv_flow_conditions 中的条件类型 "%0"。';

wwv_flow_api.create_message (
  p_id=>197111231309154470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNABLE_PROC_COND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_conditions 中出现意外错误。函数应返回一些值。';

wwv_flow_api.create_message (
  p_id=>197111325649154470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNEXPECTED_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_rows_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有要处理的行';

wwv_flow_api.create_message (
  p_id=>197111406522154470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_ROWS_TO_PROCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_owner_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未指定表所有者';

wwv_flow_api.create_message (
  p_id=>197111521470154471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_OWNER_NOT_SPECIFIED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_name_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未指定表名';

wwv_flow_api.create_message (
  p_id=>197111601564154471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_NAME_NOT_SPECIFIED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_prim_key_col_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未指定主键列';

wwv_flow_api.create_message (
  p_id=>197111731308154471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.PRIM_KEY_COL_NOT_SPECIFIED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_fcs_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'校验和列 ("FCS") 是必需的, 但未提供';

wwv_flow_api.create_message (
  p_id=>197111825412154471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.FCS_MISSING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_invalid_prim_key_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标识的主键列不在查询的选择列表中';

wwv_flow_api.create_message (
  p_id=>197111903570154471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.INVALID_PRIM_KEY_COL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_prim_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未提供主键值, 至少必须提供一行才能进行更新';

wwv_flow_api.create_message (
  p_id=>197112019130154471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_PRIM_KEY_VALS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_cal_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法订阅日历模板。%0';

wwv_flow_api.create_message (
  p_id=>197112106596154471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_CAL_TEMPLATE_REFERENCE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_cal_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法发布日历模板。%0';

wwv_flow_api.create_message (
  p_id=>197112225779154472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_CAL_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message autocommit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'提交语句不适用。所有语句都自动提交。';

wwv_flow_api.create_message (
  p_id=>197112325941154472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTOCOMMIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rollback
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'回退语句不适用。所有语句都自动提交。';

wwv_flow_api.create_message (
  p_id=>197112406866154472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROLLBACK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p254_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须至少指定一个要创建的区域。';

wwv_flow_api.create_message (
  p_id=>197112520345154472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P254.VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须至少指定一个要创建的页。';

wwv_flow_api.create_message (
  p_id=>197112609052154472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P295.VALIDATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_sec_key_col_not_in_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标识的次级键列不在查询的选择列表中';

wwv_flow_api.create_message (
  p_id=>197112719108154473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_sec_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'没有为标识的次级键列提供次级键列值';

wwv_flow_api.create_message (
  p_id=>197112800480154473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_SEC_KEY_VALS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日历列。';

wwv_flow_api.create_message (
  p_id=>197112906077154473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR_COLUMN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_menu_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'菜单';

wwv_flow_api.create_message (
  p_id=>197113014534154473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_MENU_FILE_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error_in_mru
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'MRU 中出现错误: 行= %0, %1, %2';

wwv_flow_api.create_message (
  p_id=>197113107972154473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR_IN_MRU',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_lost_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在用户开始更新过程以后, 数据库中数据的当前版本已经更改。当前校验和 = "%0", 项校验和 = "%1"。';

wwv_flow_api.create_message (
  p_id=>197113221377154473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.LOST_UPDATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_job_unauthorized_attempt_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在未授权的情况下尝试通过方案 %1 在应用程序 %2 中运行作业 %0';

wwv_flow_api.create_message (
  p_id=>197113312561154473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_JOB.UNAUTHORIZED_ATTEMPT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_bg_select_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'弹出式值列表必须以 "select" 开头。';

wwv_flow_api.create_message (
  p_id=>197113415191154474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_BG_SELECT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'初始化弹出式值列表时出错: %0 %1';

wwv_flow_api.create_message (
  p_id=>197113521918154474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_INIT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'初始化弹出式值列表时出错, 过滤器为: %0 %1';

wwv_flow_api.create_message (
  p_id=>197113600255154474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_INIT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_popup_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'生成弹出式值列表时出错: %0 %1';

wwv_flow_api.create_message (
  p_id=>197113731260154474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_POPUP_LOV_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类型组合框的项 %0 没有查询。';

wwv_flow_api.create_message (
  p_id=>197113831617154474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_NO_QUERY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_js_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类型组合框 w/js 的项 %0 的重定向没有查询。';

wwv_flow_api.create_message (
  p_id=>197113901146154474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_JS_NO_QUERY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类型组合框 w/URL 的项 %0 的重定向没有查询。';

wwv_flow_api.create_message (
  p_id=>197114024861154475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类型组合框 w/URL 的项 %0 重定向到没有查询的页。';

wwv_flow_api.create_message (
  p_id=>197114130445154475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_PAGE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_package_invalid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误, 包名 %0 无效或已被使用。';

wwv_flow_api.create_message (
  p_id=>197114224872154475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.PACKAGE_INVALID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_prog_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'程序单元';

wwv_flow_api.create_message (
  p_id=>197114309499154475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_PROG_FILE_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generic_attr_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197114422047154475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERIC_ATTR.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_olb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'尝试上载到 Forms 移植项目的文件不是有效的对象库 (_olb.XML) 文件。只能上载由 Oracle Forms 附带的 Form2XML 转换工具生成的对象库 XML 文件。';

wwv_flow_api.create_message (
  p_id=>197114522898154476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_OLB_CONTENT_INVALID',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197114630039154476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法更新导航栏显示条件类型。%0';

wwv_flow_api.create_message (
  p_id=>197114731866154476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_NAVBAR_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法在只提供条件类型时更新应用程序处理。%0';

wwv_flow_api.create_message (
  p_id=>197114832285154476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_PROC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法更新应用程序计算类型。%0';

wwv_flow_api.create_message (
  p_id=>197114910552154476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_COMP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_subtitle_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法更新页子标题类型。%0';

wwv_flow_api.create_message (
  p_id=>197115025636154476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_SUBTITLE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_button_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法更新页按钮条件类型。%0';

wwv_flow_api.create_message (
  p_id=>197115126885154476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_BUTTON_COND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_branch_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法更新页分支条件类型。%0';

wwv_flow_api.create_message (
  p_id=>197115222922154477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.BRANCH_COND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法更新页计算类型。%0';

wwv_flow_api.create_message (
  p_id=>197115326213154477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_COMP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法更新页验证类型。%0';

wwv_flow_api.create_message (
  p_id=>197115400737154477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_VALID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法更新页处理类型。%0';

wwv_flow_api.create_message (
  p_id=>197115504538154477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_PROC_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_misspell_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新拼错的单词时出错。%0';

wwv_flow_api.create_message (
  p_id=>197115605120154477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_MISSPELL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法绑定 %0, 请检查项的长度是否超过 30 字节。使用 v() 语法可引用长度超过 30 字节的项。%1';

wwv_flow_api.create_message (
  p_id=>197115717395154477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.UNABLE_TO_BIND_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_convert_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1711 无法转换请求中的弹出式 lov ID。';

wwv_flow_api.create_message (
  p_id=>197115809861154478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.CONVERT_ID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1721 在请求中找不到弹出式 lov ID 的项。';

wwv_flow_api.create_message (
  p_id=>197115912928154478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.FIND_ITEM_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'drop_tablespace 错误, p_name 为空。';

wwv_flow_api.create_message (
  p_id=>197116023374154478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_TABLESPACE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除表空间。错误: %0 \nsql:\n %1';

wwv_flow_api.create_message (
  p_id=>197116121806154478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_TABLESPACE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'drop_user 没有 l_username, 因此出现错误。';

wwv_flow_api.create_message (
  p_id=>197116222105154478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_USER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除用户。错误: %0 \nsql:\n %1';

wwv_flow_api.create_message (
  p_id=>197116300454154478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_USER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_with_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误: %0 %1';

wwv_flow_api.create_message (
  p_id=>197116428868154479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.WITH_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建用户。 %0';

wwv_flow_api.create_message (
  p_id=>197116519057154479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_USER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建表空间。%0';

wwv_flow_api.create_message (
  p_id=>197116609958154479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_TABLESPACE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_grant_privs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法授予初始权限 %0';

wwv_flow_api.create_message (
  p_id=>197116727486154479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_GRANT_PRIVS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_remove_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'remove_provisioned_company 中出现错误。工作区为空。';

wwv_flow_api.create_message (
  p_id=>197116824765154479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.REMOVE_COMPANY_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表已创建。';

wwv_flow_api.create_message (
  p_id=>197116906429154479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'视图已创建。';

wwv_flow_api.create_message (
  p_id=>197117018719154480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197117107323154480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'触发器已创建';

wwv_flow_api.create_message (
  p_id=>197117203182154480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'函数已创建。';

wwv_flow_api.create_message (
  p_id=>197117310970154480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'过程已创建。';

wwv_flow_api.create_message (
  p_id=>197117406603154480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_body_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已创建包主体。';

wwv_flow_api.create_message (
  p_id=>197117507594154480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_BODY_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'程序包已创建。';

wwv_flow_api.create_message (
  p_id=>197117629167154481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'索引已创建。';

wwv_flow_api.create_message (
  p_id=>197117728690154481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类型已创建。';

wwv_flow_api.create_message (
  p_id=>197117815670154481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户已创建。';

wwv_flow_api.create_message (
  p_id=>197117929742154481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已创建实体化视图。';

wwv_flow_api.create_message (
  p_id=>197118024200154481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'角色已创建。';

wwv_flow_api.create_message (
  p_id=>197118129098154481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'序列已创建。';

wwv_flow_api.create_message (
  p_id=>197118204888154482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'同义词已创建。';

wwv_flow_api.create_message (
  p_id=>197118302848154482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cmd_executed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已执行命令。';

wwv_flow_api.create_message (
  p_id=>197118430525154482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CMD_EXECUTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_table_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'由于 SQL 语法无效导致表创建失败。';

wwv_flow_api.create_message (
  p_id=>197118515875154482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.TABLE_CREATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 行已更新。';

wwv_flow_api.create_message (
  p_id=>197118603782154482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_UPDATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_inserted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已插入 %0 行。';

wwv_flow_api.create_message (
  p_id=>197118723525154482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_INSERTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_package_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'由于 SQL 语法无效导致包创建失败。';

wwv_flow_api.create_message (
  p_id=>197118817308154483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.PACKAGE_CREATE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已删除 %0 行。';

wwv_flow_api.create_message (
  p_id=>197118919761154483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_DELETED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197119016279154483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_fetch_fnd_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法提取 fnd 用户信息。 %0';

wwv_flow_api.create_message (
  p_id=>197119105297154483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.FETCH_FND_USER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_delete_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除开发者角色时出错。%0';

wwv_flow_api.create_message (
  p_id=>197119209925154483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.DELETE_DEV_ROLE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_user_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户 %0 没有 %1 方案的权限。';

wwv_flow_api.create_message (
  p_id=>197119314459154483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.USER_NO_PRIV_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_updatable_report_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对可更新报表进行语法分析时出错: %0';

wwv_flow_api.create_message (
  p_id=>197119405529154484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.UPDATABLE_REPORT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表已删除。';

wwv_flow_api.create_message (
  p_id=>197119514363154484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'程序包已删除。';

wwv_flow_api.create_message (
  p_id=>197119629371154484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户已删除。';

wwv_flow_api.create_message (
  p_id=>197119724851154484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'视图已删除。';

wwv_flow_api.create_message (
  p_id=>197119811893154484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_execution_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行 wwv_flow_copy_page %0 >> %1 时出错';

wwv_flow_api.create_message (
  p_id=>197119929185154484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE.EXECUTION_PAGE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'序列已删除。';

wwv_flow_api.create_message (
  p_id=>197120000491154485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表已更改。';

wwv_flow_api.create_message (
  p_id=>197120125110154485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dataload_xml_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197120213984154485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATALOAD_XML.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'函数已删除。';

wwv_flow_api.create_message (
  p_id=>197120307583154485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'过程已删除。';

wwv_flow_api.create_message (
  p_id=>197120400763154485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_credentials_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未授权访问 (未设置 wwv_flow_api.set_credentials)。';

wwv_flow_api.create_message (
  p_id=>197120527079154485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.CREDENTIALS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除开发者角色时出错。%0';

wwv_flow_api.create_message (
  p_id=>197120610948154486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.DEV_ROLE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'索引已删除。';

wwv_flow_api.create_message (
  p_id=>197120714571154486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'实体化视图已删除。';

wwv_flow_api.create_message (
  p_id=>197120825300154486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'角色已删除。';

wwv_flow_api.create_message (
  p_id=>197120922024154486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'同义词已删除。';

wwv_flow_api.create_message (
  p_id=>197121001390154486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'触发器已删除。';

wwv_flow_api.create_message (
  p_id=>197121116691154486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类型已删除。';

wwv_flow_api.create_message (
  p_id=>197121200242154487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'索引类型已删除。';

wwv_flow_api.create_message (
  p_id=>197121312314154487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_context_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上下文已删除。';

wwv_flow_api.create_message (
  p_id=>197121409464154487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CONTEXT_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已删除数据库链接。';

wwv_flow_api.create_message (
  p_id=>197121513562154487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.DATABASE_LINK_DROPPED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已创建数据库链接。';

wwv_flow_api.create_message (
  p_id=>197121606635154487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.DATABASE_LINK_CREATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_renamed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表已重命名。';

wwv_flow_api.create_message (
  p_id=>197121725494154487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_RENAMED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'视图已变更。';

wwv_flow_api.create_message (
  p_id=>197121830137154488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'类型已变更。';

wwv_flow_api.create_message (
  p_id=>197121914095154488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'触发器已更改';

wwv_flow_api.create_message (
  p_id=>197122005182154488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'索引类型已改变。';

wwv_flow_api.create_message (
  p_id=>197122119627154488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_truncated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表被截断。';

wwv_flow_api.create_message (
  p_id=>197122211372154488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_TRUNCATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cluster_truncated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'簇已截断。';

wwv_flow_api.create_message (
  p_id=>197122303823154489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CLUSTER_TRUNCATED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_package_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'程序包已变更。';

wwv_flow_api.create_message (
  p_id=>197122407007154489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PACKAGE_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'函数已更改。';

wwv_flow_api.create_message (
  p_id=>197122531129154489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'过程已更改。';

wwv_flow_api.create_message (
  p_id=>197122607390154489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'序列已更改。';

wwv_flow_api.create_message (
  p_id=>197122700605154489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户已更改。';

wwv_flow_api.create_message (
  p_id=>197122813567154489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_ALTERED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message test
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'测试';

wwv_flow_api.create_message (
  p_id=>197122915214154490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEST',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message up
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'向上';

wwv_flow_api.create_message (
  p_id=>197123030940154490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_query_heading_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'获取查询标题时出错: %0';

wwv_flow_api.create_message (
  p_id=>197123117472154490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.QUERY_HEADING_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_column_value_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'提取列值时出错: %0';

wwv_flow_api.create_message (
  p_id=>197123215520154490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.COLUMN_VALUE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_hint_remove_table_hint_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在没有 p_table_id 的情况下调用 remove_table_hint, 必须提供表。';

wwv_flow_api.create_message (
  p_id=>197123325089154490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HINT.REMOVE_TABLE_HINT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_hint_create_normalize_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建规范化错误: %0';

wwv_flow_api.create_message (
  p_id=>197123400860154490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HINT.CREATE_NORMALIZE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197123529885154491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_find_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到文件: %0';

wwv_flow_api.create_message (
  p_id=>197123629018154491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.FIND_FILE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_find_data_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'查找数据类型错误: %0';

wwv_flow_api.create_message (
  p_id=>197123716172154491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.FIND_DATA_TYPE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_get_max_col_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'获取最大列长度错误 1: %0';

wwv_flow_api.create_message (
  p_id=>197123801003154491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.GET_MAX_COL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_get_datatype_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'获取数据类型错误: %0';

wwv_flow_api.create_message (
  p_id=>197123928309154491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.GET_DATATYPE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_collection_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法创建集合: %0';

wwv_flow_api.create_message (
  p_id=>197124000487154491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.COLLECTION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_load_csv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'加载 csv 数据错误:';

wwv_flow_api.create_message (
  p_id=>197124119789154492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.LOAD_CSV_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_run_ddl_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Excel 加载运行 ddl 错误: %0 %1';

wwv_flow_api.create_message (
  p_id=>197124201622154492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.RUN_DDL_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_table_info_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法获取表信息。l_line=%0 %1';

wwv_flow_api.create_message (
  p_id=>197124324000154492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.TABLE_INFO_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_load_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'加载 excel 数据错误: %0';

wwv_flow_api.create_message (
  p_id=>197124417142154492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.LOAD_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_lookup_tables_privs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'用户 %0 没有 %1 方案的权限。';

wwv_flow_api.create_message (
  p_id=>197124505375154492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOOKUP_TABLES.PRIVS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_find_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法找到文件。 %0';

wwv_flow_api.create_message (
  p_id=>197124612956154492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.FIND_FILE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_unable_get_code_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法获取代码块: %0';

wwv_flow_api.create_message (
  p_id=>197124723371154493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.UNABLE_GET_CODE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_get_statement_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法获取语句: %0';

wwv_flow_api.create_message (
  p_id=>197124831662154493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.GET_STATEMENT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_save_parameter_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法将参数保存到数据库: %0';

wwv_flow_api.create_message (
  p_id=>197124911798154493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.SAVE_PARAMETER_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_validate_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法验证文件 "%0"。%1';

wwv_flow_api.create_message (
  p_id=>197125018708154493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.VALIDATE_FILE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_check_code_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法检查是否已对代码进行语法分析: %0';

wwv_flow_api.create_message (
  p_id=>197125102671154493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CHECK_CODE_PARSE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_control_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行控制文件: %0';

wwv_flow_api.create_message (
  p_id=>197125229824154493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CONTROL_FILE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_run_code_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行代码: %0';

wwv_flow_api.create_message (
  p_id=>197125330681154494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.RUN_CODE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_bulk_collect_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法成批收集: %0';

wwv_flow_api.create_message (
  p_id=>197125403803154494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.BULK_COLLECT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_run_statement_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法运行语句: %0';

wwv_flow_api.create_message (
  p_id=>197125529427154494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.RUN_STATEMENT_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_package_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'警告: 创建的包体带有编译错误。';

wwv_flow_api.create_message (
  p_id=>197125613361154494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.PACKAGE_COMP_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未成功执行语句: %0';

wwv_flow_api.create_message (
  p_id=>197125725731154494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.EXECUTION_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_delete_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法删除已经过语法分析的信息: %0';

wwv_flow_api.create_message (
  p_id=>197125813953154494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.DELETE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_control_file_stats_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法检查控制文件统计信息: %0';

wwv_flow_api.create_message (
  p_id=>197125905315154495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CONTROL_FILE_STATS_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_public_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无法对文件进行语法分析。%0';

wwv_flow_api.create_message (
  p_id=>197126005928154495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER_PUBLIC.PARSE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_series_attr_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'错误';

wwv_flow_api.create_message (
  p_id=>197126129692154495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SERIES_ATTR.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_sgid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须设置安全组 ID。';

wwv_flow_api.create_message (
  p_id=>197126204339154495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.SGID_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_old_tabset_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到选项卡 ID = %0 的旧选项卡集。';

wwv_flow_api.create_message (
  p_id=>197126328881154495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.OLD_TABSET_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_new_tabset_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'找不到父选项卡 ID = %0 的新选项卡集。';

wwv_flow_api.create_message (
  p_id=>197126411509154495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.NEW_TABSET_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页 ID: %0 不是数字。';

wwv_flow_api.create_message (
  p_id=>197126514804154496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.PAGE_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_spec_new_tabset_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'必须为选项卡 ID = %0 指定新的选项卡集。';

wwv_flow_api.create_message (
  p_id=>197126604780154496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.SPEC_NEW_TABSET_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_update_not_supported_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不支持更新 %0。';

wwv_flow_api.create_message (
  p_id=>197126700813154496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UPDATE_NOT_SUPPORTED_ERR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message easy_report_invalid_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加的条件已造成查询无效。';

wwv_flow_api.create_message (
  p_id=>197126802083154496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EASY_REPORT.INVALID_CONDITION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认: 垂直报表, 外观 2 (不含空列)';

wwv_flow_api.create_message (
  p_id=>197126902689154496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME4',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认: 垂直报表, 外观 2 (包含空列)';

wwv_flow_api.create_message (
  p_id=>197127031000154496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME5',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认值: 外观 3';

wwv_flow_api.create_message (
  p_id=>197127127232154497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME13',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'默认值: 外观 4';

wwv_flow_api.create_message (
  p_id=>197127227712154497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME14',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parsing_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对方案进行语法分析';

wwv_flow_api.create_message (
  p_id=>197127311226154497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARSING_SCHEMA',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_change_interactive_rpt_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求更改交互报表查询。如果将列添加到查询, 则在报表运行时不显示这些列。您将需要使用“操作”菜单, 然后选择列或单击<b>重置</b>。如果删除查询中的任何列, 则将禁用现有的过滤器, 突出显示规则以及引用这些列的其他报表设置。请确认您的请求。';

wwv_flow_api.create_message (
  p_id=>197127407240154497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_removed_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已删除列';

wwv_flow_api.create_message (
  p_id=>197127514350154498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REMOVED_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_new_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新建列';

wwv_flow_api.create_message (
  p_id=>197127601578154498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NEW_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_view_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表/视图所有者';

wwv_flow_api.create_message (
  p_id=>197127709427154498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_VIEW_OWNER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_view_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'表/视图名';

wwv_flow_api.create_message (
  p_id=>197127814557154498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_VIEW_NAME',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message close_window
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'关闭窗口';

wwv_flow_api.create_message (
  p_id=>197127909931154498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CLOSE_WINDOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_all_page_definition_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑所有页定义属性';

wwv_flow_api.create_message (
  p_id=>197128006811154499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页眉文本';

wwv_flow_api.create_message (
  p_id=>197128102170154499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HEADER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message footer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'页脚文本';

wwv_flow_api.create_message (
  p_id=>197128215918154499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FOOTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message on_load
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'加载时';

wwv_flow_api.create_message (
  p_id=>197128312605154499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ON_LOAD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 标头';

wwv_flow_api.create_message (
  p_id=>197128422264154500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_HEADER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message define_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'定义值列表';

wwv_flow_api.create_message (
  p_id=>197128522578154500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEFINE_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_dynamic_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建动态值列表';

wwv_flow_api.create_message (
  p_id=>197128627836154500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_DYNAMIC_LOV',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_updated_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'更新者';

wwv_flow_api.create_message (
  p_id=>197128718036154500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_UPDATED_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_created_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'创建者';

wwv_flow_api.create_message (
  p_id=>197128812374154500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_CREATED_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_stored_procedure_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'存储过程所有者';

wwv_flow_api.create_message (
  p_id=>197128922832154500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STORED_PROCEDURE_OWNER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message compile_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已成功编译 PL/SQL 代码 (%0)';

wwv_flow_api.create_message (
  p_id=>197129020696154501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPILE_SUCCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message compile_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编译失败, 行 <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1';

wwv_flow_api.create_message (
  p_id=>197129106022154501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPILE_FAILURE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您请求运行的脚本包含 SQL 工作室将忽略的语句。请确认请求。';

wwv_flow_api.create_message (
  p_id=>197129231949154501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_WARNING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'块';

wwv_flow_api.create_message (
  p_id=>197129331027154501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_BLOCK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_canvas
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'画布';

wwv_flow_api.create_message (
  p_id=>197129426003154501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_CANVAS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_objectlibrarytab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对象库选项卡';

wwv_flow_api.create_message (
  p_id=>197129514958154501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_OBJECTLIBRARYTAB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_programunit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'程序单元';

wwv_flow_api.create_message (
  p_id=>197129613058154502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_PROGRAMUNIT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_propertyclass
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'属性类';

wwv_flow_api.create_message (
  p_id=>197129707816154502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_PROPERTYCLASS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_visualattribute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'视觉属性';

wwv_flow_api.create_message (
  p_id=>197129827622154502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_VISUALATTRIBUTE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_window
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'窗口';

wwv_flow_api.create_message (
  p_id=>197129907719154502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_WINDOW',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项';

wwv_flow_api.create_message (
  p_id=>197130031727154502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_ITEM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_objectgroup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对象组';

wwv_flow_api.create_message (
  p_id=>197130132573154502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_OBJECTGROUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_graphics
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图形';

wwv_flow_api.create_message (
  p_id=>197130216930154503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_GRAPHICS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_empty
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您请求运行的脚本不包含任何可运行的语句。';

wwv_flow_api.create_message (
  p_id=>197130303076154503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_EMPTY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset_pagination
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重置页码';

wwv_flow_api.create_message (
  p_id=>197130400758154503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET_PAGINATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message redirect_to_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重定向到页 %0';

wwv_flow_api.create_message (
  p_id=>197130523460154503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REDIRECT_TO_PAGE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message redirect_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重定向到 %0';

wwv_flow_api.create_message (
  p_id=>197130618331154503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REDIRECT_TO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditional
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'有条件';

wwv_flow_api.create_message (
  p_id=>197130712883154503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONAL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'从不';

wwv_flow_api.create_message (
  p_id=>197130812326154504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT_NEVER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_assignment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'静态分配';

wwv_flow_api.create_message (
  p_id=>197130914348154504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_ASSIGNMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL 函数体';

wwv_flow_api.create_message (
  p_id=>197131006289154504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION_BODY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_expression
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 表达式';

wwv_flow_api.create_message (
  p_id=>197131129747154504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_EXPRESSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message plsql_expression
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PLSQL 表达式';

wwv_flow_api.create_message (
  p_id=>197131214540154504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLSQL_EXPRESSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'项值';

wwv_flow_api.create_message (
  p_id=>197131329116154504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_VALUE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_session_state_protection_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'会话状态保护违规: 这可能是因为手动变更了包含校验和的 URL, 或者使用了具有不正确的或缺失校验和的链接。如果您不确定导致此错误的原因, 请与应用程序管理员联系, 以获取帮助。';

wwv_flow_api.create_message (
  p_id=>197131411871154505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SESSION_STATE_PROTECTION_VIOLATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_blocks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'块';

wwv_flow_api.create_message (
  p_id=>197131531410154505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_BLOCKS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_coordinates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'坐标';

wwv_flow_api.create_message (
  p_id=>197131612862154505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_COORDINATES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_programunits
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'程序单元';

wwv_flow_api.create_message (
  p_id=>197131719248154505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_PROGRAMUNITS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_recgrps
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'记录组';

wwv_flow_api.create_message (
  p_id=>197131812263154505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_RECGRPS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_windows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'窗口';

wwv_flow_api.create_message (
  p_id=>197131917194154505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_WINDOWS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_visualattributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'视觉属性';

wwv_flow_api.create_message (
  p_id=>197132004836154506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_VISUALATTRIBUTES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_triggers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'触发器';

wwv_flow_api.create_message (
  p_id=>197132119351154506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_TRIGGERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_alerts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'预警';

wwv_flow_api.create_message (
  p_id=>197132232316154506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_ALERTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_editor
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑器';

wwv_flow_api.create_message (
  p_id=>197132309949154506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_EDITOR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_page_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'编辑页属性';

wwv_flow_api.create_message (
  p_id=>197132419847154506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_PAGE_ATTRIBUTES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message must_not_be_public_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不能是公共用户';

wwv_flow_api.create_message (
  p_id=>197132503468154506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MUST_NOT_BE_PUBLIC_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_110_drop_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除数据库用户: %0';

wwv_flow_api.create_message (
  p_id=>197132618834154507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_110_DROP_USERS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_110_drop_tablespaces
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除表空间和关联的数据文件: %0';

wwv_flow_api.create_message (
  p_id=>197132706095154507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_110_DROP_TABLESPACES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message qb_create_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'请输入有效查询以查看结果';

wwv_flow_api.create_message (
  p_id=>197132829406154507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QB_CREATE_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_46_ret_to_qry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回原始查询';

wwv_flow_api.create_message (
  p_id=>197132922805154507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_46_RET_TO_QRY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list_utilization
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'列表使用情况';

wwv_flow_api.create_message (
  p_id=>197133014947154507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST_UTILIZATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_w_argument
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'非 %0';

wwv_flow_api.create_message (
  p_id=>197133103812154507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_W_ARGUMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_script_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'脚本大小 (字节)';

wwv_flow_api.create_message (
  p_id=>197133201366154508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_SCRIPT_SIZE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_on_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在 %0 由 %1';

wwv_flow_api.create_message (
  p_id=>197133309433154508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_ON_BY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unsupported_data_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不支持的数据类型';

wwv_flow_api.create_message (
  p_id=>197133431459154508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNSUPPORTED_DATA_TYPE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_use_app_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'应用程序默认值';

wwv_flow_api.create_message (
  p_id=>197133526426154508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.USE_APP_TEMPLATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_analysis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'分析';

wwv_flow_api.create_message (
  p_id=>197133627426154508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_ANALYSIS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'添加';

wwv_flow_api.create_message (
  p_id=>197133723206154509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ADD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_remove_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除聚集';

wwv_flow_api.create_message (
  p_id=>197133811431154509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REMOVE_AGGREGATE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_reports
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表';

wwv_flow_api.create_message (
  p_id=>197133908905154509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_REPORTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_charts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表';

wwv_flow_api.create_message (
  p_id=>197134010883154509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_CHARTS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_sum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'总和';

wwv_flow_api.create_message (
  p_id=>197134131523154509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_SUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_avg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'平均值';

wwv_flow_api.create_message (
  p_id=>197134205777154509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_AVG',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_max
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最大值';

wwv_flow_api.create_message (
  p_id=>197134321562154510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_MAX',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_min
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'最小值';

wwv_flow_api.create_message (
  p_id=>197134423641154510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_MIN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_median
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'中值';

wwv_flow_api.create_message (
  p_id=>197134531954154510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_MEDIAN',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'模式';

wwv_flow_api.create_message (
  p_id=>197134605887154510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_MODE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&gt;';

wwv_flow_api.create_message (
  p_id=>197134710756154510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&lt;';

wwv_flow_api.create_message (
  p_id=>197134800235154510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PREVIOUS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error_in_mrd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'执行多行删除操作时出错: 行= %0, %1, %2';

wwv_flow_api.create_message (
  p_id=>197134900585154511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR_IN_MRD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'多行操作失败';

wwv_flow_api.create_message (
  p_id=>197135009780154511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_attached_library
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'附加库';

wwv_flow_api.create_message (
  p_id=>197135122221154511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_ATTACHED_LIBRARY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'菜单';

wwv_flow_api.create_message (
  p_id=>197135208947154511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_MENU',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_object_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'对象组';

wwv_flow_api.create_message (
  p_id=>197135317329154511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_OBJECT_GROUP',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_used
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0% 已使用';

wwv_flow_api.create_message (
  p_id=>197135429958154512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.USED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_working_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'工作报表';

wwv_flow_api.create_message (
  p_id=>197135521248154512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_WORKING_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表';

wwv_flow_api.create_message (
  p_id=>197135629933154512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'图表';

wwv_flow_api.create_message (
  p_id=>197135718303154512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'日历';

wwv_flow_api.create_message (
  p_id=>197135829641154512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CALENDAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_unknown_statement
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未知语句';

wwv_flow_api.create_message (
  p_id=>197135913226154512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.UNKNOWN_STATEMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑';

wwv_flow_api.create_message (
  p_id=>197136021665154513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BREADCRUMB',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message breadcrumbs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'面包屑';

wwv_flow_api.create_message (
  p_id=>197136118034154513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BREADCRUMBS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'全部';

wwv_flow_api.create_message (
  p_id=>197136219836154513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ALL',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_go
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'开始';

wwv_flow_api.create_message (
  p_id=>197136304763154513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_GO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'选择列';

wwv_flow_api.create_message (
  p_id=>197136424815154513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_COLUMNS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_filter
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'过滤器';

wwv_flow_api.create_message (
  p_id=>197136522222154513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FILTER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'排序';

wwv_flow_api.create_message (
  p_id=>197136609011154514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'突出显示';

wwv_flow_api.create_message (
  p_id=>197136717338154514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_flashback
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'闪回';

wwv_flow_api.create_message (
  p_id=>197136803547154514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FLASHBACK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_compute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'计算';

wwv_flow_api.create_message (
  p_id=>197136915063154514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPUTE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_download
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下载';

wwv_flow_api.create_message (
  p_id=>197137005060154514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DOWNLOAD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'保存报表';

wwv_flow_api.create_message (
  p_id=>197137121416154514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE_REPORT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'重置';

wwv_flow_api.create_message (
  p_id=>197137225305154515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RESET',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_standard_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'标准';

wwv_flow_api.create_message (
  p_id=>197137328304154515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STANDARD_CALENDAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_partial_refresh_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'部分页刷新';

wwv_flow_api.create_message (
  p_id=>197137423477154515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_canceling
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'取消';

wwv_flow_api.create_message (
  p_id=>197137502968154515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.CANCELING',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save_as_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'另存为默认值';

wwv_flow_api.create_message (
  p_id=>197137620314154515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE_AS_DEFAULT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_enhanced_qry_note
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'集成增强查询。';

wwv_flow_api.create_message (
  p_id=>197137720661154515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ENHANCED_QRY_NOTE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete_checked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'删除选定项';

wwv_flow_api.create_message (
  p_id=>197137806502154516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE_CHECKED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_aggregation_defined
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未定义聚集。';

wwv_flow_api.create_message (
  p_id=>197137930318154516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_AGGREGATION_DEFINED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_computation_defined
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'未定义计算。';

wwv_flow_api.create_message (
  p_id=>197138016790154516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_COMPUTATION_DEFINED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_create_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 为表 "%0" 创建过程';

wwv_flow_api.create_message (
  p_id=>197138100758154516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_CREATE_COMMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_update_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 为表 "%0" 更新过程';

wwv_flow_api.create_message (
  p_id=>197138200379154516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_UPDATE_COMMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_delete_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 为表 "%0" 删除过程';

wwv_flow_api.create_message (
  p_id=>197138308982154517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_DELETE_COMMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_get_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 为表 "%0" 获取过程';

wwv_flow_api.create_message (
  p_id=>197138427548154517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_GET_COMMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_md5_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 为表 "%0" 构建 MD5 函数';

wwv_flow_api.create_message (
  p_id=>197138523926154517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_MD5_COMMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_pkg_body_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 程序包体';

wwv_flow_api.create_message (
  p_id=>197138603980154517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_PKG_BODY_COMMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_pkg_spec_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 程序包说明';

wwv_flow_api.create_message (
  p_id=>197138708231154517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_PKG_SPEC_COMMENT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p77_original_qry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'原始查询';

wwv_flow_api.create_message (
  p_id=>197138825240154517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P77_ORIGINAL_QRY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message qb_new_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>您已选择创建新的查询, 此操作将丢失对当前查询所做的所有未保存的更改。</p><b>是否继续?</b>';

wwv_flow_api.create_message (
  p_id=>197138904484154518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QB_NEW_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_text_contains
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'行文本包含';

wwv_flow_api.create_message (
  p_id=>197139032528154518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_TEXT_CONTAINS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_in_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'在下';

wwv_flow_api.create_message (
  p_id=>197139127833154518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_IN_NEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_isnot_in_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不在下';

wwv_flow_api.create_message (
  p_id=>197139201125154518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_navigation_bar_icon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'导航栏图标';

wwv_flow_api.create_message (
  p_id=>197139322425154518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.NAVIGATION_BAR_ICON',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message restricted_no_set_from_browser
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'限制 - 不能从浏览器设置';

wwv_flow_api.create_message (
  p_id=>197139406279154518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESTRICTED_NO_SET_FROM_BROWSER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unrestricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无限制';

wwv_flow_api.create_message (
  p_id=>197139523172154519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNRESTRICTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message checksum_required_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'需要校验和 - 应用程序级别';

wwv_flow_api.create_message (
  p_id=>197139620307154519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECKSUM_REQUIRED_WORKSPACE',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message checksum_required_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'需要校验和 - 用户级别';

wwv_flow_api.create_message (
  p_id=>197139717554154519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECKSUM_REQUIRED_USER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message checksum_required_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'需要校验和 - 会话级别';

wwv_flow_api.create_message (
  p_id=>197139807912154519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECKSUM_REQUIRED_SESSION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不更新页';

wwv_flow_api.create_message (
  p_id=>197139907482154519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_PAGES',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_application_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不更新应用程序项';

wwv_flow_api.create_message (
  p_id=>197140006202154519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_data_entry_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不更新数据条目项';

wwv_flow_api.create_message (
  p_id=>197140108750154520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_display_only_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不更新仅显示项';

wwv_flow_api.create_message (
  p_id=>197140226954154520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DO_NOT_UPDATE_PAGE_ITEMS';

wwv_flow_api.create_message (
  p_id=>197140300806154520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO NOT UPDATE PAGE ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message arguments_must_have_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'参数必须具有校验和';

wwv_flow_api.create_message (
  p_id=>197140419135154520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_arguments_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不允许使用参数';

wwv_flow_api.create_message (
  p_id=>197140526315154520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_ARGUMENTS_ALLOWED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_url_access
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无 URL 访问权限';

wwv_flow_api.create_message (
  p_id=>197140629910154521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_URL_ACCESS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_last_x_years
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'过去 %0 年';

wwv_flow_api.create_message (
  p_id=>197140704870154521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LAST_X_YEARS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_last_year
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'去年';

wwv_flow_api.create_message (
  p_id=>197140808166154521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LAST_YEAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_last_month
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上个月';

wwv_flow_api.create_message (
  p_id=>197140910333154521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LAST_MONTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_last_week
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'上周';

wwv_flow_api.create_message (
  p_id=>197141031468154521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LAST_WEEK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_last_x_days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'前 %0 天';

wwv_flow_api.create_message (
  p_id=>197141102853154521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LAST_X_DAYS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_last_day
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'前 1 天';

wwv_flow_api.create_message (
  p_id=>197141230424154522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LAST_DAY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_last_x_hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'前 %0 小时';

wwv_flow_api.create_message (
  p_id=>197141309903154522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LAST_X_HOURS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_last_hour
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'前 1 小时';

wwv_flow_api.create_message (
  p_id=>197141422420154522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LAST_HOUR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'不更新页项';

wwv_flow_api.create_message (
  p_id=>197141532188154522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_PAGE_ITEMS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next_hour
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下一小时';

wwv_flow_api.create_message (
  p_id=>197141615351154522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT_HOUR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next_x_hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下 %0 小时';

wwv_flow_api.create_message (
  p_id=>197141718654154523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT_X_HOURS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next_day
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下一天';

wwv_flow_api.create_message (
  p_id=>197141819496154523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT_DAY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next_x_days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下 %0 天';

wwv_flow_api.create_message (
  p_id=>197141901675154523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT_X_DAYS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next_week
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下周';

wwv_flow_api.create_message (
  p_id=>197142002592154523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT_WEEK',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next_month
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下个月';

wwv_flow_api.create_message (
  p_id=>197142110771154523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT_MONTH',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next_year
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下一年';

wwv_flow_api.create_message (
  p_id=>197142227200154523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT_YEAR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next_x_years
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'下 %0 年';

wwv_flow_api.create_message (
  p_id=>197142321940154524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT_X_YEARS',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_no_stmt_buffer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'缓冲区中没有要运行的语句。';

wwv_flow_api.create_message (
  p_id=>197142429247154524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.NO_STMT_BUFFER',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_unique_key_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表查询需要唯一关键字来标识各行。提供的关键字不能用于此查询。请定义唯一关键字列。%0';

wwv_flow_api.create_message (
  p_id=>197142504480154524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_UNIQUE_KEY_ERROR',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_unique_key_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'报表查询需要唯一关键字来标识各行。提供的关键字无法用于此查询。请编辑报表属性以定义唯一关键字列。%0';

wwv_flow_api.create_message (
  p_id=>197142613022154524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_UNIQUE_KEY_ERROR2',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_html_text_escape_sc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 文本转义特殊字符';

wwv_flow_api.create_message (
  p_id=>197142703032154524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.HTML_TEXT_ESCAPE_SC',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_function_returning_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'返回 SQL 查询的函数';

wwv_flow_api.create_message (
  p_id=>197142805401154524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.FUNCTION_RETURNING_SQL_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_simple_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'简单图表';

wwv_flow_api.create_message (
  p_id=>197142929085154525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.SIMPLE_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_updatable_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'可更新的 SQL 查询';

wwv_flow_api.create_message (
  p_id=>197143013787154525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.UPDATABLE_SQL_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG 图表';

wwv_flow_api.create_message (
  p_id=>197143109076154525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.SVG_CHART',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_structured_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'结构化查询';

wwv_flow_api.create_message (
  p_id=>197143231574154525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.STRUCTURED_QUERY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_email_subject_password_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'口令已更改。';

wwv_flow_api.create_message (
  p_id=>197143319108154525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_EMAIL_SUBJECT_PASSWORD_CHANGED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_email_body_password_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'已更改用户 %0 的帐户口令。';

wwv_flow_api.create_message (
  p_id=>197143415761154525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_EMAIL_BODY_PASSWORD_CHANGED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_email_body_new_password
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'新口令';

wwv_flow_api.create_message (
  p_id=>197143525469154526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_EMAIL_BODY_NEW_PASSWORD',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hidden_and_protected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'隐藏和受保护';

wwv_flow_api.create_message (
  p_id=>197143622478154526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HIDDEN_AND_PROTECTED',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_count
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'计数';

wwv_flow_api.create_message (
  p_id=>197143703147154526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_COUNT',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message go
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'开始';

wwv_flow_api.create_message (
  p_id=>197143821194154526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'GO',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_foreign_key
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'外键';

wwv_flow_api.create_message (
  p_id=>197143905946154526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_FOREIGN_KEY',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_copy_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'您已请求复制具有以下属性的应用程序。请确认您的选择。';

wwv_flow_api.create_message (
  p_id=>197144008213154527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COPY_APPLICATION',
  p_message_language=>'zh-cn',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_parent
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'无父面包屑条目';

wwv_flow_api.create_message (
  p_id=>197144121185154527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_PARENT',
  p_message_language=>'zh-cn',
  p_message_text=>h