/*jslint nomen: false, evil: false, browser: true, eqeqeq: false, white: false, undef: false */
/*
Oracle Database Application Express, Release 3.1

B32468-02

Copyright © 2003, 2008, Oracle. All rights reserved.

The Programs (which include both the software and documentation) contain proprietary information; they are provided under a license agreement containing restrictions on use and disclosure and are also protected by copyright, patent, and other intellectual and industrial property laws. Reverse engineering, disassembly, or decompilation of the Programs, except to the extent required to obtain interoperability with other independently created software or as specified by law, is prohibited.

The information contained in this document is subject to change without notice. If you find any problems in the documentation, please report them to us in writing. This document is not warranted to be error-free. Except as may be expressly permitted in your license agreement for these Programs, no part of these Programs may be reproduced or transmitted in any form or by any means, electronic or mechanical, for any purpose.

If the Programs are delivered to the United States Government or anyone licensing or using the Programs on behalf of the United States Government, the following notice is applicable:

U.S. GOVERNMENT RIGHTS Programs, software, databases, and related documentation and technical data delivered to U.S. Government customers are "commercial computer software" or "commercial technical data" pursuant to the applicable Federal Acquisition Regulation and agency-specific supplemental regulations. As such, use, duplication, disclosure, modification, and adaptation of the Programs, including documentation and technical data, shall be subject to the licensing restrictions set forth in the applicable Oracle license agreement, and, to the extent applicable, the additional rights set forth in FAR 52.227-19, Commercial Computer Software--Restricted Rights (June 1987). Oracle USA, Inc., 500 Oracle Parkway, Redwood City, CA 94065.

The Programs are not intended for use in any nuclear, aviation, mass transit, medical, or other inherently dangerous applications. It shall be the licensee's responsibility to take all appropriate fail-safe, backup, redundancy and other measures to ensure the safe use of such applications if the Programs are used for such purposes, and we disclaim liability for any damages caused by such use of the Programs.

Oracle, JD Edwards, PeopleSoft, and Siebel are registered trademarks of Oracle Corporation and/or its affiliates. Other names may be trademarks of their respective owners.

The Programs may provide links to Web sites and access to content, products, and services from third parties. Oracle is not responsible for the availability of, or any content provided on, third-party Web sites. You bear all risks associated with the use of such content. If you choose to purchase any products or services from a third party, the relationship is directly between you and the third party. Oracle is not responsible for: (a) the quality of third-party products or services; or (b) fulfilling any of the terms of the agreement with the third party, including delivery of products or services and warranty obligations related to purchased products or services. Oracle is not responsible for any loss or damage of any sort that you may incur from dealing with any third party.
*/
/**
 * @fileOverview
 * This file holds all non namespaced functions and objects for Oracle Application Express
 *
 * */
var gDebug = true;
var gkeyPressTime;
var gLastTab=false;
var gRegex=false;
var ie=(document.all)?true:false;
if(ie){document.expando=true;}
var gDebugWindow = false;

/**
 * Given a DOM node or string ID (pNd), this function returns a DOM node if the element is on the page, or returns false if it is not.
 * @function
 * @param {DOM node | string ID} pNd
 * @return {DOM node | false}
 */
function $x(pNd){var lItem = new apex.page.item(pNd);return lItem.node;}

/**
 * Given a DOM node or string ID (pNd), this function returns a apex.page.item object.
 * @function
 * @param {DOM node | string ID} pNd
 * @return {DOM node | false}
 */
function $x_object(pNd){var lItem = new apex.page.item(pNd);return lItem;}
$item = $x_object;

/**
 * Given a DOM node or string ID (pNd), this function returns the value of an Application Express item in the same format as it would be posted.
 * @function
 * @param {DOM node | string ID} pNd
 */
function $v(pNd){
	var lItem = new apex.page.item(pNd);
	return lItem.value();
}

/**
 * Given a DOM node or string ID (pNd), this function sets the Application Express item value taking into account what type of item it is.
 * @function
 * @param {DOM node | string ID} pNd
 * @param {String , Array} pValue 
 */
function $s(pNd,pValue){var lItem = new apex.page.item(pNd);return lItem.set(pValue);}

/**
 * Given a DOM node or string ID or an Array (pNd), this function will try to return an Array. Used for creating DOM based functionality that can accept a single or multiple DOM nodes.
 * @function
 * @param {DOM node | string ID | Array} pNd
 * @return Array
 */
function $u_Carray(pNd){return ($x(pNd))?[pNd]:pNd;}

/**
 * Given a DOM node or string ID or an Array (pNd), this function will try to return a single value, if an pNd is an array but only has one element the value of that element will be returned otherwise the array will be returned.   Used for creating DOM based functionality that can accept a single or multiple DOM nodes.
 * @function
 * @param {DOM node | string ID | Array} pNd
 * @return {Array} Array or first value
 */
function $u_Narray(pNd){return (pNd.length == 1)?pNd[0]:pNd;}

/**
 * If pTest is empty or false return pDefault otherwise return pTest.
 * @function
 * @param {String | Array} pTest
 * @param {String | Array} pDefault
 * @return {String | Array}
 */
function $nvl(pTest,pDefault){return (pTest!=null)?pTest:((!!pDefault)?pDefault:'');}

/**
 * Submits the page setting the Application Express Request value (pRequest).
 * @function
 * @param {String} pRequest
 */
function doSubmit(pRequest){
	var lSubmit = new apex.page.form(pRequest);
	lSubmit.submit(pRequest);
}

/**
 * Displays a confirmation showing a message (pMessage) and depending on user's choice, submits a page setting request value (pRequest) or cancels page submit.
 * @function
 * @param {String}[pMessage]
 * @param {String}[pRequest]
 */
function confirmDelete(pMessage,pRequest){
	var lSubmit = new apex.page.form(pRequest);
	lSubmit.confirm(pMessage,pRequest);
}

/**
 * Check to see if this a compond object and if so return it's fieldset instead this helps get and items whole html structure instead of just the form element itself
 * @function
 * @param {DOM node | string ID} pNd
 */

function $x_Check_For_Compound(pNd){
	var lNode = $x(pNd);
    if(lNode && $x(lNode.id + '_fieldset')){
	 return $x(lNode.id + '_fieldset');
	}else{
	 return lNode;
	}
}

/**
 * Sets a specific style property (pStyle) to given value (pString) of a DOM node or DOM node Array (pNd).
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @param {String} pStyle
 * @param {String} pString 
 * @return {DOM node | DOM Array}
 */
function $x_Style(pNd,pStyle,pString){
	pNd = $u_Carray(pNd);
	for(var i=0;i<pNd.length;i++){
		var node = $x(pNd[i]);
		(!!node)?node.style[pStyle]=pString:null;
	}
	return $u_Narray(pNd);
}

/**
* Hides a DOM node or array of DOM nodes (pNd).
* @function
* @param {DOM node | string ID | DOM node Array} pNd
* @return {DOM node | Array}
*/
function $x_Hide(pNd){
	return $x_Style(pNd,'display','none');
}

/**
 * Shows a DOM node or array of DOM nodes (pNd).
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @return {DOM node | Array}
 */
function $x_Show(pNd){
	return $x_Style(pNd,'display','');
}

/**
 * Shows a DOM node or array of DOM nodes (pShow) and hides a DOM node or array of DOM nodes (pHide)
 * @function
 * @param {DOM node | string ID | DOM node Array} pShow
 * @param {DOM node | string ID | DOM node Array} pHide
 */
function $x_Show_Hide(pShow,pHide){
	$x_Hide(pHide);
	$x_Show(pShow);
	return;
}



/**
 * Toggles a DOM node or array of DOM nodes (pNd).
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @return {DOM node | Array}
 */
function $x_Toggle(pNd){
	pNd = $u_Carray(pNd);
	for(var i=0;i<pNd.length;i++){
		var node = $x(pNd[i]);
		if (node) {if(node.style.display == "none"){$x_Show(node);}else{$x_Hide(node);}}
	}
	return $u_Narray(pNd);
}

/**
 * Removes a DOM node or array of DOM nodes.
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @return {DOM node | Array} 
 */
function $x_Remove(pNd){
	pNd = $u_Carray(pNd);
	for(var i=0,len=pNd.length;i<len;i++){
		var node = $x(pNd[i]);
		var lParent = node.parentNode;
		if (node && lParent){
			lParent.removeChild(node);
			lParent.normalize();
		}
	}
	return $u_Narray(pNd);
}

/**
 * Sets the value (pValue) of a DOM node or array of DOM nodes (pNd).
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @param { String } pValue
 */
function $x_Value(pNd,pValue){
	pNd = $u_Carray(pNd);
	for(var j=0,len=pNd.length;j<len;j++){
		var lTemp = new apex.page.item(pNd[j]);
		lTemp.set(pValue);
	}
	return;
}

/**
 * Starting from a DOM node (pNd), this function cascades up the DOM tree until the tag of node name (pToTag) is found.
 * @function
 * @param {DOM node | string ID} pNd
 * @param {String} pToTag
 * @param {String} pToClass
 * @return {DOM Node | false}
 */
function $x_UpTill(pNd,pToTag,pToClass,pCount){
 var node = $x(pNd);
 if(node){
	var tPar = node.parentNode;
	if(pToClass){
		while(tPar.nodeName != pToTag && tPar.className != pToClass){tPar = tPar.parentNode;}
	}else{
		while(tPar.nodeName != pToTag){tPar = tPar.parentNode;}
	}
	return tPar;
 }else{
  return false;
 }
}

/**
 * Given DOM node or array of DOM nodes, this function (shows / hides /toggles) the entire row that contains the DOM node or array of DOM nodes. This is most useful when using Page Items.
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @param { String } pFunc ['TOGGLE','SHOW','HIDE']
 * */
function $x_ItemRow(pNd,pFunc){
	pNd = $u_Carray(pNd);
	for(var i=0;i<pNd.length;i++){
		var node = $x(pNd[i]);
		node = $x_Check_For_Compound(pNd[i])
		var lTr = $x_UpTill(node,'TR');
		switch(pFunc){
			case 'TOGGLE':$x_Toggle(lTr);break;
			case 'SHOW':$x_Show(lTr);break;
			case 'HIDE':$x_Hide(lTr);break;
			default:break;
		}
	}
	return;
}

/**
 * Given a page item name, this function hides the entire <tr> row that holds the item. In most cases, this will be the item and its label.
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @param { String } pFunc ['TOGGLE','SHOW','HIDE']
 * */
function $x_HideItemRow(pNd){
	$x_ItemRow(pNd,'HIDE');
}

/**
 * Given a page item name, this function shows the entire <tr> row that holds the item. In most cases, this will be the item and its label.
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * */
function $x_ShowItemRow(pNd){
	$x_ItemRow(pNd,'SHOW');
}

/**
 * Given a page item name (pNd), this function toggles the entire <tr> row that holds the item. In most cases, this will be the item and its label.
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * */
function $x_ToggleItemRow(pNd){
	$x_ItemRow(pNd,'TOGGLE');
}

/**
 * Hides all DOM nodes referenced in pNdArray and then shows the DOM node referenced by pNd. This is most useful when pNd is also a node in pNdArray.
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @param {DOM node | String | Array} pNdArray
 * @return {DOM node | DOM Array}
 * */
function $x_HideAllExcept(pNd,pNdArray){
	var l_Node = $x(pNd);
	if(l_Node){
		$x_Hide(pNdArray);
		$x_Show(l_Node);
	}
	return l_Node;
}

/**
 * Hides all sibling nodes of given DOM node (pNd).
 * @function
 * @param {DOM node | string ID} pNd
 * @return {DOM node}
 * */
function $x_HideSiblings(pNd){
	return $x_HideAllExcept(pNd,$x(pNd).parentNode.childNodes);
}

/**
 * Shows all sibling DOM nodes of given DOM nodes (pNd).
 * @function
 * @param {DOM node | string ID} pNd
 * @return {DOM node | false}
 * */
function $x_ShowSiblings(pNd){
   var l_Node = $x(pNd);
   if(l_Node){
		var l_NodeSibs = l_Node.parentNode.childNodes;
		$x_Show(l_NodeSibs);
   }
  return l_Node;
}

/**
 * Sets a DOM node or array of DOM nodes to a single class name.
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @param {String} pClass
 * */
function $x_Class(pNd,pClass){
	if($x(pNd)){pNd = [pNd];}
	var l=pNd.length;
	for(var i=0;i<l;i++){if($x(pNd[i])){$x(pNd[i]).className=pClass;}}
	return $u_Narray(pNd);
}

/**
 * Sets the class (pClass) of all DOM node siblings of a node (pNd). If pNdClass is not null the class of pNd is set to pNdClass.
 * @function
 * @param {DOM node | string ID} pNd
 * @param {String} pClass
 * @param {String} pNdClass
 * @return {DOM node | false}
 * */
function $x_SetSiblingsClass(pNd,pClass,pNdClass){
	var l_Node = $x(pNd);
	if(l_Node){
		var l_NodeSibs = l_Node.parentNode.childNodes;
		$x_Class(l_NodeSibs,pClass);
		if(pNdClass){$x_Class(l_Node,pNdClass)}
	}
	return l_Node;
}

/**
 * Returns an array of DOM nodes by a given class name (pClass). If the pNd parameter is provided, then the returned elements will be all be children of that DOM node. Including the pTag parameter further narrows the list to just return nodes of that tag type.
 * @function
 * @param {String} pClass
 * @param {DOM node | string ID} pNd
 * @param {String} pTag
 * @return { Array }
 * */
function $x_ByClass(pClass,pNd,pTag){
	var classElements=[];
	if (!pNd){pNd = document;}else{pNd = $x(pNd);}
	if (!pTag){pTag = '*';}
	var els = pNd.getElementsByTagName(pTag);
	var elsLen = els.length;
	var pattern = new RegExp("(^|\\s)"+pClass+"(\\s|$)");
	for (var i=0,j=0;i<elsLen;i++){
		if (pattern.test(els[i].className)){
			classElements[j] = els[i];
			j++;
		}
	}
	return classElements;
}

/**
 * Show all the DOM node children of a DOM node (pNd) that have a specifc class (pClass) and tag (pTag).
 * @function
 * @param {DOM node | string ID} pNd
 * @param {String} pClass
 * @param {String} pTag
 * */
function $x_ShowAllByClass(pNd,pClass,pTag) {
		var node = $x(pNd);
		var lH = $x_ByClass(pClass,node,pTag);
		if (lH) {$x_Show(lH);}
} 

/**
 * Show all all DOM node children of a DOM node (pNd).
 * @function
 * @param {DOM node | string ID} pNd
 * */
function $x_ShowChildren(pNd) {
	var node = $x(pNd);
	if (node && node.hasChildNodes) {$x_Show(node.childNodes);}
} 

/**
 * Hide all all DOM node children of a DOM node (pNd).
 * @function
 * @param {DOM node | string ID} pNd
 * */
function $x_HideChildren(pNd) {
	var node = $x(pNd);
	if (node && node.hasChildNodes) {$x_Hide(node.childNodes);}
} 

/**
 * Disables or enables an item or array of items based on (pTest)
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @param {true|false} pTest
 * */
function $x_disableItem(pNd,pTest){
	var lColor=(pTest)?'#ccc':'#fff';
	pTest = !!pTest;
	if($x(pNd)){pNd = [pNd];}
	for(var i=0,len=pNd.length;i<len;i++){
		var node = $x_object(pNd[i]);
		if(node){
			var l_Dom_Node = node.node;
			if(node.item_type=='RADIO_GROUP' || node.item_type=='CHECKBOX_GROUP'){
				l_Dom_Node = $x_FormItems(l_Dom_Node,(node.item_type=='RADIO_GROUP')?'RADIO':'CHECKBOX');
				$x_disableItem(l_Dom_Node,pTest)
			}else if(l_Dom_Node.type=='radio'||l_Dom_Node.type=='checkbox'){
				$x_Style(l_Dom_Node,'color',lColor);
				l_Dom_Node.disabled = pTest;
			}else{
				$x_Style(l_Dom_Node,'background',lColor);
				l_Dom_Node.disabled = pTest;
			}
		}
	}
	if(pNd.length==1){pNd=pNd[0];}
	return pNd;
} 

/**
 * Checks an item or an array of items to see if any are empty, set the class of all items that are empty to pClassFail, set the the class of all items that are not empty to pClass.
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * @param {String} [pClassFail]
 * @param {String} [pClass]
 * @return {false | Array} Array of all items that are empty
 * */
function $f_get_emptys(pNd,pClassFail,pClass){
	var l_temp = [],l_temp2 = [];
	if($x(pNd)){pNd = [pNd];}
	for(var i=0,len=pNd.length;i<len;i++){
		var node = $x(pNd[i]);
		if(node){
			if(isEmpty(node)){l_temp[l_temp.length] = node;}
			else{l_temp2[l_temp2.length] = node;}
		}
	}
	if(pClassFail){$x_Class(l_temp,pClassFail);}
	if(pClass){$x_Class(l_temp2,pClass);}
	if(l_temp.length===0){l_temp=false;}else{l_temp[0].focus();}
	return l_temp;
}

/**
 * @ignore
 * */
function $f_is_in(pNd,pValue){
	var l_temp = [];
	var l_temp2 = [];
	if($x(pNd)){pNd = [pNd];}
	for(var i=0,len=pNd.length;i<len;i++){
		var node = $x(pNd[i]);
		for(var ii=0,len2=pValue.length;ii<len2;ii++){
			if(node){
				if($v(node) == pValue[ii]){
					l_temp[l_temp.length] = node;
				}
			}
		}
	}
	if(l_temp.length===0){l_temp=false;}else{l_temp[0].focus();}
	return l_temp;
}

/**
 * @ignore
 * */
function $f_basic_sql(pColumn,pOp,pExp,gClassFail,gClass){
	var lArray = [pColumn,pOp,pExp];
	if(!!($f_is_in(pOp,['is null','is not null']))){lArray = [pColumn,pOp];}
	return $f_get_emptys(lArray,gClassFail,gClass);
}

/**
 * Returns an item value as an array. Useful for multiselects and checkboxs
 * @function
 * @param {DOM node | string ID} pNd
 * @return {Array}
 * */
function $v_Array(pNd){
	var lItem = new apex.page.item(pNd);
	return lItem.valueArray();
}

/**
 * Returns an array of values from the checked boxes in a checkbox item
 * @function
 * @param {DOM node | string ID} pNd
 * @return {Array}
 * */
function $f_ReturnChecked(pNd){
	return ($x(pNd))?$v_Array(pNd):false;
}

/**
 * Clears the content of an DOM node or array of DOM nodes and hides them 
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * */
function $d_ClearAndHide(pNd){
	 if($x(pNd)){pNd=[pNd];}
	 for(var i=0,len=pNd.length;i<len;i++){
		 var lNode = $x(pNd[i]);
		 if(lNode){$x_Hide(lNode).innerHTML = '';} 
	 }
	 return;
}

/**
 * Returns the DOM nodes of the selected options of a select item (pNd).
 * @function
 * @param {DOM node | string ID} pNd
 * @return {DOM Array}
 * */
function $f_SelectedOptions(pNd){
	var lSelect = $x(pNd);
	var lValue=[];
	if(lSelect.nodeName == 'SELECT'){
		var lOpts = lSelect.options;
		for(var i=0,len=lOpts.length;i<len;i++){if(lOpts[i].selected){lValue[lValue.length] = lOpts[i];}}
		return $u_Narray(lValue);
	}
	return false;
}

/**
 * Returns the values of the selected options of a select item (pNd).
 * @function
 * @param {DOM node | string ID} pNd
 * @return {Array | String}
 * */
function $f_SelectValue(pNd){
	 var lValue=$v_Array(pNd);
	 return $u_Narray(lValue);
}

/**
 * Given an array (pArray) return a string with with the values of the array delimited with a given delimiter character (pDelim).
 * @function
 * @param {Array} pArray
 * @param {String} pDelim
 * */
function $u_ArrayToString(pArray,pDelim){
	var lReturn ='';
	if(!!pDelim){pDelim=':';}
	pArray = $u_Carray(pArray);
	for(var i=0,len=pArray.length;i<len;i++){lReturn += (pArray[i])?pArray[i] + pDelim:'' + pDelim;}
	return lReturn.substr(0,(lReturn.length-1));
}

/**
 * @function
 * @param {DOM node | string ID | DOM node Array} pNd
 * */
function html_CheckSome(pThis,pValues,pArray){
  var lCheck = false;
  var l_Inputs;
  if(pArray){l_Inputs = pArray;}
  else{l_Inputs = $x_FormItems(pThis,'CHECKBOX');}
  for (var j=0,l=l_Inputs.length;j<l;j++){
	for (var ii=0,ll=pValues.length;ii<ll;ii++){if(pValues[ii] == l_Inputs[j].value){lCheck=true;}}
	l_Inputs[j].checked = lCheck;
	lCheck=false;
  }
  return;
}

/**
 * Checks an page item’s (pThis) value against a set of values (pValue). This function returns true if any value matches.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {Number | String | Array} pValue
 * @return {true | false}
 * */
function $v_CheckValueAgainst(pThis,pValue){
	var lTest = false,lArray = [],lValue = false;
	if(pValue.constructor == Array){lArray = pValue;}
	else{lArray[0] = pValue;}
	lValue = $v(pThis);
	for(var i=0,len=lArray.length;i<len;i++){
		lTest = lValue == lArray[i];
		if(lTest){break;}
	}
	return lTest;
}

/**
 * Checks an page item’s (pThis) value agianst a value (pValue). If it matches, a DOM node (pThat) is set to hidden. If it does not match, then the DOM node (pThat) is set to visible.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {DOM node | string ID | DOM node Array} pThat
 * @param {Number | String | Array} pValue
 * @return {true | false}
 * */
function $f_Hide_On_Value_Item(pThis,pThat,pValue){
	var lTest = $v_CheckValueAgainst(pThis,pValue);
	if(lTest){$x_Hide(pThat);}else{$x_Show(pThat);}
	return lTest;
}

/**
 * Checks an page item’s (pThis) value agianst a value (pValue). If it matches, a DOM node (pThat) is set to visible. If it does not match, then the DOM node (pThat) is set to hidden.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {DOM node | string ID | DOM node Array} pThat
 * @param {Number | String | Array} pValue
 * @return {true | false}
 * */
function $f_Show_On_Value_Item(pThis,pThat,pValue){
	var lTest = $v_CheckValueAgainst(pThis,pValue);
	if(lTest){$x_Show(pThat);}else{$x_Hide(pThat);}
	return lTest;
}

/**
 * Checks the value (pValue) of an item (pThis). If it matches, this function hides the table row that holds (pThat). If it does not match, then the table row is shown.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {DOM node | string ID | DOM node Array} pThat
 * @param {Number | String | Array} pValue
 * @return {true | false}
 * */
function $f_Hide_On_Value_Item_Row(pThis,pThat,pValue){
	var lTest = $v_CheckValueAgainst(pThis,pValue);
	if(lTest){$x_HideItemRow(pThat);}else{$x_ShowItemRow(pThat);}
	return lTest;
}

/**
 * Checks the value (pValue) of an item (pThis). If it matches, the function shows the table row that holds pThat. If it does not match then the table row is hidden.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {DOM node | string ID | DOM node Array} pThat
 * @param {Number | String | Array} pValue
 * @return {true | false}
 * */
function $f_Show_On_Value_Item_Row(pThis,pThat,pValue){
	var lTest = $v_CheckValueAgainst(pThis,pValue);
	if(lTest){$x_ShowItemRow(pThat);}else{$x_HideItemRow(pThat);}
	return lTest;
}

/**
 * Checks the value (pValue) of an item (pThis). If it matches, this function disables the item or array of items (pThat). If it does not match, then the item is enabled.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {String} pValue
 * @param {DOM node | string ID | DOM node Array} pThat
 * @return {true | false}
 * */
function $f_DisableOnValue(pThis,pValue,pThat){
	var lTest = $v_CheckValueAgainst(pThis,pValue);
	var lNd = [];
	if(pThat){
		if(pThat instanceof Array){
			lNd = pThat;
		}else{
			for (var i=2;i<arguments.length;i++){if(arguments[i]){lNd[lNd.length]=arguments[i];}}
		}
		html_disableItem(lNd,lTest);
	}
	return lTest;
}

/**
 * Sets a class attribute of an array of nodes that are selected by class.
 * @function
 * @param {DOM node | string ID} pNd
 * @param {String} pClass
 * @param {String} [pTag]
 * @param {String} [pClass2]
 * @return {DOM node | DOM node Array}
 * */
function $x_ClassByClass(pNd,pClass,pTag,pClass2){
	var l_Els = $x_ByClass(pClass,pNd,pTag);
	$x_Class(l_Els,pClass2);
	return l_Els;
}

/*
 * @deprecated use $x_ClassByClass 
 * */
function setClassByClass(pTag,pClass,pClass2){$x_ClassByClass(false,pClass,pTag,pClass2);}

/**
 * Sets a style attribute of an array of nodes that are selected by class.
 * @ignore
 * @param {DOM node | String} pNd
 * @param {String} pClass
 * @param {String} pTag
 * @param {String} pClass2
 * */
function $x_StyleByClass(t,c,p,v){
	var l_Els = $x_ByClass(c,false,t);
	$x_Style(l_Els,p,v);
}

/**
 * Collects the values of form items contained within DOM node (pThis) of class attribute (pClass) and nodeName (pTag) and returns an array.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {String} pClass
 * @param {String} pTag
 * */
function $f_ValuesToArray(pThis,pClass,pTag){
	var lTemp = $x_ByClass(pClass,pThis,pTag);
	var lArray = [];
	for(var i=0,len=lTemp.length;i<len;i++){lArray[i] = lTemp[i].value;}
	return lArray;
}

/**
 * @ignore
 * @function
 * @param {DOM node | String | Array} pNd
 * */
function $dom_JoinNodeLists(pThis,pThat){
	var lArray = [],i,len;
	for(i=0,len=pThis.length;i<len;i++){lArray[i] = pThis[i];}
	for(i=0,len=pThat.length;i<len;i++){lArray[lArray.length] = pThat[i];}
	return lArray;
}

/**
 * Returns all form input items contained in a DOM node (pThis) of a certain type (pType).
 * @function
 * @param {DOM node | string ID} pNd
 * @param {String} pType
 * @return {DOM node Array}
 * */
function $x_FormItems(pNd,pType){
	var lType = (pType)?pType.toUpperCase():'ALL';
	var l_Inputs = [],l_Inputs2 = [],l_Array = [];
	var l_This = $x(pNd);
	if(l_This){
		if(l_This.nodeName=='SELECT'||l_This.nodeName=='INPUT'||l_This.nodeName=='TEXTAREA'){return [l_This];}
		l_Selects = l_This.getElementsByTagName('SELECT');
		l_Inputs = l_This.getElementsByTagName('INPUT');
		l_Textarea = l_This.getElementsByTagName('TEXTAREA');
		if(lType == 'SELECT'){
			l_Inputs = l_Selects;
		}else if(lType == 'TEXTAREA'){
			l_Inputs = l_Textarea;
		}else if (lType == 'ALL'){
			l_Inputs = $dom_JoinNodeLists(l_Inputs,l_Selects);
			l_Inputs = $dom_JoinNodeLists(l_Inputs,l_Textarea);
		}else{}

		if(lType == 'SELECT'||lType == 'TEXTAREA'||lType == 'ALL'){
			l_Array = l_Inputs;
		}else{
			for (var i=0;i<l_Inputs.length;i++){
				if(l_Inputs[i].type.toUpperCase()==pType.toUpperCase()){l_Array[l_Array.length] = l_Inputs[i];}
			}
		}
		return l_Array;
	}
}

/**
 * Check or uncheck (pCheck) all check boxs contained within a DOM node (pThis). If an array of checkboxs DOM nodes (pArray) is provided, use that array for affected check boxs.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {true | false} pCheck
 * @param {DOM node Array} pArray
 * */
function $f_CheckAll(pThis,pCheck,pArray){
	var l_Inputs;
	if(pArray){l_Inputs = pArray;}
	else{l_Inputs = $x_FormItems(pThis,'CHECKBOX');}
	for (var i=0,l=l_Inputs.length;i<l;i++){l_Inputs[i].checked = pCheck;}
	return;
}

/**
 * This function sets all checkboxes located in the first column of a table based on the checked state of the calling checkbox (pNd), useful for tabular forms.
 * @function
 * @param {DOM node | String} pNd
 * @return {DOM node Array}
 * */
function $f_CheckFirstColumn(pNd){
	var lTable = $x_UpTill(pNd,"TABLE");
	var lArray = [];
	for(var i=0,len=lTable.rows.length;i<len;i++){
	  var l_Temp = $x_FormItems(lTable.rows[i],'CHECKBOX')[0];
	  if(l_Temp){lArray[lArray.length]=l_Temp;}
	}
	$f_CheckAll(false,pNd.checked,lArray);
	return lArray;
}

/**
 * Sets the value of the item in the parent window (pThat), with (pValue) and then closes the popup window.
 * @function
 * @param {String} pValue
 * @param {DOM node | string ID} pThat
 * */
function $v_PopupReturn(pValue,pThat){
	opener.$x_Value(pThat,pValue);
	window.close();
}

/** @ignore */
var gToggleWithImageA = 'pseudoButtonActive';

/** @ignore */
var gToggleWithImageI = 'pseudoButtonInactive';

/**
 * Given an image element (pThis) and a DOM node (pNd), this function toggles the display of the DOM node (pNd). The src attribute of the image element (pThis) will be rewritten. The image src will have any plus substrings with minus substrings or minus substrings will be replaced with plus substrings.
 * @function
 * @param {DOM node | string ID} pThis
 * @param {DOM node | string ID | DOM node Array} pNd
 * @return {DOM node}
 * */
function $x_ToggleWithImage(pThis,pNd){
	pThis = $x(pThis);
    if(html_CheckImageSrc(pThis,'plus')){
        $x_Class(pThis,gToggleWithImageI);
        pThis.src = html_replace(pThis.src,'plus','minus');
    }else{
        $x_Class(pThis,gToggleWithImageA);
        pThis.src = html_replace(pThis.src,'minus','plus');
    }
	var node = $x_Toggle(pNd);
	return node;
}

/**
 * Checks an image (pId) src attribute for a substring (pSearch). If a substring is found, this function replaces the image entire src attribute with (pReplace).
 * @function
 * @param {DOM node | string ID} pNd
 * @param {String} pSearch
 * @param {String} pReplace
 * @return {DOM node | false}
 * */
function $x_SwitchImageSrc(pNd,pSearch,pReplace){
  var lEl = $x(pNd);
  if(lEl && lEl.nodeName=="IMG"){if(lEl.src.indexOf(pSearch)!=-1){lEl.src=pReplace;}}
  return lEl;
}

/**
 * Checks an image (pNd) source attribute for a substring (pSearch). The function returns true if a substring (pSearch) is found. It returns false if a substring (pSearch) is not found.
 * @function
 * @param {DOM node | string ID} pNd
 * @param {String} pSearch
 * @return {true | false}
 * */
function $x_CheckImageSrc(pNd,pSearch){
    var lEL=$x(pNd) , lReturn=false;
    if(lEL && lEL.nodeName=="IMG"){lReturn = html_SubString(lEL.src,pSearch);}
    return lReturn;
}

/**
 * Returns a true or false if a string (pText) contains a substring (pMatch).
 * @function
 * @param {String} pText
 * @param {String} pMatch
 * @return {true | false}
 * */
function $u_SubString(pText,pMatch){return (pText.toString().indexOf(pMatch.toString()) != -1);}

/**
 * @function
 * @param {DOM node | string ID} pNd
 * */
function html_RemoveAllChildren(pNd) {
	var lEl = $x(pNd);
	if (lEl && lEl.hasChildNodes && lEl.removeChild){while(lEl.hasChildNodes()){lEl.removeChild(lEl.firstChild);}}
}

/** 
 * Basic Aynscronous Ajax Loading graphic.
 * @function 
 * */
function ajax_Loading(pState){
		if(pState == 1){$x_Show('loader','wait');}
		else{$x_Hide('loader');}
}

/**
 * Returns true or false if a form element is empty, this will consider any whitespace including a space, a tab, a form-feed, as empty.
 * @function
 * @param {DOM node | String} pThis
 * @return {true | false}
 * */
function $v_IsEmpty(pThis) {
	var re = /^\s{1,}$/g; //match any white space including space, tab, form-feed, etc.
	var lThis = $x(pThis);
	return ((lThis.value.length===0) || (lThis.value===null) || ((lThis.value.search(re)) > -1))?true:false;
}

/**
 * Sets the value (pValue) of a select item (pId). If the value is not found, this functions selects the first option (usually the NULL selection).
 * @function
 * @param {DOM node | String} pId
 * @param {String} pValue
 * */
function html_SetSelectValue(pId,pValue){
	var lSelect = $x(pId);
	if(lSelect.nodeName == 'SELECT'){
		lSelect.selectedIndex = 0;
		for(var i=0,l=lSelect.options.length;i<l;i++){if(lSelect.options[i].value == pValue){lSelect.options[i].selected=true;}}
	}
}

/**
 * Adds an onload function (func) without overwriting any previously specified onload functions.
 * @function
 * @param {Javascript Function} pFunction
 * */
function addLoadEvent(pFunction) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = pFunction;
  } else {
    window.onload = function() {
      if (oldonload) {oldonload();}
      pFunction();
    };
  }
}

/**
 * Swaps the form values of two form elements (pThis,pThat).
 * @function
 * @param {DOM node | String} pThis
 * @param {DOM node | String} pThat
 * @return Not applicable.
 * */
function $f_Swap(pThis,pThat){
	var lThis = $x(pThis);lThat = $x(pThat);
	if(pThis && pThat){
		$x_Value(pThis,lThat.value);
		$x_Value(pThat,lThis.value);
	}
}

/**
 * @function
 * @param {DOM node | String | Array} pNd
 * */
function $f_Enter(e){
    var keycode;
    if(window.event){keycode = window.event.keyCode;}
    else if (e){keycode = e.which;}
    else {return false;}
    if(keycode == 13){return true;}
    else{return false;}
}

/**
 * Sets array of form item (pArray) to sequential number in multiples of (pMultiple).
 * @function
 * @param {DOM node | Array} pArray
 * @param {String | Number} pMultiple
 * */
function $f_SetValueSequence(pArray,pMultiple){
	var lLength = pArray.length;
	for (var i=0;i<lLength;i++){$x_Value(pArray[i],(i+1)*pMultiple);}		
}

/**
 * Inserts the html element (pTag) as a child node of a DOM node (pThis) with the innerHTML set to (pText).
 * @param {DOM node | string ID} pThis
 * @param {String} [pTag] (default)
 * @param {String} [pText]
 * @return {DOM node}
 */
function $dom_AddTag(pThis,pTag,pText){
	var lThis = document.createElement(pTag);
	var lThat = $x(pThis);
	if(lThat){lThat.appendChild(lThis);}
	if(pText!=null){lThis.innerHTML = pText;}
	return lThis;
}

/**
 * Appends a table cell <td> to a table row (pThis). And sets the content to (pText).
 * @function
 * @param {DOM node | string ID} pThis
 * @param {String} pText
 * @return {DOM node}
 * */
function $tr_AddTD(pThis,pText){
	return $dom_AddTag($x(pThis),'TD',pText);
}

/**
 * Appends a table header cell <th> to a table row (pThis). And sets the content to (pText).
 * @function
 * @param {DOM node | string ID} pThis
 * @param {String} pText
 * @return {DOM node}
 * */
function $tr_AddTH(pThis,pText){return $dom_AddTag($x(pThis),'TH',pText);}

/**
 * @function
 * @param {DOM node | string ID} pThis
 * @param {string} pThat
 * */
function $dom_Replace(pThis,pThat){
	var lThis = $x(pThis),lParent = lThis.parentNode;
	lThat =  $dom_AddTag(lParent,pThat);
	return lParent.replaceChild(lThat,lThis);
}

/**
 * Inserts the html form input element (pType) as a child node of a DOM node (pThis) with an id (pId) and name (pName) value set to (pValue).
 * @param {DOM node | string ID} pThis
 * @param {String} [pType] default is text input
 * @param {String} [pId]
 * @param {String} [pName]
 * @param {String} [pValue]
 * @return {DOM node}
 */
function $dom_AddInput(pThis,pType,pId,pName,pValue){
	var lThis = $dom_AddTag(false,'INPUT');
	lThis.type = (pType)?pType:'text';
	lThis.id = (pId)?pId:'';
	lThis.name = (pName)?pName:'';
	lThis.value = (pValue)?pValue:'';
	if(pThis){$x(pThis).appendChild(lThis);}
	return lThis;
}

/**
 * Takes a DOM node (p_Node) and makes it a child of DOM node (p_Parent) and then returns the DOM node (pNode).
 * @param {DOM node | string ID} pThis
 * @param {DOM node | string ID} p_Parent
 * @return {DOM node}
 */
function $dom_MakeParent(pThis,p_Parent){
  var l_Node = $x(pThis);
  var l_Parent = $x(p_Parent);
  if(l_Node && l_Parent && l_Node.parentNode != l_Parent){l_Parent.appendChild(l_Node);}
  return l_Node;
}

/** @ignore */
var gCurrentRow = false;

/**
 * Give an table row DOM node (pThis), this function sets the background of all table cells to a color (pColor). A global variable gCurrentRow is set to the current table row (pThis).
 * @function
 * @param {DOM node | String} pThis
 * @param {String} pColor
 * */
function $x_RowHighlight(pThis,pColor){
    var lThis = $x(pThis);
	if(lThis){$x_Style(lThis.getElementsByTagName('TD'),'backgroundColor',pColor);}
	gCurrentRow = lThis;
	return;
}

/**
 * Give an table row DOM node (pThis), this function sets the background of all table cells to NULL.
 * @function
 * @param {DOM node | String} pThis
 * */
function $x_RowHighlightOff(pThis){
    var lThis = $x(pThis);
	if(lThis){$x_Style(lThis.getElementsByTagName('TD'),'backgroundColor','');}
	return;
}

/**
 * Sets the select option of a given select item to the first option.
 * @function
 * @param {DOM node | String } pNd
 * */
function html_ResetSelect(pNd){
	var l_Node = $x(pNd);
	var tSelects = (l_Node.nodeName == 'SELECT')?l_Node:l_Node.getElementsByTagName('select')[0];
	tSelects.selectedIndex = 0;
	return;
}

/*
 *Sets page items with return from plsql call apex_util.json_from_items('ITEM1:ITEM2:ITEM3');  
 * */
function json_SetItems(gReturn){
	gReturn = eval('(' + gReturn + ')');
	for (var j=0,len=gReturn.item.length;j<len;j++){
		var lTemp = new apex.page.item(gReturn.item[j].id);
		lTemp.set(gReturn.item[j].value);
	}
}

/**
 * Sets the value of a form item (pNd) to uppercase.
 * @function
 * @param {DOM node | String} pNd
 * */
function $v_Upper(pId){
   var obj = $x(pId);
   if(obj){obj.value = obj.value.toUpperCase();}
}

/**
 * Hides child nodes of a DOM node (pThis) where the child node's content matches any instance of (pString). To narrow the child nodes searched by specifying a tag name (pTag) or a class name (pClass). Note that the child node will be set to a block level element when set to visible.
 * @param {DOM node | String} pThis
 * @param {String} pString
 * @param {String} pTags
 * @param {String} pClass
 * */
function $d_Find(pThis,pString,pTags,pClass){
		if(!pTags){pTags = 'DIV';}
		pThis = $x(pThis);
		if(pThis){
			var d=pThis.getElementsByTagName(pTags);
			pThis.style.display="none";
			if(!gRegex){gRegex =new RegExp("test");}
			gRegex.compile(pString,"i");
			for(var i=0,len=d.length ;i<len;i++){
				if(gRegex.test(d[i].innerHTML)){
					d[i].style.display="block";
				}
				else{d[i].style.display="none";}
			}
		pThis.style.display="block";
	}
	return;
}

/**
 * @ignore 
 * @param {} pTab
 * @param {} pTabPanel
 * @param {} pClass
 * @param {} pTabsArray
 * @param {} pTabsPanelArray
 * */
function $d_TabClick(pTab,pTabPanel,pClass,pTabsArray,pTabsPanelArray){
	var lTabPanel = $x(pTabPanel) , lclassName=(pClass)?pClass:'current';
	if(!pTabsPanelArray){$x_HideSiblings(lTabPanel);}else{$x_HideAllExcept(pTabPanel,pTabsArray);}
	if(!pTabsArray){$x_SetSiblingsClass(pTab,'',lclassName);}
	else{$x_Class(pTabsArray,'');$x(pTab).className=lclassName;}
}

/**
 * @ignore 
 * @function
 * @param {DOM node | string ID} pNd
 * */
function html_RadioValue(pNd){
 var lReturn = false;
 var lSelect = $x_FormItems(pNd,'RADIO');
 var l=lSelect.length;
 for(var i=0;i<l;i++){if(lSelect[i].checked){lReturn=lSelect[i].value;}}
 return lReturn;
}

/* needs some fixing */

/** 
 * @ignore 
 * */
function html_submitFormFromKeyPress(key){if(event.keyCode == "13"){doSubmit();}}

/** 
 * @ignore 
 * Initializes all text fields in a page to submit the page when the ENTER key is pressed.
 * @function 
 * */
function html_InitTextFieldSubmits(){
  var lEls = document.getElementsByTagName('INPUT');
  for(var i=0,len=lEls.length;i<len;i++){if(lEls[i].type == "text"){lEls[i].onkeypress = html_submitFormFromKeyPress;}}
}

/** 
 * Submits a page when ENTER is pressed in a text field, setting the request value to the ID of a DOM node (pNd).
 * @function
 * */
function submitEnter(pNd,e){
	var lThis = $x(pNd);
	var lRequest = (lThis)?lThis.id:'';
	var keycode;
	if(window.event){keycode = window.event.keyCode;
	}else if(e){keycode = e.which;
	}else{return true;}
	if (keycode == 13){
		doSubmit(lRequest);
		return false;
	}else{
		return true;
	}
}

/** 
 * Sets DOM node in the global variables returnInput (p_R) and returnDisplay (p_D) for use in populating items from popups.
 * @function
 * @param {DOM Node | String} p_R
 * @param {DOM Node | String} p_D
 * */
var returnInput=null,returnDisplay=null;
function setReturn(p_R,p_D){
    if(p_R){returnInput = $x(p_R);}
    if(p_D){returnDisplay = $x(p_D);}
    return;
}

/** 
 * @ignore 
 * */
function redirect(where){
  location.href = where;
  return;
}

/** 
 * Places the user focus on the a form item (pNd). If pNd is not found then this function places focus on the first found user editable field.
 * @function
 * @return {true} if successful
 * */
function $f_First_field(pNd){
	var lThis = $x(pNd);
	try{
		if(lThis){
			if((lThis.type!="hidden")&&(!lThis.disabled)){lThis.focus();}
		}else{}
		return true;
	}catch(e){}
}

/**
 * @ignore
 * */
function getCookieVal (offset){
   var endstr = document.cookie.indexOf (";", offset);
   if (endstr==-1){endstr = document.cookie.length;}
   return unescape(document.cookie.substring(offset, endstr));
}

/**
 * Returns the value of cookie name (pName).
 * @function
 * @param {String} pName
 * */
function GetCookie(pName){
	var arg = pName + "=";
	var alen = arg.length;
	var clen = document.cookie.length;
	var i = 0;
	while (i < clen){
		var j = i + alen;
		if(document.cookie.substring(i,j)==arg){return getCookieVal(j);}
		i = document.cookie.indexOf(" ", i) + 1;
		if(i===0){break;} 
	}
	return null;
}

/**
 * Sets a cookie (pName) to a specified value (pValue).
 * @function
 * @param {String} pName
 * @param {String} pValue
 * */
function SetCookie (pName,pValue) {
   var argv = arguments;
   var argc = arguments.length;
   var expires = (argc > 2) ? argv[2] : null;
   var path = (argc > 3) ? argv[3] : null;
   var domain = (argc > 4) ? argv[4] : null;
   var secure = (argc > 5) ? true : false;
   document.cookie = pName + "=" + escape (pValue) +
        ((expires === null) ? "" : ("; expires=" + expires.toGMTString())) +
        ((path === null) ? "" : ("; path=" + path)) +
        ((domain === null) ? "" : ("; domain=" + domain)) +
        ((secure === true) ? "; secure" : "");
}

/** 
 * @ignore 
 * */
function html_GoToRelative(nURL){
	var urlP = location.pathname.substring(0,location.pathname.lastIndexOf('/'));
	document.location = urlP+"/"+nURL;
	return;
}

/** 
 * @ignore 
 * */
function html_Allow_Copy(e){
	l_return = false;
	var keyCode = document.layers ? evt.which :document.all ? event.keyCode :document.getElementById ? e.keyCode : 0; 
	if (e.ctrlKey && keyCode == "c"){l_return = true;}
	return l_return;
}

/** 
 * @ignore 
 * */
function html_StringReplace(string,text,by) {
	if(!by){by = '';}
	var strLength = string.length, txtLength = text.length;
	if ((strLength === 0) || (txtLength === 0)) {return string;}
	var i = string.indexOf(text);
	if ((!i) && (text != string.substring(0,txtLength))) {return string;}
	if (i == -1) {return string;}
	var newstr = string.substring(0,i) + by;
	if (i+txtLength < strLength){newstr += html_StringReplace(string.substring(i+txtLength,strLength),text,by);}
	return newstr;
}

/** 
 * @ignore 
 * */
function formHasValue(what) {
    var result = false;
    var output = '';
    for (var i=0,j=what.elements.length;i<j;i++) {
        myType = what.elements[i].type;
		if (myType == 'text' || myType == 'textarea') {if (what.elements[i].value != ''){result = true;}}
        if (myType == 'select-one' || myType == 'select-multiple'){
			if(what.elements[i].selectedIndex !== 0 && what.elements[i].options[what.elements[i].selectedIndex].value!==''){result = true;}
        }
    }
    return result;
}

/** 
 * @ignore 
 * */
function getScrollXY() {
  var scrOfX=0,scrOfY=0;
  if(typeof(window.pageYOffset)=='number'){
    //Netscape compliant
    scrOfY = window.pageYOffset;
    scrOfX = window.pageXOffset;
  }else if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){
    //DOM compliant
    scrOfY = document.body.scrollTop;
    scrOfX = document.body.scrollLeft;
  }else if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){
    //IE6 standards compliant mode
    scrOfY = document.documentElement.scrollTop;
    scrOfX = document.documentElement.scrollLeft;
  }
  return [scrOfX,scrOfY];
}

/** @ignore */
function html_ShowLov(s){
    if(lovUI){
        lovUI.innerHTML = s;
        $x_Show(lovUI);
        lovUI.scrollIntoView(false);
    }
    return;
}

/** @ignore */
function html_GetTarget(e){
	var targ,lEvt;
	if(!e){e = window.event;}
	if(e.target){targ = e.target;}
	else if(e.srcElement){targ = e.srcElement;}
	if(targ.nodeType == 3){targ = targ.parentNode;}// defeat Safari bug
	return targ;  
}

/** @ignore */
function findPosX(obj){
   var lEl=$x(obj),leftOff=0,curleft=0;
   if(lEl.x){
     return lEl.x;
   }else if(lEl.offsetParent){
     while(lEl.offsetParent){
       if(lEl.style.left){
          curleft += parseInt(lEl.style.left.substring(0,lEl.style.left.length-2),10);
          return curleft;
       }else{curleft+=lEl.offsetLeft;}
       lEl=lEl.offsetParent;
     }
   } 
   return curleft;
}

/** 
 * @ignore 
 * */
function findPosY(obj){
   var lEl = $x(obj),curtop = 0;
   if (lEl.y){
     return lEl.y;
   } else if (lEl.offsetParent) {
     while (lEl.offsetParent){
       if ( lEl.style.top )  {
          curtop += parseInt(lEl.style.top.substring(0,lEl.style.top.length-2),10);
          return curtop;
       }else {
          curtop += lEl.offsetTop;
       }
       lEl = lEl.offsetParent;
     }
   }
   return curtop;
}

/** @ignore */
function html_PageTable(table,start,end){
        var tTable = $x(table);
        if(!start){start=1;}
        if(!end){end=25;}
        for(var i=0;i<tTable.rows.length;i++){
			if(i>=!start && i<=end){$x_Show(tTable.rows[i]);}
			else{$x_Hide(tTable.rows[i]);}
        }
}

/** @ignore */
function timestamp(){
   var d, s = "T:";
   var c = ":";
   d = new Date();
   s += d.getHours() + c;
   s += d.getMinutes() + c;
   s += d.getSeconds() + c;
   s += d.getMilliseconds();
   return(s);
}

/** 
 * @ignore 
 * */
var dbaseTime1 = null;

/** 
 * @ignore 
 * */
var dbaseTime2 = null;

/** 
 * @ignore 
 * */
function timeC(t){
	if(dbaseTime1){
	  dbaseTime2 = new Date();
	  dbaseTime1 = null;
	  dbaseTime2 = null;
	}else{
	  dbaseTime1 = new Date();
	}
}

/**
 * calls eval for better compression
 *@ignore
 */

function $u_eval(pThis){
 return eval(pThis);
}




/** 
 * @ignore 
 * */
function setSelectionRange(input, selectionStart, selectionEnd) {
	if (input.setSelectionRange){
		input.focus();
		input.setSelectionRange(selectionStart, selectionEnd);
	}else if(input.createTextRange){
		var range = input.createTextRange();
		range.collapse(true);
		range.moveEnd('character', selectionEnd);
		range.moveStart('character', selectionStart);
		range.select();
	}
}

/** 
 * @ignore 
 * */
function setCaretToPos(input,pos){
  setSelectionRange(input, pos, pos);
}

/** 
 * @ignore 
 * */
function html_ReturnToTextSelection(pText,pThis,pNoSpace){ 
	var cmd = $x(pThis);
	var lSpace = ($v_IsEmpty(cmd)||!!pNoSpace)?'':' ';
	if (document.selection){//IE support for inserting HTML into textarea
		cmd.focus();
		var sel = document.selection;
		var rng = sel.createRange();
		rng.text = rng.text + lSpace + pText;
	}else{ // Mozilla/Netscape support for selecting textarea
		start = cmd.selectionStart;
		end = cmd.selectionEnd;
		cmd.value = cmd.value.slice(0,start) + lSpace + pText + cmd.value.slice(end,cmd.value.length);  
		cmd.focus();
		setCaretToPos (cmd, end +(pText.length + 2));
	}
}

/** 
 * @ignore 
 * */
function setCaretToEnd(input){setSelectionRange(input, input.value.length, input.value.length);}

/** 
 * @ignore 
 * */
function setCaretToBegin(input){setSelectionRange(input,0,0);}

/** 
 * @ignore 
 * */
function selectString (input, string) {
  var match = new RegExp(string, "i").exec(input.value);
  if(match){setSelectionRange(input, match.index, match.index + match[0].length);}
}

/** 
 * @ignore 
 * */
function ob_PPR_TAB(l_URL){
	top.gLastTab = l_URL;
	var lBody = document.body;
	var http = new htmldb_Get(lBody,null,null,null,null,'f',l_URL.substring(2));
	var temp = http.get(null,'<body  style="padding:10px;">','</body>');
	get = null;
	if(document.all){
		var ie_HACK = 'window.parent.obFrameSize()';
		setTimeout(ie_HACK,100);}
	else{window.parent.obFrameSize();}
} 

/** 
 * @ignore 
 * */
function flowSelectAll(){
 var theList, lListLength,i;
	if (typeof(flowSelectArray)=="undefined"){return true;}
	else{
		for (var a=0,len=flowSelectArray.length;a<len;a++){						
			theList = $x(flowSelectArray[a]);
			lListLength = theList.length;
			for (i=0;i<= lListLength-1;i++){theList.options[i].selected = false;}
			for (i=0;i<= lListLength-1;i++){theList.options[i].selected = true;}
		}
	}
 return true;
}

/** 
 * @ignore 
 * */
function charCount(tArea,maxNo,ctrField,maxField,ctrBlock,allowExtra){
	var textArea = $x(tArea);
	var ctrF	 = $x(ctrField);
	var maxF	 = $x(maxField);
	var ctrBlk   = $x(ctrBlock);
	var pctFull  = textArea.value.length / maxNo * 100;
	if (allowExtra != 'Y')
		{if (textArea.value.length >= maxNo)
			{textArea.value = textArea.value.substring(0, maxNo);
			 textArea.style.color = 'red';
			}
		 else
			{msg = null;
			 textArea.style.color = 'black';}
		}
	ctrF.innerHTML = textArea.value.length;
	maxF.innerHTML = maxNo;
	if (textArea.value.length > 0){
    ctrBlk.style.visibility = 'visible';
  }else{
    ctrBlk.style.visibility = 'hidden';
  }

	if (pctFull >= 90){
    ctrBlk.style.color='red';
  }else if (pctFull >= "80"){
    ctrBlk.style.color='#EAA914';
  }else{
    ctrBlk.style.color='black';
  }
}

/** 
 * @ignore 
 * */
function quickLinks(what){
	if (what == 'HIDE'){  
		setClassByClass('a','eLinkOn','eLink');
		setClassByClass('img','eLinkOn','eLink');
		SetCookie('ORA_WWV_QUICK_EDIT',what);
	}else{
		setClassByClass('a','eLink','eLinkOn');
		setClassByClass('img','eLink','eLinkOn'); 
		SetCookie('ORA_WWV_QUICK_EDIT',what);
	}
	$x_Toggle(['hideEdit','showEdit']);
}

/** 
 * @ignore 
 * */
var htmldb_ch=false;

/** 
 * @ignore 
 * */
function htmldb_item_change(e){htmldb_ch=true;}

/** 
 * @ignore 
 * */
function htmldb_doUpdate(r){
	if(htmldb_ch){lc_SetChange();doSubmit(r);}
	else{doSubmit(r);}  
	return;
}

/** 
 * @ignore 
 * */
function htmldb_goSubmit(r){
	if(htmldb_ch){
		if (!htmldb_ch_message || htmldb_ch_message === null){htmldb_ch_message='Are you sure you want to leave this page without saving? /n Please use translatable string.';}
		if (window.confirm(htmldb_ch_message)){doSubmit(r);}
	}else{
		doSubmit(r);
	}
	return;      
} 

/** 
 * @ignore
 * @function
 * @param pURL
 * @param pName
 * @param pWidth
 * @param pHeight
 * @param pScroll
 * @param pResizable
 * @return {Window Object}
 * */
function html_PopUp(pURL,pName,pWidth,pHeight,pScroll,pResizable){
	if(!pURL){pURL = 'about:blank';}
	if(!pName){pName = '_blank';}
	if(!pWidth){pWidth = 600;}
	if(!pHeight){pHeight = 600;}
	if(!pScroll){pScroll = 'yes';}
	if(!pResizable){pResizable = 'yes';}
	l_Window = window.open(pURL,pName,'toolbar=no,scrollbars='+pScroll+',location=no,statusbar=no,menubar=no,resizable='+pResizable+',width='+pWidth+',height='+pHeight);
	if (l_Window.opener === null){l_Window.opener = self;}
	l_Window.focus();
	return l_Window;
}

/** 
 * @ignore 
 * */
function popupFieldHelp(curentItemId, sessionId, closeButtonName){
    var closeButton;
    if (closeButtonName){closeButton = '&p_close_button_name='+closeButtonName;}
    else{closeButton = '';}
    html_PopUp("wwv_flow_item_help.show_help?p_item_id=" + curentItemId + "&p_session=" + sessionId+closeButton,'Help',500,350);
    return;
}

/**
 *@function
 */
function $p_DatePicker(p_element_index,p_form_index,p_date_format,p_bgcolor,p_dd,p_hh,p_mi,p_pm,p_yyyy,p_lang,p_application_format,p_application_id,p_security_group_id,p_mm,p_height){
	var w = open("wwv_flow_utilities.show_as_popup_calendar" + 
			"?p_element_index=" + escape(p_element_index) +
			"&p_form_index=" + escape(p_form_index) +
			"&p_date_format=" + escape(p_date_format) + 
			"&p_bgcolor=" + escape(p_bgcolor) + 
			"&p_dd=" + escape(p_dd) + 
			"&p_hh=" + escape(p_hh) + 
			"&p_mi=" + escape(p_mi) + 
			"&p_pm=" + escape(p_pm) + 
			"&p_yyyy=" + escape(p_yyyy) + 
			"&p_lang=" + escape(p_lang) +
			"&p_application_format=" + escape(p_application_format) + 
			"&p_application_id=" + escape(p_application_id) +	
			"&p_security_group_id=" + escape(p_security_group_id) + 
			"&p_mm=" + escape(p_mm),
			"winLov","Scrollbars=no,resizable=yes,width=258,height="+p_height);
	if (w.opener == null){w.opener = self;}
	w.focus();
	return w
}

/** 
Shows confrm box with message provided in p_Msg if confirm is true then submits the page with request value set to p_Req and then closes the window., mainly used in popup windows.
@function
@param  {String} p_Msg 
@param  {String} p_Req
 * */
function confirmDelete2(p_Msg,p_Req){
	var l_req = (p_Req)?p_Req:'DELETE';
    var l_msg = (p_Msg)?p_Msg:'Would you like to perform this delete action?';
    if (confirm(l_msg)){
        doSubmit(l_req);
        window.close();
     }
}

/** 
 * @ignore
 * similar to lpad (str, 2, '0')
 * */
function LZ(x){return(x<0||x>9?x:"0"+x);}

/** 
 * @ignore 
 * */
function whichElement ( pForm, pElement, pOffset ){
  n = parseInt(pElement.substring(3,pElement.length),10);
  m = n + parseInt(pOffset,10);  
  return  eval("document." + pForm + ".p_t" + LZ(m));
}

/** 
 * @ignore 
 * */
function nullFields(event, pField1, pField2, pField3) {
    var code = 0;
    code = event.keyCode;
    if (code > 45 && code < 106 || code == 8) {
      if (pField1) {pField1.value = "";}
      if (pField1) {pField2.value = "";}
      if (pField3) {pField3.value = "";}
    }
}

/** 
 * @ignore 
 * */
function selectAll(fromList){
	var len=fromList.length;
	for(var i=0;i<len;i++){fromList.options[i].selected = true;}
	return true;
}
/** 
 * @ignore 
 * */
var gChangeCheck = false;
/** 
 * @ignore 
 * */
function lc_SetChange(){
	if (!!gChangeCheck){
		gChangeCheck.value = 1;
		gChangeCheck.type = 'text';
	}
}

/** 
 * @ignore 
 * */
function setValue2(id,val,errorMsg){
	var obj = $x(id);
	if(obj){
		$x_Value(obj,val);
		if ($v(obj) != val){alert(errorMsg);}
	}
}

/*Begin DHTML Menus*/

/** 
 * @ignore 
 * */
var gCurrentAppMenu = false;

/** @ignore */
var gCurrentAppMenuImage = false;

/** @ignore */
var gSubMenuArray = [];

/** @ignore */
var g_Single_Menu = false;

/** @ignore */
var g_Single_Menu_Count = 0;

/** @ignore */
function dhtml_CloseAllSubMenus(pStart){
  var l_Start = null;
  if(!pStart){l_Start = 0;}
  else{l_Start = pStart;}

  for (var i=l_Start;i<=gSubMenuArray.length;i++){
    if(gSubMenuArray[i]){
      var l_Sm = $x_Hide(gSubMenuArray[i]);
      if(l_Sm){$x_Hide(l_Sm);}
    }
  }
  /*if you deleted starting from level do not null out array*/
  if(!pStart){gSubMenuArray.length = 0;}
  htmldb_IE_Select_Item_Fix(false);
  return;
}

/** @ignore */
function dhtml_CloseAllSubMenusL(pThis){
  var l_Start = parseInt($x_UpTill(pThis,'UL').getAttribute("htmldb:listlevel"),10)+1;
  dhtml_CloseAllSubMenus(l_Start);
  return;
}

/** @ignore */
var g_dhtmlMenu = "dhtmlMenu";

/** @ignore */
function app_AppMenuMultiClose(){
  if(gCurrentAppMenu){
    var lMenu = $x(gCurrentAppMenu);
    gCurrentAppMenuImage.className = g_dhtmlMenu;
    $x_Hide(lMenu);
    gCurrentAppMenu = false;
    gCurrentAppMenuImage = false;
  }
  return;
}

/** @ignore */
function dhtml_DocMenuCheck(e){
  var tPar = html_GetTarget(e);
  var l_Test = true;
    while(tPar.nodeName != 'BODY'){
  	  tPar = tPar.parentNode;
      if(html_SubString(tPar.className,'dhtmlMenuLG')){l_Test = !l_Test;}
    }
  if(l_Test){
    app_AppMenuMultiClose();
    dhtml_CloseAllSubMenus();
    document.onclick = null;
  }
  else{
  }
  return;
}

/** @ignore */
function dhtml_ButtonDropDown(pThis,pThat,pDir,pX,pY){dhtml_SingeMenuOpen(pThis,pThat,'Bottom',pX,pY);return;}

/** @ignore */
function dhtml_MenuOpen(pThis,pThat,pSub,pDir){
    if($x(pThat)){
      document.onclick = dhtml_DocMenuCheck;
      if(!pSub){
        dhtml_CloseAllSubMenus();
        gCurrentAppMenu = pThat;
      }else{
        var l_Level = parseInt($x(pThat).getAttribute("htmldb:listlevel"),10);
        var l_Temp = gSubMenuArray[l_Level];
        if(l_Temp){$x_Hide(l_Temp);}
        gSubMenuArray[l_Level] = $x(pThat);
       }
        var lMenu = $x(pThat);
        document.body.appendChild(lMenu);
        if(!pDir || pDir == 'Right'){
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(findPosY(pThis),10)+"px");
          lMenu.style.left = (parseInt(findPosX(pThis),10)+"px");
        }else if(pDir == 'Bottom'){
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(findPosY(pThis),10) + parseInt(pThis.offsetHeight,10)+"px");
          lMenu.style.left = (parseInt(findPosX(pThis),10)+"px");
        }else if(pDir == 'BottomRight'){
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(findPosY(pThis),10) + parseInt(pThis.offsetHeight,10)+"px");
          lMenu.style.left = (parseInt(findPosX(pThis),10) - parseInt(pThis.offsetWidth,10)+"px");
        }else{
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(findPosY(pThis),10)+"px");
          lMenu.style.left = (parseInt(findPosX(pThis),10) + parseInt(pThis.offsetWidth,10)+"px");
        }
        $x_Show(lMenu);
        dhtml_FixLeft(pThis,lMenu,pDir);
        htmldb_IE_Select_Item_Fix(lMenu);
        }
      return;
}

/** @ignore */
function dhtml_DocMenuSingleCheck(e,force){
	if(g_Single_Menu_Count > 0){
		var l_Test = true;
		if(e){
			var tPar = html_GetTarget(e);
			while(tPar.nodeName != 'BODY' && !force){
				tPar = tPar.parentNode;
				if(tPar == g_Single_Menu){l_Test = !l_Test;}
			}
		}
		if(l_Test || force){
			$x_Hide(g_Single_Menu);
			document.onclick = null;
		}else{}
	}else{
		g_Single_Menu_Count = 1;
	}
	return;
}

/** @ignore */
function dhtml_SingeMenuOpen(pThis,pThat,pDir,pX,pY){
        var lMenu = $x(pThat);
        var lThis = $x(pThis);
        lMenu.style.zIndex = 2001;
        document.body.appendChild(lMenu);
        if(!pDir || pDir == 'Right'){
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(findPosY(lThis),10)+"px");
          lMenu.style.left = (parseInt(findPosX(lThis),10)+"px");
        }else if(pDir == 'Bottom'){
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(findPosY(lThis),10) + parseInt(lThis.offsetHeight,10)+"px");
          lMenu.style.left = (parseInt(findPosX(lThis),10)+"px");
        }else if(pDir == 'BottomRight'){
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(findPosY(lThis),10) + parseInt(lThis.offsetHeight,10)+"px");
          lMenu.style.left = (parseInt(findPosX(lThis),10) - parseInt(lThis.offsetWidth,10)+"px");
        }else if(pDir == 'Set'){
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(pY,10)+"px");
          lMenu.style.left = (parseInt(pX,10)+"px");
        }else {
          lMenu.style.position = "absolute";
          lMenu.style.top = (parseInt(findPosY(lThis),10)+"px");
          lMenu.style.left = (parseInt(findPosX(lThis),10) + parseInt(lThis.offsetWidth,10)+"px");
        }

      $x_Show(lMenu);
      dhtml_FixLeft(lThis,lMenu,pDir);
      htmldb_IE_Select_Item_Fix(true);
      g_Single_Menu_Count = 0;
      g_Single_Menu = lMenu;
      document.onclick = dhtml_DocMenuSingleCheck;
      return;
}

/** @ignore */
function dhtml_FixLeft(pThis,pMenu,pDir){
     var l_Width;
     if(document.all){
     	 l_Width = document.body.clientWidth;
     } else {
     	 l_Width = window.innerWidth;
     }
     if (pDir=='bottom') {
       if(parseInt(l_Width,10) < parseInt(findPosX(pThis),10) + parseInt(pThis.offsetWidth,10) + parseInt(pMenu.offsetWidth,10)){
         pMenu.style.position = "absolute";
         pMenu.style.left = (parseInt(findPosX(pThis),10) - parseInt(pMenu.offsetWidth,10))+"px";
       }
     } else {
       if(parseInt(l_Width,10) < parseInt(findPosX(pThis),10) + parseInt(pMenu.offsetWidth,10)){
         pMenu.style.position = "absolute";
         pMenu.style.left = (parseInt(findPosX(pThis),10) - parseInt(pMenu.offsetWidth,10))+"px";
       }
     }  
     return;
}

/** @ignore */
function htmldb_IE_Select_Item_Fix(pTest){
  /* only run in IE and only if there is a select in the page*/
  var lSel = document.getElementsByTagName('SELECT').length >= 1;
  if(document.all && pTest && lSel){
        if(pTest.firstChild && pTest.firstChild.nodeName != 'IFRAME'){
          pTest.innerHTML = '<iframe  src="'+htmldb_Img_Dir+'blank.html" width="'+pTest.offsetWidth+'" height="'+pTest.offsetHeight+'" style="z-index:-10;position: absolute;left: 0;top: 0;filter: progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0);" scrolling="no" frameborder="0"></iframe>' + pTest.innerHTML;
        }
  } 
  return;
}

/** @ignore */
var g_dhtmlMenuOn = "dhtmlMenuOn";

/** @ignore */
function app_AppMenuMultiOpenBottom(pThis,pThat,pSub){
      var lMenu = $x(pThat);
      if(pThis != gCurrentAppMenuImage){
        app_AppMenuMultiClose();
        var l_That = pThis.previousSibling.firstChild ; 
        pThis.className = g_dhtmlMenuOn;
        dhtml_MenuOpen(l_That,pThat,false,'Bottom');
        gCurrentAppMenuImage = pThis;
      }else{
        dhtml_CloseAllSubMenus();
        app_AppMenuMultiClose();
      }
  return;
}

/** @ignore */
function app_AppMenuMultiOpenBottom2(pThis,pThat,pSub){
      var lMenu = $x(pThat);
      if(pThis != gCurrentAppMenuImage){
        app_AppMenuMultiClose();
        var l_That = pThis.parentNode; 
        pThis.className = g_dhtmlMenuOn;
        dhtml_MenuOpen(l_That,pThat,false,'Bottom');
        gCurrentAppMenuImage = pThis;
      }else{
        dhtml_CloseAllSubMenus();
        app_AppMenuMultiClose();
      }
  return;
}

/** @ignore */
function $a_report(pId,pMin,pMax,pFetched,pSort){
	lThis = $u_js_temp_drop();
	var lOld = $x('report_'+pId+'_catch');
	lOld.id = 'report_'+pId+'_catch_old';
	var l_URL = 'p='+$v('pFlowId')+':'+$v('pFlowStepId')+':'+$v('pInstance')+':FLOW_PPR_OUTPUT_R'+pId+'_';
	if(!!pSort){l_URL += pSort+'::RP&fsp_region_id='+pId;}
	else{l_URL += 'pg_R_'+pId+':NO&pg_max_rows='+pMax+'&pg_min_row='+pMin+'&pg_rows_fetched='+pFetched;}
	var ajax = new htmldb_Get(null,null,null,null,null,'f',l_URL);
    var gReturn = ajax.get();
	lThis.innerHTML = gReturn;
	lOld.innerHTML = $x('report_'+pId+'_catch').innerHTML;
	lOld.id = 'report_'+pId+'_catch';
	lThis.innerHTML = '';
	return;
}

/**
 * puts an invisible and temporary div in the page to capture html coming in from an ajax call
 * @function
 */

function $u_js_temp_drop(){
	var lThis = $x('apex_js_temp_drop');
	if(!lThis){
		lThis = $dom_AddTag(document.body,'DIV');
		lThis.id = 'apex_js_temp_drop';
		$x_Hide(lThis);
	}
	lThis.innerHTML = '';
	return lThis;
}

function $u_js_temp_clear(){
	var lThis = $x('apex_js_temp_drop');
	if(lThis){lThis.innerHTML = '';}
	return lThis;
}


/** @ignore */
function $a_report_Split(pThis,pArgs){
	var lArgs=pArgs.split("_");
	$a_report(pThis,lArgs[0],lArgs[1],lArgs[2]);
}

/* Begin Smart Table Code */

/** @ignore */
function html_RemoveRow(pId){
 var l_Table = $x('htmldbAddRowTable');
 var l_Row = $x_UpTill(pId,'TR');
 if(l_Table.childNodes.length >= 2 && l_Row){
  l_Table.removeChild(l_Row);
  l_Table.normalize();
 }
 return;
}
/* inits the Add Row Table */

/** @ignore */
var g_CheckedArray_IE;

/** @ignore */
function ie_RowFixStart(pThis){
  if(document.all){
		var l_Items = $x_FormItems(pThis,'checkbox');
		g_CheckedArray_IE = [];
		for (var i=0,len=l_Items.length;i<len;i++){if(l_Items[i].type == 'checkbox'){g_CheckedArray_IE[i] = l_Items[i].checked;}}
	}
}

/** @ignore */
function ie_RowFixFinish(pThis){
  if(document.all){
		var l_Items = $x_FormItems(pThis,'checkbox');
		for (var i=0,len=l_Items.length;i<len;i++){if(l_Items[i].type == 'checkbox'){l_Items[i].checked = g_CheckedArray_IE[i];}}
 }
}
/*begin fix for ie unchecking checkbox on row move*/

/** @ignore */
function html_InitAddRowTable(){
  var l_Table = $x('htmldbAddRowTable');
  var l_Cell = l_Table.rows[0].cells[l_Table.rows[0].cells.length-1];
  l_Cell.innerHTML ="<br />";
  l_Cell.className = l_Table.rows[0].cells[l_Table.rows[0].cells.length-2].className;
  return;
}

var gLastRowMoved = null;

/** @ignore */
var gLastRowMovedColor = '#CCCCCC';

/** @ignore */
var gLastRowHighlight = true;

/** @ignore */
function $tr_RowMoveFollow(pThis,pColorLastRow){
	if(gLastRowHighlight){
	  if(pColorLastRow && gLastRowMoved){html_RowHighlightOff(gLastRowMoved);}
		html_RowHighlight(pThis,gLastRowMovedColor);
	}
	gLastRowMoved = pThis;
}

/** @ignore */
function html_RowUp(pThis,pColorLastRow){
	var l_Row = $x_UpTill(pThis,'TR');
	ie_RowFixStart(l_Row);
	$tr_RowMoveFollow(l_Row,pColorLastRow);
	var l_Table = l_Row.parentNode;
	var l_RowPrev = l_Row.previousSibling;
	while(!!l_RowPrev){
		if(l_RowPrev.nodeType == 1){break;}
		l_RowPrev = l_RowPrev.previousSibling;
	}
	if(!!l_RowPrev && !!l_RowPrev.firstChild && l_RowPrev.firstChild.nodeName != 'TH' && l_RowPrev.nodeName == 'TR'){
		oElement = l_Table.insertBefore(l_Row ,l_RowPrev);
	}else{
		oElement = l_Table.appendChild(l_Row);
	}
	ie_RowFixFinish(oElement);
	return oElement;
 }

/** @ignore */
function html_RowDown(pThis,pColorLastRow){
  var l_Row = $x_UpTill(pThis,'TR');
	ie_RowFixStart(l_Row);
  $tr_RowMoveFollow(l_Row,pColorLastRow);
  var l_Table = l_Row.parentNode;
  var l_RowNext = l_Row.nextSibling;
  while(!!l_RowNext){
	 if(l_RowNext.nodeType == 1){break;}
	 l_RowNext = l_RowNext.nextSibling;
  }
	if(!!l_RowNext && l_RowNext.nodeName == 'TR'){
    oElement = l_Table.insertBefore(l_Row ,l_RowNext.nextSibling);
  }else{
    oElement = l_Table.insertBefore(l_Row ,l_Table.getElementsByTagName('TR')[1]);
  }
	ie_RowFixFinish(oElement);
  return oElement;
}

/* tool tip section */

/** @ignore */
var tt_target;

/** @ignore */
var gToolTipGraphic = "arrow2.gif";

/** @ignore */
var gToolTip = false;

/** @ignore */
var gToopTipPointer = false;

/** @ignore */
var gToolTipContent = false;

/** @ignore */
function toolTip_init(){
  if (document && document.body) {
	    gToolTipContent = $x('gToolTipContent');
        gToolTip = $x("dhtmltooltip");
        if (!gToolTip){
			gToolTip = $dom_AddTag(document.body,'DIV');
			gToolTip.id="dhtmltooltip";
			gToolTip.className="htmldbToolTip";
			gToolTip.style.position = "absolute";
			gToolTip.style.border="1px solid black"; 
			gToolTip.style.padding="2px"; 
			gToolTip.style.backgroundColor=""; 
			gToolTip.style.visibility="hidden"; 
			gToolTip.style.zIndex=10000;
        }
        gToopTipPointer=$x("dhtmlpointer");
        if (!gToopTipPointer) {
			gToopTipPointer = $dom_AddTag(document.body,'IMG');
			gToopTipPointer.id="dhtmlpointer";
			gToopTipPointer.src= htmldb_Img_Dir + gToolTipGraphic;
			gToopTipPointer.style.position = "absolute";
			gToopTipPointer.style.zIndex=10001;  
        }
     return true;
    } else {
     return false;
    }
}

/** @ignore */
function toolTip_disable(){
	if(toolTip_init()){
		tt_target = null;
		gToolTip.style.visibility="hidden";
		gToolTip.style.backgroundColor='';
		gToolTip.style.width='';
		gToopTipPointer.style.visibility="hidden";
		if(gToolTipContent){gToolTipContent.innerHTML='';}
		else{gToolTip.innerHTML='';}   
	}
}

/** @ignore */
function toolTip_enable(evt,obj,tip, width, color){
    evt=(evt)?evt:((window.event)?event:null);
    var target_x=evt.pageX?evt.pageX:evt.clientX+getScrollXY()[0];
    var target_y=evt.pageY?evt.pageY:evt.clientY+getScrollXY()[1];
    if(toolTip_init()){
    tt_target = obj;
    if(!tip){tip = obj.getAttribute("htmldb:tip");}
    if(gToolTipContent){gToolTipContent.innerHTML=tip;}else{gToolTip.innerHTML=tip;}
    if(!!width){gToolTip.style.width=width+"px";}
    if(!!color){gToolTip.style.backgroundColor=color;}else{gToolTip.style.backgroundColor="lightyellow";}
    gToopTipPointer.style.left = ( 10 + target_x ) +"px";
    gToopTipPointer.style.top  = (15 + target_y ) +"px";   
    gToolTip.style.left = ( 7 + target_x ) +"px";
    gToolTip.style.top  = ( 28 + target_y ) +"px";   
    gToolTip.style.visibility="visible";
    gToolTip.style.zIndex=10000;
    gToopTipPointer.style.zIndex=10001;
    gToopTipPointer.style.visibility="visible";
    try {obj.addEventListener("mouseout",toolTip_disable, false);}
	catch(e){obj.attachEvent('onmouseout',toolTip_disable);}
   }
    return false;
}

/** @ignore */
function toolTip_follow(evt,obj){
    evt=(evt)?evt:((window.event)?event:null);
    var target_x=evt.pageX?evt.pageX:evt.clientX+getScrollXY()[0];
    var target_y=evt.pageY?evt.pageY:evt.clientY+getScrollXY()[1];
    if (gToolTip) {
		gToolTip.style.left = ( 7 + target_x ) +"px";
		gToolTip.style.top  = ( 28 + target_y ) +"px";   
		gToolTip.style.visibility="visible";
		gToolTip.style.zIndex=10000;
		gToopTipPointer.style.left = ( 10 + target_x ) +"px";
		gToopTipPointer.style.top  = (15 + target_y ) +"px";
		gToopTipPointer.style.zIndex=10001;
		gToopTipPointer.style.visibility="visible";
    }
    return false;
}

/** @ignore */
function dhtml_ShuttleValue(pThis,pThat){
	var l_SelectArray = [];
	var l_From = $x(pThis);
	var l_To = $x(pThat); 
	l_SelectArray = html_SelectedOptions(l_From);
	if($x(l_SelectArray)){l_SelectArray = [l_SelectArray];}
	for (var i=0;i<l_SelectArray.length;i++){l_To.appendChild(l_SelectArray[i]);}
}

/** 
 * create javascript object to run shuttle item
 * @constructor
 * @param {DOM node | String} pThis
 * @param {DOM node | String} pThat
 * */
function dhtml_ShuttleObject(pThis,pThat){
 this.Select1 = $x(pThis);
 this.Select2 = $x(pThat);
 this.Select1ArrayInit = this.Select1.cloneNode(true);
 this.Select2ArrayInit = this.Select2.cloneNode(true);
 this.Op1Init = [];
 this.Op2Init = []; 
 this.Op1Init = this.Select1ArrayInit.options;
 this.Op2Init = this.Select2ArrayInit.options;
    /**
	 * @extends dhtml_ShuttleObject
	 */
	this.move = function (){
		var l_A = html_SelectedOptions(this.Select1);
		if($x(l_A)){l_A = [l_A];}
		var l_AL = l_A.length;
		for (var i=0;i<l_AL;i++){this.Select2.appendChild(l_A[i]);}
	};
    /**
	 * @extends dhtml_ShuttleObject
	 */
	this.remove = function (){
		var l_A = html_SelectedOptions(this.Select2);
		if($x(l_A)){l_A = [l_A];}
		var l_AL = l_A.length;
		for (var i=0;i<l_AL;i++){this.Select1.appendChild(l_A[i]);}
	};
    /**
	 * @extends dhtml_ShuttleObject
	 */

	this.reset =  function (){
		this.Select1.options.length = 0;
		this.Select2.options.length = 0;
		var L_Count1 = this.Op1Init.length;
		for(var i=0;i<L_Count1;i++){this.Select1.options[i]= new Option(this.Op1Init[i].text,this.Op1Init[i].value);}
		var L_Count2 = this.Op2Init.length;
		for(var i2=0;i2<L_Count2;i2++){this.Select2.options[i2]= new Option(this.Op2Init[i2].text,this.Op2Init[i2].value);}
	};
    /**
	 * @extends dhtml_ShuttleObject
	 */

	this.move_all = function (){
		for (var i=0,len=this.Select1.options.length;i<len;i++){this.Select1.options[i].selected=true;}
		this.move();
	};
    /**
	 * @extends dhtml_ShuttleObject
	 */

	this.remove_all =  function (){
		for (var i=0,len=this.Select2.options.length;i<len;i++){this.Select2.options[i].selected=true;}
		this.remove();
	};
    /**
	 * @extends dhtml_ShuttleObject
	 */

	this.sort = function (pShuttle,pDir){
		var nextOption,i;
		var lLength = pShuttle.options.length;
		if(pDir == 'U'){
			for (i=0;i<lLength;i++){
				if(!!pShuttle.options[i].selected){if(pDir == 'U'){if(!!i){pShuttle.insertBefore(pShuttle.options[i], pShuttle.options[i-1]);}}}
			}
		}else if(pDir == 'D'){
			for (i=lLength-1;i>=0;i--){
				if(!!pShuttle.options[i].selected){if(pDir == 'D'){if(i!=lLength-1){pShuttle.insertBefore(pShuttle.options[i], pShuttle.options[i+2]);}}}
			}
		}else{
			var l_Opt = [];
			for (i=0;i<lLength;i++){if(!!pShuttle.options[i].selected){l_Opt[l_Opt.length] = pShuttle.options[i];}}
			if(pDir == 'B'){
				for (i=0;i<l_Opt.length;i++){pShuttle.appendChild(l_Opt[i]);}
			}else if(pDir == 'T'){
				for (i=l_Opt.length-1;i>=0;i--){pShuttle.insertBefore(l_Opt[i],pShuttle.firstChild);}
			}
		}
	};
    /**
	 * @extends dhtml_ShuttleObject
	 */
	this.sort1 = function (pDir){this.sort(this.Select1,pDir);};
    /**
	 * @extends dhtml_ShuttleObject
	 */	
	this.sort2 = function (pDir){this.sort(this.Select2,pDir);};
 return;
}

/** 
 * @ignore
 * @function
 * */
function $d_Overlap(pThis,pThat){
	var lReturn = true;
	var lReturn2 = true;
	var l =	 findPos(pThis);
	var lX = l[0];
	var lY = l[1];
	var lT = findPos(pThat);
	var lTX = lT[0];
	var lTY = lT[1];
	if(lTX > lX || lX > lTX + pThat.offsetWidth){lReturn = false;}
	if(lTY > lY || lY > lTY + pThat.offsetHeight){lReturn = false;}
	return lReturn;
}

/** 
 * @ignore
 * @function
 * */
function apex_RefreshChart(page_id,region_id,browser_lang) {
	var get = new htmldb_Get(null,$v('pFlowId'), 'FLOW_FLASH_CHART_R' + region_id + '_' + browser_lang, page_id);
	var gReturn = get.get();   
	get = null;
	if(ie){window["c"+region_id].SetXMLText(gReturn);}
	else{document["c"+region_id].SetXMLText(gReturn);}
} 

/** 
 * @ignore
 * @function
 * */
function apex_SWFFormFix(swfname){
  if(!ie){return false;}
  var testnodename = "SWFFormFix";
  document.write('<div id="'+testnodename+'" onclick="apex_SWFFormFixCallback(this,\''+swfname+'\');return false;" style="display:none">&nbsp;</div>');
  $x(testnodename).onclick();
}

/** 
 * @ignore
 * @function
 * */
function apex_SWFFormFixCallback(obj,swfname){
  var path = document;   
  var testnode = obj;
  while(obj == obj.parentNode){
    if(obj.nodeName.toLowerCase() == "form"){
      if(!!obj.name && obj.name.length > 0){
        path = path.forms[obj.name];
      }
    }
  }
  testnode.parentNode.removeChild(testnode);   
  window[swfname]=path[swfname];
  return true;
}

/** 
 * @ignore
 * @function
 * */
function colorPopUp(pItemName){
 return html_PopUp("wwv_flow_utilities.gen_popup_color?p_item_name=" + escape(pItemName),"ColorPicker",250,255,'no','no');
}

/** 
 * @ignore
 * @function
 * */
function changePreviewColor(pThis){
	var x = $x(pThis).value;
	$x_Style(pThis.id+'_PREVIEW','background',x);
}

/** 
 * @deprecated
 * @function
 * */
function html_processing(){
  var t = $x("htmldbWait");
   if (!t) {
    var l_newDiv = document.createElement('DIV');
    l_newDiv.className="htmldbProcessing";
    l_newDiv.style.zIndex=20000;
    l_newDiv.id = "htmldbDisablePage";
    l_newDiv.style.width = "100%";
    l_newDiv.style.height = "100%";
    l_newDiv.onclick = "return false;";
    l_newDiv.style.position="absolute";
    l_newDiv.style.top="0";
    l_newDiv.style.left="0";
    document.body.insertBefore(l_newDiv,document.body.firstChild);
  }
}
/** 
 * @deprecated
 * @function
 * */
function html_enableBase(){
  var t = $x("htmldbDisablePage");
   if (t){t.parentNode.removeChild(t);}
}
/** 
 * @deprecated
 * @function
 * */
function html_disableBase(z,c){
  var t = $x("htmldbDisablePage");
   if (!t) {
    var l_newDiv = document.createElement('DIV');
    l_newDiv.className = (!!c)?c:"htmldbDisablePage";
    l_newDiv.style.zIndex=z;
    l_newDiv.id = "htmldbDisablePage";
    l_newDiv.style.width = "100%";
    l_newDiv.style.height = "100%";
    l_newDiv.onclick = "return false;";
    l_newDiv.style.position="absolute";
    l_newDiv.style.top="0";
    l_newDiv.style.left="0";
    document.body.insertBefore(l_newDiv,document.body.firstChild);
  }
}
/** 
 * @deprecated
 * @function
 * */
function dhtml_CloseDialog(pThis){
  html_enableBase();
  $x_Hide($x_UpTill(pThis,'TABLE'));
  toolTip_disable();
}
/** 
 * @deprecated
 * @function
 * */
function html_Centerme(id){
	var t = $x(id);
	if(document.all){
		l_Width = document.body.clientWidth;
		l_Height = document.body.clientHeigth;
	}else{
		l_Width = window.innerWidth;
		l_Height = window.innerHeight;
	}
	var tW=t.offsetWidth;
	var tH=t.offsetHeight;  
	t.style.top = '40%';
	t.style.left = '40%';
}
/** 
 * @deprecated
 * @function
 * */
function hideShow(objectID,imgID,showImg,hideImg){
    var theImg = $x(imgID);
    var theDiv = $x(objectID);
    if(theDiv.style.display == 'none' || theDiv.style.display == '' || theDiv.style == null){
        theImg.src = hideImg;
        $x(objectID).style.display = 'block';}
    else{
        theImg.src = showImg;
        $x(objectID).style.display = 'none';}
    return;
}
/** 
 * @deprecated
 * @function
 * */
function disableItems(testString,item1,item2,item3,item4,item5,item6,item7,item8,item9,item10){
	var theTest = eval(testString);
	var i = 1;
	if(theTest){
		for(i;i<12;i++){
			if (!!arguments[i]){
				disItem = $x(arguments[i]);
				disItem.style.background = '#cccccc';
				disItem.disabled = true;
			}
		}
	}else{
		for(i;i<12;i++){
			if (!!arguments[i]){
				disItem = $x(arguments[i]);
				disItem.disabled = false;
				disItem.style.background = '#ffffff';
			}
		}
	}
}   
/** 
 * @deprecated
 * @function
 * */
function htmldbCheckCookie(pThis){
  SetCookie ('ISCOOKIE','true');
  flow = GetCookie ('ISCOOKIE');
  return;
}
/** 
 * @deprecated
 * @function
 * */
function shuttleItem(theSource, theDest, moveAll) {
    var srcList  = $x(theSource),destList = $x(theDest),arrsrcList = [],arrdestList = [],arrLookup = [],i;
    if (moveAll){
    for (i = 0;i <= srcList.length-1; i++ ){
			  srcList.options[i].selected = true;}
    }
    for (i = 0; i < destList.options.length; i++) {
        arrLookup[destList.options[i].text] = destList.options[i].value;
        arrdestList[i] = destList.options[i].text;}
    var fLength = 0;
    var tLength = arrdestList.length;
    for(i = 0; i < srcList.options.length; i++) {
        arrLookup[srcList.options[i].text] = srcList.options[i].value;
        if (!!srcList.options[i].selected && !!srcList.options[i].value) {
            arrdestList[tLength] = srcList.options[i].text;
            tLength++;}
        else {
            arrsrcList[fLength] = srcList.options[i].text;
            fLength++;}
    }
    arrsrcList.sort();
    arrdestList.sort();
    srcList.length = 0;
    destList.length = 0;
    var c,no;
    for(c = 0; c < arrsrcList.length; c++) {
        no = new Option();
        no.value = arrLookup[arrsrcList[c]];
        no.text = arrsrcList[c];
        srcList[c] = no;
    }
    for(c = 0; c < arrdestList.length; c++) {
        no = new Option();
        no.value = arrLookup[arrdestList[c]];
        no.text = arrdestList[c];
        destList[c] = no;
       }
} 
/** 
 * @deprecated
 * @function
 * */
function cDebug(pThis,pThat){}
/** 
 * @deprecated
 * @function
 * */
function html_VisibleElement(pNd){var l_Node = $x(pNd);if(l_Node){l_Node.style.visibility = "visible";}return l_Node;}
/** 
 * @deprecated
 * @function
 * */
function html_HiddenElement(pNd){var l_Node = $x(pNd);if(l_Node){l_Node.style.visibility = "hidden";}return l_Node;}
/** 
 * @deprecated use 
 * @function
 * */
function html_TabMakeCurrent(pThis){var node = $x(pThis);if(node){var nodeSibs = node.parentNode.parentNode.childNodes;for(var i=0;i < nodeSibs.length;i++){if(nodeSibs[i] && nodeSibs[i].nodeType == 1 && nodeSibs[i].getElementsByTagName('A')[0]){nodeSibs[i].getElementsByTagName('A')[0].className = "";}}pThis.className = "tabcurrent";}return node;}
/** 
 * @deprecated use $x_HideSiblings
 * @function
 * */
html_HideSiblings = $x_HideSiblings;
/** 
 * @deprecated use $x_ShowSiblings
 * @function
 * */
html_ShowSiblings = $x_ShowSiblings;
/** 
 * @deprecated
 * @function
 * */
function html_ShowAllByClass(pThis,pClass,pTag) {$x_ShowAllByClass(pThis,pClass,pTag);}
/** 
 * @deprecated
 * @function
 * */
function f_Hide_On_Value_Item(pThis,pThat,pValue){return $f_Hide_On_Value_Item(pThis,pThat,pValue);}
/** 
 * @deprecated
 * @function
 * */
function f_Hide_On_Value_Item_Row(pThis,pThat,pValue){return $f_Hide_On_Value_Item_Row(pThis,pThat,pValue);}
/** 
 * @deprecated
 * @function
 * */
function html_disableItems(a,nd){if(nd){var lArray = [];for (var i=1,len=arguments.length;i<len;i++){if(arguments[i]){lArray[lArray.length]=arguments[i];}}html_disableItem(lArray,a);}return;}
/** 
 * @deprecated
 * @function
 * */
function html_GetPageScroll(){return getScrollXY()[1];}
/** 
 * @deprecated
 * @function
 * */
function popUpNamed(pURL,pName) {html_PopUp(pURL,pName,null,null);}
/** 
 * @deprecated
 * @function
 * */
function popUp2(pURL,pWidth,pHeight) {day = new Date();pName = day.getTime();html_PopUp(pURL,pName,pWidth,pHeight);}
/** 
 * @deprecated
 * @function
 * */
function popUp(pURL) {day = new Date();pName = day.getTime();html_PopUp(pURL,pName,null,null);}
/** 
 * @deprecated
 * @function
 * */
function popupURL(pURL){html_PopUp(pURL,"winLov",800,600);}
/** 
 * @deprecated
 * @function
 * */
function $x_SetClassArray(pNd,pClass){$x_Class(pNd,pClass);}
/** 
 * @deprecated
 * @function
 * */
function html_TabClick(pThis,pId){var nodeSibs = $x(pThis).parentNode.parentNode.childNodes , lSibArray = [];for(var i=0;i < nodeSibs.length;i++){if($x(nodeSibs[i]) && nodeSibs[i].getElementsByTagName('A')[0]){lSibArray[lSibArray.length] = nodeSibs[i].getElementsByTagName('A')[0];}}$d_TabClick(pThis,pId,'tabcurrent',lSibArray);return;}
/** 
 * @deprecated
 * @function
 * */
function detailTab(id){html_TabClick(id);return;}
/** 
 * @deprecated
 * @function
 * */
function retFalse(){return false;}
/** 
 * @deprecated
 * @function
 * */
function getSelected(opt){var selected=[];for (var i=0;i<opt.length;i++){if (opt[i].selected){selected[selected.length]=opt[i];}}return selected;}
/** 
 * @deprecated
 * @function
 * */
 $x_AddTag = $dom_AddTag;
/** 
 * @deprecated
 * @function
 * */
function html_CreateFormElement(pType,pName,pValue){return $dom_AddInput(false,pType,'',pName,pValue);}
/** 
 * @deprecated
 * @function
 * */
html_disableItem = $x_disableItem;
/** 
 * @deprecated
 * @function
 * */
html_CascadeUpTill = $x_UpTill;
/** 
 * @deprecated
 * @function
 * */
html_HideItemRow=$x_HideItemRow;
/** 
 * @deprecated
 * @function
 * */
html_ShowItemRow=$x_ShowItemRow;
/** 
 * @deprecated
 * @function
 * */
html_ToggleItemRow=$x_ToggleItemRow;
/** 
 * @deprecated
 * @function
 * */
html_ShowAllChildren = $x_ShowChildren;
/** 
 * @deprecated
 * @function
 * */
setStyle = $x_Style;
/** 
 * @deprecated
 * @function
 * */
html_replace = html_StringReplace;
/** 
 * @deprecated
 * @function
 * */
upperMe = $v_Upper;
/** 
 * @deprecated
 * @function
 * */
html_DisableOnValue = $f_DisableOnValue;
/** 
 * @deprecated
 * @function
 * */
htmldb_ToggleTableBody = $x_ToggleWithImage;
/** 
 * @deprecated
 * @function
 * */
htmldb_ToggleWithImage = $x_ToggleWithImage;
/** 
 * @deprecated
 * @function
 * */
html_Return_Form_Items = $x_FormItems;
/** 
 * @deprecated
 * @function
 * */
html_Find = $d_Find;
/** 
 * @deprecated
 * @function
 * */
$f_SetValue = $x_Value;
/** 
 * @deprecated
 * @function
 * */
setValue = $x_Value;
/** 
 * @deprecated
 * @function
 * */
html_MakeParent = $dom_MakeParent;
/** 
 * @deprecated
 * @function
 * */
isEmpty = $v_IsEmpty;
/** 
 * @deprecated see $x()
 * @function
 * */
html_GetElement=$x;
/** 
 * @deprecated see $x()
 * @function
 * */
$x_El = $x;
/** 
 * @deprecated see $x_Toggle()
 * @function
 * */
html_ToggleElement = $x_Toggle;
/** 
 * @deprecated see $x_Hide()
 * @function
 * */
html_HideElement = $x_Hide;
/** 
 * @deprecated see $x_Show()
 * @function
 * */
html_ShowElement = $x_Show;
/** 
 * @deprecated see $u_SubString()
 * @function
 * */
html_SubString = $u_SubString;
/** 
 * @deprecated
 * @function
 * */
getElementsByClass = $x_ByClass;
/** 
 * @deprecated
 * @function
 * */
html_SwitchImageSrc = $x_SwitchImageSrc;
/** @ignore */
html_CheckValueAgainst = $v_CheckValueAgainst;
/** 
 * @deprecated
 * @function
 * */
html_CheckAll = $f_CheckAll;
/** 
 * @deprecated
 * @function
 * */
first_field = $f_First_field;
/** 
 * @deprecated
 * @function
 * */
$f_InitTextFieldSubmits = html_InitTextFieldSubmits;
/** 
 * @deprecated
 * @function
 * */
html_CheckImageSrc = $x_CheckImageSrc;
/** 
 * @deprecated
 * @function
 * */
setStyleByClass = $x_StyleByClass;
/** 
 * @deprecated
 * @function
 * */
function html_CleanRegionId(pRid){
	var l_PTest = pRid.indexOf('.');
	var l_CTest = pRid.indexOf(',');
	var l_Rid = pRid;
	if(l_PTest >= 0){l_Rid = l_Rid.substring(0,l_PTest);
	}else if (l_CTest >= 0){l_Rid = l_Rid.substring(0,l_CTest);}
	return l_Rid;
}
/** 
 * @deprecated
 * @function
 * */
function init_htmlPPRReport2(pId){
  var l_Table = $x('report'+pId);
  if(l_Table){
    var l_THS = l_Table.getElementsByTagName('TH');
    for(var i = 0;i<l_THS.length;i++){
    if(l_THS[i].getElementsByTagName('A')[0]){
      var oldHREF = l_THS[i].getElementsByTagName('A')[0].href;
      l_THS[i].getElementsByTagName('A')[0].href = 'javascript:html_PPR_Report_Page(this,\''+pId+'\',\''+oldHREF+'\');';
      }
    }
  }
  return;
}
/** 
 * @deprecated
 * @function
 * */
function init_htmlPPRReport(pId){
  if(document.all){
    var ie_HACK = 'init_htmlPPRReport2(\''+pId+'\')';setTimeout(ie_HACK,100);}
    else{init_htmlPPRReport2(pId);}
  return;
}
/** 
 * @deprecated
 * @function
 * */
function html_PPR_Report_Page (pThis,pRid,pURL,pHeader,pFooter){
	var l_pRid = html_CleanRegionId(pRid);
	document.body.style.cursor = 'wait';
    var l_URL = pURL;
    var start = l_URL.indexOf('?');
    l_URL = l_URL.substring(start + 1);
    l_URL = html_replace(l_URL,'pg_R_','FLOW_PPR_OUTPUT_'+l_pRid+'_pg_R_');
    l_URL = html_replace(l_URL,'fsp_sort_','FLOW_PPR_OUTPUT_'+l_pRid+'_fsp_sort_');
    var http = new htmldb_Get('report'+ l_pRid,null,null,null,null,'f',l_URL);
    http.get(null,'<htmldb:'+l_pRid+'>','</htmldb:'+l_pRid+'>');
    if(pHeader){$x('report'+ l_pRid).innerHTML =  pHeader + $x('report'+ l_pRid).innerHTML;}
    if(pFooter){$x('report'+ l_pRid).innerHTML += pFooter;}
    document.body.style.cursor = '';
    init_htmlPPRReport(l_pRid);
    http = null;
    return;
}
/** 
 * @deprecated
 * @function
 * */
function PPR_Tabluar_Submit(pId,pFlowID,pPageId,pRequest,pInsertReturn,pReportId,pReplacementOveride){
	var pThis = $x(pId),get,i,q;
	if(pInsertReturn){get = new htmldb_Get(pId,pFlowID,pRequest,pPageId,null,'wwv_flow.accept');}
	else{get = new htmldb_Get(null,pFlowID,pRequest,pPageId,null,'wwv_flow.accept');}
	var lItems = $x_FormItems(pThis);
	for(i=0;i<lItems.length;i++){
		if(lItems[i].type == 'checkbox'){
			if(!!lItems[i].checked){get.addParam(lItems[i].name,lItems[i].value);}
		}else{
			if(lItems[i].name && lItems[i].name != 'fcs'){get.addParam(lItems[i].name,lItems[i].value);}
		}  
	}
	var lSelects = $x_FormItems(pThis,'SELECT');
	for(i=0;i<lSelects.length;i++){get.addParam(lSelects[i].name,html_SelectValue(lSelects[i]));}
	var lTextarea= $x_FormItems(pThis,'TEXTAREA');
	for(i=0;i<lTextarea.length;i++){get.addParam(lTextarea[i].name,lTextarea[i].value);}
	if(pReplacementOveride){
		q = get.get(null,'<htmldb:'+pReplacementOveride+'>','</htmldb:'+pReplacementOveride+'>');
		}else{
		q = get.get(null,'<htmldb:PPR_'+pId+'>','</htmldb:PPR_'+pId+'>');
	}
		if(pReportId){init_htmlPPRReport(pReportId);}
		get = null;
	return q;
}

/** 
 * @deprecated
 * @function
 * */
function removeMessageTimeout(){setTimeout(function(){$x('htmldbMessageHolder').innerHTML = '';},5000);}

/** 
 * @deprecated 
 * */
html_RowHighlight = $x_RowHighlight;
/** 
 * @deprecated
 * @function
 * */
html_RowHighlightOff = $x_RowHighlightOff;
/** 
 * @deprecated
 * @function
 * */
html_SelectedOptions = $f_SelectedOptions;
/** 
 * @deprecated
 * @function
 * */
html_SelectValue = $f_SelectValue;

