/*jslint nomen: false, evil: false, browser: true, eqeqeq: false, white: false, undef: false */
/*
Oracle Database Application Express, Release 3.1

B32468-02

Copyright © 2003, 2008, Oracle. All rights reserved.

Primary Author:  Carl Backstrom

The Programs (which include both the software and documentation) contain proprietary information; they are provided under a license agreement containing restrictions on use and disclosure and are also protected by copyright, patent, and other intellectual and industrial property laws. Reverse engineering, disassembly, or decompilation of the Programs, except to the extent required to obtain interoperability with other independently created software or as specified by law, is prohibited.

The information contained in this document is subject to change without notice. If you find any problems in the documentation, please report them to us in writing. This document is not warranted to be error-free. Except as may be expressly permitted in your license agreement for these Programs, no part of these Programs may be reproduced or transmitted in any form or by any means, electronic or mechanical, for any purpose.

If the Programs are delivered to the United States Government or anyone licensing or using the Programs on behalf of the United States Government, the following notice is applicable:

U.S. GOVERNMENT RIGHTS Programs, software, databases, and related documentation and technical data delivered to U.S. Government customers are "commercial computer software" or "commercial technical data" pursuant to the applicable Federal Acquisition Regulation and agency-specific supplemental regulations. As such, use, duplication, disclosure, modification, and adaptation of the Programs, including documentation and technical data, shall be subject to the licensing restrictions set forth in the applicable Oracle license agreement, and, to the extent applicable, the additional rights set forth in FAR 52.227-19, Commercial Computer Software--Restricted Rights (June 1987). Oracle USA, Inc., 500 Oracle Parkway, Redwood City, CA 94065.

The Programs are not intended for use in any nuclear, aviation, mass transit, medical, or other inherently dangerous applications. It shall be the licensee's responsibility to take all appropriate fail-safe, backup, redundancy and other measures to ensure the safe use of such applications if the Programs are used for such purposes, and we disclaim liability for any damages caused by such use of the Programs.

Oracle, JD Edwards, PeopleSoft, and Siebel are registered trademarks of Oracle Corporation and/or its affiliates. Other names may be trademarks of their respective owners.

The Programs may provide links to Web sites and access to content, products, and services from third parties. Oracle is not responsible for the availability of, or any content provided on, third-party Web sites. You bear all risks associated with the use of such content. If you choose to purchase any products or services from a third party, the relationship is directly between you and the third party. Oracle is not responsible for: (a) the quality of third-party products or services; or (b) fulfilling any of the terms of the agreement with the third party, including delivery of products or services and warranty obligations related to purchased products or services. Oracle is not responsible for any loss or damage of any sort that you may incur from dealing with any third party.
*/
/**
 * @fileOverview
 * This file holds Application Express + AXAX framework specific functionality
 *
 * */
/*
  str should be in the form of a valid f?p= syntax
*/

/** 
 * @constructor
 * @param {Dom node | String} [obj] object to put in the partial page
 * @param {String} [flow] flow id
 * @param {String} [req] request value
 * @param {String} [page] page id
 * @param {String} [instance] instance
 * @param {String} [proc] process to call
 * @param {String} [queryString] hodler for quesry string
 *
 * */
function htmldb_Get(obj,flow,req,page,instance,proc,queryString) {
  /* setup variables */
  this.obj      = $x(obj);                   // object to put in the partial page
  this.proc     = (!!proc)	?proc	:'wwv_flow.show'; // proc to call 
  this.flow     = (!!flow)	?flow	: $v('pFlowId');          // flowid
  this.request  = (!!req)	?req	:'';               // request 
  this.page     = (!!page)	?page	:'0';
  this.queryString = (!!queryString)?queryString:null; // holder for passing in f? syntax

  this.params   = '';   // holder for params
  this.response = '';   // holder for the response
  this.base     = null; // holder fot the base url
  this.syncMode     = false;
  // declare methods
  this.addParam     = htmldb_Get_addParam;
  this.add          = htmldb_Get_addItem;
  this.getPartial   = htmldb_Get_trimPartialPage;
  /** 
   * function return the full response  
   * */
this.getFull      = function(obj){
	var result;
	var node;
	if (obj){this.obj = $x(obj);}
	if (this.obj){
		if(this.obj.nodeName == 'INPUT'){
			this.obj.value = this.response;
		}else{
			if(document.all){
				result = this.response;
				node = this.obj;
				setTimeout(function() {htmldb_get_WriteResult(node, result)},100);
			}else{
				$s(this.obj,this.response);
			}
		}
	}
	return this.response;
} ;

/** 
 * Desc
 * @param {Dom Node | String | Array | Dom Array | String id}[]
 * @return {}
 * */
  this.get          = function(mode,startTag,endTag){
   var p;
   try {
      p = new XMLHttpRequest();
    } catch (e) {
      p = new ActiveXObject("Msxml2.XMLHTTP");
    }
    try {
    	var startTime = new Date();
   	    p.open("POST", this.base, this.syncMode);   	    
    	p.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
        p.send(this.queryString == null ? this.params : this.queryString );
        this.response = p.responseText;
        if (this.node){this.replaceNode(p.responseXML);}
        if ( mode == null || mode =='PPR' ) {
            return this.getPartial(startTag,endTag);
        } if ( mode == "XML" ) {
            return p.responseXML;
        } else {
            return this.getFull();
        }

    } catch (e) {
       return;
    }
 }

  this.url          = htmldb_Get_getUrl;
  this.escape       = htmldb_Get_escape;
  this.clear        = htmldb_Get_clear;
  this.sync         = htmldb_Get_sync;
  this.setNode      = setNode;
  this.replaceNode  = replaceNode;

  // setup the base url
   var u = (window.location.href.indexOf("?") > 0) ? window.location.href.substring(0,window.location.href.indexOf("?")) : window.location.href;
   this.base = u.substring(0,u.lastIndexOf("/"));

   if (!!!this.proc){this.proc = u.substring(u.lastIndexOf("/")+1);}

   this.base = this.base +"/" + this.proc;

  // grab the instance form the page form 	
  if(instance==null||instance==""){
    this.instance = $v('pInstance');
  }else{
    this.instance = instance;
  }

  // finish setiing up the base url and params
  if ( ! queryString ) {
      this.addParam('p_request',     this.request) ;
      this.addParam('p_instance',    this.instance);
      this.addParam('p_flow_id',     this.flow);
      this.addParam('p_flow_step_id',this.page);
  }

  function setNode(id) {
    this.node = $x(id);
  }
  function replaceNode(newNode){
      var i=0;
      for(i=this.node.childNodes.length-1;i>=0;i--){
        this.node.removeChild(this.node.childNodes[i]);
      }
      this.node.appendChild(newNode);
  }
}
function htmldb_Get_sync(s){
  this.syncMode=s;
}

function htmldb_Get_clear(val){
  this.addParam('p_clear_cache',val);
}

//
// return the queryString
//
function htmldb_Get_getUrl(){
    return this.queryString == null ? this.base +'?'+ this.params : this.queryString;
}

function htmldb_Get_escape(val){
    // force to be a string
     val = val + "";
     val = val.replace(/\%/g, "%25");
     val = val.replace(/\+/g, "%2B");
     val = val.replace(/\ /g, "%20");
     val = val.replace(/\./g, "%2E");
     val = val.replace(/\*/g, "%2A");
     val = val.replace(/\?/g, "%3F");
     val = val.replace(/\\/g, "%5C");
     val = val.replace(/\//g, "%2F");
     val = val.replace(/\>/g, "%3E");
     val = val.replace(/\</g, "%3C");
     val = val.replace(/\{/g, "%7B");
     val = val.replace(/\}/g, "%7D");
     val = val.replace(/\~/g, "%7E");
     val = val.replace(/\[/g, "%5B");
     val = val.replace(/\]/g, "%5D");
     val = val.replace(/\`/g, "%60");
     val = val.replace(/\;/g, "%3B");
     val = val.replace(/\?/g, "%3F");
     val = val.replace(/\@/g, "%40");
     val = val.replace(/\&/g, "%26");
     val = val.replace(/\#/g, "%23");
     val = val.replace(/\|/g, "%7C");
     val = val.replace(/\^/g, "%5E");
     val = val.replace(/\:/g, "%3A");
     val = val.replace(/\=/g, "%3D");
     val = val.replace(/\$/g, "%24");
     //val = val.replace(/\"/g, "%22");
    return val;
}
// Simple function to add name/value pairs to the url
function htmldb_Get_addParam(name,val){
	if ( this.params == '' ) 
     this.params =  name + '='+ ( val != null ? this.escape(val)  : '' );
  else
     //this.params = this.params + '&'+ name + '='+ ( val != null ? val  : '' );
     this.params = this.params + '&'+ name + '='+ ( val != null ? this.escape(val)  : '' );
     return;
}
/** Simple function to add name/value pairs to the url */
function htmldb_Get_addItem(name,value){
  this.addParam('p_arg_names',name);
  this.addParam('p_arg_values',value);  
}
/** funtion strips out the PPR sections and returns that */
function htmldb_Get_trimPartialPage(startTag,endTag,obj) {
   if(obj) {this.obj = $x(obj);}
   if(!startTag){startTag = '<!--START-->'};  
   if(!endTag){endTag  = '<!--END-->'};
   var start = this.response.indexOf(startTag);
   var part;
   var result;
   var node;
   if(start>0){
       this.response  = this.response.substring(start+startTag.length);
       var end   = this.response.indexOf(endTag); 
       this.response  = this.response.substring(0,end);
   }         
       if(this.obj){
            if(document.all){
              result = this.response;
              node = this.obj;
              setTimeout(function() {htmldb_get_WriteResult(node, result)},100);
            }else{
              $s(this.obj,this.response);
            }
          }
   return this.response;
}

var gResult = null;
var gNode = null;

function htmldb_get_WriteResult(node, result){
	$s(node,result);
	return;
} 

function html_Doneprocessing(){}
function html_processing(){}

/**
 * Adds asyncronous AJAX to the htmldb_Get object pVar is the function that you want to call when the xmlhttp state changes in the function specified by pVar the xmlhttp object can be referenced by the variable p
 * @extends
 * {Javascript Function} pVar
*/
htmldb_Get.prototype.GetAsync = function(pVar){
   try{
      p = new XMLHttpRequest();
    }catch(e){
      p = new ActiveXObject("Msxml2.XMLHTTP");
    }
    try {
    	var startTime = new Date();
			p.open("POST", this.base, true);
			if(p) {
					p.onreadystatechange = pVar;
					p.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
					p.send(this.queryString == null ? this.params : this.queryString );
					return p;
	  	} 
		}catch(e){
      return false;
    }
 }

/**
 * Gets PDF src XML 
 * */
function htmldb_ExternalPost(pThis,pRegion,pPostUrl){
   var pURL = 'f?p='+$x('pFlowId').value+':'+$x('pFlowStepId').value+':'+$x('pInstance').value+':FLOW_FOP_OUTPUT_R'+pRegion
   document.body.innerHTML = document.body.innerHTML + '<div style="display:none;" id="dbaseSecondForm"><form id="xmlFormPost" action="' + pPostUrl + '?ie=.pdf" method="post" target="pdf"><textarea name="vXML" id="vXML" style="width:500px;height:500px;"></textarea></form></div>';
   var l_El = $x('vXML');
   var get = new htmldb_Get(l_El,null,null,null,null,'f',pURL.substring(2));
   get.get();
   get = null;
   setTimeout('$x("xmlFormPost").submit()',10);
  return;
}

/**
 * Simple XML Control 
 * */
function $xml_Control(pThis){
		this.xsl_string = '<?xml version="1.0"?><xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:output method="html"/><xsl:param name="xpath" /><xsl:template match="/"><xsl:copy-of select="//*[@id=$xpath]"/></xsl:template></xsl:stylesheet>';
		if(document.all){
			this.xsl_object = new ActiveXObject("Msxml2.FreeThreadedDOMDocument.3.0");
			this.xsl_object.async=false;
			this.xsl_object.loadXML(this.xsl_string)
			tmp = new ActiveXObject("Msxml2.XSLTemplate.3.0");
			tmp.stylesheet = this.xsl_object;
			this.xsl_processor = tmp.createProcessor();
		}else{
		  this.xsl_object = (new DOMParser()).parseFromString(this.xsl_string, "text/xml");
			this.xsl_processor = (new XSLTProcessor());
			this.xsl_processor.importStylesheet(this.xsl_object);
			this.ownerDocument = document.implementation.createDocument("", "test", null);
		}
		this.xml = pThis;
		this.CloneAndPlace = _CloneAndPlace;
		return

		function _CloneAndPlace(pThis,pThat,pText){
		   var lThat = $x(pThat);
			 if(document.all){
				this.xsl_processor.addParameter("xpath", pThis);
				this.xsl_processor.input = this.xml;
				this.xsl_processor.transform;
			 	var newFragment = this.xsl_processor.output;
			 }else{
			 	 this.xsl_processor.setParameter(null, "xpath", pThis);
			 	 var newFragment = this.xsl_processor.transformToFragment(this.xml,this.ownerDocument);
			 }
			 if(lThat){
				if(ie){
				 $s(lThat,newFragment);
				}else{
				 $s(lThat,'');
			 	 lThat.appendChild(newFragment);
				}
			 /*
			 in IE newFragment will be a string
			 in FF newFragment will be a dome Node (more useful)
			 */
			 return newFragment;
			 }
		}
}


htmldb_Get.prototype.AddArray=function(pArray,pFnumber){
		var lFName = 'f';
		pFnumber = $nvl(pFnumber,1); 
		if(pFnumber<10){lFName+='0'+pFnumber}else{lFName+=pFnumber};
		for(var i=0,len=pArray.length;i<len;i++){this.addParam(lFName,pArray[i]);}
		return this;
	}

htmldb_Get.prototype.AddArrayItems=function(pArray,pFnumber){
		var lFName = 'f';
		pFnumber = $nvl(pFnumber,1); 
		if(pFnumber<10){lFName+='0'+pFnumber}else{lFName+=pFnumber};
		for(var i=0,len=pArray.length;i<len;i++){this.addParam(lFName,$nvl($v(pArray[i])),'');}
		return this;
	}

htmldb_Get.prototype.AddArrayClob=function(pText,pFnumber){
		var lArray = $s_Split(pText,4000);
		this.AddArray(lArray,pFnumber)
		return this;
	}


/**
 * @function
 * Post Large Strings 
 * */
function $a_PostClob(pThis,pRequest,pPage,pReturnFunction){
	var get = new htmldb_Get(null,$v('pFlowId'),pRequest,pPage, null, 'wwv_flow.accept');
	get.AddArrayClob($x(pThis).value,1)
	get.GetAsync(pReturnFunction);
	get=null;
}

/**
 * @function
 * Get Large Strings 
 * */
function $a_GetClob(pRequest,pPage,pReturnFunction){
   var get = new htmldb_Get(null,$v('pFlowId'),pRequest,pPage, null,'wwv_flow.accept');
   get.GetAsync(pReturnFunction);
   get = null;
   x = null;
}

htmldb_Get.prototype.AddPageItems = function(pArray){
		for(var i=0,len=pArray.length;i<len;i++){
			if($x(pArray[i])){this.add($x(pArray[i]).id,$v(pArray[i]));}
		}
	}


htmldb_Get.prototype.AddGlobals=function(p_widget_mod,p_widget_action,p_widget_action_mod,p_widget_num_return,x01,x02,x03,x04,x05,x06,x07,x08,x09,x10){
	this.addParam('p_widget_mod',p_widget_mod);
	this.addParam('p_widget_action',p_widget_action);
	this.addParam('p_widget_action_mod',p_widget_action_mod);
	this.addParam('p_widget_num_return',p_widget_num_return);
	this.addParam('x01',x01);
	this.addParam('x02',x02);
	this.addParam('x03',x03);
	this.addParam('x04',x04);
	this.addParam('x05',x05);
	this.addParam('x06',x06);
	this.addParam('x07',x07);
	this.addParam('x08',x08);
    this.addParam('x09',x09);
	this.addParam('x10',x10);
	return this;
}

/**
 * Split a string pString into an array of strings the size of pLength
 * @function
 * @param {String} pString
 * @param {Number} pLength
 * @return Array
 *
 * */
function $s_Split(pString,pLength){
    var lArray = [];
	if (pString.length<=pLength) {
		lArray[lArray.length]=pString;
	} else {
		while (pString.length>4000) {
			lArray[lArray.length]=pString.substr(0,4000);
			pString = pString.substr(4000,pString.length-4000);
		}
		lArray[lArray.length]=pString.substr(0,4000);
	}
	return lArray;
}

/* End Post and Retrieve Large Strings */

/* 
Set items in conjunction with apex_util.json_from_items('ITEM1:ITEM2:ITEM3'); 
*/
function json_SetItems(gReturn){
	gReturn = eval('(' + gReturn + ')');
	for (var j=0,len=gReturn.item.length;j<len;j++){
		var lTemp = new apex.page.item(gReturn.item[j].id);
		lTemp.set(gReturn.item[j].value);
	}
}

/*namespaced javascript*/

