/*jslint nomen: false, evil: false, browser: true, eqeqeq: false, white: false, undef: false */
/*
Oracle Database Application Express, Release 3.1

B32468-02

Copyright © 2003, 2008, Oracle. All rights reserved.

The Programs (which include both the software and documentation) contain proprietary information; they are provided under a license agreement containing restrictions on use and disclosure and are also protected by copyright, patent, and other intellectual and industrial property laws. Reverse engineering, disassembly, or decompilation of the Programs, except to the extent required to obtain interoperability with other independently created software or as specified by law, is prohibited.

The information contained in this document is subject to change without notice. If you find any problems in the documentation, please report them to us in writing. This document is not warranted to be error-free. Except as may be expressly permitted in your license agreement for these Programs, no part of these Programs may be reproduced or transmitted in any form or by any means, electronic or mechanical, for any purpose.

If the Programs are delivered to the United States Government or anyone licensing or using the Programs on behalf of the United States Government, the following notice is applicable:

U.S. GOVERNMENT RIGHTS Programs, software, databases, and related documentation and technical data delivered to U.S. Government customers are "commercial computer software" or "commercial technical data" pursuant to the applicable Federal Acquisition Regulation and agency-specific supplemental regulations. As such, use, duplication, disclosure, modification, and adaptation of the Programs, including documentation and technical data, shall be subject to the licensing restrictions set forth in the applicable Oracle license agreement, and, to the extent applicable, the additional rights set forth in FAR 52.227-19, Commercial Computer Software--Restricted Rights (June 1987). Oracle USA, Inc., 500 Oracle Parkway, Redwood City, CA 94065.

The Programs are not intended for use in any nuclear, aviation, mass transit, medical, or other inherently dangerous applications. It shall be the licensee's responsibility to take all appropriate fail-safe, backup, redundancy and other measures to ensure the safe use of such applications if the Programs are used for such purposes, and we disclaim liability for any damages caused by such use of the Programs.

Oracle, JD Edwards, PeopleSoft, and Siebel are registered trademarks of Oracle Corporation and/or its affiliates. Other names may be trademarks of their respective owners.

The Programs may provide links to Web sites and access to content, products, and services from third parties. Oracle is not responsible for the availability of, or any content provided on, third-party Web sites. You bear all risks associated with the use of such content. If you choose to purchase any products or services from a third party, the relationship is directly between you and the third party. Oracle is not responsible for: (a) the quality of third-party products or services; or (b) fulfilling any of the terms of the agreement with the third party, including delivery of products or services and warranty obligations related to purchased products or services. Oracle is not responsible for any loss or damage of any sort that you may incur from dealing with any third party.
*/
/**
 * @fileOverview
 * This file holds all namespaced objects and functions for Oracle Application Express
 *
 * */
var NameSpaceOnly = false;
var apex = {};
if (apex===null || typeof(apex)!="object"){apex={};}
if (apex.page===null || typeof(apex.page)!="object"){apex.page={};}
if (apex.tabular===null || typeof(apex.tabular)!="object"){apex.tabular={};}
if (apex.spreadsheet===null || typeof(apex.spreadsheet)!="object"){apex.spreadsheet={};}
if (apex.items===null || typeof(apex.items)!="object"){apex.items={};}
if (apex.util===null || typeof(apex.util)!="object"){apex.util={};}
if (apex.ajax===null || typeof(apex.ajax)!="object"){apex.ajax={};}
if (apex.dhtml===null || typeof(apex.dhtml)!="object"){apex.dhtml={};}
if (apex.worksheet===null || typeof(apex.worksheet)!="object"){apex.worksheet={};}
if (apex.validation===null || typeof(apex.validation)!="object"){apex.validation={};}
if (apex.widget===null || typeof(apex.widget)!="object"){apex.widget={};}
/* end standard namespaces */

/**
 * @namespace apex
 */
apex={
	/**
	 * This object holds utility functions mainly for built in functionality
	 * @constructor
	 */	
	util : function (){
		var that = this;
		this.el = false;
		this.init = function(pId){
			that.el = $x(pId);
			if(!that.el){return false;}
		};

		this.select = {};
		/**
		 * In some cases an empty select function needs to be cleared out
		 * @function
		 */
		this.select.clean = function(pId){
			that.init(pId);
			if(that.el.length == 1 && that.el.options[0].value == 'DELETE ME'){that.el.length--;}
		}

		return that;
	}
}
var gUtil = new apex.util();

/**
 * @namespace apex.page
 */
apex.page = {
	/**
	 * The apex page form object. This can be used to change requests on the fly or to supress page submission
	 * @constructor
	 */	
	form : function (pRequest){
		var that = this;
		that.request = pRequest;
		that.supress = false;
		/*
		 *This runs the standard doSubmit()
		 **/
		that.submit = function(pRequest){
			if(pRequest){that.request = pRequest;}
			if(!that.supress){
				/* should this be namespaced ?*/
				flowSelectAll();
				$s('pRequest',that.request);
				document.wwv_flow.submit();
			}
		};

		this.confirm = function(pMessage,pRequest){
			if(!!!pRequest){pRequest='Delete';}
			that.supress = !confirm((!!!pMessage)?"Would you like to perform this delete action?":pMessage);
			that.submit(pRequest);
		}
	},
	/**
	 * The apex page item object. This will hold all single item functions
	 * These functions assume that these are APEX generated ITEMS and will make best guess at the proper functionality to apply.
	 * @constructor
	 */	
	item : function (pNd){
		var that = this;
		this.node = false;
		this.item_type = false;
		this.id = false;
		this.value = value;
		this.valueArray = valueArray;
		/**/
		this.init = init;
		this.set = set;
		this.init(pNd);
		return;
		function init(pNd){
			try{
				switch(typeof (pNd)){
					case 'string':that.node = document.getElementById(pNd);break;
					case 'object':that.node = pNd;break;
					default:that.node = false;break;
				}
				if(that.node.nodeType == 1){}else{that.node = false;}
			}catch(e){that.node = false;}
			if(that.node){
				that.id = that.node.id;
				var lNodeType = that.node.nodeName.toUpperCase();
				var lClass = that.node.className.toUpperCase();
				if(lNodeType == 'FIELDSET'){
					that.item_type = lClass;
					switch(lClass){
						case 'CHECKBOX_GROUP':;break;
						case 'RADIO_GROUP':; break;
						case 'SHUTTLE':; break;
						case 'LISTMANAGER':; break;
						default: that.item_type = false;
						break;
					}
				}else if(lNodeType == 'INPUT'){
					that.item_type = that.node.type.toUpperCase();
					switch(that.item_type){
						case 'CHECKBOX':; break;
						case 'RADIO':; break;
						case 'TEXT':
						var TEXT_TYPE = that.node.parentNode.className.toUpperCase();
						switch(TEXT_TYPE){
							case 'LOV':that.item_type = TEXT_TYPE;break;
							case 'COLORPICKER':that.item_type = TEXT_TYPE;break;
							case 'CALCULATOR':that.item_type = TEXT_TYPE;break;
							case 'DATEPICKER':that.item_type = TEXT_TYPE;break;   
							default:;break;
						}	 
					    ; break;
						case 'PASSWORD':; break;
						case 'HIDDEN':; break;
						case 'FILE':; break;
						default: that.item_type = false; break;
					}
				}else{
					that.item_type = lNodeType;
					switch(that.item_type){
						case 'TEXTAREA':
							 if(that.node.parentNode.className == 'html_editor' && that.node.parentNode.tagName == 'FIELDSET'){
								that.item_type = 'FCKEDITOR'
							 }
							; break;
						case 'SELECT':;break;
						case 'SPAN':that.item_type = false; break;
						default: that.item_type = false;break;
					}
				}
			}
		};


		function valueArray(){
			if(!that.node){return false;}
			var lArray = true,lReturn=[];
			switch(that.item_type){
				case 'RADIO_GROUP'		:
										lOpts = $x_FormItems(that.node,'RADIO');
										for(var i=0,len=lOpts.length;i<len;i++){if(lOpts[i].checked){lReturn[lReturn.length]=lOpts[i].value}}
										 break;
				case 'CHECKBOX_GROUP'	:
										lOpts = $x_FormItems(that.node,'CHECKBOX');
										for(var i=0,len=lOpts.length;i<len;i++){if(lOpts[i].checked){lReturn[lReturn.length]=lOpts[i].value}}
										 break;
				case 'SHUTTLE'			:lOpts = $x(that.node.id+'_RIGHT').options;for(var i=0,len=lOpts.length;i<len;i++){lReturn[lReturn.length]=lOpts[i].value}break;
				case 'LISTMANAGER'		:lOpts = $x(that.node.id+'_LISTMGRDATA').options;for(var i=0,len=lOpts.length;i<len;i++){lReturn[lReturn.length]=lOpts[i].value}break;
				case 'SELECT'			:var lOpts = that.node.options;for(var i=0,len=lOpts.length;i<len;i++){if(lOpts[i].selected){lReturn[lReturn.length]=lOpts[i].value}}break;
				default	:lReturn = [false]; lArray=false;break;
			}
			if(lArray){}else{
				switch(that.item_type){
					case 'CHECKBOX'	:lReturn = [(that.node.checked)?that.node.value:false];break;
					case 'RADIO'	:lReturn = [(that.node.checked)?that.node.value:false];break;
					case 'TEXT'		:lReturn = [that.node.value];break;
					case 'LOV'		:lReturn = [that.node.value];break;
					case 'COLORPICKER'	:lReturn = [that.node.value];break;	 							
					case 'CALCULATOR'	:lReturn = [that.node.value];break;
					case 'DATEPICKER'	:lReturn = [that.node.value];break;
					case 'PASSWORD'	:lReturn = [that.node.value];break;
					case 'HIDDEN'	:lReturn = [that.node.value];break;
					case 'FILE'		:lReturn = [that.node.value];break;
					case 'TEXTAREA'		:lReturn = [that.node.value];break;
					case 'FCKEDITOR'	:
							var oEditor = FCKeditorAPI.GetInstance(that.node.id) ;
							lReturn = [oEditor.GetHTML()];
							break;
					default	:lReturn = [false]; break;
				}
			}
			return lReturn;
		};
 		function value(){
			lReturn = that.valueArray();
			lReturn = $u_ArrayToString(lReturn,':')
			return lReturn;
		};
 		function set(pNd){
			var lOpts = false;
			if(!that.node){
				return;
			}
			switch(that.item_type){
				case 'RADIO_GROUP'		:lOpts = $x_FormItems(that.node,'RADIO');break;
				case 'CHECKBOX_GROUP'	:lOpts = $x_FormItems(that.node,'CHECKBOX');break;
			 // case 'SHUTTLE'			:lOpts = $x(that.node.id+'_RIGHT').options;for(var i=0,len=lOpts.length;i<len;i++){lReturn[lReturn.length]=lOpts[i].value}break;
				case 'LISTMANAGER'		:lOpts = $x(that.node.id+'_LISTMGRDATA').options;break;
				case 'SELECT'			:var lOpts = that.node.options;break;
				default	:lOpts=false;break;
			}
			if(lOpts){
				for(var i=0,len=lOpts.length;i<len;i++){
					var lCheck = (lOpts[i].value==pNd)?true:false;
					if(that.item_type == 'RADIO_GROUP' || that.item_type == 'CHECKBOX_GROUP'){
						lOpts[i].checked=lCheck;
					}else{
						lOpts[i].selected=lCheck;
					}
				}
			}else{
				switch(that.item_type){
					case 'CHECKBOX'	:(that.node.value==pNd)?that.node.checked=true:null;
					case 'RADIO'	:(that.node.value==pNd)?that.node.checked=true:null;
					case 'TEXT'		:that.node.value=pNd;break;
					case 'LOV'		:that.node.value=pNd;break;
					case 'COLORPICKER'	:that.node.value=pNd;break;
					case 'CALCULATOR'	:that.node.value=pNd;break;
					case 'DATEPICKER'	:that.node.value=pNd;break;
					case 'PASSWORD'	:that.node.value=pNd;break;
					case 'HIDDEN'	:that.node.value=pNd;break;
					case 'FILE'		:that.node.value=pNd;break;
					case 'TEXTAREA'	:that.node.value=pNd;break;		 
					case 'FCKEDITOR'	:
							var oEditor = FCKeditorAPI.GetInstance(that.node.id) ;
							oEditor.SetHTML(pNd);
							break;
					/**
					 * must be some other tag item set it's innerHTML 
					 * */
					default	: that.node.innerHTML = pNd;break;
				}
				/**
				 * if the node has an onchange attribute fire it 
				 **/
				if(that.node.getAttribute('onchange') || that.node.onchange){that.node.onchange()}
			}
		};
		return;
	}
}

/**
 * @namespace apex.validation
 */
apex.validation = {	
   v : function (){
		var that = this;
		this.get_emptys = function(pNd,pClassFail,pClass){
			var l_temp = [];
			var l_temp2 = [];
			if($x(pNd)){pNd = [pNd];}
			for(var i=0,len=pNd.length;i<len;i++){
				var node = $x(pNd[i]);
				if(node){
					if(isEmpty(node)){l_temp[l_temp.length] = node}
					else{l_temp2[l_temp2.length] = node}
				}
			}
			if(pClassFail){$x_Class(l_temp,pClassFail);}
			if(pClass){$x_Class(l_temp2,pClass);}
			if(l_temp.length==0){l_temp=false;}else{l_temp[0].focus();}
			return l_temp;
		}

		this.is_in = function(pNd,pValue){
			var l_temp = [];
			var l_temp2 = [];
			if($x(pNd)){pNd = [pNd];}
			for(var i=0,len=pNd.length;i<len;i++){
				var node = $x(pNd[i]);
				for(var ii=0,len=pValue.length;ii<len;ii++){if(node){if(node.value == pValue[ii]){l_temp[l_temp.length] = node}}}
			}
			if(l_temp.length==0){l_temp=false;}else{l_temp[0].focus();}
			return l_temp;
		}

		this.basic_sql = function(pColumn,pOp,pExp,gClassFail,gClass){
			var lArray = [pColumn,pOp,pExp];
			if(!!($f_is_in(pOp,['is null','is not null']))){lArray = [pColumn,pOp];}
			return $f_get_emptys(lArray,gClassFail,gClass);
		}
	}
}

/**
 * @class $d_LOV_from_JSON
 * Using a standard json feed creates several types of lov constructs
 *
 */
function $d_LOV_from_JSON(){
	var that = this;
	/** 
	 * @type String
	 * SELECT,MULTISELECT,SHUTTLE,CHECK,RADIO,FILTER. 
	 * */
	this.l_Type = false;
	/** 
	 * @type String
	 * JSON Formated String
	 * */
	this.l_Json = false;
	/** */
	this.l_This = false;
	/** */
	this.l_JSON = false;
	/** */
	this.l_Id = 'json_temp';
	/** */
	this.l_NewEls = [];
	/** */
	this.create = create;
	/** */
	this.l_Dom = false;
	return;
		function create(pThis,pJSON,pType,pId){
		var myObject = $u_eval('(' + pJSON + ')');
		if(that.l_Type == 'SHUTTLE'){/* SHUTTLE */
			var lvar = '<table cellspacing="0" cellpadding="0" border="0" class="ajax_shuttle" summary=""><tbody><tr><td class="shuttleSelect1" id="shuttle1"></td><td align="center" class="shuttleControl"><img title="Reset" alt="Reset" onclick="g_Shuttlep_v01.reset();" src="/i/htmldb/icons/shuttle_reload.png"/><img title="Move All" alt="Move All" onclick="g_Shuttlep_v01.move_all();" src="/i/htmldb/icons/shuttle_last.png"/><img title="Move" alt="Move" onclick="g_Shuttlep_v01.move();" src="/i/htmldb/icons/shuttle_right.png"/><img title="Remove" alt="Remove" onclick="g_Shuttlep_v01.remove();" src="/i/htmldb/icons/shuttle_left.png"/><img title="Remove All" alt="Remove All" onclick="g_Shuttlep_v01.remove_all();" src="/i/htmldb/icons/shuttle_first.png"/></td><td class="shuttleSelect2" id="shuttle2"></td><td class="shuttleSort2"><img title="Top" alt="Top" onclick="g_Shuttlep_v01.sort2(\'T\');" src="/i/htmldb/icons/shuttle_top.png"/><img title="Up" alt="Up" onclick="g_Shuttlep_v01.sort2(\'U\');" src="/i/htmldb/icons/shuttle_up.png"/><img title="Down" alt="Down" onclick="g_Shuttlep_v01.sort2(\'D\');" src="/i/htmldb/icons/shuttle_down.png"/><img title="Bottom" alt="Bottom" onclick="g_Shuttlep_v01.sort2(\'B\');" src="/i/htmldb/icons/shuttle_bottom.png"/></td></tr></tbody></table>';
			$x(pThis).innerHTML = lvar;
			var lSelect = $dom_AddTag('shuttle1','select');
			var lSelect2 = $dom_AddTag('shuttle2','select');
			lSelect.multiple = true;
			lSelect2.multiple = true;
			for (var i=0,len=myObject.row.length;i<len;i++){
				if(!!myObject.row[i]){
					var lTest = (!!myObject.row[i].C)?parseInt(myObject.row[i].C):false;
					if(lTest){var lOption = $dom_AddTag(lSelect2,'option');}
					else{var lOption = $dom_AddTag(lSelect,'option');}
					lOption.text = myObject.row[i].D;
					lOption.value = myObject.row[i].R;
				}
			}
			window.g_Shuttlep_v01 = null;
			if(!flowSelectArray){var flowSelectArray = [];}
			flowSelectArray[2] = lSelect;
			flowSelectArray[1] = lSelect2;
			window.g_Shuttlep_v01 = new dhtml_ShuttleObject(lSelect,lSelect2);
			return window.g_Shuttlep_v01;

		}else if(that.l_Type == 'SELECT' || that.l_Type == 'MULTISELECT'){
			var lSelect = $dom_AddTag(pThis,'select');
			for (var i=0,len=myObject.row.length;i<len;i++){
				if(!!myObject.row[i]){
					var lOption = $dom_AddTag(lSelect,'option');
					lOption.text = myObject.row[i].D;
					lOption.value = myObject.row[i].R;
					var lTest = parseInt(myObject.row[i].C)
					lOption.selected=lTest;
				}
			}
			that.l_Dom = lSelect;
			return that;
		}else if(that.l_Type == 'CHECKBOX'){
			var ltable = $dom_AddTag(pThis,'table');
			for (var i=0,len=myObject.row.length;i<len;i++){
				if(!!myObject.row[i]){
					if(i % 10==0){lrow = $dom_AddTag(ltable,'tr');}
					var lTd = $dom_AddTag(lrow,'td')
					var lTest = parseInt(myObject.row[i].C)
					var lCheck = $dom_AddInput(lTd,'checkbox',myObject.row[i].R)
					lCheck.checked=lTest;
					$dom_AddTag(lTd,'span',myObject.row[i].D)
				}
			}
			that.l_Dom = lSelect;
			return that;
		}else{
			var lHolder = $dom_AddTag(pThis,'div');
				for (var i=0,len=myObject.row.length;i<len;i++){
				if(!!myObject.row[i]){
					var l_D = (!!myObject.row[i].D)?myObject.row[i].D:myObject.row[i].R;
					var lThis = $dom_AddTag(lHolder,that.l_Type.toUpperCase(),l_D);
					that.l_NewEls[that.l_NewEls.length] = lThis;
					lThis.id = myObject.row[i].R;
					var lTest = parseInt(myObject.row[i].C)
					if(lTest){lThis.className = 'checked';}
				}
			}
			that.l_Dom = lHolder;
			return that;
		}

	}
}

/**
 * @namespace = apex.worksheet
 */
apex.worksheet = {
	/**
	* @class ws
	* the worksheet object
	*/	 
   ws : function (pId){

		/** 
		 * use that as call to worksheet object in contained namespaces.
		 * */
		var that = this;

		/** 
		 * only one ajax at a time 
		 * */
		 this.ajax_busy = false;


		/** 
		 * the worksheet id 
		 * @type string
		 * */
		this.worksheet_id = false;

		/** 
		 * current report id 
		 * @type string
		 * */
		this.report_id = false;

		/** 
		 * current column id 
		 * @type string
		 * */
		this.current_col_id = false;

		/** 
		 * the last current column id
		 * @type string
		 * */
		this.last_col_id = false;

		/** 
		 * the current control 		 
		 * @type string
		 * */

		this.current_control = false;

		/** 
		 * the active control	
		 * @type string
		 * */
		this.active_dialog = false;

		/** 
		 * supress the ajax update useful for setting a preference or value without bugging user
		 * @type string
		 * */
		this.supress_update = false;

		/** 
		 * array of items to post with go button 
		 * @type String CSV of PAGE items to post with the Go Button
		 * */
		this.external_items = false;

		/**
		 *This holds the temporary ID 
		 * */

		/** 
		 * @ignore 
		 * */
		this.init = init;

		/** 
		 * @ignore 
		 * */
		this.init(pId);

		/** 
		 * @function
		 * toggles the control bar between full view and icon view 
		 * */
		this.toggle_controls = function(){
			var lTest = ($x('apexir_CONTROL_PANEL_COMPLETE').style.display != 'none')?'Y':'N';
			$x_ToggleWithImage('apexir_CONTROLS_IMAGE',['apexir_CONTROL_PANEL_COMPLETE','apexir_CONTROL_PANEL_SUMMARY']);
			that.supress_update = true;
			that.action('CONTROL_MIN',false,false,lTest);
		}

		/** 
		 * @namespace 
		 * holds functions that return a worksheet dom item
		 * */
		this.item = {}

		/** 
		 * @ignore 
		 **/
		this.item.worksheet_holder = function(){return $x('apexir_WORKSHEET_REGION');}

		/** 
		 * @ignore 
		 **/
		this.item.worksheet_detail = function(){return $x('apexir_DETAIL');}

		/** 
		 * @ignore
		 **/
		this.item.worksheet_report = function(){return $x('apexir_REPORT');}

		/** 
		 * @ignore */
		this.item.worksheet_div = function(){return $x('apexir_WORKSHEET');}

		/** 
		 * @ignore */
		this.item.control_panel_drop = function(){return $x('apexir_CONTROL_PANEL_DROP');}

		/** 
		 * @ignore */
		this.item.ws_control_panel = function(){return $x('apexir_CONTROL_PANEL');}

		/** 
		 * @ignore */
		this.item.worksheet_id = function(){return $x('apexir_NUM_ROWS');}

		/** 
		 * @ignore */
		this.item.search = function(){return $x('apexir_SEARCH');}

		/**
		 * @ignore 
		 * */
		this.item.search_column = function(){return $x('apexir_CURRENT_SEARCH_COLUMN');}

		/** 
		 * @namespace  
		 * holds functions specifc to worksheet dialogs
		 * */
		this.dialog = {}

		/** 
		 * check to see if something in the dialog was pressed or something else, if something else then reset dialog
		 * */
		this.dialog.check = function (e){
			var tPar = html_GetTarget(e);
			var lEl = $x('apexir_rollover');
			var l_Test = true;
			while(tPar.nodeName != 'BODY'){
				tPar = tPar.parentNode;
				if(tPar == lEl){l_Test = false;}
			}
			if(l_Test){that.dialog.reset();}
		}

		this.dialog.check2 = function (e){
			var tPar = html_GetTarget(e);
			var lEl = $x('apexir_col_values_drop');
			var l_Test = true;
			while(tPar.nodeName != 'BODY'){
				tPar = tPar.parentNode;
				if(tPar == lEl){l_Test = false;}
			}
			if(l_Test){$x_Remove('apexir_col_values_drop')}
		}

		/**
		 * @function
		 *	reset dialog and page to no dialog showing
		 * */
		this.dialog.reset = function (){
			if(that.supress_update){}else{
				$d_ClearAndHide(['searchdrop',that.item.control_panel_drop(),'apexir_SEARCHDROP']);
				$x_Hide(['searchdrop','apexir_rollover']);
				$s('apexir_rollover_content','');
				if($x(that.last_col_id)){$x_Class($x(that.last_col_id).parentNode,'');}
				that.dialog.id = false;
				document.body.onclick = '';
			}
		}

		/**
		 * This returns an object that can be used in dialog validate or highlight save or filter save
		 * @function
		 */
		this.dialog.util_exp_type = function(){
			var l_ob = {};
			l_ob.col = $x('apexir_COLUMN_NAME');
			l_ob.col_type = l_ob.col.options[l_ob.col.selectedIndex].className;
			l_ob.col_opt = $x('apexir_'+l_ob.col_type+'_OPT');
			l_ob.col_opt_val = $v(l_ob.col_opt);
			if(l_ob.col_type == 'DATE' && !(l_ob.col_opt_val=='is in the last' || l_ob.col_opt_val=='is not in the last' || l_ob.col_opt_val=='is in the next' || l_ob.col_opt_val=='is not in the next')){
				l_ob.form_items = ['apexir_BETWEEN_FROM','apexir_BETWEEN_TO'];
			}else{
				l_ob.form_items = ['apexir_EXPR','apexir_EXPR2'];
			}
			return l_ob;
		}

		this.dialog.validate = function(pThis){
			var lTest = [];
			var l_OB = that.dialog.util_exp_type();
			switch(true){
				case (l_OB.col_opt_val=='between'):
					lTest = [l_OB.form_items[0],l_OB.form_items[1]];
				break;    
				case (l_OB.col_opt_val=='is null' || l_OB.col_opt_val=='is not null'):
					lTest = [];
				break;
				case (l_OB.col_opt_val=='is in the last' || l_OB.col_opt_val=='is not in the last' || l_OB.col_opt_val=='is in the next' || l_OB.col_opt_val=='is not in the next'):
					lTest = [l_OB.form_items[0],'apexir_EXPR3'];
				break;
				default:
					lTest = [l_OB.form_items[0]];
			}
			if($f_get_emptys(lTest,'error','')){
				return false;
			}else{
				return l_OB;
			}
			//return $f_get_emptys(lTest,'error','');
		}

		/** 
		 * @namespace  
		 * This namespace holds all functions related to pulling or running page controls
		 * */
		this.controls = {};

		/** resets the control dialog */
		this.controls.cancel = function(){
			that.dialog.reset();
		}

		/** 
		 * Toggles betweeen the two different save dialogs
		 * */
		this.controls.save_toggle = function(pThis){
			var lTest = ($v(pThis)=='NAMED')?'apexir_SAVE_NAMED':'apexir_SAVE_DEFAULT';
			$x_HideSiblings(lTest);
		}			

		/** 
		 * @function
		 * */
		this.controls.drop = function(){
			return that.item.control_panel_drop();
		}

		/** 
		 * @function
		 * standard call to get a control 
		 * */
        this.controls.get =	function(pControl,pID){
			that.dialog.reset();
			that.l_Action = 'CONTROL';
			that.l_Type = pControl;
			that.current_control= pControl;
			that.current_dom = $x(pID)
			if(pID){that.current_col_id = pID;}
			that._Get('CONTROL',pControl,false,pID);
		}

		/** 
		 * Controls Dropdown
		 * @function
		 * */
        this.controls.menu = function(pThis,pId){
			that.dialog.reset();
			app_AppMenuMultiOpenBottom2(pThis,pId,false);
		}

		this.controls.init = function(pThis){

		}

        /**
		 * Pull IR table header widget.
		 * @function
		 */
        this.controls.widget =			function(pID){
			this.get('SORT_WIDGET',pID);
			that.current_col_dom = $x(pID);
			document.body.onclick = that.dialog.check;
		}

		/**
		 * Pulls a Narrow Filter dropdown on a text area
		 *@function
		 */
		this.controls.narrow = function(pID){
			that.supress_update = true;
			that.temp_return_element = $x(pID);
			this.get('NARROW',$v('apexir_COLUMN_NAME'));
		}

		/**
		 * Pulls a Format Mask dropdown on a text area
		 *@function
		 */
		this.controls.format_mask = function(pID){
			that.supress_update = true;
			that.temp_return_element = $x(pID);
			this.get('FORMAT_MASK_LOV');
		}

		/** 
		 * @ignore 
		 * */
		this.controls.col_lov =			function(pID){
			this.get('COL_LOV',pID);
		}

		/** Action Menu Filter */
        this.controls.filter =			function(pID){
			this.get('SHOW_FILTER',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.filter2 =			function(){
			that.controls.set = true;
			this.get('SHOW_FILTER');
		}

		/** 
		 * Action Menu Select Columns 
		 * */
        this.controls.display_column =	function(pID){
			this.get('SHOW_COLUMN',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.search_column =	function(pID){
			this.get('SEARCH_COLUMN',pID);
		}

		/** 
		 * Action Menu Highlight 
		 * @function
		 * */
        this.controls.highlight =		function(pID){
			this.get('SHOW_HIGHLIGHT',pID);
		}

		/** 
		 * Action Menu Sort 
		 * @function
		 * */
        this.controls.ordering =		function(pID){
			this.get('SHOW_ORDERING',pID);
		}

		/** 
		 * Action Menu Save 
		 * @function
		 * */
        this.controls.save =			function(pID){
			this.get('SAVE_REPORT',pID);
		}

		/**
		 * @ignore 
		 * */
        this.controls.chart =			function(pID){
			this.get('SHOW_CHART',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.calendar =		function(pID){
			this.get('SAVE_CAL',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.aggregate =		function(pID){
			this.get('SHOW_AGGREGATE',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.delete_report =	function(pID){
			this.get('SHOW_DELETE',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.flashback =		function(pID){
			this.get('SHOW_FLASHBACK',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.reset =			function(pID){
			this.get('SHOW_RESET',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.rename =			function(pID){
			this.get('SHOW_RENAME',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.row =				function(pID){
			this.get('SHOW_DETAIL',pID);
		}

		/** 
		 * @ignore 
		 * */
        this.controls.computation =		function(pID){
			pID = (pID)?pID:that.dialog.id;
			this.get('SHOW_COMPUTATION',pID);
			that.dialog.id = false;
		}

		/** 
		 * @ignore 
		 * */
		this.controls.download =		function(pID){
			this.get('SHOW_DOWNLOAD',pID);
		}

		/** 
		 * @ignore 
		 * */
		this.controls.info=				function(pID){
			this.get('INFO',that.current_col_id);
		}

		/** 
		 * Pulls control break.
		 * */
		this.controls.ctrl_break =		function(pID){this.get('SHOW_CTRL_BREAK',pID);}

		/** 
		 * @namespace 
		 * */
		this.highlight = {};

		/** 
		 * Removes a higlight rule.
		 * @param {String} pId highlight id
		 * */
		this.highlight.clear = function(pId){
			that.action('CLEAR_HIGHLIGHT',false,$nvl(pId,$x('HIGHLIGHT_ID').value));
		}

		/** 
		 * toggles a higlight rule
		 * @param {Dom node} pThis this must be a checkbox for now
		 * @param {String} pId highlight id
		 * */
		this.highlight.toggle = function(pThis,pId){
			that.action('TOGGLE_HIGHLIGHT',false,pId,(pThis.checked)?'Y':'N');
		}

		/**
		 * @function
		 * Save a highlight rule (Step 1 of 2) next call is
		 **/
		this.highlight.save = function(pThis){
			var l_OB = that.dialog.validate();
			if(!l_OB){return}
			that.supress_update = true;
			var lTemp = ['apexir_HIGHLIGHT_ID','apexir_HIGHLIGHT_NAME',l_OB.col,l_OB.col_opt,l_OB.form_items[0],l_OB.form_items[1],'apexir_EXPR3','apexir_HIGHLIGHT_SEQUENCE','apexir_HIGHLIGHT_ENABLED','apexir_HIGHLIGHT_TYPE','apexir_BG_COLOR','apexir_FONT_COLOR'];
			that.get.AddArrayItems(lTemp,1);
			that.action('SAVE_HIGHLIGHT');
			l_OB = null;
			return;
		}

		/** 
		 * @namespace 
		 * */
		this.navigate = {};

		/** 
		 * @ignore 
		 * */
		this.navigate.paginate = function(pThis){
			that.get.addParam('p_widget_num_return',pThis.split('max_rows=')[1].split('rows_fetched')[0])
			that.action('PAGE',pThis);
		}

		/** 
		 * @namespace 
		 * */
		this.column = {};

		/** 
		 * @ignore 
		 * */
		this.column.pOb = this;

		/** 
		 * @ignore */
		this.column.break_on = function(pThis){
			if(pThis){that.current_col_id = pThis};
			that.action('BREAK',false,that.current_col_id);
		}

		/** 
		 * @ignore */
		this.column.break_toggle = function(pThis,pId){
			that.action('BREAK_TOGGLE',false,pId,(pThis.checked)?'Y':'N');
		}

		/** 
		 * @ignore
		 * hides column*/
		this.column.hide=function(pThis){
			var lValue = (!!pThis)?pThis:that.current_col_id;
			that.action('HIDE',false,lValue);
		}

		/** 
		 * @ignore 
		 * applies quick filter and filter dialog
		 * */
		this.column.filter=function(pThis){
			var lAction = 'ADD';
			if(pThis){
				that.current_col_id = pThis;
				lAction = 'UPDATE';
			}else{
				pThis = $v('apexir_COLUMN_NAME');
			}
			var l_OB = that.dialog.validate();
			if(!l_OB){return}
			var lTemp = [l_OB.col,l_OB.col_opt,l_OB.form_items[0],l_OB.form_items[1],'apexir_EXPR3']
			that.get.AddArrayItems(lTemp,1);
			that.supress_update = true;
			that.action('FILTER',lAction,pThis);
		}

		/** 
		 * @function
		 * Deletes the display of search or a filter.
		 * */
		this.column.filter_delete=function(pThis){
			that.action('FILTER_DELETE',false,pThis);
		}

        /** 
		 * @function 
		 * toggle display of search or a filter
		 * */
		this.column.filter_toggle=function(pThis,pId){
			that.action('FILTER_TOGGLE',false,pId,(pThis.checked)?'Y':'N');
		}
		/** 
		 * @function 
		 * applies columns to display
		 * */
		this.column.display=function(pThis){
			var lTemp = [];
			var lSelects = $x('apexir_shuttle2').getElementsByTagName('SELECT')[0];
			for(i=0,len = lSelects.options.length;i<len;i++){lTemp[lTemp.length]=lSelects.options[i].value}
			that.get.AddArray(lTemp,1)
			that.action('SET_COLUMNS');
		}

		/** 
		 * @function 
		 * applies quick sort and order dialog
		 * */
		this.column.order=function(pThis){
			if(pThis == 'ASC' || pThis=='DESC'){
					that.get.addParam('f01',that.last_col_id);
					that.get.addParam('f02',pThis);
					that.action('COLUMN_ORDER');
			}else{
				var lTemp = ['apexir_COLUMN_01','apexir_COLUMN_02','apexir_COLUMN_03','apexir_COLUMN_04','apexir_COLUMN_05','apexir_COLUMN_06'];
				var lTemp2 = ['apexir_ASCENDING_01','apexir_ASCENDING_02','apexir_ASCENDING_03','apexir_ASCENDING_04','apexir_ASCENDING_05','apexir_ASCENDING_06'];
				var lTemp3 = ['apexir_NULLS_01','apexir_NULLS_02','apexir_NULLS_03','apexir_NULLS_04','apexir_NULLS_05','apexir_NULLS_06'];
				for(var i=0,len=lTemp.length;i<len;i++){
					if($x(lTemp[i]).value != '0'){
						that.get.addParam('f01',$v(lTemp[i]));
						that.get.addParam('f02',$v(lTemp2[i]));
						that.get.addParam('f03',$v(lTemp3[i]));
					}}
				that.action('SORT');
			}

		}

		/** 
		 * @function 
		 * applies control break dialog
		 * */ 
		this.column.break_save=function(pThis){ 
			 if(pThis == 'ENABLE' || pThis=='DISABLE'){ 
					   that.get.addParam('f01',that.last_col_id); 
					   that.get.addParam('f02',pThis); 
			 }else{ 
				  var lTemp = ['apexir_COLUMN_01','apexir_COLUMN_02','apexir_COLUMN_03','apexir_COLUMN_04','apexir_COLUMN_05','apexir_COLUMN_06']; 
				  var lTemp2 = ['apexir_ENABLE_01','apexir_ENABLE_02','apexir_ENABLE_03','apexir_ENABLE_04','apexir_ENABLE_05','apexir_ENABLE_06']; 
				  for(var i=0,len=lTemp.length;i<len;i++){ 
					   if($x(lTemp[i]).value != '0'){ 
					   that.get.addParam('f01',$v(lTemp[i])); 
					   that.get.addParam('f02',$v(lTemp2[i])); 
				  }} 
			 } 
			 that.action('SAVE_BREAK'); 
		}

		/** 
		 * @namespace 
		 * */
		this.flashback = {}

		/** 
		 * @function
		 * Calls flashback to pull report data from N minutes ago (Step 1 of 2)
		 */
		this.flashback.save = function(){
			that.supress_update = true;
			that.action('FLASHBACK_SET',false,false,$v('apexir_FLASHBACK_TIME'));
		}

		/** 
		 * @ignore 
		 */
		this.flashback.clear = function(){
			that.action('FLASHBACK_CLEAR',false,false,false);
		}

		/** 
		 * @ignore 
		 */
		this.flashback.toggle = function(){
			that.action('FLASHBACK_TOGGLE',false,false,false);
		}

		/** 
		 * @namespace
		 * */
		this.aggregate = {}

		/**
		 * Controls any adjustments needed when displaying aggregate control
		 * @function
		 */
		this.aggregate.control = function(){
			if($v('apexir_AGGREGATE_BY')=='COUNT'){
				$x_Show_Hide('ALL_COLUMNS','NUMBER_COLUMNS');
			}else{
				$x_Show_Hide('NUMBER_COLUMNS','ALL_COLUMNS');
			}
		}

		/**
		 * Save an aggregate on report
		 * @function
		 */
		this.aggregate.save = function(){
			var lCol = ($v('apexir_AGGREGATE_BY')=='COUNT')?$v('apexir_COLUMN_NAME_ALL'):$v('apexir_COLUMN_NAME');
			that.action('SAVE_AGGREGATE',false,$v('apexir_AGGREGATION'),$v('apexir_AGGREGATE_BY'),lCol); 
		}

		/** 
		 * Delete an Aggrigation
		 * @function 
		 */
		this.aggregate.clear = function(){
			that.action('DELETE_AGGREGATE',false,$v('apexir_AGGREGATION'));
		}

		/** 
		 * @ignore 
		 **/
		this.aggregate.toggle = function(){}

		/** 
		 * @namespace 
		 **/
		this.computation = {}

		/**
		 *	Part 1 : save computation this is a 2 part process first to see if the computation is valid then show messaging or to repull the report
		 *	@function
		 **/
		this.computation.save = function(){			
			var lValidate = $f_get_emptys(['apexir_COLUMN_LABEL','apexir_COMPUTATION_EXPR'],'error','');			
			if(!!lValidate){return}
			that.supress_update = true;
			that.action('SAVE_COMPUTATION',false,$v('apexir_COMPUTATION_ID'),$v('apexir_COLUMN_LABEL'),$v('apexir_REPORT_LABEL'),$v('apexir_FORMAT_MASK'),$v('apexir_COMPUTATION_EXPR'));
		}

		/** 
		 * @ignore 
		 */
		this.computation.clear = function(){
			that.action('DELETE_COMPUTATION',false,$v('apexir_COMPUTATION_ID'));
		}

		/** 
		 * @ignore 
		 */
		this.computation.toggle = function(){}

		/** 
		 * @namespace 
		 */
		this.chart= {}

		/** 
		 * @ignore 
		 */
		this.chart.control = function(pThis){
				var l_P = [];
				l_P[0] = $x('apexir_LABEL_AXIS_TITLE').parentNode
				l_P[1] = $x('apexir_VALUE_AXIS_TITLE').parentNode
				l_P[2]= l_P[0].previousSibling;
				l_P[3] = l_P[1].previousSibling;
				if($x('apexir_CHART_TYPE_2').checked){
					$x_Hide(l_P);
				}else{
					$x_Show(l_P);
				}

		}

		/**
		 * calls SAVE_CHART action with the items posted to the f01 array in the order listed
		 * @function
		 */
		this.chart.save = function(){
			var lTemp = ['apexir_CHART_TYPE','apexir_CHART_LABEL','apexir_CHART_VALUE','apexir_AGGREGATE_BY','apexir_LABEL_AXIS_TITLE','apexir_VALUE_AXIS_TITLE','apexir_SORT'];
			that.get.AddArrayItems(lTemp,1);
			that.action('SAVE_CHART');
		}

		/** 
		 * @namespace 
		 */
		this.chart.clear = function(){
			that.action('DELETE_CHART');
		}

		/**
		 *@function
		 *calls SAVE_CHART action with the items posted to the f01 array in the order listed
		 */
		this.chart.view = function(){
			that.action('VIEW_CHART',false,false);
		}

		/** 
		 * @namespace 
		 */
		this.calendar= {}

		/** 
		 * @ignore 
		 */
		this.calendar.save = function(){
			that.action('SAVE_CALENDAR',false,false,$v('DATE_COLUMN'),$v('DISPLAY_COLUMN'));
		}

		/** 
		 * @ignore 
		 */
		this.calendar.view = function(){
			that.action('VIEW_CALENDAR',false,false);
		}

		/** 
		 * @namespace 
		 */
		this.data = {}

		/** 
		 * @ignore 
		 */
        this.data.view =function(){
			that.action('VIEW_REPORT',false,false);
		}

		/** 
		 * @namespace 
		 * */
		this.detail = {}

		/** @ignore */
		this.detail.last_row_opened = false;

		/** @ignore */
		this.detail.show = function(pThis){
			if(that.ajax_busy){return;}
			$x_Show(getElementsByClass('displayed'));
			$x_Show(getElementsByClass('other'));
			if($x('apexir_EXCLUDE_NULL_0').checked && $x('apexir_DISPLAY_OPTION').checked){       
				$x_Hide(getElementsByClass('null')); 
				$x_Hide(getElementsByClass('other'));      
			}else if ($x('apexir_EXCLUDE_NULL_0').checked) {  
				$x_Hide(getElementsByClass('null')); 
			}else if ($x('apexir_DISPLAY_OPTION').checked) { 
				$x_Hide(getElementsByClass('other'));  
			}
			that.l_Action = 'CHANGE_DETAIL_OPTION';
			that.supress_update = true;
			that.action('CHANGE_DETAIL_OPTION',false,false,$v('apexir_EXCLUDE_NULL_0'),$v('apexir_DISPLAY_OPTION'));
		}

		/**
		 * Delete current worksheet report
		 * @function 
		 * */
		this.remove = function(){
			that.action('DELETE',false,false,false);
		}

		/** 
		 * Reset current  worksheet report to initial state
		 * @function 
		 * */
		this.reset = function(){
			that.action('RESET',false,false,false);
		}

		/** 
		 * Save or Rename current worksheet report state
		 * @function 
		 * @param {} pThis
		 * */
		this.save = function(pThis){ 
			var l_c = $x('create_category'); 
			var lValidate = $f_get_emptys(['apexir_WORKSHEET_NAME'],'error',''); 
			if(l_c){lValidate = $f_get_emptys([l_c],'error','')}; 
			if(!!lValidate){return} 
			l_cat = (l_c)?l_c.value:$v('apexir_WORKSHEET_CATEGORY'); 
			pThis =(!!pThis)?'RENAME':'SAVE';
			that.action(pThis,false,false,$v('apexir_WORKSHEET_NAME'),l_cat,$v('apexir_PUBLIC'),$v('apexir_DESCRIPTION'),$v('apexir_IS_DEFAULT')); 
		}

		/** 
		 * Save current worksheet report state as default worksheet report
		 * @function 
		 * */
		this.save_default = function(){
               that.action('SAVE_DEFAULT',false,false,false);
        }

		/** @ignore */
		this.save_category_check = function(pThis){
			if(pThis.value=='new'){$dom_AddInput(pThis.parentNode,'text','create_category','');}
			else{$x_Remove('create_category')}
		}		

		/** 
		 * Pull worksheet report setting pThis to current report
		 * @function 
		 * @param {String} [pThis] worksheet id
		 * */
		this.pull = function(pThis){
			if(!!pThis){that.report_id = pThis;}
			that._Get('PULL');
		}

		/** @ignore */
		this.download=function(pThis){}

		/**
		 * Runs the basic search functionality of the worksheet.
		 * @param {String} [pThis] if set to SEARCH check 
		 *
		 * */
		this.search=function(pThis){
			var lSearch = that.item.search();
			var lSearch_Col = that.item.search_column();
            var lReport = $v('apexir_REPORT_ID');
			var lTemp;
			if(pThis='SEARCH'){
				that.get.addParam('p_widget_num_return',$v('apexir_NUM_ROWS'));
				if(!!that.external_items){
				 /* 
				  * if there are external items to submit 
				  * */
					var l_external_items = that.external_items.split(",");
					that.get.AddPageItems(l_external_items);
				}
			}
			if($v_IsEmpty(lSearch)){
				that.pull(lReport);
			}else{
				if(pThis='SEARCH'){
					lTemp = [$v('apexir_CURRENT_SEARCH_COLUMN'),'contains',$v(lSearch),$v('apexir_NUM_ROWS')];
					pThis = 'QUICK_FILTER';
				}else{
					lTemp = [this.current_col_id,'=',$v(lSearch),$v('apexir_NUM_ROWS')];
					pThis = 'FILTER';
				}
				that.get.AddArray(lTemp,1);
				that.action(pThis,'ADD');
			}
			$s(lSearch,'');
		}

		/**
		 * generic call for returning dialogs with validation
		 * @function
		 */
		this.valid_action = function(pTest){
			if(pTest == 'true'){
				that.pull();
			}else{
				$s('apexir_DIALOG_MESSAGE',pTest);
			}
		}

		/**
		 * the basic AJAX call for ACTIONs for the ws.
		 * @param {String} p_widget_action widget action to call
		 * @param {String} [p_widget_action_mod] modify widget action to call
		 * @param {String} [p_id] id of whatever you want to send
		 * @param {String} [p_value] value of whatever you want to send
		 * @param {String} [p_x05] extra value
		 * @param {String} [p_x06] extra value
		 * @param {String} [p_x07] extra value
		 * @param {String} [p_x08] extra value
		 * @param {String} [p_x09] extra value
		 * @param {String} [p_x10] extra value
		 * */
		this.action = function(p_widget_action,p_widget_action_mod,p_id,p_value,p_x05,p_x06,p_x07,p_x08,p_x09,p_x10){
			that.l_Action = p_widget_action;
			that._Get('ACTION',p_widget_action,p_widget_action_mod,p_id,p_value,p_x05,p_x06,p_x07,p_x08,p_x09,p_x10);
		}

		/**
		 * @function
		 * This function is the base worksheet ajax call 
		 * */
	this._Get = function(p_widget_mod,p_widget_action,p_widget_action_mod,p_id,p_value,p_x05,p_x06,p_x07,p_x08,p_x09,p_x10){
		if(that.ajax_busy){
			return;
		}else{
			that.ajax_busy = true;
		}
		that.get.addParam('p_widget_name','worksheet');
		(!!p_widget_mod)?that.get.addParam('p_widget_mod',p_widget_mod):null;
		(!!p_widget_action)?that.get.addParam('p_widget_action',p_widget_action):null;
		(!!p_widget_action_mod)?that.get.addParam('p_widget_action_mod',p_widget_action_mod):null;
		that.get.addParam('x01',$v('apexir_WORKSHEET_ID'));
		(!!that.report_id)?that.get.addParam('x02',that.report_id):'0';
		(!!p_id)?that.get.addParam('x03',p_id):null;
		(!!p_value)?that.get.addParam('x04',p_value):null;
		/*
		 * extra values
		 */
		(!!p_x05)?that.get.addParam('x05',p_x05):null;
		(!!p_x06)?that.get.addParam('x06',p_x06):null;
		(!!p_x07)?that.get.addParam('x07',p_x07):null;
		(!!p_x08)?that.get.addParam('x08',p_x08):null;
		(!!p_x09)?that.get.addParam('x09',p_x09):null;
		(!!p_x10)?that.get.addParam('x10',p_x10):null;
		that.get.GetAsync(that._Return);
	}

	/** 
	 * Gets called before all worksheet AJAX calls 
	 * @function
	 */
	this._Loading = function(){
		$x_Hide('apexir_rollover');
		that._BusyGraphic(p.readyState);
		return;
	}

	/**
	 * Gets called after all worksheet AJAX calls 
	 * @function
	 */
	this._Finished_Loading = function(){
		that._BusyGraphic(p.readyState);
		/**
		 *This fixes IE bug for a style section in AJAX pulled HTML snippet.
		 */
		if(ie){
			if(!!!that.lCSS){
				that.lCSS = document.createStyleSheet();
			}
			startTag = '<style id="apexir_WORKSHEET_CSS" type="text/css">' ;
			endTag = '</style>';
			var start = p.responseText.indexOf(startTag);
			var response  = p.responseText.substring(start+startTag.length);
			var end   = response.indexOf(endTag); 
			response  = response.substring(0,end);
			that.lCSS.cssText = response;
		}
		document.onclick = null;
		that.init();
		if(!!that.l_LastFunction){
			that.l_LastFunction();
			that.l_LastFunction = false;
		}
		that.ajax_busy = false;
		return;
	}

	/**
	 * This function shows a loading graphic based on readyState
	 *@function
	 */
	this._BusyGraphic = function(pState){
		if(pState == 1){
			$x_Show('apexir_LOADER');
		}
		else{$x_Hide('apexir_LOADER');}
		return;
	}

	/**
	 * This function is the central control for AJAX returns in the worksheet 
	 * @function
	 */
	this._Return = function(){
		if(p.readyState == 1){
			that._Loading();
		}else if(p.readyState == 2){
		}else if(p.readyState == 3){
		}else if(p.readyState == 4){

			$x_Hide('searchdrop').innerHTML='';
			if(that.l_Action=='CONTROL'){

				if(that.current_control == 'COL_LOV'){

					var lBuild = new $d_LOV_from_JSON();
					lBuild.l_Type = 'SELECT';
					lBuild.create(gReport.controls.lov_dom,p.responseText);
					$s(lBuild.l_Dom,gReport.controls.value);
					lBuild.l_Dom.focus()
					lBuild.l_Dom.onblur = function(e){cellsave(e,this)}
				
				}else if(that.current_control == 'SORT_WIDGET'){
					var myObject = $u_eval('(' + p.responseText + ')');
					that.dialog.id = myObject.dialog.id;
					var l = $x('apexir_rollover').getElementsByTagName('TABLE')[0];
					/*
					 * This code shows or hides control elements
					**/
					$x_Show_Hide([l,'apexir_sortup','apexir_sortdown','apexir_removefilter','apexir_hide','apexir_break','apexir_info','apexir_computation'],myObject.dialog.hide);
					$x_Hide(myObject.dialog.hide);
					/*
					 * The following code populates the unquie value list
					 */
					if(myObject.dialog.uv){
						var len = myObject.dialog.row.length
						for (var i=0;i<len;i++){
							if(myObject.dialog.row[i].R != null){
								if(myObject.dialog.row[i].D != null){var tDisplay = myObject.dialog.row[i].D}
								else {var tDisplay = myObject.dialog.row[i].R}
								var lTemp = $dom_AddTag('apexir_rollover_content','a',tDisplay);
								lTemp.apexir_RETURN_VALUE = myObject.dialog.row[i].R;
								lTemp.href= 'javascript:void(false);';
								lTemp.onclick = function(){
									var lTemp = [that.current_col_id,'=',this.apexir_RETURN_VALUE,'',''];
									that.get.AddArray(lTemp,1);
									that._Get('ACTION','QUICK_FILTER');
								}
							}
						}
						if(len > 10){$x_Style('apexir_rollover_content','height','210px')}
						else{$x_Style('apexir_rollover_content','height','')}
						$x_Show('apexir_rollover_content');
						$s('apexir_search','');
					}else{
						$x_Hide('apexir_rollover_content');
					}

					var pThis = $x(that.current_col_dom);
					$x_Show('apexir_rollover');
					$x_Style('apexir_rollover','left',(findPosX(pThis.parentNode))+'px');
					$x_Style('apexir_rollover','top',(findPosY(pThis)+pThis.offsetHeight+5)+'px');
					$x_Class(pThis.parentNode,'current');
					that.last_col_id = pThis.id;
					document.body.onclick = that.dialog.check;
				}else if(that.current_control == 'SHOW_FILTER' || that.current_control == 'SHOW_HIGHLIGHT'){
					var lDrop = that.item.control_panel_drop();
					$s(lDrop,p.responseText);
					$x_Show(lDrop);
					/* switch out */
					ws_ColumnCheck($x('apexir_COLUMN_NAME'));
				}else if(that.current_control == 'NARROW' || that.current_control == 'FORMAT_MASK_LOV'){
					var lBuild = new $d_LOV_from_JSON();
					lBuild.l_Type = 'a';
					lBuild.create(lDiv,p.responseText);
					lBuild.l_Dom.id='apexir_col_values_drop';
					$x_Style(lBuild.l_Dom,'height','200px');
					$x_Style(lBuild.l_Dom,'display','block');
					if(!$x('apexir_col_values_drop_space')){
						lThis = $dom_AddTag($x(that.temp_return_element).parentNode,'BR');
						lThis.id="apexir_col_values_drop_space";
					}
					$x(that.temp_return_element).parentNode.appendChild(lBuild.l_Dom);
					for(var i=0,len=lBuild.l_NewEls.length;i<len;i++){
						lTemp = lBuild.l_NewEls[i];
						lTemp.href="javascript:void(false)";
						if(that.current_control == 'NARROW'){
							lTemp.onclick = function(){
								var lCol = $x('apexir_COLUMN_NAME');
								var lOpt = $x('apexir_'+lCol.options[lCol.selectedIndex].className+'_OPT');
								var l_Test = $v(lOpt);
								if(l_Test == 'in' || l_Test == 'not in'){
									l_Test = $v(that.temp_return_element);
									$s(that.temp_return_element,(isEmpty(that.temp_return_element))?this.id:l_Test+','+this.id);
								}else{
									$s(that.temp_return_element,this.id);
									$x_Remove('apexir_col_values_drop');
								}
							}
						}else{
							lTemp.onclick = function(){
									$s(that.temp_return_element,this.id);
									$x_Remove('apexir_col_values_drop');
							}
						}
					}
					that.supress_update = false;
					that.l_Action = false;
					document.body.onclick = that.dialog.check2;					
				}else if(that.current_control == 'INFO'){
					var l = $x('apexir_rollover').getElementsByTagName('TABLE')[0];
					$x_Hide(l);
					$s('apexir_rollover_content',p.responseText);
					$x_Style('apexir_rollover_content','height','')
					var pThis = $x(that.current_col_dom);
					$x_Show('apexir_rollover');
					$x_Style('apexir_rollover','left',(findPosX(pThis.parentNode))+'px');
					$x_Style('apexir_rollover_content','top',(findPosY(pThis)+pThis.offsetHeight+5)+'px');
					$x_Class(pThis.parentNode,'current');
					that.last_col_id = pThis.id;
					document.body.onclick = that.dialog.check;
				}else if(that.current_control == 'SEARCH_COLUMN'){
					var lDiv = $x('apexir_SEARCHDROP');
					$s(lDiv,'');
					var lBuild = new $d_LOV_from_JSON();
					lBuild.l_Type = 'a';
					lBuild.create(lDiv,p.responseText);
					lBuild.l_Dom.id='apexir_columnsearch';
					var lSearch_Col = that.item.search_column();
					for(var i=0,len=lBuild.l_NewEls.length;i<len;i++){
						lBuild.l_NewEls[i].href='javascript:void(0)';
						lBuild.l_NewEls[i].onclick=function(){
							if(this.id != 0){
								$s('apexir_SEARCH_COLUMN_DROP',this.innerHTML+'');
								$s(lSearch_Col,this.id);
							}else{
								$s('apexir_SEARCH_COLUMN_DROP','');
								$s(lSearch_Col,''); 
							}
							$x_Hide(lDiv);
						};
					}
					$x_Show(lDiv);
					document.body.onclick = that.dialog.check;
				}else if(that.current_control  == 'SHOW_DETAIL'){
						$x_Hide(that.item.worksheet_report());
						$s('apexir_DATA_PANEL','');
						$s('apexir_CONTROL_PANEL_DROP','');
						$s(that.item.worksheet_detail(),p.responseText);
						$x_Show(that.item.worksheet_detail());
				}else{
					var lDrop = that.item.control_panel_drop();
					lDrop.innerHTML = p.responseText;
					if(that.current_control  == 'SHOW_CHART'){
						that.chart.control();
					}
					if(that.controls.set){
						$s('apexir_COLUMN_NAME',that.last_col_id);
						$s('apexir_EXPR',$v('apexir_SEARCH'));
						that.controls.set = false;
						$s('apexir_SEARCH','');
					}
                    if(that.current_control == 'SHOW_COLUMN'){
                        window.g_Shuttlep_v01 = null;
                        if(!flowSelectArray){var flowSelectArray = [];}
                        flowSelectArray[2] = $x('apexir_SHUTTLE_LEFT');
                        flowSelectArray[1] = $x('apexir_SHUTTLE_RIGHT');
                        window.g_Shuttlep_v01 = new dhtml_ShuttleObject(flowSelectArray[2],flowSelectArray[1]);
                    }
					/* finally show */
					$x_Show(lDrop);
				}
			}else{
				if(that.supress_update){
					if(that.l_Action == 'SAVE_COMPUTATION' || that.l_Action == 'FLASHBACK_SET' || that.l_Action == 'SAVE_HIGHLIGHT' || that.l_Action == 'FILTER'){
						that.l_LastFunction =  function(){that.valid_action(p.responseText);}
					}
					that.ajax_busy = false;
				    that.supress_update = false;
					that.l_Action = false;
				}else{
					that.ajax_busy = false;
					$x_Hide('apexir_rollover');
					lTemp = $x('apexir_WORKSHEET');
					lTemp.id = 'apexir_WORKSHEET_old';
					lThis = $u_js_temp_drop();
					$s(lThis,p.responseText);
					lTemp.parentNode.replaceChild($x('apexir_WORKSHEET'),lTemp);
					$d_ClearAndHide('apexir_DETAIL');
					$s('apexir_CURRENT_SEARCH_COLUMN','');
					$s('apexir_SEARCH_COLUMN_DROP','');
					$x_Show('apexir_REPORT');
					$u_js_temp_clear();
				}
			}
			that._Finished_Loading();
		}else{return false;}
	}

return;

	/** @function
	 *	Initializes Interactive Report
	 * */
	function init(pId){
		this.l_Action = false;
		this.l_Type = false;
		that.ajax_busy = false;
		if(!!pId){that.worksheet_id = pId}
		that.report_id = ($v('apexir_REPORT_ID'))?$v('apexir_REPORT_ID'):'0';
		this.get = new htmldb_Get(null,$v('pFlowId'),'APXWGT',$v('pFlowStepId'));
	}

	}
}

/**
 * @namespace = apex.ajax
 */ 
apex.ajax = {
	/*clob*/
	clob : function (pReturn){
		var that = this;
		this.ajax = new htmldb_Get(null,$x('pFlowId').value,'APXWGT',0);
		this.ajax.addParam('p_widget_name','apex_utility');
		this.ajax.addParam('x04','CLOB_CONTENT');
		this._get = _get;
		this._set = _set;
		this._return = !!pReturn?pReturn:_return;
		return;
		function _get(pValue){
			that.ajax.addParam('x05','GET');
			that.ajax.GetAsync(that._return);
		}
		function _set(pValue){
			that.ajax.addParam('x05','SET');
			that.ajax.AddArrayClob(pValue,1);
			that.ajax.GetAsync(that._return);
		}
		function _return(){
		if(p.readyState == 1){
			}else if(p.readyState == 2){
			}else if(p.readyState == 3){
			}else if(p.readyState == 4){
			  return p;
			}else{return false;}
		}
	},
	test : function (pReturn){
		var that = this;
		this.ajax = new htmldb_Get(null,$x('pFlowId').value,'APXWGT',0);
		this.ajax.addParam('p_widget_name','apex_utility');
		this._get = _get;
		this._set = _set;
		this._return = !!pReturn?pReturn:_return;
		return;
		function _get(pValue){
			that.ajax.GetAsync(that._return);
		}
		function _set(pValue){}
		function _return(pValue){}
	},
	widget : function (pWidget,pReturn){
		var that = this;
		this.ajax = new htmldb_Get(null,$x('pFlowId').value,'APXWGT',0);
		this.ajax.addParam('p_widget_name',pWidget);
		this._get = _get;
		this._set = _set;
		this._return = !!pReturn?pReturn:_return;
		return;
		function _get(pValue){
			that.ajax.GetAsync(that._return);
		}
		function _set(pValue){}
		function _return(pValue){}
	},
	ondemand : function (pWidget,pReturn){
		var that = this;
		this.ajax = new htmldb_Get(null,$x('pFlowId').value,'APPLICATION_PROCESS='+pWidget,0);
		this._get = _get;
		this._set = _set;
		this._return = !!pReturn?pReturn:_return;
		return;
		function _get(pValue){
			that.ajax.GetAsync(that._return);
		}
		function _set(pValue){}
		function _return(pValue){}
	}
}
/**
 * @namespace = apex.tabular
 */ 
apex.tabular = {
   table : function (pThis,pChange){
		var that = this;
		this.l_Table = $x(pThis);
		this.l_Headers = that.l_Table.rows[0].cells;
		this.l_Row1 = that.l_Table.rows[1].cells;
		this.currentItem = null;
		this.col = {};
		this.col.length = that.l_Headers.length;
		this.col.by_id = function(pId){
			for(var i=0,len=that.col.length;i<len;i++){
				var lTest = (that.col[i].id == pId)
				if(lTest){return that.col[i]}
			}
		}

		this.col.by_name = function(pName){
			for(var i=0,len=that.col.length;i<len;i++){
				var lTest = (that.col[i].name == pName)
				if(lTest){return that.col[i]}
			}
		}

		this.error = function(){
			that.currentItem.focus();
			$x_Style(that.currentItem,'border','1px solid red');
		}

		this.success = function(){
			$x_Style(that.currentItem,'border','');
		}

		for(var i=0,len=this.l_Headers.length;i<len;i++){
			var l_column = {}
			l_column.id = this.l_Headers[i].id;
			var lTemp = $x_FormItems(this.l_Row1[i],'ALL')[0]
			l_column.name = (lTemp)?lTemp.name:false;
			l_column.dom = this.l_Headers[i];
			this.col[i] = l_column;
		}
		var lInputs = $x_FormItems(this.l_Table,'ALL');
		for(var i=0,len=lInputs.length;i<len;i++){
			lInputs[i].onchange=function(){that.row.init(this,that);}
		}
		this.row ={}
		this.row.dom
		this.row.init = (pChange)?pChange:function(pThis,pThat){};
		this.row.cell={}
		this.row.cell.item= function(pThis){return $x_FormItems(that.row.dom.cells[that.col.by_id(pThis).dom.cellIndex])[0];}
		this.row.cell.value = function(pThis,pValue){that.row.cell.item(pThis)[0].value=pValue;}
		this.row.cell.disable = function(pThis,pValue){$v(that.row.cell.item(pThis),pValue);}
   },
	sort :function(pId){
		  var that = this;
		  /*image section*/
		  that.class_name = 'pb';
		  that.src_up = htmldb_Img_Dir+'htmldb/icons/up_arrow.gif';
		  that.src_down = htmldb_Img_Dir+'htmldb/icons/down_arrow.gif';

		  that.resequence = true;
		  that.resequence_class = 'orderby';

		  that.table = false;
		  that.row = {};
		  that.row.before_move = function (){}
		  that.row.after_move = function(){}
		  that.row.up = function(pThis){return that.row.move(pThis,'UP');}
		  that.row.down = function(pThis){return that.row.move(pThis,'DOWN');}

		  that.row.top = function(){}
		  that.row.bottom = function(){}

		  that.row.move = function (pThis,pDir){
				that.row.before_move();
				var l_Row = $x_UpTill(pThis,'TR');
				ie_RowFixStart(l_Row);
				$tr_RowMoveFollow(l_Row,true);
				var l_Table = l_Row.parentNode;
				var l_RowNext = l_Row.nextSibling;
				var l_RowPrev = l_Row.previousSibling;
				if(pDir == 'DOWN'){
					while(l_RowNext != null){
						if(l_RowNext.nodeType == 1){break}
						l_RowNext = l_RowNext.nextSibling;
					}
					if(l_RowNext != null && l_RowNext.nodeName == 'TR'){
						oElement = l_Table.insertBefore(l_Row ,l_RowNext.nextSibling);
					}else{
						oElement = l_Table.insertBefore(l_Row ,l_Table.getElementsByTagName('TR')[1]);
					}
				}else if(pDir == 'UP'){
					while(l_RowPrev != null){
						if(l_RowPrev.nodeType == 1){break}
						l_RowPrev = l_RowPrev.previousSibling;
					}
					if(l_RowPrev != null && l_RowPrev.firstChild != null && l_RowPrev.firstChild.nodeName != 'TH' && l_RowPrev.nodeName == 'TR'){
						oElement = l_Table.insertBefore(l_Row ,l_RowPrev);
					}else{
						oElement = l_Table.appendChild(l_Row);
					}
				}
				ie_RowFixFinish(oElement);
				for (var i=1,len=l_Table.rows.length;i<len;i++){
					var lRow = l_Table.rows[i];
					var lH2 = getElementsByClass(that.resequence_class,lRow,'INPUT');
					for (var iI=0,Ilen=lH2.length;iI<Ilen;iI++){lH2[iI].value = i;}
				}
			that.row.after_move();
			return oElement;
		  }
		  that.row.remove = function(){}
		  that.row.add = function(){}

		  that.init = init;
		  if(!!pId){that.init(pId);}

		  return;
		  function init(pId){
				that.table = $x(pId);
				that.lH = getElementsByClass(that.resequence_class,that.table,'INPUT');
				this.create = create;
				var lRow = that.table.rows;
				for (var i=0,len=lRow.length;i<len;i++){
					if(i==0){
						$tr_AddTH(lRow[i],'<br />');
					}
					else{
						var lTd = $tr_AddTD(lRow[i]);
						var lImg_1 = this.create(lTd,that.src_up,that.class_name,function(){that.row.up(this)})
						var lImg_2 = this.create(lTd,that.src_down,that.class_name,function(){that.row.down(this)})
					}
				}
			return;
			  	function create(pThis,pSrc,pClass,pFunction){
						var lImg_1 = $dom_AddTag(pThis,'IMG');
						lImg_1.src=pSrc;
						lImg_1.className = pClass;
						lImg_1.onclick = pFunction;
						return lImg_1;
				}
		  }
	}
}

/** 
 * @ignore 
 * This checks that the proper UI is displayed based on operator
 * */
function ws_OperatorCheck(pThis){
	var lClass = $x('apexir_COLUMN_NAME').options[$x('apexir_COLUMN_NAME').selectedIndex].className;
	var lValue = $v(pThis);
	var lThis = [];
	lThis[0] = $x('apexir_EXPR').parentNode;
	lThis[1] = $x('apexir_EXPR2').parentNode;
	lThis[2] = $x('apexir_EXPR3').parentNode;
	lThis[3] = $x('apexir_BETWEEN_FROM_fieldset').parentNode;
	lThis[4] = $x('apexir_BETWEEN_TO_fieldset').parentNode;
	$x_Show_Hide('apexir_EXPR_ICON',lThis);
	if(lValue=='is null' || lValue=='is not null'){
		$x_Hide('apexir_EXPRESSION_LABEL');
		return;
	}else{
		$x_Show('apexir_EXPRESSION_LABEL');
		if(lClass == 'DATE' && !(lValue=='is in the last' || lValue=='is not in the last' || lValue=='is in the next' || lValue=='is not in the next')){
			$x_Show(lThis[3]);
			(lValue=='between')?$x_Show(lThis[4]):null;
		}else{
			$x_Show(lThis[0]);
			(lValue=='between')?$x_Show(lThis[1]):null;
			(lValue=='is in the last' || lValue=='is not in the last' || lValue=='is in the next' || lValue=='is not in the next')?$x_Show_Hide(lThis[2],'apexir_EXPR_ICON'):null;
		}
	}
	return;
}

/** 
 * @ignore 
 * Checks that proper operator select list is shown
 * */
function ws_ColumnCheck(pThis){
	var lClass = pThis.options[pThis.selectedIndex].className;
	$x_HideSiblings('apexir_'+lClass+'_OPT');
	ws_OperatorCheck('apexir_'+lClass+'_OPT');
}

function item_menu(pThis,pColumn){
	$x_Style('item_menu','position','absolute');
	var lA = $x('item_menu').getElementsByTagName('a');
		for (var i=0,len=lA.length;i<len;i++){
		var lHref = lA[i].href;
		lHref=lHref.split(':');
		lHref[lHref.length-1] = pColumn;
		lA[i].href = $u_ArrayToString(lHref,':')
	}
	dhtml_ButtonDropDown(pThis,'item_menu');
	$x_Show('item_menu');
}

/** 
 * @ignore  
 * */
function comp(pValue){
	lSpace = (!(isNaN(pValue))||pValue == '.');
	html_ReturnToTextSelection(pValue,'apexir_COMPUTATION_EXPR',lSpace);
}

/** 
 * This function controls the ajax based calendar functionality.
 * @function
 * {String} p_calendar_type
 * {String} p_calendar_action
 * {String} p_calendar_date
 * */

function ajax_calendar(p_calendar_type, p_calendar_action, p_calendar_date){
   var l_cal_type_field = $v('p_cal_type_field_id');
   var l_cal_date_field = $v('p_cal_date_field_id');
   var l_cal_id = $v('p_calendar_id');
   var l_calendar_region = 'calendar' + l_cal_id;
   $s(l_cal_date_field,$v('p_calendar_date'));
   // create and apex.ajax.widget object
    var a = new apex.ajax.widget('calendar',function(){
        /* start the return function */
        if(p.readyState == 1){
			document.body.style.cursor = "wait";
        }else if(p.readyState == 2){
		}else if(p.readyState == 3){
		}else if(p.readyState == 4){
           $x(l_calendar_region).innerHTML = p.responseText ;
		   $s(l_cal_date_field,$v('p_calendar_date'));
           document.body.style.cursor = "";
        }else{return false;}
    });
     // code for next,previous and today
    if (p_calendar_type == 'S'){
		p_calendar_type = $v('p_calendar_type');
	}else{
		$s(l_cal_type_field,p_calendar_type);
	}
    a.ajax.addParam('p_widget_mod',p_calendar_type);
    a.ajax.addParam('p_widget_action',p_calendar_action);
    a.ajax.addParam('x01',l_cal_id);
    var lDate = (!!p_calendar_date && p_calendar_date !== '')?p_calendar_date:$v(l_cal_date_field);
    a.ajax.add(l_cal_date_field,lDate);
    a.ajax.addParam('x02',lDate);
    a.ajax.add(l_cal_type_field,p_calendar_type);
    a._get();
}

