#
# $Header: emdeploy.pl 23-nov-2005.01:44:26 tthakur Exp $
#
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      emdeploy.pl - em.ear deployment tool for 10.2
#
#    DESCRIPTION
#      This script deploys EM J2EE appliaction.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#     tthakur   11/23/05 - XbranchMerge tthakur_bug-4747613 from main 
#     tthakur   11/21/05 - bug-4747613
#     ktlaw     08/09/05 - add recoverStage 
#     ktlaw     05/31/05 - use orion-web.xml 
#     ktlaw     05/24/05 - add deploy.master 
#     ktlaw     03/30/05 - move most code to EMDeployTool
#     tthakur   03/17/05 - passing exitcode 
#     tthakur   03/01/05 - backslashes in OH on nt 
#     ktlaw     02/21/05 - 
#     ktlaw     01/25/05 - 
#     ktlaw     01/14/05 - triage setup fix 
#     ktlaw     12/10/04 - default to sysman_stage if in view 
#     tthakur   12/09/04 - 
#     tthakur   12/07/04 - 
#     tthakur   12/06/04 - deploy ini 
#     tthakur   12/03/04 - deploy.master
#     tthakur   12/03/04 - displayHelp
#     tthakur   12/02/04 - helpset config, stagedir option 
#     ktlaw     11/30/04 - ktlaw_emdeploy_ci_scripts
#     tthakur   10/27/04 - Created
################################################################################

use strict;
use English;
use Cwd;
use EMDeployTool;

my $TOOLREF;

# initialize program variables from environment
sub init()
{
  my $OH;					# oracle home
  my $TMP_DIR; 			# temporary directory
  my $TMP_DIR_DEFAULT; 	# default temporary dircetory
  my $PSEP; 				# path separator
  my $EM_STAGE_DIR;			# source directory containing em application, 
  
  # oracle home
  if ($ENV{ORACLE_HOME} eq "")
  {
    print "Please set ORACLE_HOME environment variable. \n";
    exit 2;
  }

  $OH = $ENV{ORACLE_HOME};
 
  # platform dependent variables
  if ($ENV{'OS'} eq "Windows_NT")
  {
	$TMP_DIR_DEFAULT = "c:/temp";
	$PSEP = ";";
  }
  else
  {
	$TMP_DIR_DEFAULT = "/tmp";
	$PSEP = ":";
  }

  # set temporary directory
  if (exists $ENV{'TEMP'} && defined $ENV{'TEMP'} && $ENV{'TEMP'} ne "")
  {
	$TMP_DIR = $ENV{'TEMP'};
  }
  elsif (exists $ENV{'TMP'} && defined $ENV{'TMP'} && $ENV{'TMP'} ne "")
  {
	$TMP_DIR = $ENV{'TMP'};
  }
  else
  {
	$TMP_DIR = $TMP_DIR_DEFAULT;
  }

  #workaround weird NT behaviour
  $TMP_DIR =~ s/^\/cygdrive\/([a-z])/$1:/g;
  $TOOLREF = new EMDeployTool();
  $TOOLREF->initialize($OH,$OH,$EM_STAGE_DIR,$TMP_DIR,$PSEP);
}

sub processCommandLine()
{
  my @args = @ARGV;

  # process arguments
  while (scalar(@args) gt 0)
  {
  	if ($args[0] eq "-stage_dir")
  	{
  		shift(@args);
  		$TOOLREF->setStageDir($args[0]);
  		shift(@args);
  	}
  	elsif ($args[0] eq "-nodeploymaster")
	{
		shift(@args);
		$TOOLREF->setNoDeployMaster();
	}
	else
  	{
		$TOOLREF->displayHelp();
  		exit 1;
  	}
  }
}

######################################################################
# Main program.
######################################################################

my $origdir = getcwd();

init();

processCommandLine();

$TOOLREF->printEnviron();

$TOOLREF->doPrereqChecks();

$TOOLREF->appendToDeployIni();

$TOOLREF->appendFromDeployMaster();

$TOOLREF->generateOrionWebXml();

if( -e "$TOOLREF->{'stage_dir'}" )
{
  $TOOLREF->createMasterHelpsetConfig();
  $TOOLREF->renameIndexHtml();
  $TOOLREF->createEmEar();
}else
{
  $TOOLREF->recoverStage();
}

$TOOLREF->deployEmEar();

chdir($origdir);

die unless $TOOLREF->getExitStatus()==0;
#################### END of MAIN #####################################
