/*
 * $Header: gsdsy.h,v 1.2 97/03/10 17:33:49 skjain: Exp $ 
 */


/* Copyright (c) 1987 by Oracle Corporation */
 
/* NAME
     gsdsy.h
   FUNCTION
     Header file for cyptographic functions.
   NOTES
     Uses DES.  Currently these routines are only used for password
     encrypting.  See lpwe.c.
   MODIFIED
    dmatic     06/09/94 -  Creation 
    troberts   08/24/92 -  missing CONST on dsyhtl 
    esedlar    09/05/91 -  Creation 
    Baldwin    11/01/87 - CREATION.
*/

#ifndef GSDSY_H
#define GSDSY_H

/* PUBLIC CONSTANTS */
#define	DSYKSL	(2*16)		/* Number of ub4s in key schedule. */

/* PUBLIC FUNCTIONS */

/* Compute checksum of buffer using cipher block chaining.
 * bufl must be a multiple of two.
 * ichksum is the starting value for the checksum.  For example,
 * it could be the result of checksumming the previous block.
 * ochksum is the result from this block including ichksum.
 */
void	dsychk(/*_ ub4 *ks, ub4 *buf, word bufl,
		   ub4 *ichksum, ub4 *ochksum _*/);


/* Electronic code book.
 * It's ok for in = out.
 */
void	dsyecb(/*_ ub4 *ks, ub4 *in, ub4 *out _*/);


/* Generate key schedule.
 * If encrypt is false generate key schedule for decryption.
 * For DES the only difference between encryption and decryption
 * is the order in which keys are passed to the 16 rounds.
 */
void	dsygks(/*_ ub4 *key, ub4 *ks, bool encrypt _*/);


/* Convert 16 char hex string (null terminated) to two ub4s.
 */
void	dsyhtl(/*_ CONST text *hex, ub4 *out _*/);


/* Convert two ub4s to 16 char hex string (null terminated).
 */
void	dsylth(/*_ ub4 *in, text *hex _*/);



/* PRIVATE FUNCTIONS. */

/* Convert two ub4s to bytes, one bit per byte.
 */
void	dsyltb(/*_ ub4 *in, ub1 *out _*/);


/* Convert bytes, one bit per byte, to two ub4s.
 */
void	dsybtl(/*_ ub1 *in, ub4 *out _*/);


/* Do split of 64 bits into two 32 bit reps.
 */
void	dsydlr(/*_ ub1 *in, ub1 *left, ub1 *right _*/);


/* Undo split of 64 bits into two 32 bit reps.
 */
void	dsyulr(/*_ ub1 *left, ub1 *right, ub1 *out _*/);


/* Swap two 32 bit values.
 */
void	dsyswp(/*_ ub1 *x, ub1 *y _*/);


/* XOR n bits.  z = x xor y.
 */
void	dsyxor(/*_ word n, ub1 *x, ub1 *y, ub1 *z _*/);


/* Rotate 28 bit value by 1 bit position.
 */
void	dsyrot(/*_ ub1 *value _*/);


/* Print n bits of value.
 */
void	dsypbv(/*_ word n, ub1 *value _*/);


/* Do IP
 */
void	dsydip(/*_ ub1 *in, ub1 *out _*/);


/* Undo IP
 */
void	dsyuip(/*_ ub1 *in, ub1 *out _*/);


/* Do E expansion.
 */
void	dsyde(/*_ ub1 *in, ub1 *out _*/);


/* Do S-box lookup.
 */
void	dsydsb(/*_ ub1 *in, ub1 *out _*/);


/* Lookup for single S-box.
 */
void	dsysbl(/*_ word box, ub1 *in, ub1 *out _*/);


/* Do P permutation.
 */
void	dsydp(/*_ ub1 *in, ub1 *out _*/);


/* Do PC1 for C
 */
void	dsyc1c(/*_ ub1 *in, ub1 *out _*/);


/* Do PC1 for D
 */
void	dsyc1d(/*_ ub1 *in, ub1 *out _*/);


/* Do PC2 for C
 */
void	dsyc2c(/*_ ub1 *in, ub1 *out _*/);


/* Do PC2 for D
 */
void	dsyc2d(/*_ ub1 *in, ub1 *out _*/);

/*
   the following two function's definition is nowhere to be found
   neither has it been invoked anywhere.  That's why, commenting
   it out in order to take care of Olint errors.
*/
#ifdef NEVER
ub4 gsddes(/*_ gsdsi * context,  text *in, size_t size, text *out, size_t *outsize,
                bool encrypt _*/);
#endif

#endif /* GSDSY_H */
