/*
 * $Header: oaxm.h,v 2.12 97/10/29 14:36:09 clcooper: Stab $
 */

/* copyright (c) 1994, 1990 by the Oracle Corporation */

/*
NAME
   OAXM.H - Library ConteXt management
CONSTANTS
   OAXM<abc> - The various client subsystem id's
TYPEDEFS
   oaxmctx - global (meta-) ConTeXt
   oaxmitm - individual context ITeM tracked (PRIVATE)
STRUCTURES
   oaxmctx - global (meta-) ConTeXt (PRIVATE)
   oaxmitm - individual context ITeM tracked (PRIVATE)
PROTOTYPES
   oaxmini - INItialize
   oaxmsin - Set INcrement value for dynamic expansion of itm array
   oaxmcls - CLoSe-down
   oaxmalc - ALloCate a subsystem context area
   oaxmins - INSert a subsystem context area
   oaxmfre - FREe a subsystem context area
   oaxmrem - REMove a subsystem context area
   oaxmlsc - Lookup Subsystem Context
NOTES
   General description of OAXM here.
OWNER
   M.C. Fine
DATE
   10/19/90
MODIFIED      (MM/DD/YY)
    clcooper   10/29/97 -  change name for OCCS compliance 
    clcooper   10/22/97 -  add constant for groupware monitoring context 
    ewinner    03/18/97 -  add oaxmoauterr context 
    ewinner    10/07/96 -  core3 upgrade 
    dwoods     03/09/95 -  remove sx.h 
    dwoods     03/08/95 -  include sx.h instead of s.h 
    dfrazier   08/25/94 -  add contexts
    hyu        08/23/94 -  Add oaps context.
    bgustafs   08/09/94 -  add OAXMOAPR
    rlin       06/23/94 -  add OAXMRPC
    mhaselti   06/10/94 -  Add OAXMOADDVC, Remove OAXMOADDVD and OAXMOADDVF
    strabosh   02/03/94 -  add context for disconnected operations
    jliang     12/29/93 -  Add constants for field manager
    jliang     12/20/93 -  add OAXMOALI
    nakumar    05/11/93 -  Add constant OAXMOAPL (on Steve's behalf).
    dfrazier   04/22/93 -  add ODU context
    dfrazier   04/20/93 -  add DRUID contexts (officially)
    fnazem     03/01/93 -  add oa find file context
    akumaran   01/21/93 -  Added DMUL Subsystem bit
    ssiva      01/11/93 -  remove DM log context
    ssiva      01/08/93 -  add DM logging utility context
    mklein     12/08/92 -  add LDT context
    mklein     08/19/92 -  remove OAXMHST, add OAXMTST
    mklein     07/24/92 -  add some more global contexts
    mfine      06/08/92 -  Add OAXMDMW for DocMgr Front End
    fnazem     05/26/92 -  added OAXMRC
    gkellner   04/16/92 -  remove lcx.h
    dfrazier   04/15/92 -  temporarily add lcx.h include
    mfine      03/16/92 -  lcx -> oaxm
    mklein     03/03/92 -  add new context field
    pdixon     02/28/92 -  coauthor subsystem id
    gkellner   10/16/91 -  added Mail Server and alarm server
    gkellner   09/05/91 -  added command line arg
    strabosh   07/15/91 -  added OAMM and OAMR
    strabosh   04/18/91 -  added OAMH
    fnazem     04/17/91 -  use the soa memory routines.
    mfine      10/19/90 -  Creation
*/

#ifndef OAXM
#define OAXM


#ifndef S
# include <s.h>
#endif

/*
** Constants
*/



/*
** The various client subsystem id's
**
** As subsystems are created/introduced, they must receive a
** subsystem id in this list.
*/
#define OAXMZERO     0       /* Zero (0) is reserved!  Do not use!      */
#define OAXMABC      1       /* One  (1) for testing!  Do not use!      */
#define OAXMRM       2       /* Two  (2) for testing!  Do not use!      */
#define OAXMTK       3       /* Subsystem ID for ToolKit                */
#define OAXMOAT      4       /* OA Trace Facility                       */
#define OAXMNLS      5       /* National Language System                */
#define OAXMERR      6       /* Error Handling Package                  */
#define OAXMCAL      7       /* Calendar UI                             */
#define OAXMDAT      8       /* Oracle Date Context                     */
#define OAXMMUI      9       /* Mail User Interface                     */
#define OAXMOA      10       /* Office Automation Context               */
#define OAXMOAMH    11       /* OA Message Handler (LMS)                */
#define OAXMOAMM    12       /* OA Memory Manager                       */
#define OAXMOAMR    13       /* OA Record Manager                       */
#define OAXMOACM    14       /* OA Cursor Manager                       */
#define OAXMOMD     15       /* OMail Daemon                            */
#define OAXMDCC     16       /* Disconnectable Client Context           */
#define OAXMTOADS   17       /* The OA DS                               */
#define OAXMOADT    18       /* OA DaTe module                          */
#define OAXMDM      19       /* Document Manager                        */

#define OAXMAUI     20       /* Temp: context for alarm UI code         */

#define OAXMCO      21       /* CoAuthor                                */
#define OAXMDMO     22       /* Doc. Mgr. Object layer                  */
#define OAXMRC      23       /* Resource file cache layer               */

#define OAXMDMW     24       /* Doc. Mgr. Front End (W)                 */
#define OAXMDMUT    25       /* DM trace context                        */
#define OAXMDMUP    26       /* DM print context                        */
#define OAXMDMUS    27       /* DM scan context                         */
#define OAXMDMZE    28       /* DM error stack context                  */
#define OAXMDMZR    29       /* DM recovery stack                       */

#define OAXMUAS     30       /* Temp: Mail server (Prob. end up in oacx)*/

#define OAXMDMUE    31       /* DM timer context                        */
#define OAXMDMTST   32       /* DM test context                         */
#define OAXMLDT     33       /* CORE date context (ldt)                 */
#define OAXMDMUL    34       /* DM Utility List context                 */
#define OAXMFFL     35       /* OA Find FiLe context                    */

#define OAXMODUDD   36       /* OD Dialog Dispatcher                    */
#define OAXMODRM    37       /* OD Resource Manager                     */
#define OAXMODUDM   38       /* OD Dialog Manager                       */
#define OAXMOADD    39       /* DRUID                                   */
#define OAXMODU     40       /* ODU context                             */
#define OAXMOAPL    41       /* OAPL context                            */
#define OAXMOALI    42       /* OA Language Inteface                    */
#define OAXMOADDVC  43       /* DRUID Value Context                     */
#define OAXMOAPF    45       /* Programmable Forms (Field Manager)      */
#define OAXMRPC     46       /* RPC context                             */
#define OAXMOAPR    47       /* OA Preferences Context                  */
#define OAXMOAPS    48       /* OA Persistent State Context             */
#define OAXMOAUS    49       /* OAUS Context                            */
#define OAXMGLO     50      /* NLS LXGLO struct */
#define OAXMOAUTERR 51      /* new replacement for the uter stack */
#define OAXMGSAM    52       /* monitoring API context */

#define OAXMCMAR   100       /* Temp: Command line argument structure   */



/*
** Typedefs
*/

typedef struct oaxmctx oaxmctx;


/*
** Prototypes
*/

/*
** OAXMINI - INItialize
**
** Parameters (in):
**
**   numctx - The number of subsystem contexts to make room for initially.
**
** Returns:
**
**   oaxmctx * - The global context area
**
** Notes:
**
**   Allocates the global oaxm context area and returns a pointer to it.
*/
oaxmctx * oaxmini (/*_ eword numctx _*/);


/*
** OAXMSIN - Set INcrement size for dynamic expansion of itm array
**
** Parameters (in):
**
**   oaxmcx - The global context area
**   numctx - The number of subsystem contexts to make room for when
**            it is time to dynamically expand the itm array.
**
** Returns:
**
**   Status code (always 0).
**
** Notes:
**
**   None.
*/
eword oaxmsin (/*_ oaxmctx *oaxmcx, eword numctx _*/);


/*
** OAXMCLS - CLoSe-down
**
** Parameters (in):
**
**   oaxmcx - The global context area
**
** Returns:
**
**   Status code (always 0).
**
** Notes:
**
**   Frees the global context area and does any necessary close-down.
*/
eword  oaxmcls (/*_ oaxmctx *oaxmcx _*/);


/*
** OAXMALC - ALloCate a subsystem context area
**
** Parameters (in):
**
**   oaxmcx     - The global context area pointer
**   ssid       - Subsystem id
**   instance   - Instance number (which subsystem context out of many?)
**   size       - Size of the subsystem context area to allocate
**   oaxmbpoffs - Offset into the subsystem context structure to place
**                a "back pointer" to the global context area.
**
** Returns:
**
**   dvoid *   - The pointer to the newly allocated subsystem context area
**
** Notes:
**
**   Allocates the context area of given size, and records (ssid,
**   instance, ptr) triple in oaxmcx and records back pointer to the
**   global oaxm context in the new context area.
*/
dvoid * oaxmalc (/*_ oaxmctx *oaxmcx,
                     eword ssid, eword instance,
                     size_t size,
                     eword oaxmbpoffs _*/);


/*
** OAXMINS - INSert a subsystem context area
**
** Parameters (in):
**
**   oaxmcx    - The global context area pointer
**   ssid      - Subsystem id
**   instance  - Instance number (which subsystem context out of many?)
**   pointer   - Pointer to the subsystem context area
**
** Returns:
**
**   dvoid *   - The pointer to the newly allocated subsystem context area
**
** Notes:
**
**   Used for registering contexts in oaxm that are already allocated.
**   Returns pointer that was passed in if successful finding an open
**   spot in the OAXM context directory, otherwise returns a null pointer.
**   Does NOT allocate any space and does NOT record the backpointer to
**   oaxmcx.
*/
dvoid * oaxmins (/*_ oaxmctx *oaxmcx,
                     eword ssid, eword instance,
                     dvoid * pointer _*/);


/*
** OAXMFRE - FREe a subsystem context area
**
** Parameters (in):
**
**   oaxmcx  - The global context area pointer
**   ssid     - Subsystem id
**   instance - Instance number (which subsystem context out of many?)
**
** Returns:
**
**   Return code (0 if successful, non-zero if failure)
**
** Notes:
**
**   Frees the subsytem context area (found via the pair (ssid, instance)).
**   Removes the entry from the global context area.
*/
eword oaxmfre (/*_ oaxmctx *oaxmcx, eword ssid, eword instance _*/);


/*
** OAXMREM - REMove a subsystem context area
**
** Parameters (in):
**
**   oaxmcx   - The global context area pointer
**   ssid     - Subsystem id
**   instance - Instance number (which subsystem context out of many?)
**
** Returns:
**
**   Return code (0 if successful, non-zero if failure)
**
** Notes:
**
**   Removes the subsytem context area (found via the pair (ssid, instance)).
**   Removes the entry from the global context area.
*/
eword oaxmrem (/*_ oaxmctx *oaxmcx, eword ssid, eword instance _*/);


/*
** OAXMLSC - Lookup Subsystem Context
**
** Parameters (in):
**
**   oaxmcx   - The global context area pointer
**   ssid     - Subsystem id
**   instance - Instance number (which subsystem context out of many?)
**
** Returns:
**
**   dvoid *  - The subsystem context found
**
** Notes
**   Looks up a subsystem's context pointer from the global context
**   via (ssid, instance) pair.  Returns pointer found.
*/
dvoid * oaxmlsc (/*_ oaxmctx *oaxmcx, eword ssid, eword instance _*/);


/*
** --- Things under this line are PRIVATE ---
*/

typedef struct oaxmitm oaxmitm;
struct oaxmitm
{
    eword     ssid_oaxmitm;
    eword     inst_oaxmitm;
    dvoid   * ptr_oaxmitm;
};


struct oaxmctx
{
   eword       inc_oaxmctx;       /* INCrement size for dynamic expansion */
   oaxmitm   * firstitm_oaxmctx;  /* first of the context ITeMs */
   oaxmitm   * lastitm_oaxmctx;   /* last of the context ITeMs */
};


#endif /* OAXM */
