#!/usr/local/bin/perl
# 
# $Header: disklayout_stage.pl 30-jun-2005.01:09:54 pshroff Exp $
#
# disklayout_stage.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      disklayout_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pshroff     06/30/05 - pshroff_map_shiphome
#    rbhanush    05/24/05 - rbhanush_update_props
#    rbhanush    05/19/05 - Creation
# 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

#Staging directive for disk layout component

main();

sub main()
{
print "Creating kickstart file\n";

#get_oraDirectiveProperty("NAME_Filename");

#root (/) partition information
my $mountPoint = get_oraComponentProperty("NAME_Partitions[0].NAME_MountPoint");
my $diskDeviceName = get_oraComponentProperty("NAME_Partitions[0].NAME_DiskDeviceName");
my $fileSystemType = get_oraComponentProperty("NAME_Partitions[0].NAME_FileSysType");
my $partitionSize = get_oraComponentProperty("NAME_Partitions[0].NAME_PartitionSize");
my $partition_entry;
if($diskDeviceName eq "")
{
	$partition_entry="part $mountPoint --fstype $fileSystemType --size $partitionSize\n";
}
else
{
	$partition_entry="part $mountPoint --fstype $fileSystemType --onpart=$diskDeviceName --size $partitionSize\n";
}
appendToKickstart($partition_entry);


#swap partition information
my $mountPoint = get_oraComponentProperty("NAME_Partitions[1].NAME_MountPoint");
my $diskDeviceName = get_oraComponentProperty("NAME_Partitions[1].NAME_DiskDeviceName");
my $fileSystemType = get_oraComponentProperty("NAME_Partitions[1].NAME_FileSysType");
my $partitionSize = get_oraComponentProperty("NAME_Partitions[1].NAME_PartitionSize");
my $partition_entry;
if($diskDeviceName eq "")
{
	$partition_entry="part $mountPoint --size $partitionSize\n";
}
else
{
	$partition_entry="part $mountPoint --onpart=$diskDeviceName --size $partitionSize\n";
}
appendToKickstart($partition_entry);


}

sub appendToKickstart()
{

my ($entry)=@_;
print "Writing entry $entry to kickstart file\n";

my $ksfilename="disklayout-kickstart";
open OUT, ">>$ksfilename" or die "Can find kickstart file" ;

print OUT $entry;

close OUT;
}

sub getKickstart()
{
my $ksfilename="/root/rishi/image-kickstart";
return $ksfilename;
}
