Rem  Copyright (c) Oracle Corporation 1999 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      reset_image_prefix
Rem
Rem    DESCRIPTION
Rem      Reset the image prefix used in an Application Express installation
Rem
Rem    NOTES
Rem
Rem      - This utility should be run via SQL*Plus and connected as SYS.
Rem      - This utility will also recompile the entire Application Express schema
Rem
Rem      - This utility should not be run on an active Application Express instance.
Rem        If need be, the database should be started in RESTRICT mode.
Rem
Rem    Arguments:
Rem      None - The user will be prompted for the updated image prefix
Rem
Rem    MODIFIED    (MM/DD/YYYY)
Rem      jkallman   02/27/2007 - Created 
Rem      jkallman   12/04/2007 - Updated with FLOWS_030100
Rem      jkallman   04/14/2008 - Add call to wwv_flow_page_cache_api.purge_all (Bug 6963877)
Rem      jkallman   09/09/2008 - Change FLOWS_030100 references to APEX_030200

set define '&'
set concat on
set concat .
set verify off
set termout on

prompt
prompt
accept IMGPRE CHAR default '/i/' prompt 'Enter the Application Express image prefix [/i/] '

prompt ...Changing Application Express image prefix
select '&IMGPRE' new_image_prefix from dual
/


whenever sqlerror exit

begin
    if nvl(length('&IMGPRE'),0) = 0 then
        raise_application_error(-20001,'Invalid image prefix');
    end if;
end;
/
begin
    if substr('&IMGPRE',length('&IMGPRE'),1) <> '/' then
        raise_application_error(-20001,'Image prefix must end in ''/''');
    end if;
end;
/

alter session set current_schema = APEX_030200;

prompt
prompt ...Recreate APEX global
prompt
declare
    l_stmt varchar2(4000);
begin
    l_stmt := 'create or replace package wwv_flow_image_prefix
is
    g_image_prefix       constant varchar2(255) := ''&IMGPRE'';
end wwv_flow_image_prefix;';

    execute immediate l_stmt;
end;
/



prompt
prompt ...Update image prefix for all internal Application Express applications
prompt
begin
    wwv_flow_security.g_security_group_id := 10;
    --
    update wwv_flows
       set flow_image_prefix = '&IMGPRE'
     where id between 4000 and 5000
       and security_group_id = 10;
    commit;
end;
/

prompt
prompt ...Purge all cached region and page entries
prompt
begin
    wwv_flow_page_cache_api.purge_all;
    commit;
end;
/



prompt
prompt ...Recompiling the Application Express schema
prompt
begin
    dbms_utility.compile_schema(schema => 'APEX_030200', compile_all => FALSE);
end;
/


prompt 
prompt Image Prefix update complete
prompt

exit;
