//	Copyright (c) Oracle Corporation 2006.	All rights reserved.
//
//
//NAME
//	    opctrnm.h - File giving counter offsets for Oracle
//DESCRIPTION
//	Offset definition file for extensible counter objects and counters
//
//RELATED DOCUMENTS
//
//
//NOTES
//
//	These "relative" offsets must start at 0 and be multiples of 2 (i.e.
//	even numbers). In the Open Procedure, they will be added to the
//	"First Counter" and "First Help" values for the device they belong to, 
//	in order to determine the absolute location of the counter and
//	object names and corresponding Explain text in the registry.
//
//	This file is used by the extensible counter DLL code as well as the
//	counter name and Explain text definition file (.INI) file that is used
//	by LODCTR to load the names into the registry.
//
//
//MODIFIED
//	name	  MM/DD/YY : explanation
//
//  	sthachap  11/17/06 : Update for 11g
//	psciarra  10/11/95 : release
//	rsubbaro  07/01/95 : Creation
//
//
//
//
//*****************************************************************************

// ORA11_DATAFILE_OBJ - reserves 0 - 9
#define ORA11_DATAFILE_OBJ 0
#define ORA11_DATAFILE_OBJ_PHYSICAL_READ 2
#define ORA11_DATAFILE_OBJ_PHYSICAL_WRITE 4

// ORA11_SORTS_OBJ - reserves 10-19
#define ORA11_SORTS_OBJ 10
#define ORA11_SORTS_OBJ_MEMORY 12
#define ORA11_SORTS_OBJ_DISK 14

// ORA11_DYNAMIC_SPACE_MANAGEMENT_OBJ - reserves 20-29
#define ORA11_SPACE_OBJ 20
#define ORA11_SPACE_OBJ_RECURSIVE 22

// ORA11_LIBRARY_CACHE_OBJ - reserves 30-39
#define ORA11_LIBRARY_OBJ 30
#define ORA11_LIBRARY_OBJ_RELOADS 32
#define ORA11_LIBRARY_OBJ_PINS 34

// ORA11_DICTIONARY_CACHE_OBJ  - reserves 40-49
#define ORA11_DICTIONARY_OBJ 40
#define ORA11_DICTIONARY_OBJ_GETMISSES 42
#define ORA11_DICTIONARY_OBJ_GETS 44

// ORA11_FREELIST_CACHE_OBJ - reserves 50-59
#define ORA11_FREELIST_OBJ 50
#define ORA11_FREELIST_OBJ_WAITS 52
#define ORA11_FREELIST_OBJ_REQUESTS 54

// ORA11_DBWR1_OBJ - reserves 60 - 69
#define ORA11_DBWR1_OBJ 60
#define ORA11_DBWR1_OBJ_BUFFERS_SCANNED 62
#define ORA11_DBWR1_OBJ_LRU_SCANS 64

// ORA11_DBWR2_OBJ - reserves 70 - 79
#define ORA11_DBWR2_OBJ 70
#define ORA11_DBWR2_OBJ_TIMEOUTS 72
#define ORA11_DBWR2_OBJ_CHECKPOINTS 74

// ORA11_BUFFER_OBJ - reserves 80 - 89
#define ORA11_BUFFER_OBJ 80
#define ORA11_BUFFER_OBJ_PHYREADS 82
#define ORA11_BUFFER_OBJ_GETS 84

// ORA11_REDO1_OBJ - reserves 90-99
#define ORA11_REDO1_OBJ 90
#define ORA11_REDO1_OBJ_REQUESTS 92

//*****************************************************************************
// THE END OF FILE							
//*****************************************************************************
