<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <!--
    <xsl:include href="../xplan/xplHtml.xsl"/>
   -->
<xsl:template match="/">
 <html>
 <head>
 <title> SQL Plan Diff Report </title>
  <style type="text/css">
    body, table, input, select, textarea
    {font:normal normal 8pt Verdana,Arial;text-decoration:none;color:#000000;}
    .s8 {font-size:8pt;color:#006699}
    .s9 {font-size:10pt;color:#006699}
    .s10 {font-size:14pt;color:#006699;}
    .s16 {border-width : 1px; border-color : #CCCC99;
            border-style: solid;color:#006699;font-size:8pt;}
    .s17 {border-width : 1px; border-color : #CCCC99;
           border-style: solid;font-size:8pt;}
    .s27 {border-width : 1px; border-color : #CCCC99; border-style: solid;}
 
    <!--
      A { text-decoration:none }
    -->
   </style>
 </head>
 <body>
  <xsl:apply-templates select="report/head"/>
  <xsl:apply-templates select="report/body"/>
 </body>
 </html>
</xsl:template>

<xsl:template name="left-pad">
<xsl:param name="n"/>
<xsl:if test="$n != 0">
  <xsl:text>.</xsl:text> 
  <xsl:call-template name="left-pad">
    <xsl:with-param name="n" select="$n - 1"/>
  </xsl:call-template>
</xsl:if>
</xsl:template>

<!-- +++++++++++++++++++++++++++ plan +++++++++++++++++++++++++++++++++++  -->
<xsl:template match="plan">
   <!-- metadata about the plan -->
   <table border="0">
     <xsl:if test="./@id"> 
     <tr> 
        <th align="left">Plan Id</th>
        <td>: <xsl:value-of select="./@id"/></td>
     </tr>
     </xsl:if>

     <tr>
       <th align="left">Plan Hash Value </th>
       <xsl:choose>
         <xsl:when test="./@hash"> 
           <td>: <xsl:value-of select="./@hash"/></td>
         </xsl:when>
         <xsl:otherwise>
           <td>: 
           <xsl:value-of 
            select="operation[@id=1]/other_xml/info[@type='plan_hash']"/>
           </td>
         </xsl:otherwise>
       </xsl:choose>
     </tr>
   </table>

   <br/>
   <!-- display plan lines -->
   <table bordercolor="#000000" ora_borderstyle="headeronly">
     <tr>
       <th align="left" bgcolor="#CCCC99" class="s16">Id</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Operation</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Name</th>
       <!--
       <th align="left" bgcolor="#CCCC99" class="s16">Rows</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Bytes</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Cost</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Time</th>
       -->
     </tr>
     <xsl:for-each select="operation">
       <xsl:apply-templates select="."/>   
     </xsl:for-each>
   </table>      

   <!-- predicates information section -->
   <xsl:if test="operation/predicates"> 
    
     <br/>Predicate Information (identified by operation id):
     <hr size="1" width="290" align="left"/>
     <ul>   
     <xsl:for-each select="operation/predicates">
       <li>
         <xsl:value-of select="../@id"/> - 
         <xsl:value-of select="@type"/>(<xsl:value-of select="."/>)
       </li>
     </xsl:for-each>
     </ul>

   </xsl:if>

   <!-- note information section  -->
   <xsl:if test="(operation[@id=1]/other_xml/info/@type='dynamic_sampling') or
                 (operation[@id=1]/other_xml/info/@type='sql_profile') or 
                 (operation[@id=1]/other_xml/info/@type='baseline') or 
                 (operation[@id=1]/other_xml/info/@type='sql_patch')"> 
     <br/>Note
     <hr size="1" width="30" align="left"/>
     
     <!-- dynamic sampling -->
     <xsl:if test="(operation[@id=1]/other_xml/info/@type='dynamic_sampling')">
       - dynamic sampling used for this statement
     </xsl:if>

     <!-- profile information -->
     <xsl:if test="(operation[@id=1]/other_xml/info/@type='sql_profile')"> 
       - SQL profile 
         <xsl:value-of 
          select="operation[@id=1]/other_xml/info[@type='sql_profile']"/>
         used for this statement
     </xsl:if>

     <!-- plan baseline information -->
     <xsl:if test="(operation[@id=1]/other_xml/info/@type='baseline')"> 
       - SQL plan baseline 
         <xsl:value-of 
          select="operation[@id=1]/other_xml/info[@type='baseline']"/>
         used for this statement
     </xsl:if>

     <!-- sql patch information -->
     <xsl:if test="(operation[@id=1]/other_xml/info/@type='sql_patch')"> 
       - SQL patch
         <xsl:value-of 
          select="operation[@id=1]/other_xml/info[@type='sql_patch']"/>
         used for this statement
     </xsl:if>
     <br/>
   </xsl:if>
</xsl:template>


<!-- +++++++++++++++++++++++++++ plan line  +++++++++++++++++++++++++++++  -->
<xsl:template match="operation">
  <tr bgcolor="#F7F777" valign="bottom">
    <td class="s27" align="right">
      <!-- check predicates -->
      <xsl:if test="predicates"> * </xsl:if>     
      <xsl:value-of select="./@id"/>
    </td>
    <td class="s27" ora_space_char=".">          
       <!-- indent operation using depth if needed -->               
       <xsl:if test="./@depth &gt; 0">
         <font color="#F7F777">
           <xsl:call-template name="left-pad">
             <xsl:with-param name="n" select="./@depth"/>
           </xsl:call-template>
         </font> 
       </xsl:if>
       <!-- display operation name and options --> 
       <xsl:value-of select="./@name"/> 
       <xsl:text>&#160;</xsl:text>  
       <xsl:value-of select="./@options"/>
    </td>
    <td class="s27"> 
       <a>
         <xsl:attribute name="href">
           #<xsl:value-of select="substring-after(./object_alias, '@')"/>
         </xsl:attribute> 
         <xsl:value-of select="object"/> 
       </a>
    </td>
    <!--
    <td class="s27" align="right"> <xsl:value-of select="card"/> </td>
    <td class="s27" align="right"> <xsl:value-of select="bytes"/> </td>
    <td class="s27" align="right"> <xsl:value-of select="cost"/> </td>
    <td class="s27" align="right"> <xsl:value-of select="time"/> </td>
    -->
  </tr>
</xsl:template>

<!-- +++++++++++++++++++++++++++ report header ++++++++++++++++++++++++++  -->
<xsl:template match="head">
  <a name="general"/>
  <a href="#general" style="text-decoration:none">
    <font class="s10"> General Information </font>
  </a>
  <hr size="3" width="650" align="left"/>
  <br/>
  <xsl:apply-templates select="task"/>
</xsl:template>


<!-- ++++++++++++++++++++++++++ task information ++++++++++++++++++++++++++ -->
<xsl:template match="task">

   <table class="ex" cellspacing="0" border="0">
     <tr>
       <td>
         <font class="s9"><b>Task Information:</b></font>
         <hr size="1" width="312" align="left"/>
       </td>
       <td>
         <font class="s9"><b>Workload Information:</b></font>
         <hr size="1" width="315" align="left"/>
       </td>
     </tr>

     <tr align="left" valign="top"> 
       <td>   
         <table class="ex" cellspacing="0" border="0">
          <tr><th align="left">Task Name</th>
           <td>: <xsl:value-of select="property[@name='name']"/></td></tr>
         <tr><th align="left">Task Owner</th>
          <td>: <xsl:value-of select="property[@name='owner']"/></td></tr>
         <tr><th align="left">Description</th>
          <td>: <xsl:value-of select="property[@name='desc']"/></td></tr>
         </table>
       </td> 
       <td>   
         <xsl:apply-templates select="../sqlset"/>
       </td> 
     </tr>

   </table>
   
   <!-- display current execution information -->
   <!--
   <br/>
   <font class="s9"><b>Execution Information:</b></font>
   <hr size="1" width="650" align="left"/>
   <table class="ex" cellspacing="0" border="0">
     <tr>
      <td>
      <table class="ex" cellspacing="0" border="0">
       <tr>
        <th align="left">Execution Name</th>
        <td>: 
         <xsl:value-of select=
              "execution[@label='current']/property[@name='name']"/>
        </td>
       </tr>
       <tr>
        <th align="left">Execution Type</th>
        <td>: 
         <xsl:value-of select=
              "execution[@label='current']/property[@name='type']"/>
         </td></tr>
       <tr>
        <th align="left">Description</th>
        <td>: 
         <xsl:value-of select=
              "execution[@label='current']/property[@name='desc']"/>
        </td>
       </tr>
       <tr>
        <th align="left">Scope</th>
        <td>: 
         <xsl:value-of select=
              "execution[@label='current']/property[@name='mode']"/>
        </td>
       </tr>
       <tr>
        <th align="left">Status</th>
        <td>: 
         <xsl:value-of select=
              "execution[@label='current']/property[@name='status']"/>
        </td>
       </tr>
      </table>
      </td>

      <td>
      <table class="ex" cellspacing="0" border="0">
       <tr>
        <th align="left">Started </th>
        <td>: 
         <xsl:value-of select=
              "execution[@label='current']/property[@name='start']"/>
        </td>
       </tr>
       <tr><th align="left">Last Updated </th>
         <td>: 
          <xsl:value-of select=
               "execution[@label='current']/property[@name='modif']"/>
         </td>
       </tr>
       <tr>
         <th align="left">Global Time Limit</th>
         <td>: 
          <xsl:value-of select=
               "execution[@label='current']/property[@name='time_limit']"/>
         </td>
       </tr>
       <tr>
         <th align="left">Per-SQL Time Limit</th>
         <td>: 
           <xsl:value-of select=
             "execution[@label='current']/property[@name='local_time_limit']"/>
         </td>
       </tr>
       <tr>
         <th align="left">Number of Errors</th>
         <td>: 
          <xsl:value-of select=
               "execution[@label='current']/property[@name='err_count']"/>
         </td>
       </tr>
       </table>
       </td> 
     </tr> 
   </table>
   -->
</xsl:template>



<!-- +++++++++++++++++++++++++ template execution +++++++++++++++++++++++++ -->
<xsl:template match="execution">
   <!-- common execution information -->
   <table class="ex" cellspacing="0" border="0">
     <tr><th align="left">Execution Name</th>
     <td>: <xsl:value-of select="./property[@name='name']"/></td></tr>
     <tr><th align="left">Execution Type</th>
       <td>: 
         <xsl:value-of select="./property[@name='type']"/>
         <xsl:if test="(./property[@name='dblink'])"> 
           REMOTE
         </xsl:if>         
       </td>
     </tr>
     <xsl:if test="(./property[@name='dblink'])"> 
       <tr><th align="left">Database Link</th>
       <td>: <xsl:value-of select="./property[@name='dblink']"/></td></tr>
     </xsl:if>         
     <xsl:if test="(./property[@name='desc'])"> 
       <tr><th align="left">Description</th>
       <td>: <xsl:value-of select="./property[@name='desc']"/></td></tr>
     </xsl:if>         
     <tr><th align="left">Scope</th>
     <td>: <xsl:value-of select="./property[@name='mode']"/></td></tr>
     <tr><th align="left">Status</th>
     <td>: <xsl:value-of select="./property[@name='status']"/></td></tr>
     <tr><th align="left">Started </th>
     <td>: <xsl:value-of select="./property[@name='start']"/></td></tr>
     <tr><th align="left">Last Updated </th>
     <td>: <xsl:value-of select="./property[@name='modif']"/></td></tr>
     <tr><th align="left">Global Time Limit</th>
     <td>: <xsl:value-of select="./property[@name='time_limit']"/></td></tr>
     <tr><th align="left">Per-SQL Time Limit</th>
     <td>: <xsl:value-of select="./property[@name='local_time_limit']"/></td>
     </tr>
     <tr><th align="left">Number of Errors</th>
     <td>: <xsl:value-of select="./property[@name='err_count']"/></td>
     </tr>
   </table>
</xsl:template>

<!-- ++++++++++++++++++++++++++ sts information ++++++++++++++++++++++++++ -->
<xsl:template match="sqlset">
   <table class="ex" cellspacing="0" border="0">
     <tr><th align="left">SQL Tuning Set Name</th>
           <td>: <xsl:value-of select="property[@name='name']"/></td></tr>
     <tr><th align="left">SQL Tuning Set Owner</th>
           <td>: <xsl:value-of select="property[@name='owner']"/></td></tr>
     <tr><th align="left">Total SQL Statement Count</th>
           <td>: <xsl:value-of select="property[@name='sql_count']"/></td></tr>
   </table>
</xsl:template>


<!-- ++++++++++++++++++++++++++ report body ++++++++++++++++++++++++++ -->
<xsl:template match="body">
  <a name="details"/>
  <a href="#details" style="text-decoration:none">
    <font class="s10"><br/>
       Report Details: 
    </font>
    <font class="s9">
      <b>
        SQL Plan Comparison
      </b>
    </font>
  </a>
  <!--
  <xsl:apply-templates select="objects_qbreg" mode="summary"/>
  -->
  <xsl:apply-templates select="objects_qbreg_sum"/>
  <xsl:apply-templates select="objects_jo"/>
  <xsl:apply-templates select="objects_jm"/>
  <xsl:apply-templates select=".//plan"/>
  <xsl:apply-templates select="objects" mode="compiler repository"/>
  <!--
  <xsl:apply-templates select="objects" mode="fix control"/>
  -->
  <xsl:apply-templates select="objects_qbreg" mode="details"/>
</xsl:template>


<!-- ++++++++++++++++++++++++++++ SQL errors +++++++++++++++++++++++++++++ -->
<xsl:template match="error">
 <br/>
 <font class="s8"><b> Errors: </b></font>
 <hr size="1" width="100" align="left"/>
 <table border="0" ora_widthc="80">
 <tr>
    <td>
      <ol>
         <li><xsl:value-of select="."/></li>
      </ol>
    </td>
 </tr>
 </table>
</xsl:template>


<!-- ++++++++++++++++++++++++++++ QB Diff Summary ++++++++++++++++++++++++ -->
<xsl:template match="objects_qbreg_sum">
  <h4>Query Block Diff</h4>
  <table border="1" ora_borderstyle="headeronly">
     <tr>
       <th bgcolor="#CCCC99" class="s16">Query Block</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan 1</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan 2</th>
       <th bgcolor="#CCCC99" class="s16">Diff</th>
     </tr>

  <xsl:for-each select="item">
   <xsl:if test="./@type='qbreg'">
     <tr>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' and 
                 (./@difflvl &gt; 1)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <!-- indent operation using depth if needed -->
         <xsl:if test="./@difflvl &gt; 0">
           <font color="#F7F777">
             <xsl:call-template name="left-pad">
               <xsl:with-param name="n" select="./@difflvl"/>
             </xsl:call-template>
           </font>
         </xsl:if>
         <xsl:choose>
           <xsl:when test=". = '*' and 
                (./@difflvl &gt; 1)">
             <font color="white">
               <xsl:value-of select="./@qbc"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@qbc"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' 
                 and (./@difflvl &gt; 1)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
           <xsl:when test=". = '*' and 
               (./@difflvl &gt; 1)">
             <font color="white">
               <xsl:value-of select="./@final1"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@final1"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' and 
                 (./@difflvl &gt; 1)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
        <xsl:choose>
           <xsl:when test=". = '*' and 
                (./@difflvl &gt; 1)">
             <font color="white">
               <xsl:value-of select="./@final2"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@final2"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' and 
                 (./@difflvl &gt; 1)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <!-- indent operation using depth if needed -->
         <xsl:if test="./@difflvl &gt; 0">
           <font color="#F7F777">
             <xsl:call-template name="left-pad">
               <xsl:with-param name="n" select="./@difflvl"/>
             </xsl:call-template>
           </font>
         </xsl:if>
         <a>
           <xsl:attribute name="href">
             #<xsl:value-of select="./@qbc"/>
           </xsl:attribute>
           <xsl:choose>
             <xsl:when test=". = '*' and 
               (./@difflvl &gt; 1)">
               <font color="white">
                 <xsl:value-of select="./@transformation"/>
               </font>
             </xsl:when>
             <xsl:otherwise>
               <font color="black">
                 <xsl:value-of select="./@transformation"/>
               </font>
             </xsl:otherwise>
           </xsl:choose>
         </a>
       </td>
     </tr>
   </xsl:if>

 </xsl:for-each>
 </table>
 <br/>
</xsl:template>

<!-- ++++++++++++++++++++++++++++ SQL CR +++++++++++++++++++++++++++++++++ -->
<xsl:template match="objects" mode="compiler repository">
  <table border="1" ora_borderstyle="headeronly">
     <tr>
       <th bgcolor="#CCCC99" class="s16">Item</th>
       <th bgcolor="#CCCC99" class="s16">Type</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan #1 </th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan #2 </th>
     </tr>

  <xsl:for-each select="item">
    <!-- Hide construct for now
    <xsl:if test="./@type = 'construct' and ./@difflvl != 'no_diff'">
     <tr>
       <td bgcolor="#CCCC99" class="s17" align="left">
         <xsl:value-of select="."/>
       </td>
       <td bgcolor="#CCCC99" class="s17" align="left">
         <xsl:value-of select="./@type"/>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">white</xsl:when>
             <xsl:otherwise>yellow</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="color">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">black</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:value-of select="./@status1"/>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">white</xsl:when>
             <xsl:otherwise>yellow</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="color">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">black</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:value-of select="./@status2"/>
       </td>
     </tr>
   </xsl:if>
   -->

   <xsl:if test="./@type = 'Feature' and ./@difflvl != 'no_diff'">
     <tr>
       <td class="s17" align="left"><xsl:value-of select="."/></td>
       <td class="s17" align="left">
         <xsl:value-of select="./@p_feature"/>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">white</xsl:when>
             <xsl:otherwise>yellow</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="color">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">black</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:value-of select="./@status1"/>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">white</xsl:when>
             <xsl:otherwise>yellow</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="color">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">black</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:value-of select="./@status2"/>
       </td>
     </tr>
   </xsl:if>

   <xsl:if test="./@type = 'Outline'  and ./@difflvl != 'no_diff'">
     <tr>
       <td class="s17" align="left"><xsl:value-of select="."/></td>
       <td class="s17" align="left">
         <xsl:value-of select="./@type"/>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">white</xsl:when>
             <xsl:otherwise>yellow</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="color">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">black</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:value-of select="./@status1"/>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">white</xsl:when>
             <xsl:otherwise>yellow</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="color">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">black</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:value-of select="./@status2"/>
       </td>
     </tr>
   </xsl:if>
 </xsl:for-each>
 </table>
 <br/>
</xsl:template>

<!-- ++++++++++++++++++++++++++++ Fix Control ++++++++++++++++++++++++++++ -->
<xsl:template match="objects" mode="fix control">
  <table border="1" ora_borderstyle="headeronly">
     <tr>
       <th bgcolor="#CCCC99" class="s16">Bug#</th>
       <th bgcolor="#CCCC99" class="s16">Fix Description</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan #1 </th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan #2 </th>
     </tr>

  <xsl:for-each select="item">
   <xsl:if test="./@type = 'Fix' and ./@difflvl != 'no_diff'">
     <tr>
       <td class="s17" align="left"><xsl:value-of select="."/></td>
       <td class="s17" align="left">
         <xsl:value-of select="./@p_feature"/>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">white</xsl:when>
             <xsl:otherwise>yellow</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="color">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">black</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:value-of select="./@status1"/>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">white</xsl:when>
             <xsl:otherwise>yellow</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="color">
           <xsl:choose>
             <xsl:when test="./@status1=./@status2">black</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:value-of select="./@status2"/>
       </td>
     </tr>
   </xsl:if>
 </xsl:for-each>
 </table>
 <br/>
</xsl:template>


<!-- ++++++++++++++++++++++++++++ Join order ++++++++++++++++++++++++++++ -->
<xsl:template match="objects_jo">
  <h4>Join Order Diff</h4>
  <table border="1" ora_borderstyle="headeronly">
     <tr>
       <th bgcolor="#CCCC99" class="s16">Query Block</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan 1 </th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan 2 </th>
     </tr>

  <xsl:for-each select="item">
   <xsl:if test="./@type = 'join_order' and . = '*'">
     <tr>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*'">red</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <a>
           <xsl:attribute name="href">
             #<xsl:value-of select="./@qbc"/>
           </xsl:attribute>
           <xsl:choose>
             <xsl:when test=". = '*'">
               <font color="white">
                 <xsl:value-of select="./@qbc"/>
               </font>
             </xsl:when>
             <xsl:otherwise>
               <font color="black">
                 <xsl:value-of select="./@qbc"/>
               </font>
             </xsl:otherwise>
           </xsl:choose>
         </a>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*'">red</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
           <xsl:when test=". = '*'">
             <font color="white">
               <xsl:value-of select="./@jo1"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@jo1"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*'">red</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
           <xsl:when test=". = '*'">
             <font color="white">
               <xsl:value-of select="./@jo2"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@jo2"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
     </tr>
   </xsl:if>
 </xsl:for-each>
 </table>
 <br/>
</xsl:template>


<!-- ++++++++++++++++++++++++++++ Join Method ++++++++++++++++++++++++++++ -->
<xsl:template match="objects_jm">
  <h4>Join Method Diff</h4>
  <table border="1" ora_borderstyle="headeronly">
     <tr>
       <th bgcolor="#CCCC99" class="s16">Query Block</th>
       <th bgcolor="#CCCC99" class="s16">Table to Join</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan 1</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan 2</th>
     </tr>

  <xsl:for-each select="item">
   <xsl:if test="./@type = 'join_method'">
     <tr>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*'">red</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <a>
           <xsl:attribute name="href">
             #<xsl:value-of select="./@qbc"/>
           </xsl:attribute>
           <xsl:choose>
             <xsl:when test=". = '*'">
               <font color="white">
                 <xsl:value-of select="./@qbc"/>
               </font>
             </xsl:when>
             <xsl:otherwise>
               <font color="black">
                 <xsl:value-of select="./@qbc"/>
               </font>
             </xsl:otherwise>
           </xsl:choose>
         </a>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*'">red</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
           <xsl:when test=". = '*'">
             <font color="white">
               <xsl:value-of select="./@arg1"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@arg1"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*'">red</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
           <xsl:when test=". = '*'">
             <font color="white">
               <xsl:value-of select="./@jm1"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@jm1"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*'">red</xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
           <xsl:when test=". = '*'">
             <font color="white">
               <xsl:value-of select="./@jm2"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@jm2"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
     </tr>
   </xsl:if>
 </xsl:for-each>
 </table>
 <br/>
</xsl:template>

<!-- ++++++++++++++++++++++++++++ QB Diff details ++++++++++++++++++++++++ -->
<xsl:template match="objects_qbreg" mode="details">
  <table border="1" ora_borderstyle="headeronly">
     <tr>
       <th bgcolor="#CCCC99" class="s16">Diff</th>
       <th bgcolor="#CCCC99" class="s16">Transformation</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan 1</th>
       <th bgcolor="#CCCC99" class="s16">SQL Plan 2</th>
       <th bgcolor="#CCCC99" class="s16">Query block</th>
     </tr>

  <xsl:for-each select="item">
   <xsl:if test="./@type='qbreg'">
     <tr>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' and 
                 (./@difflvl &gt; 1 or ./@final1 = ./@final2)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
           <xsl:when test=". = '*' and 
             (./@difflvl &gt; 1 or ./@final1 = ./@final2)">
             <font color="white">
               <xsl:value-of select="."/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="."/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' and 
                 (./@difflvl &gt; 1 or ./@final1 = ./@final2)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <!-- indent operation using depth if needed -->
         <xsl:if test="./@difflvl &gt; 0">
           <font color="#F7F777">
             <xsl:call-template name="left-pad">
               <xsl:with-param name="n" select="./@difflvl"/>
             </xsl:call-template>
           </font>
         </xsl:if>
         <a>
           <xsl:attribute name="name">
             <xsl:choose>
               <xsl:when test="./@qbc1 = 'NA'">
                 <xsl:value-of select="./@qbc2"/>
               </xsl:when>
               <xsl:otherwise>
                 <xsl:value-of select="./@qbc1"/>                   
               </xsl:otherwise>
             </xsl:choose>
           </xsl:attribute>
           <xsl:choose>
             <xsl:when test=". = '*' and 
               (./@difflvl &gt; 1 or ./@final1 = ./@final2)">
               <font color="white">
                 <xsl:choose>
                   <xsl:when test="./@transform1 = 'NA'">
                     <xsl:value-of select="./@transform2"/>
                   </xsl:when>
                   <xsl:otherwise>
                     <xsl:value-of select="./@transform1"/>                   
                   </xsl:otherwise>
                 </xsl:choose>
               </font>
             </xsl:when>
             <xsl:otherwise>
               <font color="black">
                 <xsl:choose>
                   <xsl:when test="./@transform1 = 'NA'">
                     <xsl:value-of select="./@transform2"/>
                   </xsl:when>
                   <xsl:otherwise>
                     <xsl:value-of select="./@transform1"/>                   
                   </xsl:otherwise>
                 </xsl:choose>
               </font>
             </xsl:otherwise>
           </xsl:choose>
         </a>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' 
                 and (./@difflvl &gt; 1 or ./@final1 = ./@final2)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
           <xsl:when test=". = '*' and 
               (./@difflvl &gt; 1 or ./@final1 = ./@final2)">
             <font color="white">
               <xsl:value-of select="./@final1"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@final1"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' and 
                 (./@difflvl &gt; 1 or ./@final1 = ./@final2)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
        <xsl:choose>
           <xsl:when test=". = '*' and 
                (./@difflvl &gt; 1 or ./@final1 = ./@final2)">
             <font color="white">
               <xsl:value-of select="./@final2"/>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:value-of select="./@final2"/>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
       <td class="s17" align="left">
         <xsl:attribute name="bgcolor">
           <xsl:choose>
             <xsl:when test=". = '*' and 
                 (./@difflvl &gt; 1 or ./@final1 = ./@final2)">red
             </xsl:when>
             <xsl:otherwise>white</xsl:otherwise>
           </xsl:choose>
         </xsl:attribute>
         <!-- indent operation using depth if needed -->
         <xsl:if test="./@difflvl &gt; 0">
           <font color="#F7F777">
             <xsl:call-template name="left-pad">
               <xsl:with-param name="n" select="./@difflvl"/>
             </xsl:call-template>
           </font>
         </xsl:if>
         <xsl:choose>
           <xsl:when test=". = '*' and 
                (./@difflvl &gt; 1 or ./@final1 = ./@final2)">
             <font color="white">
               <xsl:choose>
                 <xsl:when test="./@qbc1 = 'NA'">
                   <xsl:value-of select="./@qbc2"/>
                 </xsl:when>
                 <xsl:otherwise>
                   <xsl:value-of select="./@qbc1"/>                   
                 </xsl:otherwise>
               </xsl:choose>
             </font>
           </xsl:when>
           <xsl:otherwise>
             <font color="black">
               <xsl:choose>
                 <xsl:when test="./@qbc1 = 'NA'">
                   <xsl:value-of select="./@qbc2"/>
                 </xsl:when>
                 <xsl:otherwise>
                   <xsl:value-of select="./@qbc1"/>                   
                 </xsl:otherwise>
               </xsl:choose>
             </font>
           </xsl:otherwise>
         </xsl:choose>
       </td>
     </tr>
   </xsl:if>

 </xsl:for-each>
 </table>
 <br/>
</xsl:template>

</xsl:stylesheet>

