#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/emca/emcaDbUtil.pl /st_emdbsa_11.2/5 2009/05/14 00:45:58 ssanklec Exp $
#
# emcaDbUtil.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emcaDbUtil.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ssanklec    05/12/09 - Bug : 8325548
#    ssanklec    09/19/08 - Bug : 7481372
#    ssanklec    09/19/08 - Bug : 7384292
#    supal       05/10/08 - Bug7030353: Print error msg on connect failure
#    dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
#                           st_emdbsa_11.1
#    ssanklec    04/17/07 - Bug 5005727 : 11G RAC DBCONTROL CONFIGURATION ENHANCEMENT
#    rahgupta    01/27/05 - rahgupta_bug-4017590_main
#    rahgupta    01/23/05 - Creation
# 

# Usage $0 ORACLE_HOME  CONNECT_DESC DB_USER DB_ROLE SQL ORACLE_SID NO_OF_PARAMS_TO_BIND PARAM_NAME. 
# DB_PWD passed in stdin as DB_PWD=dbPwd.
# Params to bind should be passed in stdin as PARAM_NAME=PARAM_VALUE.

use strict;
use Oraperl;
use DBI;
use DBI qw(:sql_types);

require "emd_common.pl";

my @argArray = @ARGV;
print "Arguments passed @argArray \n\n";

if ( scalar ( @argArray ) < 5 )
{
  print "Usage: \n";
  print "$0 ORACLE_HOME ORACLE_SID DB_USER DB_ROLE SQL NO_OF_PARAMS_TO_BIND PARAM_NAME \n";
  print "DB_PWD passed in stdin as DB_PWD=dbPwd \n";
  print "Params to bind should be passed in stdin as PARAM_NAME=PARAM_VALUE \n";
  exit 1;
}

my %stdinArgs = get_stdinvars();

my $oracleHome = $argArray[0];
shift @argArray;
my $oracleConnectDesc = $argArray[0];
shift @argArray;
my $dbUser = $argArray[0];
shift @argArray;
my $dbRole = $argArray[0];
shift @argArray;
my $dbPwd = $stdinArgs{"DB_PWD"};
my $sql = $argArray[0];
shift @argArray;
my $sid = $argArray[0];
shift @argArray;
my $noOfParams = $argArray[0];
shift @argArray;


my $sysUser = quotemeta("SYS");
my $sysDbaRole = quotemeta("SYSDBA");


# If the the role is SYSDBA, user is SYS and PWD is not supplied
# then use OS authentication through bequeath.
# We need to connect using bequeath connection in order to make use of OS authentication.
# hence set the env variable ORACLE_HOME and ORACLE_SID

$ENV{ORACLE_HOME} = $oracleHome;
if ( // =~ quotemeta("$dbPwd") && $dbRole =~ /\b$sysDbaRole\b/i && $dbUser =~ /\b$sysUser\b/i )
{
  $dbUser = "";
  $ENV{ORACLE_SID} = $sid;
  print ( "Connecting to database using sid $sid in home $oracleHome with user \"$dbUser\" role \"$dbRole\". \n" );
}
else
{
  $ENV{TWO_TASK} = $oracleConnectDesc;
  #Required for Windows
  $ENV{LOCAL}  = $oracleConnectDesc;
  $ENV{REMOTE} = $oracleConnectDesc;
  print ( "Connecting to database using connect string $oracleConnectDesc in home $oracleHome with user \"$dbUser\" role \"$dbRole\". \n" );
}

# We need to connect as SYS user using SYSDBA logon.
my $mode = 0;
if ( $dbRole =~ /SYSDBA/i )
{
  $mode = 2;
}

my $lda;
#DBI->trace ( 4, 'dbiTrace.log' );
$lda = DBI->connect('dbi:Oracle:', "$dbUser", "$dbPwd",
                            {ora_session_mode => $mode,
                             PrintError => 0,
                             RaiseError => 0}) or die "Couldn't connect to the db - " . DBI->errstr;
print "connected to database. \n";
print "sql to execute $sql \n";

my $sth = $lda->prepare($sql) or die "Couldn't prepare statement: " . $lda->errstr;

my $cntr = 0;
my $name;
my $value;

print ( "noOfParams to bind: $noOfParams. \n" );
for ( $cntr = 1 ; $cntr <= $noOfParams ; ++$cntr )
{
  $name  = $argArray[0];
  shift @argArray;
  $value = $stdinArgs { $name };

  $sth->bind_param ( $cntr, $value );
}

$sth->execute () or die "Couldn't execute statement: " . $sth->errstr;
$sth->finish ();

print "sql execute successfully. \n";

$lda->disconnect ();

exit 0;

