@echo off
REM ###########################################################################
REM #
REM # $Header: EMDeploy.bat.template 15-dec-2005.21:25:45 tthakur Exp $
REM #
REM # Copyright (c) 2004, Oracle Corporation.  All rights reserved.
REM #
REM # PRODUCT
REM #       Oracle Enterprise Manager for 10.2
REM #
REM # FILENAME
REM #       EMDeploy.bat.template
REM #
REM # DESCRIPTION
REM #		Wrapper script for emdeploy.pl
REM #
REM # NOTES
REM # 
REM # MODIFIED   (MM/DD/YY)
REM #    tthakur   12/14/05 - XbranchMerge tthakur_bug-4885497 from main 
REM #    tthakur   12/14/05 - bug-4885497
REM #    tthakur   05/26/05 - ORACLE_HOME fix 
REM #    tthakur   03/17/05 - call commonenv 
REM #    tthakur   12/03/04 - emdeploy path change 
REM #    ktlaw     11/30/04 - ktlaw_emdeploy_ci_scripts
REM #    ktlaw     11/10/04 - make template 
REM #    ktlaw     11/09/04 - ktlaw_ci_emdeploy_scripts
REM #    tthakur   10/27/04 - Created
REM ################################################################################
REM #
setlocal

:while 
	if (%1)==() goto done
    if %1 equ -oracle_home (
    	set ORACLE_HOME=%~2
       	shift
    )
    shift
    goto while
:done

if not defined ORACLE_HOME (
	set ORACLE_HOME=%ORACLE_HOME%
)

if not defined ORACLE_HOME (
   echo Please set ORACLE_HOME environment variable.
   goto :EOF
)

set EMDW_HOME=%ORACLE_HOME%

REM # source commonenv to set common variables
call %EMDW_HOME%\bin\commonenv

set PERL5LIB=%ORACLE_HOME%\%EMPERLOHBIN%;%ORACLE_HOME%\perl\lib;%ORACLE_HOME%\perl\lib\site_perl;%ORACLE_HOME%\perl\site\lib;%ORACLE_HOME%\sysman\admin\scripts;%ORACLE_HOME%\sysman\install;%ORACLE_HOME%\bin;%PERL5LIB%

set PATH=%ORACLE_HOME%\%EMPERLOHBIN%;%ORACLE_HOME%\bin;%PATH%

perl %ORACLE_HOME%\sysman\install\emdeploy.pl %*

endlocal

REM Windows batch files need to use "exit" for the caller program to reap 
REM the exit code. Otherwise the caller always gets '0' as the exit code.
REM When invoked from command-line exit forces the cmd window to close.
REM Protecting it with a variable defintion
if defined NEED_EXIT_CODE exit %errorlevel%

