REM drv: <migrate type="data_upgrade" version="11.2.0.0" pos="-" condition="EM_REPOS_MODE=SYSAUX"/>
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/pp_db/11.2.0.0/patchadvisor/pa_data_upgrade.sql /st_emdbsa_11.2/3 2009/04/03 19:41:53 vsubrahm Exp $
Rem
Rem pa_data_upgrade.sql
Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      pa_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vsubrahm    03/26/09 - XbranchMerge vsubrahm_bug-8359504 from
Rem                           st_emdbsa_11.2beta2
Rem    vsubrahm    03/24/09 - Call pa_out_of_box.sql as well
Rem    vsubrahm    02/25/09 - Fix name of application for CRS DP
Rem    vsubrahm    11/25/08 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-- executing all post_creation scripts in the same order as specified by the header known at this time.
-- teams should update the following section when adding new post_creation scripts.

@&EM_SQL_ROOT/pp_db/latest/deploymentProcs_sql/db_deploymentProcs.sql
@&EM_SQL_ROOT/pp_db/latest/pa/pa_out_of_box.sql

UPDATE mgmt_paf_procedures
        SET base_guid =
          (SELECT procedure_guid
           FROM mgmt_paf_procedures procs,
              (SELECT name,
               application_name,
               MIN(version) AS
            min_version
             FROM mgmt_paf_procedures
             WHERE application_name = 'PatchOracleDBSoftware'
             AND name = 'PATCH_STANDALONE_ORACLE_DB'
             AND is_oracle = 'Y'
             GROUP BY name,
               application_name)
          min_ver
           WHERE procs.application_name = 'PatchOracleDBSoftware'
           AND procs.name = 'PATCH_STANDALONE_ORACLE_DB'
           AND procs.version = min_ver.min_version
           AND procs.is_oracle = 'Y')
        WHERE application_name = 'PatchOracleDBSoftware'
         AND name = 'PATCH_STANDALONE_ORACLE_DB'
         AND is_oracle = 'Y';

UPDATE mgmt_paf_procedures
        SET base_guid =
          (SELECT procedure_guid
           FROM mgmt_paf_procedures procs,
              (SELECT name,
               application_name,
               MIN(version) AS
            min_version
             FROM mgmt_paf_procedures
             WHERE application_name = 'PatchPrerequisites'
             AND name = 'PATCH_PREREQ_HDR'
             AND is_oracle = 'Y'
             GROUP BY name,
               application_name)
          min_ver
           WHERE procs.application_name = 'PatchPrerequisites'
           AND procs.name = 'PATCH_PREREQ_HDR'
           AND procs.version = min_ver.min_version
           AND procs.is_oracle = 'Y')
        WHERE application_name = 'PatchPrerequisites'
         AND name = 'PATCH_PREREQ_HDR'
         AND is_oracle = 'Y';

UPDATE mgmt_paf_procedures
        SET base_guid =
          (SELECT procedure_guid
           FROM mgmt_paf_procedures procs,
              (SELECT name,
               application_name,
               MIN(version) AS
            min_version
             FROM mgmt_paf_procedures
             WHERE application_name = 'PatchOracleDBSoftware'
             AND name = 'PATCH_RAC_DB_ROLLING'
             AND is_oracle = 'Y'
             GROUP BY name,
               application_name)
          min_ver
             WHERE procs.application_name = 'PatchOracleDBSoftware' 
             AND procs.name = 'PATCH_RAC_DB_ROLLING'
             AND procs.version = min_ver.min_version
             AND procs.is_oracle = 'Y')
        WHERE application_name = 'PatchOracleDBSoftware'
         AND name = 'PATCH_RAC_DB_ROLLING'
         AND is_oracle = 'Y';

UPDATE mgmt_paf_procedures
        SET base_guid =
          (SELECT procedure_guid
           FROM mgmt_paf_procedures procs,
              (SELECT name,
               application_name,
               MIN(version) AS
            min_version
             FROM mgmt_paf_procedures
             WHERE application_name = 'PatchOracleDBSoftware'
             AND name = 'PATCH_RAC_DB_ALL_NODES'
             AND is_oracle = 'Y'
             GROUP BY name,
               application_name)
          min_ver
             WHERE procs.application_name = 'PatchOracleDBSoftware'
             AND procs.name = 'PATCH_RAC_DB_ALL_NODES'
             AND procs.version = min_ver.min_version
             AND procs.is_oracle = 'Y')
        WHERE application_name = 'PatchOracleDBSoftware'
         AND name = 'PATCH_RAC_DB_ALL_NODES'
         AND is_oracle = 'Y';

UPDATE mgmt_paf_procedures
        SET base_guid =
          (SELECT procedure_guid
           FROM mgmt_paf_procedures procs,
              (SELECT name,
               application_name,
               MIN(version) AS
            min_version
             FROM mgmt_paf_procedures
             WHERE application_name = 'PatchOracleClusterware'
             AND name = 'PATCH_CRS_ROLLING'
             AND is_oracle = 'Y'
             GROUP BY name,
               application_name)
          min_ver
             WHERE procs.application_name = 'PatchOracleClusterware'
             AND procs.name = 'PATCH_CRS_ROLLING'
             AND procs.version = min_ver.min_version
             AND procs.is_oracle = 'Y')
        WHERE application_name = 'PatchOracleClusterware'
         AND name = 'PATCH_CRS_ROLLING'
         AND is_oracle = 'Y';

COMMIT;
