set define '^'
set concat on
set concat .
set verify off

Rem
Rem    Application Express 3.2.1 patch
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem    jkallman    03/02/2009 - Created
Rem    sathikum    03/11/2009 - Added patch script for bug #8320185
Rem    hfarrell    03/12/2009 - Added patch script for bug #8331010
Rem    hfarrell    03/16/2009 - Added patch script for bug #8338787
Rem    sspadafo    03/22/2009 - Addded directives to compile .sql and .plb files for bug 8352574
Rem    hfarrell    03/23/2009 - Added patch script for bug #8349919
Rem    sspadafo    03/26/2009 - Added directives to compile files for bug 8370221 (sw_util.plb, generate_table_api.plb)
Rem    sathikum    03/26/2009 - added patch script for bug #8358834 and also compiling wwv_mig_frm_utilities.sql & plb which is related to the bug
Rem    jkallman    03/27/2009 - Added htmldb_util.plb (Bug 8355079)
Rem    msewtz      04/01/2009 - Added patch script for bug #8320124
Rem    sspadafo    04/06/2009 - Added directive to compile wwv_flow_calendar3.plb for bug 8352574
Rem    sspadafo    04/08/2009 - Added directive to compile patch_8354310.sql
Rem    sspadafo    04/08/2009 - Added directive to compile patch_8417472.sql
Rem    jkallman    04/08/2009 - Added prov.plb
Rem    pawolf      04/08/2009 - Added patch script for bug #8415325
Rem    sspadafo    04/09/2009 - Added directive to compile wwv_flow_fnd_developer_api.plb for bug 8422688
Rem    jkallman    04/09/2009 - Update version check
Rem    jkallman    04/13/2009 - Added patch_8416002.sql
Rem    hfarrell    04/14/2009 - Added patch script for bug #8330936
Rem    cbcho       04/15/2009 - Added wwv_flow_worksheet_expr.plb for bug #8347332
Rem    jstraub     04/15/2009 - Added patch script for bug #8432829
Rem    sspadafo    04/15/2009 - Added directives to compile wwv_dbms_sql.plb/wwv_dbms_sql_noroles.plb for bug 8431814
Rem    jstraub     04/15/2009 - Added patch script for bug #8371342
Rem    sspadafo    04/20/2009 - Added directive to compile wwv_flow_sample_app.plb for bug 8329301
Rem    jkallman    04/24/2009 - Added trigger wwv_biu_flow_companies
Rem    sspadafo    04/26/2009 - Added directive to compile custom_auth_std.plb (Bug 8461706)
Rem    sspadafo    04/26/2009 - Added grants to product schema for dbms_random, dbms_obfuscation_toolkit (Bug 8466721)
Rem    sspadafo    04/27/2009 - Added directive to compile wwv_flow_fnd_user_api.plb for bug 8466935
Rem    cbcho       04/28/2009 - Added wwv_flow_copy_page.plb (Bug 8460439)
Rem    hfarrell    05/06/2009 - Added patch script for bug #8486277
Rem    jkallman    05/06/2009 - Added view apex_application_page_ir_col (Bug 8494970)
Rem    jkallman    05/15/2009 - Removed view apex_application_page_ir_col, add apex_views.sql (Bug 8494970)
Rem    jkallman    05/19/2009 - Added trigger WWV_FLOW_SESSIONS$_T1 and flowc.plb (Bug 8530955)
Rem    jkallman    05/19/2009 - Delete any orphaned rows in wwv_flow_worksheet_rpts and wwv_flow_debug (Bug 8530955)
Rem    jkallman    05/20/2009 - Add synonyms for APEX_UI_DEFAULT
Rem    pawolf      05/20/2009 - Fixed Javascript bug in IE for charts (bug 8534848)
Rem    jkallman    05/26/2009 - Move dev-only files from corepatch.sql to devpatch.sql
Rem    jkallman    05/28/2009 - Added patch_8551429.sql
Rem    jkallman    06/05/2009 - Added crypt.plb (Bug 8573453)
Rem    jkallman    06/09/2009 - Added patch_8567600.sql and patch_8567757.sql
Rem    jkallman    07/20/2009 - Added spell.plb, flowu.plb, api.plb


alter session set current_schema = APEX_030200;

begin
    wwv_flow_security.g_security_group_id := 10;
end;
/

Rem check that the release we're attempting to patch is 3.2.0.00.27 or 3.2.1.00.10
set termout off
column release new_val release1
select decode(wwv_flows_release,'3.2.0.00.27','dontexit','3.2.1.00.10','dontexit','exit') release from dual;
set termout on

set serveroutput on
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
begin
    if '^release1' = 'exit' then
        dbms_output.put_line(chr(13)||chr(10));
        dbms_output.put_line('Error:');
        dbms_output.put_line('This script can only be used to patch release 3.2.0.00.27 or 3.2.1.00.10');
        dbms_output.put_line(chr(13)||chr(10)||chr(13)||chr(10));
        execute immediate('invalid sql statement to force exit');
    end if;
end;
/
WHENEVER SQLERROR CONTINUE

exec dbms_registry.loading('APEX','Oracle Application Express');




---------------------------------------------------------------------------
-- Direct, rerunnable DDL
---------------------------------------------------------------------------
create or replace trigger wwv_biu_flow_companies
    before insert or update on wwv_flow_companies
    for each row
begin
    if :new.provisioning_company_id = 20 and :new.short_name not in ('ORACLE','COM.ORACLE.APEX.APPLICATIONS') then
        raise_application_error(-20001,wwv_flow_lang.system_message('TRIGGER.SGID_RESERVED'));
    end if;
    if inserting and :new.id is null then
        :new.id := wwv_flow_id.next_val;
    end if;
    :new.short_name := upper(:new.short_name);
end;
/

create or replace trigger WWV_FLOW_SESSIONS$_T1
BEFORE
delete on WWV_FLOW_SESSIONS$
for each row
begin
   delete from wwv_flow_debug where id = :old.id;
   delete from wwv_flow_worksheet_rpts where session_id = :old.id;	
   --	
   update wwv_flow_companies
   set last_login = trunc(:old.CREATED_ON)
   where provisioning_company_id = :old.security_group_id and
        (last_login < trunc(:old.CREATED_ON) or last_login is null);
end;
/

create or replace synonym APEX_030200.APEX_UI_DEFAULT for APEX_030200.WWV_FLOW_HINT
/

create or replace public synonym APEX_UI_DEFAULT for APEX_030200.APEX_UI_DEFAULT
/

begin
    execute immediate 'drop public synonym WWV_FLOW_DML';
exception
    when others then
        if sqlcode <> -1432 then
            raise;
        end if;
end;
/






---------------------------------------------------------------------------
-- Compilation of package specifications (of the form @^PREFIX.core/foo.sql
---------------------------------------------------------------------------
@^PREFIX.core/flows_release.sql
@^PREFIX.core/wwv_flow_assert.sql

-------------------------------------------------------------------
-- Compilation of package bodies (of the form @^PREFIX.core/foo.plb
-------------------------------------------------------------------
@^PREFIX.core/wwv_flow_assert.plb
@^PREFIX.core/flow_dml.plb
@^PREFIX.core/wwv_flow_form_control.plb
@^PREFIX.core/flow.plb
@^PREFIX.core/prov.plb
@^PREFIX.core/sw_api.plb
@^PREFIX.core/sw_util.plb
@^PREFIX.core/wwv_flow_worksheet_standard.plb
@^PREFIX.core/wwv_flow_upgrade.plb
@^PREFIX.core/sw_util.plb
@^PREFIX.core/htmldb_util.plb
@^PREFIX.core/wwv_flow_calendar3.plb
@^PREFIX.core/wwv_flow_fnd_developer_api.plb
@^PREFIX.core/wwv_flow_worksheet_expr.plb
@^PREFIX.core/wwv_flow_sample_app.plb
@^PREFIX.core/custom_auth_std.plb
@^PREFIX.core/wwv_flow_fnd_user_api.plb
@^PREFIX.core/flowc.plb
@^PREFIX.core/wwv_flow_worksheet.plb
@^PREFIX.core/crypt.plb
@^PREFIX.core/spell.plb
@^PREFIX.core/flowu.plb
@^PREFIX.core/api.plb
@^PREFIX.core/apex_views.sql


-------------------------------------------------------------------
-- Compilation of development package specifications and bodies
-------------------------------------------------------------------
column thescript new_val script
set termout off
select decode(count(*),0,'patch_8417472.sql','devpatch.sql') thescript from wwv_flows where id = 4000;
set termout on
@^PREFIX.patches/3.2.1/^script



--------------------------------------------------------------------
-- Patch files (of the form @^PREFIX.patches/3.2.1/patch_1234567.sql
--------------------------------------------------------------------
@^PREFIX.patches/3.2.1/patch_8320185.sql
@^PREFIX.patches/3.2.1/patch_8331010.sql
@^PREFIX.patches/3.2.1/patch_8338787.sql
@^PREFIX.patches/3.2.1/patch_8349919.sql
@^PREFIX.patches/3.2.1/patch_8358834.sql
@^PREFIX.patches/3.2.1/patch_8320124.sql
@^PREFIX.patches/3.2.1/patch_8354310.sql
@^PREFIX.patches/3.2.1/patch_8417472.sql
@^PREFIX.patches/3.2.1/patch_8415325.sql
@^PREFIX.patches/3.2.1/patch_8416002.sql
@^PREFIX.patches/3.2.1/patch_8330936.sql
@^PREFIX.patches/3.2.1/patch_8432829.sql
@^PREFIX.patches/3.2.1/patch_8371342.sql
@^PREFIX.patches/3.2.1/patch_8466721.sql
@^PREFIX.patches/3.2.1/patch_8486277.sql
@^PREFIX.patches/3.2.1/patch_8551429.sql
@^PREFIX.patches/3.2.1/patch_8567757.sql
@^PREFIX.patches/3.2.1/patch_8567600.sql


delete from wwv_flow_worksheet_rpts r where r.session_id is not null and r.session_id not in  (select id from wwv_flow_sessions$)
/

delete from wwv_flow_debug where id not in (select id from wwv_flow_sessions$)
/
commit
/

create or replace public synonym APEX_APPLICATION_TRANS_MAP for APEX_030200.APEX_APPLICATION_TRANS_MAP
/


--
-- Compile the version of sys.wwv_dbms_sql that uses logon roles if XE or 10.2.0.3 or greater
--
column :thescript new_val script NOPRINT
variable thescript varchar2(35)
begin
    if wwv_flow_utilities.db_version_is_at_least('10.2.0.3') or wwv_flow_utilities.db_edition_is_xe then
        :thescript := 'wwv_dbms_sql.plb';
    else
        :thescript := 'wwv_dbms_sql_noroles.plb';
    end if;
end;
/
select :thescript from dual;
@^PREFIX.core/^script

begin 
dbms_utility.compile_schema( 'APEX_030200',FALSE );
end;
/

prompt ...Adjust internal application version

column flow_version new_val version
set termout off
select wwv_flows_release flow_version from dual where rownum = 1;
set termout on

update wwv_flows
   set flow_version = '&PRODUCT_NAME. ' || '^version'
 where id between 4000 and 4999
/

update wwv_flows
   set flow_version = '&PRODUCT_NAME. '
 where id between 4550 and 4559
/

update wwv_flows
   set flow_version = '&PRODUCT_NAME. '
 where id between 4400 and 4409
/

commit
/

prompt ...Validating Application Express
exec sys.validate_apex;


-- Set the preference to indicate this is a patched instance
begin
    wwv_flow_platform.set_preference('APEX_3_2_1_PATCH',to_char(sysdate,'YYYY-MM-DD_HH24-MI-SS'));
end;
/

commit
/


exec dbms_registry.loaded('APEX','^version');

alter session set current_schema = SYS;

exec validate_apex;
