set define '^'

Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem    jkallman   04/13/2009 - Created patch file for bug 8416002

alter session set current_schema = APEX_030200;



delete from wwv_flow_data_load_unload where security_group_id not in
    (select provisioning_company_id from wwv_flow_companies)
/

delete from wwv_flow_data_load_bad_log where security_group_id not in
    (select provisioning_company_id from wwv_flow_companies)
/

delete from wwv_flow_data_load_bad_log where load_id not in
    (select id from wwv_flow_data_load_unload)
/

commit
/


begin
    execute immediate 'alter table wwv_flow_data_load_unload
                         add constraint wwv_flow_data_load_unload_pk
                         primary key(id)';
exception
    when others then
        if sqlcode in (-955,-2260) then
            null;
        else
            raise;
        end if;
end;
/

begin
    execute immediate 'alter table wwv_flow_data_load_unload
                         add constraint wwv_flow_data_load_unload_fk 
                         foreign key(security_group_id)
                         references wwv_flow_companies(provisioning_company_id)
                         on delete cascade';
exception
    when others then
        if sqlcode in (-955,-2275) THEN
            null;
        else
        	  raise;
       end if;
end;       
/


begin
    execute immediate 'alter table wwv_flow_data_load_bad_log
                         add constraint wwv_flow_data_load_bad_log_fk1 
                         foreign key(load_id) 
                         references wwv_flow_data_load_unload(id)
                         on delete cascade';
exception
    when others then
        if sqlcode in (-955,-2275) THEN
            null;
        else
        	  raise;
       end if;
end;       
/


begin
    execute immediate 'alter table wwv_flow_data_load_bad_log
                         add constraint wwv_flow_data_load_bad_log_fk2 
                         foreign key(security_group_id)
                         references wwv_flow_companies(provisioning_company_id)
                         on delete cascade';
exception
    when others then
        if sqlcode in (-955,-2275) then
            null;
        else
        	  raise;
        end if;
end;       
/


begin
    execute immediate 'create index wwv_flow_data_load_unload_idx1 on wwv_flow_data_load_unload(security_group_id)';
exception 
    when others then
        if sqlcode = -955 then
            null;
        else
        	  raise;
        end if;
end;
/

begin
    execute immediate 'create index wwv_flow_data_load_bad_idx1 on wwv_flow_data_load_bad_log(load_id)';
exception 
    when others then
        if sqlcode = -955 then
            null;
        else
        	  raise;
        end if;
end;
/


begin
    execute immediate 'create index wwv_flow_data_load_bad_idx2 on wwv_flow_data_load_bad_log(security_group_id)';
exception 
    when others then
        if sqlcode = -955 then
            null;
        else
        	  raise;
        end if;
end;
/
