Rem create.sql
rem SQL script for running the Point4 test, showing
rem how to work with instance methods in Java store procedures
connect &1/&2
set echo on
set serveroutput on

rem clean up from previous runs
drop table point_table;
drop type point force;

rem set up object type and table for the test
create or replace type point as object (
  x number, 
  y number,
  member function jdistance (p point) return number,
  member procedure moveby (p point)
);
/
show errors;

create or replace type body point is
  member function jdistance (p point) return number is
  language java name
    'Point4.distance (Point4) return double';
 
  member procedure moveby (p point) is
  language java name
    'Point4.moveBy (Point4)';
end;
/
show errors;

create table point_table (p point);
insert into point_table values (point (0, 0));
insert into point_table values (point (3, 4));
insert into point_table values (point (10, 10));

exit
