<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuaindex.xsl
DESCRIPTION
    Convert sxml INDEX diff document to ALTER_XML document
    NOT_ALTERABLE Reasons:
    - UNIQUE_INDEX
    - BITMAP_INDEX
    - ON_TABLE
    - COLUMN
    - PARALLEL_INSTANCES
MODIFIED        MM/DD/YY
    adalee     04/16/09 - add FLASH_CACHE and CELL_FLASH_CACHE
    rapayne      12/02/08 - modify 'rebuild partition' to quote partition name and tablespace name.
    rapayne    09/25/08 - Bug 7434520:SegAttr for range-partitioned index diffs processed twice.
    rapayne      09/25/08 - Bug 7434520:SegAttr for range-partitioned index diffs processed twice.
    lbarton      09/15/08 - bug 7362930: UNUSABLE index (sub)partitions
    lbarton      07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    rapayne      22/01/08 - fix parameter selection for PARALLEL (i.e., not just PARALLEL_DEGREE)
    lbarton      01/22/08 - Bug 6724820: table compression
    rapayne      16/07/07 - move CommonNotAlterable to kuacomm.xsl 
                          - check for incompatible index 'types' and mark as not
                            alterable if appropriate:
                            (e.g., TABLE_INDEX vs. BITMAP_JOIN_INDEX)
    rapayne      24/11/06 - correct ade sync problem
    htseng       20/11/06 - not alterable unique, col_list 
    rapayne      06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuatprop.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="DROP_MISSING_COLUMNS">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <xsl:param name="PRS_COLUMN_ATTRIBUTE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:INDEX">
  <!-- *******************************************************************
Template: INDEX - top-level template for Index.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">INDEX</xsl:element>
   <!--Display schema.objname for CoMPareObjects 1 and 2 -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:element name="ALTER_LIST">
    <!--check if index is alterable  -->
    <xsl:call-template name="checkAlterable">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <!--check INDEX_ATTRIBUTES -->
    <xsl:call-template name="CheckIndexAttr">
     <xsl:with-param name="IndexNode" select="."/>
     <xsl:with-param name="AttribNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES"/>
    </xsl:call-template>
    <!--check INVISIBLE attribute -->
    <xsl:if test="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:INVISIBLE/@src">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="IndexVisibility">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="InvisibleNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:INVISIBLE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="IndexVisibility">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="InvisibleNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:INVISIBLE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <!--check KEYCOMPRESSION -->
    <xsl:if test="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:KEYCOMPRESS/@src or
      sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:KEYCOMPRESS/@value">
     <xsl:choose>
      <xsl:when test="sxml:TABLE_INDEX/sxml:GLOBAL_PARTITIONING">
       <!-- Can not alter compression on partitioned indexes -->
       <xsl:call-template name="CommonNotAlterable">
        <xsl:with-param name="NameParent" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:KEYCOMPRESS"/>
        <xsl:with-param name="Reason">KEY COMPRESSION</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="CommonNotAlterable">
        <xsl:with-param name="NameParent" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:KEYCOMPRESS"/>
        <xsl:with-param name="Reason">KEY COMPRESSION</xsl:with-param>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
    <!--check PARALLEL_DEGREE -->
    <xsl:if test="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL/@src or
        sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL_DEGREE/@src or
        sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL_DEGREE/sxml:DEGREE/@value1 or
        sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL_DEGREE/sxml:INSTANCES/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="IndexParallel">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="ParallelNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL |
                                              sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL_DEGREE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="IndexParallel">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="ParallelNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL |
                                              sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL_DEGREE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:if test="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:LOGGING/@value1 or
                  sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:LOGGING/@src">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="IndexLogging">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="LoggingNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:LOGGING"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="IndexLogging">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="LoggingNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:LOGGING"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:if test="sxml:TABLE_INDEX/sxml:UNUSABLE/@src">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterIndUsable">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="UsableNode" select="sxml:TABLE_INDEX/sxml:UNUSABLE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterIndUsable">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="UsableNode" select="sxml:TABLE_INDEX/sxml:UNUSABLE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:if test="sxml:TABLE_INDEX/sxml:MONITORING_USAGE/@src">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterIndMonitor">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="MonitorNode" select="sxml:TABLE_INDEX/sxml:MONITORING_USAGE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterIndMonitor">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="MonitorNode" select="sxml:TABLE_INDEX/sxml:MONITORING_USAGE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:if test="sxml:TABLE_INDEX/sxml:LOCAL_PARTITIONING//@src or
        sxml:TABLE_INDEX/sxml:LOCAL_PARTITIONING//@value1">
     <xsl:call-template name="AlterLocalPart">
      <xsl:with-param name="IndexNode" select="."/>
      <xsl:with-param name="PartList" select="sxml:TABLE_INDEX/sxml:LOCAL_PARTITIONING/sxml:PARTITION_LIST"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="sxml:TABLE_INDEX/sxml:GLOBAL_PARTITIONING//@src or
        sxml:TABLE_INDEX/sxml:GLOBAL_PARTITIONING//@value1">
     <xsl:if test="sxml:TABLE_INDEX/sxml:GLOBAL_PARTITIONING/sxml:HASH_PARTITIONING">
      <xsl:call-template name="AlterGlobalPart">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="PartList" select="sxml:TABLE_INDEX/sxml:GLOBAL_PARTITIONING/sxml:HASH_PARTITIONING"/>
       <xsl:with-param name="PartType">HASH</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="sxml:TABLE_INDEX/sxml:GLOBAL_PARTITIONING/sxml:RANGE_PARTITIONING">
      <xsl:call-template name="AlterGlobalPart">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="PartList" select="sxml:TABLE_INDEX/sxml:GLOBAL_PARTITIONING/sxml:RANGE_PARTITIONING"/>
       <xsl:with-param name="PartType">RANGE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:if>
    <!-- Index name rename (the last thing we do) -->
    <xsl:call-template name="RenIndex">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="checkAlterable">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: checkAlterable - Detects certain non-alterable cases
 1. type diffs (e.g., UNIQUE_INDEX, BITMAP_INDEX)
 2. COL_LIST diffs
 3. index are on different tables
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:if test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
   <!-- Check for "UNIQUE" difference -->
   <xsl:if test="sxml:UNIQUE/@src or 
                 sxml:BITMAP/@src or
                 sxml:BITMAP_JOIN_INDEX/@src or
                 sxml:CLUSTER_INDEX/@src or
                 sxml:TABLE_INDEX/@src">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="."/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="sxml:NAME"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">INCOMPATIBLE_INDEX</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:element>
   </xsl:if>
   <!-- Check for COL_LIST  difference -->
   <xsl:for-each select="sxml:TABLE_INDEX/sxml:COL_LIST/sxml:COL_LIST_ITEM">
    <xsl:if test="./@src or sxml:NAME/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:element name="PARSE_LIST">
       <xsl:call-template name="AddXPathParseItem">
        <xsl:with-param name="Node" select="."/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
        <xsl:with-param name="Item">NAME</xsl:with-param>
        <xsl:with-param name="Value1" select="sxml:NAME"/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">COLUMNS</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:if>
   </xsl:for-each>
   <!-- Check for ON_TABLE  difference -->
   <xsl:if test="sxml:TABLE_INDEX/sxml:ON_TABLE/sxml:NAME/@value1">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="."/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="sxml:NAME"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">ON_TABLE</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:element>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="IndexVisibility">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="InvisibleNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: IndexVisibility- 
 (1)
Parameters:
 IndexNode 
 InvisibleNode - 
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <!-- Check for "LOGGIN" difference -->
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="."/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$InvisibleNode/@src='1'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">VISIBLE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$InvisibleNode/@src='2'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">INVISIBLE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$InvisibleNode/@src='1'">
         <xsl:text> VISIBLE </xsl:text>
        </xsl:when>
        <xsl:when test="$InvisibleNode/@src='2'">
         <xsl:text> INVISIBLE </xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="IndexParallel">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="ParallelNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: IndexParallel - 
 (1)
Parameters:
 ParentNode - Parent node (i.e., PARALLEL_DEGREE>
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <!-- Check for "PARALLEL" difference -->
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="."/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$ParallelNode/@src='2'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">ADD_PARALLEL</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$ParallelNode/@src='1'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">REMOVE_PARALLEL</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$ParallelNode/sxml:DEGREE/@value1">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">MODIFY_PARALLEL</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$ParallelNode/sxml:INSTANCES/@value1">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">PARALLEL_INSTANCES</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:variable name="ParallelValue">
        <xsl:choose>
         <xsl:when test="$ParallelNode/sxml:DEGREE">
          <xsl:value-of select="$ParallelNode/sxml:DEGREE"/>
         </xsl:when>
         <xsl:otherwise>
          <xsl:value-of select="$ParallelNode"/>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>
       <xsl:choose>
        <xsl:when test="$ParallelNode/@src='2' or $ParallelNode/@value1 or
                                  $ParallelNode/sxml:DEGREE/@src='2' or $ParallelNode/sxml:DEGREE/@value1">
         <xsl:text> PARALLEL </xsl:text>
         <xsl:if test="not($ParallelValue='AUTOMATIC')">
          <xsl:value-of select="$ParallelValue"/>
         </xsl:if>
        </xsl:when>
        <xsl:when test="$ParallelNode/@src='1'">
         <xsl:text> NOPARALLEL</xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="IndexLogging">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="LoggingNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: IndexLogging- 
     If this template is called there IS some kind of LOGGING diff.
Parameters:
 IndexNode 
 LoggingNode - 
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <!-- Check for "LOGGING" difference -->
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="."/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$LoggingNode/@value1='N' or 
                ($LoggingNode/@src='1' and $LoggingNode ='N') or
                ($LoggingNode/@src='2' and $LoggingNode ='Y')">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">ADD_LOGGING</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">DISABLE_LOGGING</xsl:with-param>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$LoggingNode/@value1='N' or
                ($LoggingNode/@src='1' and $LoggingNode ='N') or
                ($LoggingNode/@src='2' and $LoggingNode ='Y')">
         <xsl:text> LOGGING </xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text> NOLOGGING </xsl:text>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterIndUsable">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="UsableNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterIndUsable

Parameters:
 IndexNode 
 PartNode - partition node
 UsableNode - 
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <!-- Check for "LOGGIN" difference -->
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$UsableNode"/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$UsableNode/@src='1'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">USABLE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$UsableNode/@src='2'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">UNUSABLE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <!-- Non-regular SQL syntax:
          ALTER INDEX ind [ MODIFY [SUB]PARTITION p ] UNUSABLE
          ALTER INDEX ind REBUILD [[SUB]PARTITION p ]
   -->
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$UsableNode/@src='1'">
         <xsl:text> REBUILD </xsl:text>
         <xsl:if test="string-length($PartNode)!=0">
          <xsl:choose>
           <xsl:when test="local-name($PartNode)='PARTITION_LIST_ITEM'">PARTITION "</xsl:when>
           <xsl:when test="local-name($PartNode)='SUBPARTITION_LIST_ITEM'">SUBPARTITION "</xsl:when>
          </xsl:choose>
          <xsl:value-of select="$PartNode/sxml:NAME"/>
          <xsl:text>"</xsl:text>
         </xsl:if>
        </xsl:when>
        <xsl:when test="$UsableNode/@src='2'">
         <xsl:if test="string-length($PartNode)!=0">
          <xsl:choose>
           <xsl:when test="local-name($PartNode)='PARTITION_LIST_ITEM'"> MODIFY PARTITION "</xsl:when>
           <xsl:when test="local-name($PartNode)='SUBPARTITION_LIST_ITEM'"> MODIFY SUBPARTITION "</xsl:when>
          </xsl:choose>
          <xsl:value-of select="$PartNode/sxml:NAME"/>
          <xsl:text>"</xsl:text>
         </xsl:if>
         <xsl:text> UNUSABLE </xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterIndMonitor">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="MonitorNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterIndMonitoring- 
 (1)
Parameters:
 IndexNode 
 MonitorNode - 
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <!-- Check for "LOGGIN" difference -->
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$MonitorNode"/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$MonitorNode/@src='1'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">NOMONITORING USAGE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$MonitorNode/@src='2'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">MONITORING USAGE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$MonitorNode/@src='1'">
         <xsl:text> NOMONITORING USAGE </xsl:text>
        </xsl:when>
        <xsl:when test="$MonitorNode/@src='2'">
         <xsl:text> MONITORING USAGE </xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="RenIndex">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: RenIndex
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:NAME[@value1]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:if test="$PRS_NAME=1 or 
                  $PRS_CLAUSE_TYPE=1 or
                  $PRS_COLUMN_ATTRIBUTE=1 or
                  $PRS_ALTERABLE=1 or
                  $PRS_XPATH=1">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="$ParentNode"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME/@value1"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">RENAME_INDEX</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> RENAME TO </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="sxml:NAME"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CheckIndexAttr">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="AttribNode" select="''"/>
  <!-- *******************************************************************
Template: CheckIndexAttr
Parameters:
 IndexNode
 AttribNode 
******************************************************************** -->
  <xsl:if test="  $AttribNode/sxml:PCTUSED/@value1 or
  $AttribNode/sxml:INITRANS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:INITIAL/@value1 or
  $AttribNode/sxml:STORAGE/sxml:NEXT/@value1 or
  $AttribNode/sxml:STORAGE/sxml:MINEXTENTS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:MAXEXTENTS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:PCTINCREASE/@value1 or
  $AttribNode/sxml:STORAGE/sxml:FREE_LISTS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:FREE_LIST_GROUPS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:BUFFER_POOL/@value1 or
  $AttribNode/sxml:STORAGE/sxml:FLASH_CACHE/@value1 or
  $AttribNode/sxml:STORAGE/sxml:CELL_FLASH_CACHE/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterIndexAttr">
     <xsl:with-param name="IndexNode" select="$IndexNode"/>
     <xsl:with-param name="AttribNode" select="$AttribNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <!-- No SQL action for INITIAL or FREE_LIST_GROUPS because they result in ORA-2170 errors -->
    <xsl:if test="  $AttribNode/sxml:PCTUSED/@value1 or
  $AttribNode/sxml:INITRANS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:NEXT/@value1 or
  $AttribNode/sxml:STORAGE/sxml:MINEXTENTS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:MAXEXTENTS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:PCTINCREASE/@value1 or
  $AttribNode/sxml:STORAGE/sxml:FREE_LISTS/@value1 or
  $AttribNode/sxml:STORAGE/sxml:BUFFER_POOL/@value1 or
  $AttribNode/sxml:STORAGE/sxml:FLASH_CACHE/@value1 or
  $AttribNode/sxml:STORAGE/sxml:CELL_FLASH_CACHE/@value1">
     <xsl:call-template name="AlterIndexAttr">
      <xsl:with-param name="IndexNode" select="."/>
      <xsl:with-param name="AttribNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES"/>
      <xsl:with-param name="Action">SQL</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
   </xsl:element>
  </xsl:if>
  <!-- default index attributes (tablespace and pctfree) are also part of INDEX_ATTRIBUTES but are
         handled a little differently
-->
  <xsl:if test="$AttribNode/sxml:TABLESPACE/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:choose>
     <xsl:when test="$IndexNode/sxml:TABLE_INDEX/sxml:GLOBAL_PARTITIONING or 
  $IndexNode/sxml:LOCAL_PARTITIONING">
      <xsl:call-template name="AlterIndDefAttr">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="AttribNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterIndDefAttr">
       <xsl:with-param name="IndexNode" select="."/>
       <xsl:with-param name="AttribNode" select="sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:if test="($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
       <xsl:element name="PARSE_LIST">
        <xsl:call-template name="AddXPathParseItem">
         <xsl:with-param name="Node" select="."/>
        </xsl:call-template>
        <xsl:call-template name="AddParseItem">
         <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
         <xsl:with-param name="Item">NAME</xsl:with-param>
         <xsl:with-param name="Value1" select="sxml:NAME"/>
        </xsl:call-template>
        <xsl:call-template name="AddParseItem">
         <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
         <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
         <xsl:with-param name="Value1">INDEX_NOT_PARTITIONED</xsl:with-param>
        </xsl:call-template>
       </xsl:element>
      </xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterIndexAttr">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="AttribNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterIndexAttr - modify the index attributes:
    PCTFREE
    PCTUSED 
    INITRANS
    storage_clause
Parameters:
 IndexNode
AttribNode
Action - PARSE or SQL 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$IndexNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">INDEX_ATTRIBUTES</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:call-template name="AlterPhysicalAttributes">
        <xsl:with-param name="ParentNode" select="$AttribNode"/>
        <xsl:with-param name="TypeNode">MODIFY</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterIndDefAttr">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="AttribNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterIndDefAttr - modify the index default attributes:
     TABLESPACE and PCTFREE
Parameters:
 IndexNode
AttribNode
Action - PARSE or SQL 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$IndexNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">INDEX_TABLESPACE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:text> MODIFY DEFAULT ATTRIBUTES </xsl:text>
       <xsl:if test="$AttribNode/sxml:PCTFREE/@value1">
        <xsl:text> PCTFREE </xsl:text>
        <xsl:value-of select="$AttribNode/sxml:PCTFREE"/>
       </xsl:if>
       <xsl:if test="$AttribNode/sxml:TABLESPACE/@value1">
        <xsl:text> TABLESPACE </xsl:text>
        <xsl:value-of select="$AttribNode/sxml:TABLESPACE"/>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DropGlobalPart">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DropGlobalPart
Parameters:
 IndexNode
 PartNode  <PARTITION_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PartNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DROP_GLOBAL_PARTITION </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:text> DROP PARTITION </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$PartNode"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterLocalPart">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartList" select="''"/>
  <!-- *******************************************************************
Template: AlterLocalPart - only allowable modification is
REBUILD or MODIFY UNUSABLE
Parameters: 
 IndexNode
 PartList  <PARTITION_LIST>
******************************************************************** -->
  <xsl:for-each select="$PartList/sxml:PARTITION_LIST_ITEM">
   <xsl:call-template name="DoAlterLocalPart">
    <xsl:with-param name="IndexNode" select="$IndexNode"/>
    <xsl:with-param name="PartListItem" select="."/>
   </xsl:call-template>
   <xsl:for-each select="./sxml:SUBPARTITION_LIST/sxml:SUBPARTITION_LIST_ITEM">
    <xsl:call-template name="DoAlterLocalPart">
     <xsl:with-param name="IndexNode" select="$IndexNode"/>
     <xsl:with-param name="PartListItem" select="."/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoAlterLocalPart">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartListItem" select="''"/>
  <!-- *******************************************************************
Template: DoAlterLocalPart - only allowable modification is
REBUILD or MODIFY UNUSABLE
Parameters: 
 IndexNode
 PartListItem  <PARTITION_LIST_ITEM> or <SUBPARTITION_LIST_ITEM>
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$PartListItem/@src='1'">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="."/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$PartListItem/sxml:NAME"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">
        <xsl:choose>
         <xsl:when test="local-name($PartListItem)='PARTITION_LIST_ITEM'">DROP_LOCAL_PARTITION</xsl:when>
         <xsl:when test="local-name($PartListItem)='SUBPARTITION_LIST_ITEM'">DROP_LOCAL_SUBPARTITION</xsl:when>
        </xsl:choose>
       </xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$PartListItem/@src='2'">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="."/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$PartListItem/sxml:NAME"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">
        <xsl:choose>
         <xsl:when test="local-name($PartListItem)='PARTITION_LIST_ITEM'">ADD_LOCAL_PARTITION</xsl:when>
         <xsl:when test="local-name($PartListItem)='SUBPARTITION_LIST_ITEM'">ADD_LOCAL_SUBPARTITION</xsl:when>
        </xsl:choose>
       </xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="$PartListItem/sxml:UNUSABLE/@src">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterIndUsable">
       <xsl:with-param name="IndexNode" select="$IndexNode"/>
       <xsl:with-param name="PartNode" select="$PartListItem"/>
       <xsl:with-param name="UsableNode" select="$PartListItem/sxml:UNUSABLE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterIndUsable">
       <xsl:with-param name="IndexNode" select="$IndexNode"/>
       <xsl:with-param name="PartNode" select="$PartListItem"/>
       <xsl:with-param name="UsableNode" select="$PartListItem/sxml:UNUSABLE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:if test="$PartListItem//@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:element name="PARSE_LIST">
       <xsl:call-template name="AddXPathParseItem">
        <xsl:with-param name="Node" select="."/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
        <xsl:with-param name="Item">NAME</xsl:with-param>
        <xsl:with-param name="Value1" select="sxml:NAME"/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">
         <xsl:choose>
          <xsl:when test="local-name($PartListItem)='PARTITION_LIST_ITEM'">MODIFY_LOCAL_PARTITION</xsl:when>
          <xsl:when test="local-name($PartListItem)='SUBPARTITION_LIST_ITEM'">MODIFY_LOCAL_SUBPARTITION</xsl:when>
         </xsl:choose>
        </xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterGlobalPart">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartList" select="''"/>
  <xsl:param name="PartType" select="''"/>
  <!-- *******************************************************************
Template: AlterGlobalPart - 
Parameters: 
 IndexNode
 PartList - <RANGE_PARTITIONING> or <HASH_PARTITIONING>
PartType - RANGE or HASH
******************************************************************** -->
  <xsl:for-each select="$PartList/sxml:PARTITION_LIST/sxml:PARTITION_LIST_ITEM">
   <xsl:choose>
    <xsl:when test="./@src='1'">
     <!-- drops are identical from HASH and RANGE partitions -->
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="NameParent" select="."/>
      <xsl:with-param name="Reason">DROP_GLOBAL_PARTITION</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="./@src='2'">
     <xsl:if test="$PartType = 'HASH'">
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:call-template name="AddGlobalHashPart">
        <xsl:with-param name="IndexNode" select="$IndexNode"/>
        <xsl:with-param name="PartType" select="$PartList"/>
        <xsl:with-param name="PartNode" select="."/>
        <xsl:with-param name="Action">PARSE</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="AddGlobalHashPart">
        <xsl:with-param name="IndexNode" select="$IndexNode"/>
        <xsl:with-param name="PartType" select="$PartList"/>
        <xsl:with-param name="PartNode" select="."/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:if>
     <xsl:if test="$PartType = 'RANGE'">
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:call-template name="AddGlobalRangePart">
        <xsl:with-param name="IndexNode" select="$IndexNode"/>
        <xsl:with-param name="PartNode" select="."/>
        <xsl:with-param name="Action">PARSE</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="AddGlobalRangePart">
        <xsl:with-param name="IndexNode" select="$IndexNode"/>
        <xsl:with-param name="PartNode" select="."/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <!--
          If not an ADD nor a DROP than something was modify within this
         existing partition
-->
     <!-- Diffs in Partition Names are NOT alterable -->
     <xsl:if test="./sxml:NAME//@value1">
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:element name="PARSE_LIST">
        <xsl:call-template name="AddXPathParseItem">
         <xsl:with-param name="Node" select="."/>
        </xsl:call-template>
        <xsl:call-template name="AddParseItem">
         <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
         <xsl:with-param name="Item">NAME</xsl:with-param>
         <xsl:with-param name="Value1" select="./sxml:NAME"/>
        </xsl:call-template>
        <xsl:call-template name="AddParseItem">
         <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
         <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
         <xsl:with-param name="Value1">MODIFY_PARTITION</xsl:with-param>
        </xsl:call-template>
       </xsl:element>
      </xsl:element>
     </xsl:if>
     <!-- If appropriate process SEGMENT_ATTRIBUTES differences -->
     <xsl:if test="./sxml:SEGMENT_ATTRIBUTES//@value1">
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:call-template name="RebuildSegAttr">
        <xsl:with-param name="IndexNode" select="$IndexNode"/>
        <xsl:with-param name="PartNode" select="."/>
        <xsl:with-param name="Action">PARSE</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="RebuildSegAttr">
        <xsl:with-param name="IndexNode" select="$IndexNode"/>
        <xsl:with-param name="PartNode" select="."/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="AddGlobalHashPart">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartType" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AddGlobalHashPart
Parameters:
 IndexNode
 PartNode  <PARTITION_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PartNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ADD_GLOBAL_PARTITION </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:text> ADD PARTITION </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$PartNode"/>
       </xsl:call-template>
       <xsl:text> TABLESPACE </xsl:text>
       <xsl:value-of select="sxml:TABLESPACE"/>
       <xsl:if test="$PartNode/sxml:PARALLEL">
        <xsl:text> PARALLEL </xsl:text>
        <xsl:value-of select="$PartNode/sxml:PARALLEL"/>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AddGlobalRangePart">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AddGlobalRangePart - 
Parameters: 
 IndexNode
 PartNode
Action - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="."/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ADD_GLOBAL_PARTITION </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:text> SPLIT PARTITION </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="."/>
       </xsl:call-template>
       <xsl:text> AT (</xsl:text>
       <xsl:value-of select="./sxml:VALUES"/>
       <xsl:text> )</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterSegAttr">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterSegAttr
Parameters:
 IndexNode
 PartNode  <PARTITION_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PartNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_SEGMENT_ATTRS</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:text> MODIFY DEFAULT ATTRIBUTES FOR PARTITION </xsl:text>
       <xsl:value-of select="$PartNode/sxml:NAME"/>
       <xsl:text> </xsl:text>
       <xsl:if test="./sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE/@value1">
        <xsl:text> TABLESPACE </xsl:text>
        <xsl:value-of select="./sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="RebuildSegAttr">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: RebuildSegAttr 
Description: this is called from AlterGlobalPartition - there are attributes which are not allowed for partitioned indexes (e.g. REVERSE) and therefore are not processed in the template. 
Parameters:
 IndexNode
 PartNode  <PARTITION_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PartNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">REBUILD_SEGMENT_ATTRS</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:text> REBUILD PARTITION </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="$PartNode/sxml:NAME"/>
       </xsl:call-template>
       <xsl:if test="./sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE/@value1">
        <xsl:text> TABLESPACE </xsl:text>
        <xsl:call-template name="QuotedName">
         <xsl:with-param name="NameNode" select="./sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
        </xsl:call-template>
       </xsl:if>
       <!-- process ATTRIBUTES and STORAGE  diffs if appropriate -->
       <xsl:if test="./sxml:SEGMENT_ATTRIBUTES//@value1">
        <xsl:call-template name="AlterPhysicalAttributes">
         <xsl:with-param name="ParentNode" select="./sxml:SEGMENT_ATTRIBUTES"/>
         <xsl:with-param name="TypeNode">MODIFY</xsl:with-param>
        </xsl:call-template>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="RenameIndexPartition">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="RenType" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: RenameIndexPartition
     Rename index partition or subpartition
Parameters:
 IndexNode
 PartNode  <PARTITION> node
 RenType  - PARTITION or SUBPARTITION
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <!-- Check for "LOGGING" difference -->
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="."/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$PartNode/sxml:NAME/@value1"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">RENAME_PARTITION</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER INDEX </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$IndexNode"/>
       </xsl:call-template>
       <xsl:text> RENAME</xsl:text>
       <xsl:if test="$RenType = 'SUBPARTITION'">
        <xsl:text> SUB</xsl:text>
       </xsl:if>
       <xsl:text> PARTITION </xsl:text>
       <xsl:value-of select="$PartNode/sxml:NAME/@value1"/>
       <xsl:text> TO </xsl:text>
       <xsl:value-of select="$PartNode/sxml:NAME"/>
       <xsl:if test="$IndexNode/sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL">
        <xsl:text> PARALLEL </xsl:text>
        <xsl:value-of select="$IndexNode/sxml:TABLE_INDEX/sxml:INDEX_ATTRIBUTES/sxml:PARALLEL"/>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyIndexPartition">
  <xsl:param name="IndexNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <!-- *******************************************************************
Template: ModifyIndexPartition

Parameters:
 IndexNode
 PartNode  <PARTITION> node
******************************************************************** -->
  <xsl:if test="$PartNode/sxml:SEGMENT_ATTRIBUTES//@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterSegAttr">
     <xsl:with-param name="IndexNode" select="$IndexNode"/>
     <xsl:with-param name="PartNode" select="$PartNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterSegAttr">
     <xsl:with-param name="IndexNode" select="$IndexNode"/>
     <xsl:with-param name="PartNode" select="$PartNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <xsl:if test="$PartNode/sxml:NAME//@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PartNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$PartNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
      <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_PARTITION</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
