<?xml version="1.0"?>
<!--
NAME
    kuaqtab.xsl
DESCRIPTION
    Convert sxml AQ_QUEUE_TABLE diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    htseng      01/08/07 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="DROP_MISSING_COLUMNS">1</xsl:param>
 <xsl:param name="NOT_NULL_METHOD">AUTOMATIC</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <xsl:param name="PRS_COLUMN_ATTRIBUTE">0</xsl:param>
 <xsl:param name="PRS_CONSTRAINT_TYPE">0</xsl:param>
 <xsl:param name="PRS_CONSTRAINT_STATE">0</xsl:param>
 <xsl:param name="PRS_PARTITION_TYPE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:AQ_QUEUE_TABLE">
  <!-- *******************************************************************
Template: AQ_QUEUE_TABLE  - top-level template for AQ_QUEUE_TABLE. 
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">AQ_QUEUE_TABLE</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:call-template name="AlterQTab">
      <xsl:with-param name="ParentNode" select="."/>
      <xsl:with-param name="Action">PARSE</xsl:with-param>
     </xsl:call-template>
     <xsl:if test="sxml:COMMENT/@value1 or sxml:COMMENT/@src='2' or
      sxml:PRIMARY_INSTANCE/@value1 or sxml:PRIMARY_INSTANCE/@src='2' or
      sxml:SECONDARY_INSTANCE/@value1 or sxml:SECONDARY_INSTANCE/@src='2'">
      <xsl:call-template name="AlterQTab">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterQTab">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterQTab
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">AQ_QUEUE_TABLE</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_COLUMN_ATTRIBUTE"/>
      <xsl:with-param name="Item">AQ_QUEUE_TABLE_PARAMETERS</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:if test="$ParentNode/sxml:COMMENT/@value1 or $ParentNode/sxml:COMMENT/@src='2'">COMMENT</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value2">
       <xsl:if test="$ParentNode/sxml:PRIMARY_INSTANCE/@value1 or $ParentNode/sxml:PRIMARY_INSTANCE/@src='2'">PRIMARY_INSTANCE</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value3">
       <xsl:if test="$ParentNode/sxml:SECONDARY_INSTANCE/@value1 or $ParentNode/sxml:SECONDARY_INSTANCE/@src='2'">SECONDARY_INSTANCE</xsl:if>
      </xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
      <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:if test="$ParentNode/sxml:SORT_LIST/@value1 or $ParentNode/sxml:SORT_LIST/@src">SORT_LIST</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value2">
       <xsl:if test="$ParentNode/sxml:MULTIPLE_CONSUMERS/@value1 or $ParentNode/sxml:MULTIPLE_CONSUMERS/@src">MULTIPLE_CONSUMERS</xsl:if>
      </xsl:with-param>
      <xsl:with-param name="Value3">
       <xsl:if test="$ParentNode/sxml:COMPATIBLE/@value1 or $ParentNode/sxml:COMPATIBLE/@src">MCOMPATIBLE</xsl:if>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text> BEGIN DBMS_AQADM.ALTER_QUEUE_TABLE(</xsl:text>
       <xsl:text>QUEUE_TABLE => '</xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text>'</xsl:text>
       <xsl:if test="$ParentNode/sxml:COMMENT/@value1 or $ParentNode/sxml:COMMENT/@src='2'">
        <xsl:text>, </xsl:text>
        <xsl:text>COMMENT => '</xsl:text>
        <xsl:value-of select="$ParentNode/sxml:COMMENT"/>
        <xsl:text>'</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:PRIMARY_INSTANCE/@value1 or $ParentNode/sxml:PRIMARY_INSTANCE/@src='2'">
        <xsl:text>, </xsl:text>
        <xsl:text>PRIMARY_INSTANCE => </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:PRIMARY_INSTANCE"/>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:SECONDARY_INSTANCE/@value1 or $ParentNode/sxml:SECONDARY_INSTANCE/@src='2'">
        <xsl:text>, </xsl:text>
        <xsl:text>SECONDARY_INSTANCE => </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:SECONDARY_INSTANCE"/>
       </xsl:if>
       <xsl:text> ); </xsl:text>
       <xsl:text>END;</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
