<?xml version="1.0"?>
<!-- 
    Copyright (c) 2001, 2006, Oracle. All rights reserved.
NAME
    kuassoc.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_assoc_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     10/13/06 - bug 5548554: WITH SYSTEM MANAGED STORAGE TABLES
    lbarton	11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng	08/02/02 - add grantee parse param
    htseng	07/25/02 - add BaseSchemaNode, BaseNameNode, BaseObjectType
    htseng	10/11/01 - add schema parser param.
    htseng	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	06/07/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="ASSOC_T">
 <!-- *******************************************************************
Template: ASSOC_T
******************************************************************** -->
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ASSOCIATE</xsl:with-param>
   <xsl:with-param name="ObjectType">ASSOCIATION</xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:text>ASSOCIATE STATISTICS WITH </xsl:text>
  <xsl:choose>
   <xsl:when test="OBJ_TYPE=1">
    <xsl:text>COLUMNS </xsl:text>
   </xsl:when>
   <xsl:when test="OBJ_TYPE=2">
    <xsl:text>TYPES </xsl:text>
   </xsl:when>
   <xsl:when test="OBJ_TYPE=3">
    <xsl:text>PACKAGES </xsl:text>
   </xsl:when>
   <xsl:when test="OBJ_TYPE=4">
    <xsl:text>FUNCTIONS </xsl:text>
   </xsl:when>
   <xsl:when test="OBJ_TYPE=5">
    <xsl:text>INDEXES </xsl:text>
   </xsl:when>
   <xsl:when test="OBJ_TYPE=6">
    <xsl:text>INDEXTYPES </xsl:text>
   </xsl:when>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="string-length(OBJCOL)=0">
    <xsl:apply-templates select="BASE_OBJ"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Schema" select="BASE_OBJ/OWNER_NAME"/>
     <xsl:with-param name="Object" select="BASE_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text>.</xsl:text>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="OBJCOL"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="string-length(STATS_OBJ/OWNER_NAME)!=0 
		or string-length(STATS_OBJ/NAME)!=0 ">
    <xsl:text> USING </xsl:text>
    <xsl:apply-templates select="STATS_OBJ"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="OBJ_TYPE=1 or OBJ_TYPE=5">
     <xsl:text> USING NULL </xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="SELECTIVITY!=0">
    <xsl:text> DEFAULT SELECTIVITY </xsl:text>
    <xsl:value-of select="SELECTIVITY"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="CPU_COST!=0 or IO_COST!=0 or NET_COST!=0">
     <xsl:text> DEFAULT COST ( </xsl:text>
     <xsl:value-of select="CPU_COST"/>
     <xsl:text>, </xsl:text>
     <xsl:value-of select="IO_COST"/>
     <xsl:text>, </xsl:text>
     <xsl:value-of select="NET_COST"/>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="(SPARE2 mod 2)>=1">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;	</xsl:text>
   </xsl:if>
   <xsl:text> WITH SYSTEM MANAGED STORAGE TABLES</xsl:text>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
