<?xml version="1.0"?>
<!--
NAME
    kuauser.xsl
DESCRIPTION
    Convert sxml USER diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    lbarton      07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    rapayne      01/31/08 - Extend support.
    rapayne      06/09/06 - Initial version (Stubbed out).
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- Top-level parameters -->
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:USER">
  <!-- *******************************************************************
Template: USER - top-level template for USER objects.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">USER</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:element name="ALTER_LIST">
    <!-- Check USER'S NAME -->
    <xsl:if test="sxml:NAME/@value1 and
              ($PRS_NAME=1 or 
               $PRS_CLAUSE_TYPE=1 or
               $PRS_ALTERABLE=1 or
               $PRS_XPATH=1)">
     <!-- NAME is not alterable-->
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="NameParent" select="."/>
      <xsl:with-param name="Reason">USER_NAME</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- User Type (LOCAL, GLOBAL, EXTERNAL -->
    <xsl:if test="sxml:TYPE/@value1 and
                   not(sxml:TYPE='LOCAL')">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterUserType">
       <xsl:with-param name="UserNode" select="."/>
       <xsl:with-param name="TypeNode" select="sxml:TYPE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterUserType">
       <xsl:with-param name="UserNode" select="."/>
       <xsl:with-param name="TypeNode" select="sxml:TYPE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <!-- account status (Account lock and password expire -->
    <xsl:call-template name="CheckAcctStatus">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- default tablespace -->
    <xsl:if test="sxml:DEFAULT_TABLESPACE/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterDefTbsp">
       <xsl:with-param name="UserNode" select="."/>
       <xsl:with-param name="TbspType"> DEFAULT TABLESPACE </xsl:with-param>
       <xsl:with-param name="TbspNode" select="sxml:DEFAULT_TABLESPACE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterDefTbsp">
       <xsl:with-param name="UserNode" select="."/>
       <xsl:with-param name="TbspType"> DEFAULT TABLESPACE </xsl:with-param>
       <xsl:with-param name="TbspNode" select="sxml:DEFAULT_TABLESPACE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <!-- temporary tablespace -->
    <xsl:if test="sxml:TEMPORARY_TABLESPACE/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterDefTbsp">
       <xsl:with-param name="UserNode" select="."/>
       <xsl:with-param name="TbspType"> TEMPORARY TABLESPACE </xsl:with-param>
       <xsl:with-param name="TbspNode" select="sxml:TEMPORARY_TABLESPACE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterDefTbsp">
       <xsl:with-param name="UserNode" select="."/>
       <xsl:with-param name="TbspType"> TEMPORARY TABLESPACE </xsl:with-param>
       <xsl:with-param name="TbspNode" select="sxml:TEMPORARY_TABLESPACE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <!-- Alter USER PROFILE -->
    <xsl:if test="sxml:PROFILE/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterUserProfile">
       <xsl:with-param name="UserNode" select="."/>
       <xsl:with-param name="ProfileNode" select="sxml:PROFILE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterUserProfile">
       <xsl:with-param name="UserNode" select="."/>
       <xsl:with-param name="ProfileNode" select="sxml:PROFILE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="CheckAcctStatus">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: CheckAcctStatus - 
    Process ACCOUNT_LOCK and PASSWORD_EXPIRE
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:ACCOUNT_LOCK/@src">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterAcctStatus">
     <xsl:with-param name="UserNode" select="$ParentNode"/>
     <xsl:with-param name="LockNode" select="$ParentNode/sxml:ACCOUNT_LOCK"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterAcctStatus">
     <xsl:with-param name="UserNode" select="$ParentNode"/>
     <xsl:with-param name="LockNode" select="$ParentNode/sxml:ACCOUNT_LOCK"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:PASSWORD_EXPIRE/@src='2'">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterPwdExpire">
     <xsl:with-param name="UserNode" select="$ParentNode"/>
     <xsl:with-param name="PwdNode" select="$ParentNode/sxml:PASSWORD_EXPIRE"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterPwdExpire">
     <xsl:with-param name="UserNode" select="$ParentNode"/>
     <xsl:with-param name="PwdNode" select="$ParentNode/sxml:PASSWORD_EXPIRE"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:PASSWORD_EXPIRE/@src='1'">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="NameParent" select="$ParentNode/sxml:PASSWORD_EXPIRE"/>
    <xsl:with-param name="Reason">UNEXPIRE_PASSWORD</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterAcctStatus">
  <xsl:param name="UserNode" select="''"/>
  <xsl:param name="LockNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterAcctStatus - 
      <ACCOUNT_LOCK>Y</ACCOUNT_LOCK>
Parameters:
 UserNode <USER>
 LockNode -<ACCOUNT_LOCK>
 Action - "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$LockNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_ACCOUNT_LOCK</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER USER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$UserNode"/>
       </xsl:call-template>
       <xsl:text> ACCOUNT </xsl:text>
       <xsl:choose>
        <xsl:when test="$LockNode/@src='1'">UNLOCK</xsl:when>
        <xsl:otherwise>LOCK</xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterPwdExpire">
  <xsl:param name="UserNode" select="''"/>
  <xsl:param name="PwdNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterPwdExp - 
      <PASSWORD_EXPIRE\>
Parameters:
 UserNode <USER>
 PwdNode <PASSWORD_EXPIRE>
 Action - "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PwdNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PASSWORD_EXPIRE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER USER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$UserNode"/>
       </xsl:call-template>
       <xsl:text> PASSWORD EXPIRE</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterDefTbsp">
  <xsl:param name="UserNode" select="''"/>
  <xsl:param name="TbspType" select="''"/>
  <xsl:param name="TbspNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterDefTbsp - 
      <DEFAULT_TABLESPACE>
Parameters:
 UserNode <USER>
 TbspType - ' DEFAULT TABLESPACE '' or 
                    ' TEMPORARY TABLESPACE ' (i.e., WITH SPACES)
 TbspNode <DEFAULT_TABLEPSACE> or <TEMPORARY_TABLESPACE>
 Action - "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$TbspNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1" select="$TbspType"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER USER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$UserNode"/>
       </xsl:call-template>
       <xsl:value-of select="$TbspType"/>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="$TbspNode"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterUserType">
  <xsl:param name="UserNode" select="''"/>
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterUserType - <TYPE>
      This template should only modify a user to be identified 
      GLOBALLY or EXTERNALLY
Parameters:
 UserNode <USER>
 TypeNode <TYPE>
 Action - "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$TypeNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1" select="$TypeNode"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER USER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$UserNode"/>
       </xsl:call-template>
       <xsl:text> IDENTIFIED </xsl:text>
       <xsl:value-of select="$TypeNode"/>
       <xsl:text>LY</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterUserProfile">
  <xsl:param name="UserNode" select="''"/>
  <xsl:param name="ProfileNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterUserProfile - <PROFILE>
Parameters:
 UserNode <USER>
 ProfileNode <PROFILE>
 Action - "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ProfileNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">USER_PROFILE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER USER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$UserNode"/>
       </xsl:call-template>
       <xsl:text> PROFILE </xsl:text>
       <xsl:value-of select="$ProfileNode"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
