<?xml version="1.0"?>
<!-- 
    Copyright (c) 2000, 2006, Oracle. All rights reserved.
NAME
    kuidxtyp.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_indextype_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     10/23/06 - bug 5610872: composite domain indexes
    lbarton     10/13/06 - bug 5548554: WITH SYSTEM MANAGED STORAGE TABLES
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    lbarton     05/16/03 - bug 2949397: support INDEXTYPE options
    htseng      12/18/02 - add EXPORT parameter
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     07/24/00 - use uriref in import
    lbarton     06/02/00 - support parsing
    gclaborn    05/08/00 - Support multinesting
    gclaborn    04/25/00 - Add version string
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kuoper.xsl"/>
 <!-- All parameters are defined in kuoper.xsl -->
 <!-- Templates -->
 <xsl:template match="INDEXTYPE_T">
 <!-- *******************************************************************
Template: INDEXTYPE_T
******************************************************************** -->
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">INDEXTYPE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE </xsl:text>
  </xsl:if>
  <xsl:text>INDEXTYPE </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:text>FOR </xsl:text>
  <xsl:apply-templates select="OPERATORS"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;	</xsl:text>
  </xsl:if>
  <xsl:text> USING </xsl:text>
  <xsl:apply-templates select="IMPL_OBJ"/>
  <xsl:apply-templates select="PROPERTY"/>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
 <xsl:template match="OPERATORS">
 <!-- *******************************************************************
Template: OPERATORS
******************************************************************** -->
  <xsl:for-each select="OPERATORS_ITEM[4>(PROPERTY mod 8)]">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;	</xsl:text>
   </xsl:if>
   <xsl:text>&#x20;</xsl:text>
   <xsl:apply-templates select="OPER_OBJ"/>
   <xsl:apply-templates select="ARGS"/>
   <!-- in operator.xsl -->
   <xsl:if test="(PROPERTY mod 4)>=2"> REWRITE JOIN</xsl:if>
   <!-- Print a comma if this is not the last operator for this indextype -->
   <xsl:if test="not(position()=last())">
    <xsl:text>,</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="PROPERTY">
 <!-- *******************************************************************
Template: PROPERTY
******************************************************************** -->
   <xsl:if test="(. mod  2)>=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	</xsl:text>
    </xsl:if>
    <xsl:text> WITHOUT COLUMN DATA</xsl:text>
   </xsl:if>
   <xsl:if test="(. mod  4)>=2">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	</xsl:text>
    </xsl:if>
    <xsl:text> WITH ARRAY DML</xsl:text>
    <xsl:apply-templates select="../INDARRAY"/>
   </xsl:if>
   <xsl:if test="(. mod  8)>=4">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	</xsl:text>
    </xsl:if>
    <xsl:text> WITH REBUILD ONLINE</xsl:text>
   </xsl:if>
   <xsl:if test="(. mod 16)>=8">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	</xsl:text>
    </xsl:if>
    <xsl:text> WITH ORDER BY </xsl:text>
    <xsl:for-each select="../OPERATORS/OPERATORS_ITEM[(PROPERTY mod 8)>=4]">
     <xsl:apply-templates select="OPER_OBJ"/>
     <xsl:apply-templates select="ARGS"/>
     <!-- in operator.xsl -->
     <!-- Print a comma if this is not the last operator -->
     <xsl:if test="not(position()=last())">
      <xsl:text>,</xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;	 </xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:for-each>
   </xsl:if>
   <xsl:if test="(. mod 1024)>=512">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	</xsl:text>
    </xsl:if>
    <xsl:text> WITH COMPOSITE INDEX</xsl:text>
   </xsl:if>
   <xsl:if test="(. mod 32)>=16">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	</xsl:text>
    </xsl:if>
    <xsl:text> WITH LOCAL RANGE PARTITION</xsl:text>
   </xsl:if>
   <xsl:if test="(. mod 64)>=32">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	</xsl:text>
    </xsl:if>
    <xsl:text> WITHOUT ARRAY DML</xsl:text>
   </xsl:if>
   <xsl:if test="(. mod 2048)>=1024">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	</xsl:text>
    </xsl:if>
    <xsl:text> WITH SYSTEM MANAGED STORAGE TABLES</xsl:text>
   </xsl:if>
 </xsl:template>
 <xsl:template match="INDARRAY">
 <!-- *******************************************************************
Template: INDARRAY
******************************************************************** -->
  <xsl:for-each select="INDARRAY_ITEM">
   <xsl:text> (</xsl:text>
   <xsl:apply-templates select="BASETYPE_OBJ">
    <xsl:with-param name="TrailingBlank">0</xsl:with-param>
   </xsl:apply-templates>
   <xsl:text>,</xsl:text>
   <xsl:apply-templates select="ARRAYTYPE_OBJ">
    <xsl:with-param name="TrailingBlank">0</xsl:with-param>
   </xsl:apply-templates>
   <xsl:text>)</xsl:text>
   <xsl:if test="not(position()=last())">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;	 </xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
