<?xml version="1.0"?>
<!-- 
NAME
    kumodcom.xsl
DESCRIPTION
    XSLT stylesheet for common MODIFY functions
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    htseng      02/28/07 - bug 5908340: remap ref_constraint name
    htseng      02/09/07 - bug 5865356: remap constraint name
    htseng      02/01/07 - bug 5763926: remap_table in bitmap index
    lbarton     01/26/06 - REMAP_NAME
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    lbarton     07/12/04 - Lrg 1714666: don't remap typeowner SYS
    lbarton     07/30/03 - Bug 3045926: remap_schema remaps grantor
    lbarton     07/10/02 - lbarton_mdapi_modify_transform
    lbarton     06/07/02 - Created
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
 <!-- Templates -->
 <xsl:template match="@*|node()">
  <!-- *******************************************************************
 copy everything from the input file
******************************************************************** -->
  <xsl:copy>
   <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
 </xsl:template>
 <xsl:template match="ROW">
  <!-- *******************************************************************
Template: ROW
If the user specified OBJECT_ROW to select only certain rows,
  this template screens out all rows except those selected.
  Usually nothing is specified and OBJECT_ROW1 has its default value 0.
  The default is to copy all rows to the output doc.
******************************************************************** -->
  <xsl:if test="$OBJECT_ROW1=0 or
                ($OBJECT_ROW1!=0 and position()=$OBJECT_ROW1) or
                ($OBJECT_ROW2!=0 and position()=$OBJECT_ROW2) or
                ($OBJECT_ROW3!=0 and position()=$OBJECT_ROW3) or
                ($OBJECT_ROW4!=0 and position()=$OBJECT_ROW4) or
                ($OBJECT_ROW5!=0 and position()=$OBJECT_ROW5) or
                ($OBJECT_ROW6!=0 and position()=$OBJECT_ROW6) or
                ($OBJECT_ROW7!=0 and position()=$OBJECT_ROW7) or
                ($OBJECT_ROW8!=0 and position()=$OBJECT_ROW8) or
                ($OBJECT_ROW9!=0 and position()=$OBJECT_ROW9) or
                ($OBJECT_ROW10!=0 and position()=$OBJECT_ROW10)">
   <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 <xsl:template match="TYPEMD/SCHEMA_OBJ/OWNER_NAME | TYPEMD/OWNER_NAME">
  <!-- *******************************************************************
Template: OWNER_NAME for type metadata
This template does NOT remap typeowner SYS
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='SYS'">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="RemapOwner">
     <xsl:with-param name="Val" select="."/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="OWNER_NAME">
  <!-- *******************************************************************
Template: OWNER_NAME - remap the owner name
******************************************************************** -->
  <xsl:call-template name="RemapOwner">
   <xsl:with-param name="Val" select="."/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="RemapOwner">
  <xsl:param name="Val"/>
  <!-- *******************************************************************
Template: RemapOwner
Parameters:
  Val = current owner name value
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_SCHEMAO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO1">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN1"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO2">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN2"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO3">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN3"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO4">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN4"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO5">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN5"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO6">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN6"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO7">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN7"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO8">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN8"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO9">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN9"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:when test="$Val=$REMAP_SCHEMAO10">
    <OWNER_NAME>
     <xsl:value-of select="$REMAP_SCHEMAN10"/>
    </OWNER_NAME>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="GRANTEE">
  <!-- *******************************************************************
Template: GRANTEE - remap grantee
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_SCHEMAO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO1">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN1"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO2">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN2"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO3">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN3"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO4">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN4"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO5">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN5"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO6">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN6"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO7">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN7"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO8">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN8"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO9">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN9"/>
    </GRANTEE>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO10">
    <GRANTEE>
     <xsl:value-of select="$REMAP_SCHEMAN10"/>
    </GRANTEE>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="GRANTOR">
  <!-- *******************************************************************
Template: GRANTOR - remap grantor
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_SCHEMAO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO1">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN1"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO2">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN2"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO3">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN3"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO4">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN4"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO5">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN5"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO6">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN6"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO7">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN7"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO8">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN8"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO9">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN9"/>
    </GRANTOR>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO10">
    <GRANTOR>
     <xsl:value-of select="$REMAP_SCHEMAN10"/>
    </GRANTOR>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="IMPSCHEMA">
  <!-- *******************************************************************
Template: IMPSCHEMA - remap indextype implementation schema
 (see ku$_opbinding_t)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_SCHEMAO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO1">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN1"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO2">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN2"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO3">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN3"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO4">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN4"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO5">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN5"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO6">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN6"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO7">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN7"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO8">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN8"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO9">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN9"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO10">
    <IMPSCHEMA>
     <xsl:value-of select="$REMAP_SCHEMAN10"/>
    </IMPSCHEMA>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="PFSCHMA">
  <!-- *******************************************************************
Template: PSCHEMA - remap schema of fga event handler
 (see ku$_fga_policy_t)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_SCHEMAO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO1">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN1"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO2">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN2"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO3">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN3"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO4">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN4"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO5">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN5"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO6">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN6"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO7">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN7"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO8">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN8"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO9">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN9"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO10">
    <PFSCHMA>
     <xsl:value-of select="$REMAP_SCHEMAN10"/>
    </PFSCHMA>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="INDTYPE_OWNER">
  <!-- *******************************************************************
Template: INDTYPE_OWNER - remap indextype owner for domain index
 (see ku$_index_t)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_SCHEMAO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO1">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN1"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO2">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN2"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO3">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN3"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO4">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN4"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO5">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN5"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO6">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN6"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO7">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN7"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO8">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN8"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO9">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN9"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:when test=".=$REMAP_SCHEMAO10">
    <INDTYPE_OWNER>
     <xsl:value-of select="$REMAP_SCHEMAN10"/>
    </INDTYPE_OWNER>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="SCHEMA_OBJ/NAME | BASE_OBJ/NAME | SYNONYM_T/NAME | ROLLBACK_T/NAME | JIJOIN_TABS_ITEM/NAME | CONSTRAINT_T/CON0/NAME | CONSTRAINT_T/CON1/NAME | REF_CONSTRAINT_T/CON2/NAME">
  <!-- *******************************************************************
Template: SCHEMA_OBJ/NAME |BASE_OBJ/NAME - remap object/base object name
       SYNONYM_T/NAME - object denoted by the synonym
       TABLESPACE_T/NAME - tablespace name
       ROLLBACK_T/NAME - rollback segment name
       JIJOIN_TABS_ITEM/NAME - bitmap join index 
       CONSTRAINT_T/CON0/NAME - constraint name
       CONSTRAINT_T/CON1/NAME - constraint name
       REF_CONSTRAINT_T/CON2/NAME - ref constraint name

******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($REMAP_NAMEO1)=0">
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO1">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO2">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO3">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO4">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO5">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO6">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO7">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO8">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO9">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO10">
    <NAME>
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </NAME>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="LONG_NAME">
  <!-- *******************************************************************
Template: LONG_NAME - remap object longname
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".=$REMAP_NAMEO1">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO2">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO3">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO4">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO5">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO6">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO7">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO8">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO9">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO10">
    <LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </LONG_NAME>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="MVIEW/VNAME">
  <!-- *******************************************************************
Template: MVIEW/VNAME - remap materialized view name
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".=$REMAP_NAMEO1">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO2">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO3">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO4">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO5">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO6">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO7">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO8">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO9">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </VNAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO10">
    <VNAME>
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </VNAME>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="MVIEWLOG/MASTER">
  <!-- *******************************************************************
Template: MVIEWLOG/MASTER - remap materialized view log base object name
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".=$REMAP_NAMEO1">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO2">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO3">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO4">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO5">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO6">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO7">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO8">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO9">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </MASTER>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO10">
    <MASTER>
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </MASTER>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="SYN_LONG_NAME">
  <!-- *******************************************************************
Template: SYN_LONG_NAME - remap synonym long name
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".=$REMAP_NAMEO1">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO2">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO3">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO4">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO5">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO6">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO7">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO8">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO9">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO10">
    <SYN_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </SYN_LONG_NAME>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="OBJ_LONG_NAME">
  <!-- *******************************************************************
Template: OBJ_LONG_NAME - remap long obj name (synonyms)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".=$REMAP_NAMEO1">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN1"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO2">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN2"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO3">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN3"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO4">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN4"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO5">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN5"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO6">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN6"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO7">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN7"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO8">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN8"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO9">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN9"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:when test=".=$REMAP_NAMEO10">
    <OBJ_LONG_NAME>
     <xsl:value-of select="$REMAP_NAMEN10"/>
    </OBJ_LONG_NAME>
   </xsl:when>
   <xsl:otherwise>
    <xsl:copy>
     <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
